/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.client.tools.javascript.debugger.spi;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicLong;
import org.netbeans.modules.web.client.tools.javascript.debugger.api.JSCallStackFrame;
import org.netbeans.modules.web.client.tools.javascript.debugger.api.JSDebugger;
import org.netbeans.modules.web.client.tools.javascript.debugger.api.JSDebuggerConsoleEvent;
import org.netbeans.modules.web.client.tools.javascript.debugger.api.JSDebuggerConsoleEventListener;
import org.netbeans.modules.web.client.tools.javascript.debugger.api.JSDebuggerEvent;
import org.netbeans.modules.web.client.tools.javascript.debugger.api.JSDebuggerEventListener;
import org.netbeans.modules.web.client.tools.javascript.debugger.api.JSDebuggerState;
import org.netbeans.modules.web.client.tools.javascript.debugger.api.JSHttpMessage;
import org.netbeans.modules.web.client.tools.javascript.debugger.api.JSHttpMessageEvent;
import org.netbeans.modules.web.client.tools.javascript.debugger.api.JSHttpMessageEventListener;
import org.netbeans.modules.web.client.tools.javascript.debugger.api.JSProperty;
import org.netbeans.modules.web.client.tools.javascript.debugger.api.JSSource;
import org.netbeans.modules.web.client.tools.javascript.debugger.api.JSWindow;
import org.openide.awt.HtmlBrowser;
import org.openide.execution.NbProcessDescriptor;

public abstract class JSAbstractDebugger
implements JSDebugger {
    private long sequenceId;
    private URI uri;
    private HtmlBrowser.Factory browser;
    private JSDebuggerState debuggerState = JSDebuggerState.NOT_CONNECTED;
    private JSWindow[] windows = JSWindow.EMPTY_ARRAY;
    private JSSource[] sources = JSSource.EMPTY_ARRAY;
    private JSCallStackFrame[] callStackFrames = JSCallStackFrame.EMPTY_ARRAY;
    private final List<JSDebuggerEventListener> listeners;
    private final List<JSDebuggerConsoleEventListener> consoleListeners;
    private final List<JSHttpMessageEventListener> httpListeners;
    protected final PropertyChangeSupport propertyChangeSupport;
    private static AtomicLong sequenceIdGenerator = new AtomicLong(-1L);

    public JSAbstractDebugger(URI uRI, HtmlBrowser.Factory factory) {
        this.uri = uRI;
        this.browser = factory;
        this.sequenceId = sequenceIdGenerator.incrementAndGet();
        this.listeners = new CopyOnWriteArrayList<JSDebuggerEventListener>();
        this.consoleListeners = new CopyOnWriteArrayList<JSDebuggerConsoleEventListener>();
        this.httpListeners = new CopyOnWriteArrayList<JSHttpMessageEventListener>();
        this.propertyChangeSupport = new PropertyChangeSupport(this);
    }

    public final void startDebugging() {
        if (this.debuggerState.getState() != JSDebuggerState.State.NOT_CONNECTED) {
            throw new IllegalStateException();
        }
        this.startDebuggingImpl();
    }

    protected final long getSequenceId() {
        return this.sequenceId;
    }

    protected abstract void startDebuggingImpl();

    public URI getURI() {
        return this.uri;
    }

    public HtmlBrowser.Factory getBrowser() {
        return this.browser;
    }

    public synchronized JSDebuggerState getDebuggerState() {
        return this.debuggerState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setDebuggerState(JSDebuggerState jSDebuggerState) {
        JSAbstractDebugger jSAbstractDebugger = this;
        synchronized (jSAbstractDebugger) {
            this.debuggerState = jSDebuggerState;
            switch (jSDebuggerState.getState()) {
                case SUSPENDED: {
                    this.callStackFrames = this.getCallStackFramesImpl();
                    break;
                }
                default: {
                    this.callStackFrames = JSCallStackFrame.EMPTY_ARRAY;
                }
            }
        }
        this.fireJSDebuggerEvent(new JSDebuggerEvent(this, this.debuggerState));
    }

    public JSWindow[] getWindows() {
        return this.windows;
    }

    protected void setWindows(JSWindow[] jSWindowArray) {
        JSWindow[] jSWindowArray2 = this.windows;
        this.windows = jSWindowArray;
        this.propertyChangeSupport.firePropertyChange("windows", jSWindowArray2, this.windows);
    }

    protected void setHttpMessage(JSHttpMessage jSHttpMessage) {
        this.fireJSHttpMessageEvent(new JSHttpMessageEvent(this, jSHttpMessage));
    }

    public JSSource[] getSources() {
        return this.sources;
    }

    protected void setSources(JSSource[] jSSourceArray) {
        JSSource[] jSSourceArray2 = this.sources;
        this.sources = jSSourceArray;
        this.propertyChangeSupport.firePropertyChange("sources", jSSourceArray2, this.sources);
    }

    public InputStream getInputStreamForURL(URL uRL) {
        if (uRL == null) {
            return null;
        }
        return this.getInputStreamForURLImpl(uRL);
    }

    protected abstract InputStream getInputStreamForURLImpl(URL var1);

    public JSCallStackFrame[] getCallStackFrames() {
        return this.callStackFrames;
    }

    protected abstract JSCallStackFrame[] getCallStackFramesImpl();

    public JSProperty getScope(JSCallStackFrame jSCallStackFrame) {
        return this.getScopeImpl(jSCallStackFrame);
    }

    protected abstract JSProperty getScopeImpl(JSCallStackFrame var1);

    public JSProperty getThis(JSCallStackFrame jSCallStackFrame) {
        return this.getThisImpl(jSCallStackFrame);
    }

    protected abstract JSProperty getThisImpl(JSCallStackFrame var1);

    public JSProperty eval(JSCallStackFrame jSCallStackFrame, String string) {
        return this.evalImpl(jSCallStackFrame, string);
    }

    protected abstract JSProperty evalImpl(JSCallStackFrame var1, String var2);

    public JSProperty getProperty(JSCallStackFrame jSCallStackFrame, String string) {
        return this.getPropertyImpl(jSCallStackFrame, string);
    }

    protected abstract JSProperty getPropertyImpl(JSCallStackFrame var1, String var2);

    public boolean setProperty(JSCallStackFrame jSCallStackFrame, String string, String string2) {
        return this.setPropertyImpl(jSCallStackFrame, string, string2);
    }

    protected abstract boolean setPropertyImpl(JSCallStackFrame var1, String var2, String var3);

    public JSProperty[] getProperties(JSCallStackFrame jSCallStackFrame, String string) {
        return this.getPropertiesImpl(jSCallStackFrame, string);
    }

    protected abstract JSProperty[] getPropertiesImpl(JSCallStackFrame var1, String var2);

    public void setCallStackFrames(JSCallStackFrame[] jSCallStackFrameArray) {
        this.callStackFrames = jSCallStackFrameArray;
    }

    public boolean isSuspended() {
        return this.debuggerState.getState() == JSDebuggerState.State.SUSPENDED;
    }

    public void addJSDebuggerEventListener(JSDebuggerEventListener jSDebuggerEventListener) {
        this.listeners.add(jSDebuggerEventListener);
    }

    public void removeJSDebuggerEventListener(JSDebuggerEventListener jSDebuggerEventListener) {
        this.listeners.remove(jSDebuggerEventListener);
    }

    protected void fireJSDebuggerEvent(JSDebuggerEvent jSDebuggerEvent) {
        for (JSDebuggerEventListener jSDebuggerEventListener : this.listeners) {
            jSDebuggerEventListener.onDebuggerEvent(jSDebuggerEvent);
        }
    }

    public void addJSDebuggerConsoleEventListener(JSDebuggerConsoleEventListener jSDebuggerConsoleEventListener) {
        this.consoleListeners.add(jSDebuggerConsoleEventListener);
    }

    public void removeJSDebuggerConsoleEventListener(JSDebuggerConsoleEventListener jSDebuggerConsoleEventListener) {
        this.consoleListeners.remove(jSDebuggerConsoleEventListener);
    }

    protected void fireJSDebuggerConsoleEvent(JSDebuggerConsoleEvent jSDebuggerConsoleEvent) {
        for (JSDebuggerConsoleEventListener jSDebuggerConsoleEventListener : this.consoleListeners) {
            jSDebuggerConsoleEventListener.onConsoleEvent(jSDebuggerConsoleEvent);
        }
    }

    public void addJSHttpMessageEventListener(JSHttpMessageEventListener jSHttpMessageEventListener) {
        this.httpListeners.add(jSHttpMessageEventListener);
    }

    public void removeJSHttpMessageEventListener(JSHttpMessageEventListener jSHttpMessageEventListener) {
        this.httpListeners.remove(jSHttpMessageEventListener);
    }

    protected void fireJSHttpMessageEvent(JSHttpMessageEvent jSHttpMessageEvent) {
        for (JSHttpMessageEventListener jSHttpMessageEventListener : this.httpListeners) {
            jSHttpMessageEventListener.onHttpMessageEvent(jSHttpMessageEvent);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    protected String getBrowserExecutable() {
        if (this.browser != null) {
            try {
                Method method = this.browser.getClass().getMethod("getBrowserExecutable", new Class[0]);
                NbProcessDescriptor nbProcessDescriptor = (NbProcessDescriptor)method.invoke((Object)this.browser, new Object[0]);
                return nbProcessDescriptor.getProcessName();
            }
            catch (SecurityException securityException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        return "firefox";
    }

    public final void finish(boolean bl) {
        this.finishImpl(bl);
        if (bl) {
            this.setDebuggerState(JSDebuggerState.DISCONNECTED_USER);
        } else {
            this.setDebuggerState(JSDebuggerState.DISCONNECTED);
        }
    }

    protected abstract void finishImpl(boolean var1);
}

