/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.client.tools.common.dbgp;

import java.lang.reflect.Constructor;
import java.util.logging.Level;
import org.netbeans.modules.web.client.tools.common.dbgp.CommandMap;
import org.netbeans.modules.web.client.tools.common.dbgp.Log;
import org.netbeans.modules.web.client.tools.common.dbgp.Message;
import org.netbeans.modules.web.client.tools.common.dbgp.ResponseMessage;
import org.netbeans.modules.web.client.tools.common.dbgp.StreamMessage;
import org.w3c.dom.Node;

class MessageBuilder {
    private static final String TYPE = "type";

    private MessageBuilder() {
    }

    static Message createStream(Node node) {
        Node node2 = node.getAttributes().getNamedItem(TYPE);
        assert (node2 != null);
        String string = node2.getNodeValue();
        if (StreamMessage.StreamType.STDOUT.name().equalsIgnoreCase(string)) {
            return new StreamMessage(node, StreamMessage.StreamType.STDOUT);
        }
        if (StreamMessage.StreamType.STDERR.name().equalsIgnoreCase(string)) {
            return new StreamMessage(node, StreamMessage.StreamType.STDERR);
        }
        assert (false);
        return null;
    }

    static ResponseMessage createResponse(Node node) {
        try {
            String string = Message.getAttribute(node, "command");
            assert (string != null);
            Class clazz = CommandMap.valueOf(string.toUpperCase()).getResponseClass();
            Constructor constructor = clazz.getDeclaredConstructor(Node.class);
            if (constructor != null) {
                return (ResponseMessage)constructor.newInstance(node);
            }
        }
        catch (Exception exception) {
            Log.getLogger().log(Level.SEVERE, "Unable to construct response message from dbgp XML response", exception);
        }
        return null;
    }
}

