/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.client.tools.common.dbgp;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.netbeans.modules.web.client.tools.common.dbgp.Command;
import org.netbeans.modules.web.client.tools.common.dbgp.CommandMap;
import org.netbeans.modules.web.client.tools.common.dbgp.Property;
import org.netbeans.modules.web.client.tools.common.dbgp.ResponseMessage;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Context {
    private String name;
    private int id;

    private Context(String string, int n) {
        this.name = string;
        this.id = n;
    }

    public String getContext() {
        return this.name;
    }

    public int getId() {
        return this.id;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ContextNamesResponse
    extends ResponseMessage {
        static final String CONTEXT = "context";
        private static final String NAME = "name";
        private static final String ID = "id";

        ContextNamesResponse(Node node) {
            super(node);
        }

        Collection<Context> getContexts() {
            LinkedList<Context> linkedList = new LinkedList<Context>();
            NodeList nodeList = this.getNode().getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (!CONTEXT.equals(node.getNodeName())) continue;
                String string = ContextNamesResponse.getAttribute(node, NAME);
                int n = ContextNamesResponse.getInt(node, ID);
                linkedList.add(new Context(string, n));
            }
            return linkedList;
        }
    }

    public static class ContextNamesCommand
    extends Command {
        static final String DEPTH_ARG = "-d ";
        private int depth;

        public ContextNamesCommand(int n, int n2) {
            super(CommandMap.CONTEXT_NAMES.getCommand(), n);
            this.depth = n2;
        }

        public void setDepth(int n) {
            this.depth = n;
        }

        public int getDepth() {
            return this.depth;
        }

        protected String getArguments() {
            if (this.depth > -1) {
                return DEPTH_ARG + this.depth;
            }
            return "";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ContextGetResponse
    extends ResponseMessage {
        public ContextGetResponse(Node node) {
            super(node);
        }

        public int getContextId() {
            return ContextGetResponse.getInt(this.getNode(), "context");
        }

        public List<Property> getProperties() {
            List<Node> list = ContextGetResponse.getChildren(this.getNode(), "property");
            ArrayList<Property> arrayList = new ArrayList<Property>(list.size());
            for (Node node : list) {
                arrayList.add(new Property(node));
            }
            return arrayList;
        }
    }

    public static class ContextGetCommand
    extends Command {
        private static final String CONTEXT_ARG = "-c ";
        private int stackDepth;
        private Context context;

        public ContextGetCommand(int n, int n2) {
            super(CommandMap.CONTEXT_GET.getCommand(), n);
            this.stackDepth = n2;
        }

        protected String getArguments() {
            StringBuilder stringBuilder = new StringBuilder();
            if (this.stackDepth > -1) {
                stringBuilder.append("-d ");
                stringBuilder.append(this.stackDepth);
            }
            if (this.context != null) {
                if (stringBuilder.length() != 0) {
                    stringBuilder.append(" ");
                }
                stringBuilder.append(CONTEXT_ARG);
                stringBuilder.append(this.context.getId());
            }
            return stringBuilder.toString();
        }

        public void setContext(Context context) {
            this.context = context;
        }

        public Context getContext() {
            return this.context;
        }
    }
}

