/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2me.cdc.project.mbm;

import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import java.lang.reflect.InvocationTargetException;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.loaders.DataNode;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.nodes.Children;
import org.openide.nodes.CookieSet;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class MBMDataObject
extends MultiDataObject
implements CookieSet.Factory {
    static final long serialVersionUID = -6035788991669336965L;
    private static final String IMAGE_ICON_BASE = "/org/netbeans/modules/j2me/cdc/project/mbm/imageObject.png";

    public MBMDataObject(FileObject fileObject, MultiFileLoader multiFileLoader) throws DataObjectExistsException {
        super(fileObject, multiFileLoader);
    }

    public Node.Cookie createCookie(Class clazz) {
        return null;
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected Node createNodeDelegate() {
        return new ImageNode(this);
    }

    private static final class ImageNode
    extends DataNode {
        public ImageNode(MBMDataObject mBMDataObject) {
            super((DataObject)mBMDataObject, Children.LEAF);
            this.setIconBaseWithExtension(MBMDataObject.IMAGE_ICON_BASE);
        }

        protected Sheet createSheet() {
            Sheet sheet = super.createSheet();
            Sheet.Set set = sheet.get("properties");
            if (set == null) {
                set = Sheet.createPropertiesSet();
                sheet.put(set);
            }
            set.put((Node.Property)new ThumbnailProperty(this.getDataObject()));
            return sheet;
        }

        private static final class ThumbnailProperty
        extends PropertySupport.ReadOnly {
            private final DataObject obj;

            public ThumbnailProperty(DataObject dataObject) {
                super("thumbnail", Icon.class, NbBundle.getMessage(MBMDataObject.class, (String)"PROP_Thumbnail"), NbBundle.getMessage(MBMDataObject.class, (String)"HINT_Thumbnail"));
                this.obj = dataObject;
            }

            public Object getValue() throws InvocationTargetException {
                try {
                    return new ImageIcon(this.obj.getPrimaryFile().getURL());
                }
                catch (FileStateInvalidException fileStateInvalidException) {
                    throw new InvocationTargetException(fileStateInvalidException);
                }
            }

            public PropertyEditor getPropertyEditor() {
                return new ThumbnailPropertyEditor();
            }

            private final class ThumbnailPropertyEditor
            extends PropertyEditorSupport {
                private ThumbnailPropertyEditor() {
                }

                public boolean isPaintable() {
                    return true;
                }

                public void paintValue(Graphics graphics, Rectangle rectangle) {
                    ImageIcon imageIcon;
                    block5: {
                        imageIcon = null;
                        try {
                            imageIcon = (ImageIcon)ThumbnailProperty.this.getValue();
                        }
                        catch (InvocationTargetException invocationTargetException) {
                            if (!Boolean.getBoolean("netbeans.debug.exceptions")) break block5;
                            ErrorManager.getDefault().notify((Throwable)invocationTargetException);
                        }
                    }
                    if (imageIcon != null) {
                        int n = imageIcon.getIconWidth();
                        int n2 = imageIcon.getIconHeight();
                        double d = (double)n / (double)n2;
                        if (n > rectangle.width) {
                            n = rectangle.width;
                            n2 = (int)((double)n / d);
                        }
                        if (n2 > rectangle.height) {
                            n2 = rectangle.height;
                            n = (int)((double)n2 * d);
                        }
                        int n3 = n < rectangle.x ? (rectangle.x - n) / 2 : 5;
                        int n4 = n2 < rectangle.y ? (rectangle.y - n2) / 2 : 0;
                        Graphics graphics2 = graphics.create(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                        graphics.drawImage(imageIcon.getImage(), n3, n4, n, n2, null);
                    }
                }

                public String getAsText() {
                    return null;
                }
            }
        }
    }
}

