/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.menu;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Comparator;
import java.util.HashSet;
import java.util.TreeSet;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import org.netbeans.modules.form.ComponentInspector;
import org.netbeans.modules.form.RADComponent;
import org.netbeans.modules.form.RADComponentNode;
import org.netbeans.modules.form.actions.AlignAction;
import org.netbeans.modules.form.menu.MenuEditLayer;
import org.netbeans.modules.form.palette.PaletteItem;
import org.netbeans.modules.form.palette.PaletteUtils;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;

public class AddSubItemAction
extends NodeAction {
    protected boolean enable(Node[] nodeArray) {
        return true;
    }

    public String getName() {
        return NbBundle.getMessage(AddSubItemAction.class, (String)"ACT_AddFromPalette");
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected void performAction(Node[] nodeArray) {
    }

    public JMenuItem getMenuPresenter() {
        return this.getPopupPresenter();
    }

    public JMenuItem getPopupPresenter() {
        JMenu jMenu = new JMenu(NbBundle.getMessage(AddSubItemAction.class, (String)"ACT_AddFromPalette"));
        jMenu.setEnabled(this.isEnabled());
        HelpCtx.setHelpIDString((JComponent)jMenu, (String)AlignAction.class.getName());
        jMenu.addMenuListener(new MenuListener(){

            public void menuSelected(MenuEvent menuEvent) {
                JMenu jMenu = (JMenu)menuEvent.getSource();
                AddSubItemAction.this.createInsertSubmenu(jMenu);
            }

            public void menuDeselected(MenuEvent menuEvent) {
            }

            public void menuCanceled(MenuEvent menuEvent) {
            }
        });
        return jMenu;
    }

    private void createInsertSubmenu(JMenu jMenu) {
        if (jMenu.getMenuComponentCount() <= 0) {
            HashSet<Class> hashSet = new HashSet<Class>();
            TreeSet<PaletteItem> treeSet = new TreeSet<PaletteItem>(new Comparator<PaletteItem>(){

                @Override
                public int compare(PaletteItem paletteItem, PaletteItem paletteItem2) {
                    String string = paletteItem.getNode().getDisplayName();
                    String string2 = paletteItem2.getNode().getDisplayName();
                    return string.compareTo(string2);
                }
            });
            for (PaletteItem paletteItem : PaletteUtils.getAllItems()) {
                Class clazz = paletteItem.getComponentClass();
                if (clazz == null || hashSet.contains(clazz) || !JMenuItem.class.isAssignableFrom(clazz) && !JSeparator.class.isAssignableFrom(clazz)) continue;
                hashSet.add(clazz);
                treeSet.add(paletteItem);
            }
            for (PaletteItem paletteItem : treeSet) {
                JMenuItem jMenuItem = new JMenuItem(paletteItem.getNode().getDisplayName());
                jMenuItem.addActionListener(new AddListener(paletteItem));
                jMenu.add(jMenuItem);
            }
        }
    }

    private static Node[] getNodes() {
        return ComponentInspector.getInstance().getExplorerManager().getSelectedNodes();
    }

    private class AddListener
    implements ActionListener {
        private PaletteItem pItem;

        public AddListener(PaletteItem paletteItem) {
            this.pItem = paletteItem;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Node[] nodeArray;
            for (Node node : nodeArray = AddSubItemAction.getNodes()) {
                if (!(node instanceof RADComponentNode)) continue;
                RADComponentNode rADComponentNode = (RADComponentNode)node;
                RADComponent rADComponent = rADComponentNode.getRADComponent();
                MenuEditLayer.addComponentToEndOfMenu(rADComponent, this.pItem);
            }
        }
    }
}

