/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.layoutsupport.delegates;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.lang.reflect.Method;
import javax.swing.Icon;
import javax.swing.JTabbedPane;
import org.netbeans.modules.form.FormDesignValue;
import org.netbeans.modules.form.FormProperty;
import org.netbeans.modules.form.FormPropertyContext;
import org.netbeans.modules.form.FormUtils;
import org.netbeans.modules.form.RADComponent;
import org.netbeans.modules.form.codestructure.CodeExpression;
import org.netbeans.modules.form.codestructure.CodeGroup;
import org.netbeans.modules.form.codestructure.CodeStatement;
import org.netbeans.modules.form.codestructure.CodeStructure;
import org.netbeans.modules.form.codestructure.FormCodeSupport;
import org.netbeans.modules.form.layoutsupport.AbstractLayoutSupport;
import org.netbeans.modules.form.layoutsupport.LayoutConstraints;
import org.openide.ErrorManager;
import org.openide.nodes.Node;

public class JTabbedPaneSupport
extends AbstractLayoutSupport {
    private int selectedTab = -1;
    private static Method addTabMethod1;
    private static Method addTabMethod2;
    private static Method addTabMethod3;

    public Class getSupportedClass() {
        return JTabbedPane.class;
    }

    public void removeComponent(int n) {
        super.removeComponent(n);
        if (this.selectedTab >= this.getComponentCount()) {
            this.selectedTab = this.getComponentCount() - 1;
        }
    }

    public void processMouseClick(Point point, Container container, Container container2) {
        if (!(container instanceof JTabbedPane)) {
            return;
        }
        JTabbedPane jTabbedPane = (JTabbedPane)container;
        int n = jTabbedPane.getTabCount();
        for (int i = 0; i < n; ++i) {
            if (!jTabbedPane.getBoundsAt(i).contains(point)) continue;
            this.selectedTab = i;
            jTabbedPane.setSelectedIndex(i);
            break;
        }
    }

    public void selectComponent(int n) {
        this.selectedTab = n;
    }

    public void arrangeContainer(Container container, Container container2) {
        if (!(container instanceof JTabbedPane)) {
            return;
        }
        JTabbedPane jTabbedPane = (JTabbedPane)container;
        if (this.selectedTab >= 0) {
            if (jTabbedPane.getTabCount() > this.selectedTab) {
                jTabbedPane.setSelectedIndex(this.selectedTab);
                Component component = jTabbedPane.getSelectedComponent();
                if (component != null) {
                    component.setVisible(true);
                }
                jTabbedPane.repaint();
            }
        } else if (jTabbedPane.getTabCount() > 0) {
            jTabbedPane.getComponentAt(0).setVisible(true);
        }
    }

    public int getNewIndex(Container container, Container container2, Component component, int n, Point point, Point point2) {
        if (!(container instanceof JTabbedPane)) {
            return -1;
        }
        return ((JTabbedPane)container).getTabCount();
    }

    public String getAssistantContext() {
        return "tabbedPaneLayout";
    }

    public boolean paintDragFeedback(Container container, Container container2, Component component, LayoutConstraints layoutConstraints, int n, Graphics graphics) {
        if (!(container instanceof JTabbedPane)) {
            return false;
        }
        JTabbedPane jTabbedPane = (JTabbedPane)container;
        if (jTabbedPane.getTabCount() == 0 || component == jTabbedPane.getComponentAt(0)) {
            Dimension dimension = container.getSize();
            Insets insets = container.getInsets();
            dimension.width -= insets.left + insets.right;
            dimension.height -= insets.top + insets.bottom;
            graphics.drawRect(0, 0, dimension.width, dimension.height);
        } else {
            Rectangle rectangle = jTabbedPane.getComponentAt(0).getBounds();
            graphics.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        return true;
    }

    public void addComponentsToContainer(Container container, Container container2, Component[] componentArray, int n) {
        if (!(container instanceof JTabbedPane)) {
            return;
        }
        for (int i = 0; i < componentArray.length; ++i) {
            LayoutConstraints layoutConstraints = this.getConstraints(i + n);
            if (!(layoutConstraints instanceof TabConstraints)) continue;
            JTabbedPane jTabbedPane = (JTabbedPane)container;
            try {
                Object object = ((FormProperty)layoutConstraints.getProperties()[0]).getRealValue();
                Object object2 = ((FormProperty)layoutConstraints.getProperties()[1]).getRealValue();
                Object object3 = ((FormProperty)layoutConstraints.getProperties()[2]).getRealValue();
                jTabbedPane.insertTab(object instanceof String ? (String)object : null, object2 instanceof Icon ? (Icon)object2 : null, componentArray[i], object3 instanceof String ? (String)object3 : null, n + i);
                continue;
            }
            catch (Exception exception) {
                ErrorManager.getDefault().notify(1, (Throwable)exception);
            }
        }
    }

    protected CodeExpression readComponentCode(CodeStatement codeStatement, CodeGroup codeGroup) {
        int[] nArray;
        CodeExpression codeExpression;
        CodeExpression[] codeExpressionArray = codeStatement.getStatementParameters();
        Object object = codeStatement.getMetaObject();
        if (JTabbedPaneSupport.getAddTabMethod1().equals(object)) {
            codeExpression = codeExpressionArray[2];
            nArray = new int[]{0, 1, -1, 2};
        } else if (JTabbedPaneSupport.getAddTabMethod2().equals(object)) {
            codeExpression = codeExpressionArray[2];
            nArray = new int[]{0, 1, -1};
        } else if (JTabbedPaneSupport.getAddTabMethod3().equals(object)) {
            codeExpression = codeExpressionArray[1];
            nArray = new int[]{0, -1};
        } else {
            return null;
        }
        TabConstraints tabConstraints = new TabConstraints("tab");
        Node.Property[] propertyArray = tabConstraints.getProperties();
        for (int i = 0; i < codeExpressionArray.length; ++i) {
            if (codeExpressionArray[i] == codeExpression) continue;
            Node.Property property = propertyArray[nArray[i]];
            Object object2 = codeExpression.getOrigin().getMetaObject();
            if (property instanceof FormProperty && object2 instanceof RADComponent) {
                FormProperty formProperty = (FormProperty)property;
                RADComponent rADComponent = (RADComponent)object2;
                formProperty.setPropertyContext(new FormPropertyContext.Component(rADComponent));
            }
            FormCodeSupport.readPropertyExpression(codeExpressionArray[i], property, false);
        }
        this.getConstraintsList().add(tabConstraints);
        codeGroup.addStatement(codeStatement);
        tabConstraints.createComponentCode(codeGroup, this.getLayoutContext().getContainerCodeExpression(), codeExpression, false);
        return codeExpression;
    }

    protected void createComponentCode(CodeGroup codeGroup, CodeExpression codeExpression, int n) {
        LayoutConstraints layoutConstraints = this.getConstraints(n);
        if (!(layoutConstraints instanceof TabConstraints)) {
            return;
        }
        ((TabConstraints)layoutConstraints).createComponentCode(codeGroup, this.getLayoutContext().getContainerCodeExpression(), codeExpression, true);
    }

    protected LayoutConstraints createDefaultConstraints() {
        return new TabConstraints("tab" + this.getComponentCount());
    }

    private static Method getAddTabMethod1() {
        if (addTabMethod1 == null) {
            try {
                addTabMethod1 = JTabbedPane.class.getMethod("addTab", String.class, Icon.class, Component.class, String.class);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                noSuchMethodException.printStackTrace();
            }
        }
        return addTabMethod1;
    }

    private static Method getAddTabMethod2() {
        if (addTabMethod2 == null) {
            try {
                addTabMethod2 = JTabbedPane.class.getMethod("addTab", String.class, Icon.class, Component.class);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                noSuchMethodException.printStackTrace();
            }
        }
        return addTabMethod2;
    }

    private static Method getAddTabMethod3() {
        if (addTabMethod3 == null) {
            try {
                addTabMethod3 = JTabbedPane.class.getMethod("addTab", String.class, Component.class);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                noSuchMethodException.printStackTrace();
            }
        }
        return addTabMethod3;
    }

    public static class TabConstraints
    implements LayoutConstraints {
        private String title;
        private Icon icon;
        private String toolTip;
        private FormProperty[] properties;
        private CodeExpression containerExpression;
        private CodeExpression componentExpression;
        private CodeGroup componentCode;
        private CodeExpression[] propertyExpressions;

        public TabConstraints(String string) {
            this.title = string;
        }

        public TabConstraints(String string, Icon icon, String string2) {
            this.title = string;
            this.icon = icon;
            this.toolTip = string2;
        }

        public String getTitle() {
            return this.title;
        }

        public Icon getIcon() {
            return this.icon;
        }

        public String getToolTip() {
            return this.toolTip;
        }

        public Node.Property[] getProperties() {
            if (this.properties == null) {
                this.properties = new FormProperty[]{new FormProperty("TabConstraints.tabTitle", String.class, JTabbedPaneSupport.getBundle().getString("PROP_tabTitle"), JTabbedPaneSupport.getBundle().getString("HINT_tabTitle")){

                    public Object getTargetValue() {
                        return TabConstraints.this.title;
                    }

                    public void setTargetValue(Object object) {
                        TabConstraints.this.title = (String)object;
                    }

                    protected Object getRealValue(Object object) {
                        Object object2 = super.getRealValue(object);
                        if (object2 == FormDesignValue.IGNORED_VALUE) {
                            object2 = ((FormDesignValue)object).getDescription();
                        }
                        return object2;
                    }

                    protected void propertyValueChanged(Object object, Object object2) {
                        if (this.isChangeFiring()) {
                            TabConstraints.this.updateCode();
                        }
                        super.propertyValueChanged(object, object2);
                    }
                }, new FormProperty("TabConstraints.tabIcon", Icon.class, JTabbedPaneSupport.getBundle().getString("PROP_tabIcon"), JTabbedPaneSupport.getBundle().getString("HINT_tabIcon")){

                    public Object getTargetValue() {
                        return TabConstraints.this.icon;
                    }

                    public void setTargetValue(Object object) {
                        TabConstraints.this.icon = (Icon)object;
                    }

                    public boolean supportsDefaultValue() {
                        return true;
                    }

                    public Object getDefaultValue() {
                        return null;
                    }

                    protected void propertyValueChanged(Object object, Object object2) {
                        if (this.isChangeFiring()) {
                            TabConstraints.this.updateCode();
                        }
                        super.propertyValueChanged(object, object2);
                    }
                }, new FormProperty("TabConstraints.tabToolTip", String.class, JTabbedPaneSupport.getBundle().getString("PROP_tabToolTip"), JTabbedPaneSupport.getBundle().getString("HINT_tabToolTip")){

                    public Object getTargetValue() {
                        return TabConstraints.this.toolTip;
                    }

                    public void setTargetValue(Object object) {
                        TabConstraints.this.toolTip = (String)object;
                    }

                    protected Object getRealValue(Object object) {
                        Object object2 = super.getRealValue(object);
                        if (object2 == FormDesignValue.IGNORED_VALUE) {
                            object2 = ((FormDesignValue)object).getDescription();
                        }
                        return object2;
                    }

                    public boolean supportsDefaultValue() {
                        return true;
                    }

                    public Object getDefaultValue() {
                        return null;
                    }

                    protected void propertyValueChanged(Object object, Object object2) {
                        if (this.isChangeFiring()) {
                            TabConstraints.this.updateCode();
                        }
                        super.propertyValueChanged(object, object2);
                    }
                }};
                this.properties[0].setChanged(true);
            }
            return this.properties;
        }

        public Object getConstraintsObject() {
            return this.title;
        }

        public LayoutConstraints cloneConstraints() {
            TabConstraints tabConstraints = new TabConstraints(this.title);
            FormUtils.copyProperties(this.getProperties(), tabConstraints.getProperties(), 3);
            return tabConstraints;
        }

        private void createComponentCode(CodeGroup codeGroup, CodeExpression codeExpression, CodeExpression codeExpression2, boolean bl) {
            this.componentCode = codeGroup;
            this.containerExpression = codeExpression;
            this.componentExpression = codeExpression2;
            this.propertyExpressions = null;
            if (bl) {
                this.updateCode();
            }
        }

        private void updateCode() {
            CodeExpression[] codeExpressionArray;
            Method method;
            if (this.componentCode == null) {
                return;
            }
            CodeStructure.removeStatements(this.componentCode.getStatementsIterator());
            this.componentCode.removeAll();
            this.getProperties();
            if (this.properties[2].isChanged()) {
                method = JTabbedPaneSupport.getAddTabMethod1();
                codeExpressionArray = new CodeExpression[]{this.getPropertyExpression(0), this.getPropertyExpression(1), this.componentExpression, this.getPropertyExpression(2)};
            } else if (this.properties[1].isChanged()) {
                method = JTabbedPaneSupport.getAddTabMethod2();
                codeExpressionArray = new CodeExpression[]{this.getPropertyExpression(0), this.getPropertyExpression(1), this.componentExpression};
            } else {
                method = JTabbedPaneSupport.getAddTabMethod3();
                codeExpressionArray = new CodeExpression[]{this.getPropertyExpression(0), this.componentExpression};
            }
            CodeStatement codeStatement = CodeStructure.createStatement(this.containerExpression, method, codeExpressionArray);
            this.componentCode.addStatement(codeStatement);
        }

        private CodeExpression getPropertyExpression(int n) {
            if (this.propertyExpressions == null) {
                this.propertyExpressions = new CodeExpression[this.properties.length];
                for (int i = 0; i < this.properties.length; ++i) {
                    this.propertyExpressions[i] = this.componentExpression.getCodeStructure().createExpression(FormCodeSupport.createOrigin(this.properties[i]));
                }
            }
            return this.propertyExpressions[n];
        }
    }
}

