/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.editors;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import org.netbeans.modules.form.editors.ModifierEditor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;

final class ModifierPanel {
    public static final String PROP_MASK = "mask";
    public static final String PROP_MODIFIER = "modifier";
    private static final int CHECK_ABSTRACT = 0;
    private static final int CHECK_FINAL = 1;
    private static final int CHECK_STATIC = 2;
    private static final int CHECK_SYNCHRONIZED = 3;
    private static final int CHECK_TRANSIENT = 4;
    private static final int CHECK_VOLATILE = 5;
    private static final int CHECK_NATIVE = 6;
    static final String[] MODIFIER_NAMES = new String[]{"abstract", "final", "static", "synchronized", "transient", "volatile", "native"};
    private static final String[] MODIFIER_LABEL_KEYS = new String[]{"LBL_ModifierPanel_Modifier_Abstract", "LBL_ModifierPanel_Modifier_Final", "LBL_ModifierPanel_Modifier_Static", "LBL_ModifierPanel_Modifier_Synchronized", "LBL_ModifierPanel_Modifier_Transient", "LBL_ModifierPanel_Modifier_Volatile", "LBL_ModifierPanel_Modifier_Native"};
    private static final String[] MODIFIER_DESCRIPTION_KEYS = new String[]{"ACSD_ModifierPanel_Modifier_Abstract", "ACSD_ModifierPanel_Modifier_Final", "ACSD_ModifierPanel_Modifier_Static", "ACSD_ModifierPanel_Modifier_Synchronized", "ACSD_ModifierPanel_Modifier_Transient", "ACSD_ModifierPanel_Modifier_Volatile", "ACSD_ModifierPanel_Modifier_Native"};
    static final int[] MODIFIER_VALUES = new int[]{1024, 16, 8, 32, 128, 64, 256};
    static final int MODIFIER_COUNT = MODIFIER_VALUES.length;
    static final String[] ACCESS_NAMES = new String[]{"<default>", "private", "protected", "public"};
    static final int[] ACCESS_VALUES = new int[]{0, 2, 4, 1};
    static final int ACCESS_MASK = 7;
    private static final int OTHERS_MASK = 3576;
    static final int EDITABLE_MASK = 3583;
    private ModifierEditor myEditor;
    private int[] currentAccessValues;
    private String[] currentAccessNames;
    private JCheckBox[] checks;
    private ActionListener listener;
    private boolean ignored = false;
    private PropertyChangeListener editorListener;
    private JComboBox accessCombo;
    private JLabel jLabel1;
    private JPanel jPanel2;
    private JPanel modifPanel;
    private JPanel commpactP;
    private boolean isCompact = false;
    private boolean isPartial = false;

    public ModifierPanel(ModifierEditor modifierEditor) {
        this.myEditor = modifierEditor;
        this.currentAccessValues = ACCESS_VALUES;
        this.currentAccessNames = ACCESS_NAMES;
        this.editorListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (ModifierPanel.PROP_MODIFIER.equals(propertyChangeEvent.getPropertyName()) || ModifierPanel.PROP_MASK.equals(propertyChangeEvent.getPropertyName())) {
                    ModifierPanel.this.updateAccess();
                    ModifierPanel.this.ignored = true;
                    ModifierPanel.this.updateComponents();
                    ModifierPanel.this.ignored = false;
                }
            }
        };
        this.myEditor.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.editorListener, (Object)this.myEditor));
        this.listener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = ModifierPanel.this.accessCombo.getSelectedIndex();
                if (actionEvent.getSource() == ModifierPanel.this.accessCombo && n < 0) {
                    return;
                }
                if (ModifierPanel.this.checks[0].isSelected() && (ModifierPanel.this.myEditor.getModifier() & MODIFIER_VALUES[0]) == 0 && (ModifierPanel.this.myEditor.getModifier() & 2) > 0) {
                    ModifierPanel.this.checks[0].setSelected(false);
                }
                if (n >= 0 && (ModifierPanel.this.currentAccessValues[ModifierPanel.this.accessCombo.getSelectedIndex()] & 2) > 0 && (ModifierPanel.this.myEditor.getModifier() & 2) == 0) {
                    ModifierPanel.this.checks[0].setSelected(false);
                }
                ModifierPanel.this.excludeChecks(0, 1);
                ModifierPanel.this.excludeChecks(0, 6);
                ModifierPanel.this.excludeChecks(0, 2);
                ModifierPanel.this.excludeChecks(0, 3);
                ModifierPanel.this.excludeChecks(5, 1);
                if (!ModifierPanel.this.ignored) {
                    ModifierPanel.this.updateValue();
                }
            }
        };
        this.ignored = true;
        this.initBasicComponents();
        this.updateAccess();
        this.updateModifiers();
        this.updateComponents();
        this.ignored = false;
    }

    private void excludeChecks(int n, int n2) {
        if (this.checks[n].isSelected() && (this.myEditor.getModifier() & MODIFIER_VALUES[n]) == 0) {
            this.checks[n2].setSelected(false);
        } else if (this.checks[n2].isSelected() && (this.myEditor.getModifier() & MODIFIER_VALUES[n2]) == 0) {
            this.checks[n].setSelected(false);
        }
    }

    private void initBasicComponents() {
        this.accessCombo = new JComboBox();
        this.accessCombo.addActionListener(this.listener);
        this.accessCombo.getAccessibleContext().setAccessibleName("ACS_AccessRights");
        this.accessCombo.getAccessibleContext().setAccessibleDescription("ACSD_AccessRights");
        this.modifPanel = new JPanel();
        this.modifPanel.setLayout(new GridLayout(4, 2, 4, 4));
        this.modifPanel.getAccessibleContext().setAccessibleName("ACSN_OtherModifiers");
        this.modifPanel.getAccessibleContext().setAccessibleDescription("ACSD_OtherModifiers");
        this.checks = new JCheckBox[MODIFIER_COUNT];
        for (int i = 0; i < MODIFIER_COUNT; ++i) {
            this.checks[i] = new JCheckBox();
            Mnemonics.setLocalizedText((AbstractButton)this.checks[i], (String)ModifierPanel.getString(MODIFIER_LABEL_KEYS[i]));
            this.checks[i].getAccessibleContext().setAccessibleDescription(ModifierPanel.getModifierDescription(i));
            this.modifPanel.add(this.checks[i]);
            this.checks[i].setEnabled((this.myEditor.getMask() & MODIFIER_VALUES[i]) != 0);
            this.checks[i].addActionListener(this.listener);
        }
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel1.setLabelFor(this.accessCombo);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)ModifierPanel.getString("LAB_AccessRights"));
        this.jPanel2 = new JPanel();
        this.jPanel2.setLayout(new BorderLayout(8, 8));
        this.jPanel2.setBorder(new EmptyBorder(new Insets(5, 5, 5, 5)));
        this.jPanel2.add((Component)this.jLabel1, "West");
        this.jPanel2.add((Component)this.accessCombo, "Center");
        this.modifPanel.setBorder(new CompoundBorder(new TitledBorder(ModifierPanel.getString("LAB_Modifiers")), new EmptyBorder(new Insets(3, 3, 3, 3))));
        this.commpactP = new JPanel();
        this.commpactP.setLayout(new BorderLayout());
        this.commpactP.setBorder(new EmptyBorder(new Insets(6, 7, 6, 7)));
        this.commpactP.add((Component)this.modifPanel, "Center");
        this.commpactP.add((Component)this.jPanel2, "North");
        this.commpactP.getAccessibleContext().setAccessibleName("ACSN_ModifierPanel");
        this.commpactP.getAccessibleContext().setAccessibleDescription(ModifierPanel.getString("ACSD_ModifierPanel"));
    }

    public JComboBox getAccessComponent() {
        if (this.isCompact) {
            throw new IllegalStateException("cannot use both getAccessComponent/getCompactComponent");
        }
        this.isPartial = true;
        return this.accessCombo;
    }

    public JComponent getModifiersComponent() {
        if (this.isCompact) {
            throw new IllegalStateException("cannot use both getModifiersComponent/getCompactComponent");
        }
        this.isPartial = true;
        return this.modifPanel;
    }

    public JPanel getCompactComponent() {
        if (this.isPartial) {
            throw new IllegalStateException("cannot use getAccessComponent/getModifiersComponent/getCompactComponent together");
        }
        this.isCompact = true;
        if (this.commpactP == null) {
            this.initComponents();
        }
        return this.commpactP;
    }

    private void updateAccess() {
        int n;
        int n2 = this.myEditor.getModifier() & 7;
        int n3 = -1;
        int n4 = 1;
        for (n = 1; n < ACCESS_VALUES.length; ++n) {
            if ((ACCESS_VALUES[n] & this.myEditor.getMask()) == 0) continue;
            ++n4;
        }
        this.currentAccessValues = new int[n4];
        this.currentAccessNames = new String[n4];
        this.currentAccessValues[0] = ACCESS_VALUES[0];
        this.currentAccessNames[0] = ACCESS_NAMES[0];
        n4 = 1;
        for (n = 1; n < ACCESS_VALUES.length; ++n) {
            if ((ACCESS_VALUES[n] & this.myEditor.getMask()) == 0) continue;
            this.currentAccessValues[n4] = ACCESS_VALUES[n];
            this.currentAccessNames[n4] = ACCESS_NAMES[n];
            if (ACCESS_VALUES[n] == n2) {
                n3 = n4;
            }
            ++n4;
        }
        if (n3 == -1 && n2 == 0) {
            n3 = 0;
        }
        this.ignored = true;
        this.accessCombo.setModel(new DefaultComboBoxModel<String>(this.currentAccessNames));
        this.accessCombo.setSelectedIndex(n3);
        this.ignored = false;
    }

    private void updateModifiers() {
        for (int i = 0; i < MODIFIER_COUNT; ++i) {
            this.checks[i].setEnabled((this.myEditor.getMask() & MODIFIER_VALUES[i]) != 0);
        }
    }

    private void updateComponents() {
        this.updateAccessCombo();
        this.updateModifiers();
        for (int i = 0; i < MODIFIER_COUNT; ++i) {
            this.checks[i].setSelected((this.myEditor.getModifier() & MODIFIER_VALUES[i]) != 0);
        }
    }

    private void updateAccessCombo() {
        int n = -1;
        if (this.myEditor.getModifier() == 0) {
            n = 0;
        } else {
            for (int i = 1; i < this.currentAccessValues.length; ++i) {
                if ((this.currentAccessValues[i] & this.myEditor.getModifier()) == 0) continue;
                if (n != -1) {
                    n = -1;
                    break;
                }
                n = i;
            }
        }
        if (this.accessCombo.getSelectedIndex() != n) {
            this.accessCombo.setSelectedIndex(n);
        }
    }

    private void updateValue() {
        int n;
        int n2 = 0;
        int n3 = this.accessCombo.getSelectedIndex();
        Object object = this.myEditor.getType();
        int n4 = 0;
        if (ModifierEditor.FULL_CUSTOM_EDITOR == object || ModifierEditor.ACCESS_MODIFIERS_CUSTOM_EDITOR == object) {
            n4 |= 7;
            n2 = n3 == -1 ? this.myEditor.getModifier() & 7 : (n2 |= this.currentAccessValues[n3]);
        }
        if (ModifierEditor.FULL_CUSTOM_EDITOR == object || ModifierEditor.OTHERS_MODIFIERS_CUSTOM_EDITOR == object) {
            n4 |= 0xDF8;
            for (n = 0; n < MODIFIER_COUNT; ++n) {
                if (!(this.checks[n].isSelected() & this.checks[n].isEnabled())) continue;
                n2 |= MODIFIER_VALUES[n];
            }
        }
        if (((n = this.myEditor.getModifier()) & n4) != n2) {
            if (ModifierEditor.ACCESS_MODIFIERS_CUSTOM_EDITOR == object) {
                n2 |= n & 0xFFFFFFF8;
            } else if (ModifierEditor.OTHERS_MODIFIERS_CUSTOM_EDITOR == object) {
                n2 |= n & 0xFFFFF207;
            }
            this.myEditor.setModifier(n2);
        }
    }

    private static String getString(String string) {
        return NbBundle.getMessage(ModifierPanel.class, (String)string);
    }

    static String getModifierDescription(int n) {
        return ModifierPanel.getString(MODIFIER_DESCRIPTION_KEYS[n]);
    }
}

