/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.editors;

import java.beans.PropertyEditorSupport;
import org.netbeans.modules.form.NamedPropertyEditor;
import org.openide.util.NbBundle;

public class EnumEditor
extends PropertyEditorSupport
implements NamedPropertyEditor {
    private Object[] enumerationValues;
    private static String[] arrangedEnumLabels = new String[]{"WindowConstants.DISPOSE_ON_CLOSE", "DISPOSE", "WindowConstants.DO_NOTHING_ON_CLOSE", "DO_NOTHING", "WindowConstants.HIDE_ON_CLOSE", "HIDE", "JFrame.EXIT_ON_CLOSE", "EXIT", "ListSelectionModel.MULTIPLE_INTERVAL_SELECTION", "MULTIPLE_INTERVAL", "ListSelectionModel.SINGLE_INTERVAL_SELECTION", "SINGLE_INTERVAL", "ListSelectionModel.SINGLE_SELECTION", "SINGLE", "JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED", "AS_NEEDED", "JScrollPane.HORIZONTAL_SCROLLBAR_ALWAYS", "ALWAYS", "JScrollPane.HORIZONTAL_SCROLLBAR_NEVER", "NEVER", "JScrollPane.VERTICAL_SCROLLBAR_ALWAYS", "ALWAYS", "JScrollPane.VERTICAL_SCROLLBAR_NEVER", "NEVER", "JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED", "AS_NEEDED", "ScrollPaneConstants.HORIZONTAL_SCROLLBAR_AS_NEEDED", "AS_NEEDED", "ScrollPaneConstants.HORIZONTAL_SCROLLBAR_ALWAYS", "ALWAYS", "ScrollPaneConstants.HORIZONTAL_SCROLLBAR_NEVER", "NEVER", "ScrollPaneConstants.VERTICAL_SCROLLBAR_ALWAYS", "ALWAYS", "ScrollPaneConstants.VERTICAL_SCROLLBAR_NEVER", "NEVER", "ScrollPaneConstants.VERTICAL_SCROLLBAR_AS_NEEDED", "AS_NEEDED", "JTable.AUTO_RESIZE_NEXT_COLUMN", "NEXT_COLUMN", "JTable.AUTO_RESIZE_SUBSEQUENT_COLUMNS", "SUBSEQUENT_COLUMNS", "JTable.AUTO_RESIZE_OFF", "OFF", "JTable.AUTO_RESIZE_ALL_COLUMNS", "ALL_COLUMNS", "JTable.AUTO_RESIZE_LAST_COLUMN", "LAST_COLUMN"};
    private static String[] swingClassNames = new String[]{"SwingConstants.", "DebugGraphics.", "JDesktopPane.", "JFileChooser.", "WindowConstants.", "ListSelectionModel.", "JScrollBar.", "JScrollPane.", "ScrollPaneConstants.", "JSlider.", "JSplitPane.", "JTabbedPane.", "JTable.", "JTextField.", "JViewport.", "JFrame.", "JList.", "JFormattedTextField."};

    public EnumEditor(Object[] objectArray) {
        this(objectArray, true);
    }

    public EnumEditor(Object[] objectArray, boolean bl) {
        if (bl) {
            EnumEditor.translateEnumLabels(objectArray);
        }
        this.enumerationValues = objectArray;
    }

    protected Object[] getEnumerationValues() {
        return this.enumerationValues;
    }

    public String[] getTags() {
        int n = this.enumerationValues.length / 3;
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = (String)this.enumerationValues[i * 3];
        }
        return stringArray;
    }

    public void setAsText(String string) {
        int n = this.enumerationValues.length / 3;
        for (int i = 0; i < n; ++i) {
            if (!this.enumerationValues[i * 3].toString().equals(string)) continue;
            this.setValue(this.enumerationValues[i * 3 + 1]);
            break;
        }
    }

    public String getAsText() {
        Object object = this.getValue();
        int n = this.enumerationValues.length / 3;
        for (int i = 0; i < n; ++i) {
            Object object2 = this.enumerationValues[i * 3 + 1];
            if ((object2 != null || object != null) && (object2 == null || !object2.equals(object))) continue;
            return this.enumerationValues[i * 3].toString();
        }
        return this.enumerationValues.length > 0 ? this.enumerationValues[0].toString() : null;
    }

    public String getJavaInitializationString() {
        int n;
        String string = null;
        Object object = this.getValue();
        int n2 = this.enumerationValues.length / 3;
        for (n = 0; n < n2; ++n) {
            Object object2 = this.enumerationValues[n * 3 + 1];
            if ((object2 != null || object != null) && (object2 == null || !object2.equals(object))) continue;
            string = (String)this.enumerationValues[n * 3 + 2];
            break;
        }
        if (string == null) {
            String string2 = string = this.enumerationValues.length > 2 ? (String)this.enumerationValues[2] : null;
        }
        if (string == null) {
            return null;
        }
        for (n = 0; n < swingClassNames.length; ++n) {
            if (!string.startsWith(swingClassNames[n])) continue;
            string = "javax.swing." + string;
            break;
        }
        return string;
    }

    public String getDisplayName() {
        return NbBundle.getBundle(EnumEditor.class).getString("CTL_EnumEditorName");
    }

    private static void translateEnumLabels(Object[] objectArray) {
        int n = objectArray.length / 3;
        int n2 = arrangedEnumLabels.length / 2;
        block0: for (int i = 0; i < n; ++i) {
            String string = (String)objectArray[i * 3 + 2];
            for (int j = 0; j < n2; ++j) {
                if (!string.endsWith(arrangedEnumLabels[j * 2])) continue;
                objectArray[i * 3] = arrangedEnumLabels[j * 2 + 1];
                continue block0;
            }
        }
    }
}

