/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.awt.EventQueue;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.form.FormDataObject;
import org.netbeans.modules.form.FormEditor;
import org.netbeans.modules.form.FormEditorSupport;
import org.netbeans.modules.form.RADComponent;
import org.netbeans.modules.form.RefactoringInfo;
import org.netbeans.modules.form.ResourceSupport;
import org.netbeans.modules.refactoring.api.SingleCopyRefactoring;
import org.netbeans.modules.refactoring.spi.BackupFacility;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.SimpleRefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.Transaction;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.PositionBounds;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class FormRefactoringUpdate
extends SimpleRefactoringElementImplementation
implements Transaction {
    private RefactoringInfo refInfo;
    private RefactoringElementImplementation previewElement;
    private FileObject changingFile;
    private FormDataObject formDataObject;
    private FormEditor formEditor;
    private boolean loadingFailed;
    private boolean guardedCodeChanging;
    private boolean transactionDone;
    private boolean formFileRenameDone;
    private List<RefactoringElementImplementation> preFileChanges;
    private List<BackupFacility.Handle> backups;
    private static final String[] FORM_ELEMENTS_ATTRS = new String[]{"<Component ", " class=\"", "<AuxValue name=\"JavaCodeGenerator_", " value=\"", "<Property ", " preCode=\"", "<Property ", " postCode=\"", "<Connection ", " code=\""};

    public FormRefactoringUpdate(RefactoringInfo refactoringInfo, FileObject fileObject) {
        block3: {
            this.refInfo = refactoringInfo;
            this.changingFile = fileObject;
            try {
                DataObject dataObject = DataObject.find((FileObject)fileObject);
                if (dataObject instanceof FormDataObject) {
                    this.formDataObject = (FormDataObject)dataObject;
                }
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                if ($assertionsDisabled) break block3;
                throw new AssertionError();
            }
        }
    }

    FormDataObject getFormDataObject() {
        return this.formDataObject;
    }

    RefactoringElementImplementation getPreviewElement() {
        if (this.previewElement == null) {
            this.previewElement = new PreviewElement(this.changingFile);
        }
        return this.previewElement;
    }

    void setGaurdedCodeChanging(boolean bl) {
        this.guardedCodeChanging = bl;
    }

    boolean isGuardedCodeChanging() {
        return this.guardedCodeChanging;
    }

    public void addPrecedingFileChange(RefactoringElementImplementation refactoringElementImplementation) {
        if (this.preFileChanges == null) {
            this.preFileChanges = new LinkedList<RefactoringElementImplementation>();
        }
        this.preFileChanges.add(refactoringElementImplementation);
    }

    public void commit() {
        if (this.previewElement != null && !this.previewElement.isEnabled()) {
            return;
        }
        switch (this.refInfo.getChangeType()) {
            case VARIABLE_RENAME: {
                this.renameMetaComponent(this.refInfo.getOldName(), this.refInfo.getNewName());
                this.transactionDone = true;
                break;
            }
            case CLASS_RENAME: {
                if (this.refInfo.getPrimaryFile().equals(this.changingFile)) break;
                this.componentClassRename(this.refInfo.getOldName(), this.refInfo.getNewName());
                this.transactionDone = true;
                break;
            }
            case CLASS_MOVE: {
                if (this.refInfo.getPrimaryFile().equals(this.changingFile)) break;
                this.componentChange(this.refInfo.getOldName(), this.refInfo.getNewName());
                this.transactionDone = true;
                break;
            }
            case CLASS_DELETE: {
                this.saveFormForUndo();
                this.transactionDone = true;
                break;
            }
            case PACKAGE_RENAME: {
                if (this.changingFile.getParent().equals(this.refInfo.getPrimaryFile())) break;
                this.packageRename();
                this.transactionDone = true;
            }
        }
    }

    public void rollback() {
        if (this.previewElement != null && !this.previewElement.isEnabled()) {
            return;
        }
        this.undoFromBackups();
    }

    public void performChange() {
        if (this.previewElement != null && !this.previewElement.isEnabled()) {
            return;
        }
        if (this.transactionDone) {
            this.processCustomCode();
            return;
        }
        if (this.preFileChanges != null) {
            for (RefactoringElementImplementation refactoringElementImplementation : this.preFileChanges) {
                refactoringElementImplementation.performChange();
            }
        }
        switch (this.refInfo.getChangeType()) {
            case CLASS_RENAME: {
                if (!this.refInfo.getPrimaryFile().equals(this.changingFile)) break;
                this.formRename();
                break;
            }
            case CLASS_MOVE: {
                if (!this.refInfo.getPrimaryFile().equals(this.changingFile) || !this.prepareForm(false)) break;
                this.formMove();
                break;
            }
            case CLASS_COPY: {
                if (!this.refInfo.getPrimaryFile().equals(this.changingFile) || !this.prepareForm(false)) break;
                this.formCopy();
                break;
            }
            case PACKAGE_RENAME: 
            case FOLDER_RENAME: {
                this.packageRename();
            }
        }
        this.processCustomCode();
    }

    public void undoChange() {
        if (this.previewElement != null && !this.previewElement.isEnabled()) {
            return;
        }
        if (this.transactionDone) {
            return;
        }
        this.undoFromBackups();
        if (this.preFileChanges != null) {
            for (RefactoringElementImplementation refactoringElementImplementation : this.preFileChanges) {
                refactoringElementImplementation.undoChange();
            }
        }
    }

    private void renameMetaComponent(String string, String string2) {
        RADComponent rADComponent;
        if (this.prepareForm(true) && (rADComponent = this.formEditor.getFormModel().findRADComponent(string)) != null) {
            this.saveFormForUndo();
            this.saveResourcesForContentChangeUndo();
            rADComponent.setName(string2);
            this.updateForm(false);
        }
    }

    private void formRename() {
        if (this.prepareForm(true)) {
            this.saveFormForUndo();
            this.saveResourcesForFormRenameUndo();
            ResourceSupport.formMoved(this.formEditor.getFormModel(), null, this.refInfo.getOldName(), false);
            this.updateForm(true);
        }
    }

    private void componentClassRename(String string, String string2) {
        FileObject fileObject = this.refInfo.getPrimaryFile();
        String string3 = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/source").getResourceName(fileObject.getParent(), '.', false);
        String string4 = string3 != null && string3.length() > 0 ? string3 + "." + string : string;
        String string5 = string3 != null && string3.length() > 0 ? string3 + "." + string2 : string2;
        this.componentChange(string4, string5);
    }

    private void formMove() {
        final FormEditorSupport formEditorSupport = this.formDataObject.getFormEditorSupport();
        if (formEditorSupport.isOpened()) {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    FormRefactoringUpdate.this.formEditor = formEditorSupport.reloadFormEditor();
                    FormRefactoringUpdate.this.formMove2();
                }
            });
        } else {
            assert (!this.formEditor.isFormLoaded());
            this.formMove2();
        }
    }

    private void formMove2() {
        if (this.prepareForm(true)) {
            this.saveFormForUndo();
            FileObject fileObject = this.changingFile.getParent();
            this.saveResourcesForFormMoveUndo(fileObject);
            String string = this.refInfo.getOldName();
            string = string.substring(string.lastIndexOf(46) + 1);
            ResourceSupport.formMoved(this.formEditor.getFormModel(), fileObject, string, false);
            this.updateForm(true);
        }
    }

    private void formCopy() {
        if (this.refInfo.getRefactoring() instanceof SingleCopyRefactoring) {
            Object object;
            FileObject fileObject;
            FileObject fileObject2;
            block6: {
                SingleCopyRefactoring singleCopyRefactoring = (SingleCopyRefactoring)this.refInfo.getRefactoring();
                String string = singleCopyRefactoring.getNewName();
                Lookup lookup = singleCopyRefactoring.getTarget();
                fileObject2 = URLMapper.findFileObject((URL)((URL)lookup.lookup(URL.class)));
                fileObject = this.changingFile.getParent();
                this.changingFile = fileObject2.getFileObject(string, "java");
                try {
                    object = DataObject.find((FileObject)this.changingFile);
                    if (object instanceof FormDataObject) {
                        this.formDataObject = (FormDataObject)((Object)object);
                    }
                }
                catch (DataObjectNotFoundException dataObjectNotFoundException) {
                    if ($assertionsDisabled) break block6;
                    throw new AssertionError();
                }
            }
            this.formEditor = null;
            if (this.prepareForm(true)) {
                this.saveResourcesForFormRenameUndo();
                if (fileObject == fileObject2) {
                    fileObject = null;
                }
                object = this.refInfo.getOldName();
                object = ((String)object).substring(((String)object).lastIndexOf(46) + 1);
                ResourceSupport.formMoved(this.formEditor.getFormModel(), fileObject, (String)object, true);
                this.updateForm(true);
            }
        }
    }

    private void componentChange(String string, String string2) {
        FormEditorSupport formEditorSupport = this.formDataObject.getFormEditorSupport();
        if (formEditorSupport.isOpened()) {
            formEditorSupport.closeFormEditor();
        }
        this.replaceClassOrPkgName(string, string2, false);
        this.replaceShortClassName(string, string2);
    }

    private boolean replaceShortClassName(String string, String string2) {
        if (string.contains(".")) {
            String string3 = string.substring(string.lastIndexOf(46) + 1);
            String string4 = string2.substring(string2.lastIndexOf(46) + 1);
            if (!string4.equals(string3)) {
                return this.replaceClassOrPkgName(string3, string2, false);
            }
        }
        return false;
    }

    private void packageRename() {
        FormEditorSupport formEditorSupport = this.formDataObject.getFormEditorSupport();
        if (formEditorSupport.isOpened()) {
            formEditorSupport.closeFormEditor();
        }
        if (this.replaceClassOrPkgName(this.refInfo.getOldName(), this.refInfo.getNewName(), true) && !this.isGuardedCodeChanging()) {
            this.updateForm(true);
        }
    }

    private void processCustomCode() {
        if (this.isGuardedCodeChanging() && !this.formFileRenameDone) {
            String string = this.refInfo.getOldName();
            String string2 = this.refInfo.getNewName();
            if (string != null && string2 != null) {
                boolean bl = this.replaceClassOrPkgName(string, string2, false);
                switch (this.refInfo.getChangeType()) {
                    case CLASS_RENAME: 
                    case CLASS_MOVE: {
                        bl |= this.replaceShortClassName(string, string2);
                    }
                }
                if (bl) {
                    final FormEditorSupport formEditorSupport = this.formDataObject.getFormEditorSupport();
                    if (formEditorSupport.isOpened()) {
                        EventQueue.invokeLater(new Runnable(){

                            public void run() {
                                FormRefactoringUpdate.this.formEditor = formEditorSupport.reloadFormEditor();
                                FormRefactoringUpdate.this.updateForm(true);
                            }
                        });
                    } else {
                        if (this.formEditor != null && this.formEditor.isFormLoaded()) {
                            this.formEditor.closeForm();
                        }
                        if (this.prepareForm(true)) {
                            this.updateForm(true);
                        }
                    }
                }
                this.formFileRenameDone = false;
            }
        }
    }

    private void updateForm(boolean bl) {
        if (!this.prepareForm(true)) {
            return;
        }
        this.formEditor.getFormModel().fireFormChanged(true);
        FormEditorSupport formEditorSupport = this.getFormDataObject().getFormEditorSupport();
        try {
            if (!formEditorSupport.isOpened()) {
                this.formEditor.saveFormData();
                if (bl) {
                    formEditorSupport.saveSourceOnly();
                }
                this.formEditor.closeForm();
            } else if (bl) {
                formEditorSupport.saveDocument();
            }
        }
        catch (Exception exception) {
            Exceptions.printStackTrace((Throwable)exception);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean prepareForm(boolean bl) {
        if (this.formDataObject != null) {
            FormEditor formEditor = this.formDataObject.getFormEditorSupport().getFormEditor();
            if (formEditor != null) {
                this.formEditor = formEditor;
            } else if (this.formEditor == null) {
                this.formEditor = new FormEditor(this.formDataObject);
            }
        }
        if (this.formEditor == null) return false;
        if (this.formEditor.isFormLoaded() || !bl) {
            return true;
        }
        if (this.loadingFailed) return false;
        if (this.formEditor.loadForm()) {
            if (!this.formEditor.anyPersistenceError()) return true;
            this.formEditor.closeForm();
            this.loadingFailed = true;
            return false;
        } else {
            this.loadingFailed = true;
        }
        return false;
    }

    private void saveFormForUndo() {
        this.saveForUndo(this.formDataObject.getFormFile());
    }

    private void saveResourcesForContentChangeUndo() {
        for (URL uRL : ResourceSupport.getFilesForContentChangeBackup(this.formEditor.getFormModel())) {
            this.saveForUndo(uRL);
        }
    }

    private void saveResourcesForFormRenameUndo() {
        for (URL uRL : ResourceSupport.getFilesForFormRenameBackup(this.formEditor.getFormModel())) {
            this.saveForUndo(uRL);
        }
    }

    private void saveResourcesForFormMoveUndo(FileObject fileObject) {
        for (URL uRL : ResourceSupport.getFilesForFormMoveBackup(this.formEditor.getFormModel(), fileObject)) {
            this.saveForUndo(uRL);
        }
    }

    private void saveForUndo(final URL uRL) {
        BackupFacility.Handle handle;
        FileObject fileObject = URLMapper.findFileObject((URL)uRL);
        if (fileObject != null) {
            try {
                handle = BackupFacility.getDefault().backup(new FileObject[]{fileObject});
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
                return;
            }
        } else {
            handle = new BackupFacility.Handle(){

                public void restore() throws IOException {
                    FileObject fileObject = URLMapper.findFileObject((URL)uRL);
                    if (fileObject != null) {
                        fileObject.delete();
                    }
                }
            };
        }
        if (this.backups == null) {
            this.backups = new ArrayList<BackupFacility.Handle>();
        }
        this.backups.add(handle);
    }

    private void saveForUndo(FileObject fileObject) {
        try {
            BackupFacility.Handle handle = BackupFacility.getDefault().backup(new FileObject[]{fileObject});
            if (this.backups == null) {
                this.backups = new ArrayList<BackupFacility.Handle>();
            }
            this.backups.add(handle);
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
    }

    private void undoFromBackups() {
        if (this.backups != null) {
            try {
                for (BackupFacility.Handle handle : this.backups) {
                    handle.restore();
                }
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
            this.backups.clear();
        }
    }

    public String getText() {
        return "GUI form update";
    }

    public String getDisplayText() {
        return NbBundle.getMessage(FormRefactoringUpdate.class, (String)"CTL_RefactoringUpdate2");
    }

    public Lookup getLookup() {
        return Lookup.EMPTY;
    }

    public FileObject getParentFile() {
        return this.changingFile;
    }

    public PositionBounds getPosition() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean replaceClassOrPkgName(String string, String string2, boolean bl) {
        FileObject fileObject = this.formDataObject.getFormFile();
        FileLock fileLock = null;
        OutputStream outputStream = null;
        InputStream inputStream = null;
        try {
            String string3;
            boolean bl2;
            String[] stringArray;
            String[] stringArray2;
            fileLock = fileObject.lock();
            if (bl) {
                string = string + ".";
                string2 = string2 + ".";
                stringArray2 = new String[]{string, string.replace('.', '/')};
                stringArray = new String[]{string2, string2.replace('.', '/')};
                bl2 = false;
            } else {
                bl2 = !string.contains(".");
                stringArray2 = new String[]{string};
                stringArray = new String[]{string2};
            }
            String string4 = "UTF-8";
            inputStream = fileObject.getInputStream();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, string4));
            if (!bl2) {
                NameReplacer nameReplacer = new NameReplacer(stringArray2, stringArray, (int)fileObject.getSize());
                String string5 = bufferedReader.readLine();
                while (string5 != null) {
                    nameReplacer.append(string5);
                    string5 = bufferedReader.readLine();
                    if (string5 == null) continue;
                    nameReplacer.append("\n");
                }
                string3 = nameReplacer.getResult();
                if (!nameReplacer.anythingChanged()) {
                    boolean bl3 = false;
                    return bl3;
                }
            } else {
                StringBuilder stringBuilder = new StringBuilder((int)fileObject.getSize());
                boolean bl4 = false;
                String string6 = bufferedReader.readLine();
                while (string6 != null) {
                    String string7 = string6.trim();
                    for (int i = 0; i < FORM_ELEMENTS_ATTRS.length; i += 2) {
                        String string8;
                        int n;
                        String string9;
                        int n2;
                        if (!string7.startsWith(FORM_ELEMENTS_ATTRS[i]) || (n2 = string6.indexOf(string9 = FORM_ELEMENTS_ATTRS[i + 1])) <= 0) continue;
                        int n3 = n2 + string9.length();
                        if (!string9.endsWith("\"")) {
                            while (n3 < string6.length() && string6.charAt(n3) != '\"') {
                                ++n3;
                            }
                        }
                        for (n = ++n3; n < string6.length() && string6.charAt(n) != '\"'; ++n) {
                        }
                        if (n3 >= string6.length() || n >= string6.length() || !(string8 = string6.substring(n3, n)).contains(string)) continue;
                        NameReplacer nameReplacer = new NameReplacer(stringArray2, stringArray, string8.length());
                        nameReplacer.append(string8);
                        string8 = nameReplacer.getResult();
                        if (!nameReplacer.anythingChanged()) continue;
                        string6 = string6.substring(0, n3) + string8 + string6.substring(n);
                        bl4 = true;
                    }
                    stringBuilder.append(string6);
                    string6 = bufferedReader.readLine();
                    if (string6 == null) continue;
                    stringBuilder.append("\n");
                }
                if (!bl4) {
                    boolean bl5 = false;
                    return bl5;
                }
                string3 = stringBuilder.toString();
            }
            this.saveForUndo(fileObject);
            inputStream.close();
            inputStream = null;
            outputStream = fileObject.getOutputStream(fileLock);
            outputStream.write(string3.getBytes(string4));
        }
        catch (Exception exception) {
            Exceptions.printStackTrace((Throwable)exception);
            boolean bl6 = false;
            return bl6;
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (IOException iOException) {}
            if (fileLock != null) {
                fileLock.releaseLock();
            }
        }
        this.formFileRenameDone = true;
        return true;
    }

    private static class NameReplacer {
        private String[] toReplace;
        private String[] replaceWith;
        private int[] matchCounts;
        private StringBuilder buffer;
        private StringBuilder pendingChars;
        private char lastChar;
        private boolean anyChange;
        private boolean ended;

        public NameReplacer(String[] stringArray, String[] stringArray2, int n) {
            this.toReplace = stringArray;
            for (String string : stringArray) {
                assert (string != null && string.length() > 0);
            }
            for (String string : stringArray2) {
                assert (string != null && string.length() > 0);
            }
            this.replaceWith = stringArray2;
            this.pendingChars = new StringBuilder(50);
            this.buffer = new StringBuilder(n);
            this.matchCounts = new int[stringArray.length];
        }

        public void append(String string) {
            assert (!this.ended);
            for (int i = 0; i < string.length(); ++i) {
                this.append(string.charAt(i));
            }
        }

        public String getResult() {
            for (int i = 0; i < this.toReplace.length; ++i) {
                int n = this.matchCounts[i];
                String string = this.toReplace[i];
                if (n != string.length()) continue;
                this.replace(i);
                break;
            }
            this.writePendingChars();
            this.ended = true;
            return this.buffer.toString();
        }

        public boolean anythingChanged() {
            return this.anyChange;
        }

        private void append(char c) {
            int n = -1;
            boolean bl = false;
            for (int i = 0; i < this.toReplace.length; ++i) {
                int n2 = this.matchCounts[i];
                String string = this.toReplace[i];
                if (n2 == string.length()) {
                    if (this.canEndHere(c)) {
                        n = i;
                        break;
                    }
                    this.matchCounts[i] = 0;
                    continue;
                }
                if (string.charAt(n2) == c) {
                    if (n2 <= 0 && !this.canStartHere()) continue;
                    this.matchCounts[i] = n2 + 1;
                    bl = true;
                    continue;
                }
                this.matchCounts[i] = 0;
            }
            if (n >= 0) {
                this.replace(n);
                this.buffer.append(c);
            } else if (bl) {
                this.pendingChars.append(c);
            } else {
                this.writePendingChars();
                this.buffer.append(c);
            }
            this.lastChar = c;
        }

        private boolean canStartHere() {
            return this.lastChar != '.' && this.lastChar != '/' && (this.lastChar <= ' ' || !Character.isJavaIdentifierPart(this.lastChar));
        }

        private boolean canEndHere(char c) {
            return this.lastChar == '.' || this.lastChar == '/' || !Character.isJavaIdentifierPart(c);
        }

        private void replace(int n) {
            int n2 = this.pendingChars.length() - this.matchCounts[n];
            if (n2 > 0) {
                this.buffer.append(this.pendingChars.substring(0, n2));
            }
            this.buffer.append(this.replaceWith[n]);
            for (int i = 0; i < this.matchCounts.length; ++i) {
                this.matchCounts[i] = 0;
            }
            this.pendingChars.delete(0, this.pendingChars.length());
            this.anyChange = true;
        }

        private void writePendingChars() {
            if (this.pendingChars.length() > 0) {
                this.buffer.append(this.pendingChars.toString());
                this.pendingChars.delete(0, this.pendingChars.length());
            }
        }
    }

    private static class PreviewElement
    extends SimpleRefactoringElementImplementation {
        private FileObject file;

        PreviewElement(FileObject fileObject) {
            this.file = fileObject;
        }

        public String getText() {
            return "GUI form update";
        }

        public String getDisplayText() {
            return NbBundle.getMessage(FormRefactoringUpdate.class, (String)"CTL_RefactoringUpdate1");
        }

        public void performChange() {
        }

        public Lookup getLookup() {
            return Lookup.EMPTY;
        }

        public FileObject getParentFile() {
            return this.file;
        }

        public PositionBounds getPosition() {
            return null;
        }
    }
}

