/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import org.netbeans.modules.form.Event;
import org.netbeans.modules.form.EventCustomEditor;
import org.netbeans.modules.form.FormEvents;
import org.netbeans.modules.form.FormNode;
import org.netbeans.modules.form.FormUtils;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.util.Utilities;

class EventProperty
extends PropertySupport.ReadWrite {
    private static String NO_EVENT;
    private static boolean somethingChanged;
    private static boolean invalidValueTried;
    private Event event;
    private String selectedEventHandler;

    EventProperty(Event event, String string) {
        super(string, String.class, event.getListenerMethod().getName(), event.getListenerMethod().getName());
        this.event = event;
        this.setShortDescription(event.getEventSetDescriptor().getListenerType().getName());
    }

    Event getEvent() {
        return this.event;
    }

    private FormEvents getFormEvents() {
        return this.event.getComponent().getFormModel().getFormEvents();
    }

    private Method getListenerMethod() {
        return this.event.getListenerMethod();
    }

    String[] getEventHandlers() {
        return this.event.getEventHandlers();
    }

    public Object getValue() {
        if (this.selectedEventHandler == null && this.event.hasEventHandlers()) {
            this.selectedEventHandler = (String)this.event.getEventHandlerList().get(0);
        }
        return this.selectedEventHandler;
    }

    public void setValue(Object object) {
        Object object2;
        Object object3;
        Change change = null;
        Object object4 = null;
        if (object instanceof Change) {
            change = (Change)object;
        } else if (object instanceof String) {
            object3 = this.getEventHandlers();
            if (((String[])object3).length > 0) {
                int n;
                Object object5 = object2 = this.selectedEventHandler != null ? this.selectedEventHandler : object3[0];
                if ("".equals(object)) {
                    change = new Change();
                    change.getRemoved().add((String)object2);
                    for (n = 0; n < ((Object)object3).length; ++n) {
                        if (((String)object3[n]).equals(object2)) continue;
                        object4 = object3[n];
                        break;
                    }
                } else {
                    object4 = (String)object;
                    n = 0;
                    for (int i = 0; i < ((Object)object3).length; ++i) {
                        if (!((String)object3[i]).equals(object)) continue;
                        n = 1;
                        break;
                    }
                    if (n == 0) {
                        change = new Change();
                        change.getRenamedNewNames().add((String)object);
                        change.getRenamedOldNames().add((String)object2);
                    }
                }
            } else if (!"".equals(object)) {
                change = new Change();
                change.getAdded().add((String)object);
                object4 = (String)object;
            }
        } else if (object == null) {
            if (this.selectedEventHandler == null) {
                return;
            }
        } else {
            throw new IllegalArgumentException();
        }
        if (change != null) {
            somethingChanged = true;
            object3 = this.getFormEvents();
            if (change.hasRemoved()) {
                object2 = change.getRemoved().iterator();
                while (object2.hasNext()) {
                    ((FormEvents)object3).detachEvent(this.event, (String)object2.next());
                }
            }
            if (change.hasRenamed()) {
                for (int i = 0; i < change.getRenamedOldNames().size(); ++i) {
                    String string = change.getRenamedOldNames().get(i);
                    String string2 = change.getRenamedNewNames().get(i);
                    try {
                        ((FormEvents)object3).renameEventHandler(string, string2);
                        Event[] eventArray = ((FormEvents)object3).getEventsForHandler(string2);
                        for (int j = 0; j < eventArray.length; ++j) {
                            Node.Property property = eventArray[j].getComponent().getPropertyByName(this.getName());
                            if (property == null || property == this) continue;
                            try {
                                if (!string.equals(property.getValue())) continue;
                                property.setValue((Object)string2);
                                continue;
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                        }
                        continue;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        ErrorManager.getDefault().notify(16, (Throwable)illegalArgumentException);
                        object4 = null;
                    }
                }
            }
            if (change.hasAdded()) {
                Iterator<String> iterator = change.getAdded().iterator();
                while (iterator.hasNext()) {
                    try {
                        ((FormEvents)object3).attachEvent(this.event, iterator.next(), null);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        ErrorManager.getDefault().notify(16, (Throwable)illegalArgumentException);
                        object4 = null;
                    }
                }
            }
        }
        this.selectedEventHandler = object4;
        object3 = this.event.getComponent().getNodeReference();
        if (object3 != null) {
            ((FormNode)object3).firePropertyChangeHelper(this.getName(), null, null);
        }
    }

    public Object getValue(String string) {
        if ("canEditAsText".equals(string)) {
            return Boolean.TRUE;
        }
        if ("initialEditValue".equals(string)) {
            somethingChanged = false;
            invalidValueTried = false;
            return this.selectedEventHandler != null ? null : this.getFormEvents().findFreeHandlerName(this.event, this.event.getComponent());
        }
        if ("postSetAction".equals(string)) {
            return new AbstractAction(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (!somethingChanged && !invalidValueTried) {
                        EventProperty.this.getFormEvents().attachEvent(EventProperty.this.event, EventProperty.this.selectedEventHandler, null);
                    }
                }
            };
        }
        return super.getValue(string);
    }

    public boolean canWrite() {
        return !this.isReadOnly();
    }

    private boolean isReadOnly() {
        return this.event.getComponent().isReadOnly();
    }

    public PropertyEditor getPropertyEditor() {
        return new EventEditor();
    }

    private class EventEditor
    extends PropertyEditorSupport {
        private EventEditor() {
        }

        public String getAsText() {
            if (this.getValue() == null) {
                if (NO_EVENT == null) {
                    NO_EVENT = FormUtils.getBundleString("CTL_NoEvent");
                }
                return NO_EVENT;
            }
            return this.getValue().toString();
        }

        public void setAsText(String string) {
            if (!"".equals(string) && !Utilities.isJavaIdentifier((String)string)) {
                invalidValueTried = true;
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException();
                String string2 = FormUtils.getFormattedBundleString("FMT_MSG_InvalidJavaIdentifier", new Object[]{string});
                ErrorManager.getDefault().annotate((Throwable)illegalArgumentException, 65536, "Not a java identifier", string2, null, null);
                throw illegalArgumentException;
            }
            if ("".equals(string) && this.getValue() == null) {
                invalidValueTried = true;
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException();
                String string3 = FormUtils.getBundleString("FMT_MSG_EmptyString");
                String string4 = FormUtils.getFormattedBundleString("FMT_MSG_InvalidJavaIdentifier", new Object[]{string3});
                ErrorManager.getDefault().annotate((Throwable)illegalArgumentException, 65536, "Not a java identifier", string4, null, null);
                throw illegalArgumentException;
            }
            invalidValueTried = false;
            this.setValue(string);
        }

        public String[] getTags() {
            String[] stringArray = EventProperty.this.getEventHandlers();
            return stringArray.length > 1 ? stringArray : null;
        }

        public boolean supportsCustomEditor() {
            return !EventProperty.this.isReadOnly();
        }

        public Component getCustomEditor() {
            if (EventProperty.this.isReadOnly()) {
                return null;
            }
            final EventCustomEditor eventCustomEditor = new EventCustomEditor(EventProperty.this);
            DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)eventCustomEditor, FormUtils.getFormattedBundleString("FMT_MSG_HandlersFor", new Object[]{EventProperty.this.getListenerMethod().getName()}), true, new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (actionEvent.getSource().equals(DialogDescriptor.OK_OPTION)) {
                        eventCustomEditor.doChanges();
                    }
                }
            });
            return DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Change {
        private List<String> added;
        private List<String> removed;
        private List<String> renamedOldName;
        private List<String> renamedNewName;

        Change() {
        }

        boolean hasAdded() {
            return this.added != null && this.added.size() > 0;
        }

        boolean hasRemoved() {
            return this.removed != null && this.removed.size() > 0;
        }

        boolean hasRenamed() {
            return this.renamedOldName != null && this.renamedOldName.size() > 0;
        }

        List<String> getAdded() {
            if (this.added == null) {
                this.added = new ArrayList<String>();
            }
            return this.added;
        }

        List<String> getRemoved() {
            if (this.removed == null) {
                this.removed = new ArrayList<String>();
            }
            return this.removed;
        }

        List<String> getRenamedOldNames() {
            if (this.renamedOldName == null) {
                this.renamedOldName = new ArrayList<String>();
            }
            return this.renamedOldName;
        }

        List<String> getRenamedNewNames() {
            if (this.renamedNewName == null) {
                this.renamedNewName = new ArrayList<String>();
            }
            return this.renamedNewName;
        }
    }
}

