/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby;

import java.io.File;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.jruby.ast.Node;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.ruby.platform.RubyPlatform;
import org.netbeans.modules.gsf.api.ElementHandle;
import org.netbeans.modules.gsf.api.Index;
import org.netbeans.modules.gsf.api.NameKind;
import org.netbeans.modules.gsf.api.TypeSearcher;
import org.netbeans.modules.ruby.AstUtilities;
import org.netbeans.modules.ruby.NbUtilities;
import org.netbeans.modules.ruby.RubyIndex;
import org.netbeans.modules.ruby.elements.IndexedClass;
import org.netbeans.modules.ruby.elements.IndexedElement;
import org.netbeans.modules.ruby.elements.IndexedMethod;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RubyTypeSearcher
implements TypeSearcher {
    private static Pattern camelCasePattern = Pattern.compile("(?:\\p{javaUpperCase}(?:\\p{javaLowerCase}|\\p{Digit}|\\:|\\.|\\$)*){2,}");
    private NameKind cachedKind;
    private String cachedString = "/";

    private static boolean isAllUpper(String string) {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (Character.isUpperCase(c) || c == ':') continue;
            return false;
        }
        return true;
    }

    private static boolean isCamelCase(String string) {
        return camelCasePattern.matcher(string).matches();
    }

    private NameKind adjustKind(NameKind nameKind, String string) {
        if (string.equals(this.cachedString)) {
            return this.cachedKind;
        }
        if (nameKind == NameKind.CASE_INSENSITIVE_PREFIX && (RubyTypeSearcher.isAllUpper(string) && string.length() > 1 || RubyTypeSearcher.isCamelCase(string))) {
            nameKind = NameKind.CAMEL_CASE;
        }
        this.cachedString = string;
        this.cachedKind = nameKind;
        return nameKind;
    }

    public Set<? extends TypeSearcher.GsfTypeDescriptor> getDeclaredTypes(Index index, String string, NameKind nameKind, EnumSet<Index.SearchScope> enumSet, TypeSearcher.Helper helper) {
        if (string.endsWith("::")) {
            string = string.substring(0, string.length() - 2);
        } else if (string.endsWith(":")) {
            string = string.substring(0, string.length() - 1);
        }
        RubyIndex rubyIndex = RubyIndex.get(index);
        if (rubyIndex == null) {
            return Collections.emptySet();
        }
        if ((nameKind = this.adjustKind(nameKind, string)) == NameKind.CASE_INSENSITIVE_PREFIX) {
            string = string.toLowerCase();
        }
        String string2 = null;
        int n = string.indexOf(35);
        if (n != -1) {
            string2 = string.substring(n + 1);
            string = string.substring(0, n);
        }
        Set<IndexedClass> set = null;
        if (string2 == null || string.length() > 0) {
            set = rubyIndex.getClasses(string, nameKind, true, false, false, enumSet, null);
        }
        HashSet<RubyTypeDescriptor> hashSet = new HashSet<RubyTypeDescriptor>();
        if (string2 != null) {
            Set<IndexedMethod> set2 = rubyIndex.getMethods(string2, null, nameKind, enumSet);
            block8: for (IndexedMethod indexedMethod : set2) {
                if (string.length() > 0 && indexedMethod.getClz() != null) {
                    String string3 = indexedMethod.getClz();
                    switch (nameKind) {
                        case CASE_INSENSITIVE_REGEXP: 
                        case REGEXP: {
                            try {
                                if (string3.indexOf("::") != -1 && string.indexOf("::") == -1) {
                                    boolean bl = false;
                                    for (String string4 : string3.split("::")) {
                                        if (!string4.matches(string)) continue;
                                        bl = true;
                                        break;
                                    }
                                    if (bl) break;
                                    continue block8;
                                }
                                if (string3.matches(string)) break;
                                continue block8;
                            }
                            catch (Exception exception) {
                                break;
                            }
                        }
                        case CASE_INSENSITIVE_PREFIX: {
                            if (string3.regionMatches(true, 0, string, 0, string.length())) break;
                            continue block8;
                        }
                        case PREFIX: {
                            if (string3.regionMatches(false, 0, string, 0, string.length())) break;
                            continue block8;
                        }
                        case EXACT_NAME: {
                            if (string3.equalsIgnoreCase(string)) break;
                            continue block8;
                        }
                    }
                }
                hashSet.add(new RubyTypeDescriptor(indexedMethod, helper));
            }
        } else {
            for (IndexedClass indexedClass : set) {
                hashSet.add(new RubyTypeDescriptor(indexedClass, helper));
            }
        }
        return hashSet;
    }

    public String getMimetype() {
        return "text/x-ruby";
    }

    private class RubyTypeDescriptor
    extends TypeSearcher.GsfTypeDescriptor {
        private final IndexedElement element;
        private String projectName;
        private Icon projectIcon;
        private final TypeSearcher.Helper helper;
        private boolean isLibrary;
        private static final String RUBY_KEYWORD = "org/netbeans/modules/ruby/jruby.png";

        public RubyTypeDescriptor(IndexedElement indexedElement, TypeSearcher.Helper helper) {
            this.element = indexedElement;
            this.helper = helper;
        }

        public Icon getIcon() {
            if (this.projectName == null) {
                this.initProjectInfo();
            }
            return this.helper.getIcon((ElementHandle)this.element);
        }

        public String getTypeName() {
            return this.element.getName();
        }

        public String getProjectName() {
            if (this.projectName == null) {
                this.initProjectInfo();
            }
            return this.projectName;
        }

        private void initProjectInfo() {
            FileObject fileObject = this.element.getFileObject();
            if (fileObject != null) {
                File file = FileUtil.toFile((FileObject)fileObject);
                Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
                if (project != null) {
                    RubyPlatform rubyPlatform = RubyPlatform.platformFor((Project)project);
                    if (rubyPlatform != null) {
                        String string = rubyPlatform.getLibDir();
                        if (string != null && file.getPath().startsWith(string)) {
                            this.projectName = "Ruby Library";
                            this.isLibrary = true;
                        }
                    } else {
                        ProjectInformation projectInformation = ProjectUtils.getInformation((Project)project);
                        this.projectName = projectInformation.getDisplayName();
                        this.projectIcon = projectInformation.getIcon();
                    }
                }
            } else {
                this.isLibrary = true;
                Logger.getLogger(RubyTypeSearcher.class.getName()).fine("No fileobject for " + this.element.toString() + " with fileurl=" + this.element.getFileUrl());
            }
            if (this.projectName == null) {
                this.projectName = "";
            }
        }

        public Icon getProjectIcon() {
            if (this.projectName == null) {
                this.initProjectInfo();
            }
            if (this.isLibrary) {
                return new ImageIcon(ImageUtilities.loadImage((String)RUBY_KEYWORD));
            }
            return this.projectIcon;
        }

        public FileObject getFileObject() {
            return this.element.getFileObject();
        }

        public void open() {
            Node node = AstUtilities.getForeignNode(this.element, null);
            if (node != null) {
                NbUtilities.open(this.element.getFileObject(), node.getPosition().getStartOffset(), this.element.getName());
                return;
            }
            FileObject fileObject = this.element.getFileObject();
            if (fileObject == null) {
                NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)NbBundle.getMessage(RubyTypeSearcher.class, (String)"FileDeleted"), 0);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                return;
            }
            this.helper.open(fileObject, (ElementHandle)this.element);
        }

        public String getContextName() {
            StringBuilder stringBuilder = new StringBuilder();
            String string = this.element.getRequire();
            String string2 = this.element.getFqn();
            if (this.element.getName().equals(string2)) {
                string2 = null;
            }
            if (string2 != null || string != null) {
                stringBuilder.append(" (");
                if (string2 != null) {
                    stringBuilder.append(string2);
                }
                if (string != null) {
                    if (string2 != null) {
                        stringBuilder.append(" ");
                    }
                    stringBuilder.append("in ");
                    stringBuilder.append(string);
                    stringBuilder.append(".rb");
                }
                stringBuilder.append(")");
                return stringBuilder.toString();
            }
            return null;
        }

        public ElementHandle getElement() {
            return this.element;
        }

        public int getOffset() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public String getSimpleName() {
            return this.element.getName();
        }

        public String getOuterName() {
            return null;
        }
    }
}

