/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.ImageIcon;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.jruby.ast.CallNode;
import org.jruby.ast.ClassNode;
import org.jruby.ast.Colon2Node;
import org.jruby.ast.CommentNode;
import org.jruby.ast.ConstNode;
import org.jruby.ast.DefnNode;
import org.jruby.ast.DefsNode;
import org.jruby.ast.FCallNode;
import org.jruby.ast.IScopingNode;
import org.jruby.ast.InstAsgnNode;
import org.jruby.ast.ListNode;
import org.jruby.ast.MethodDefNode;
import org.jruby.ast.ModuleNode;
import org.jruby.ast.Node;
import org.jruby.ast.SClassNode;
import org.jruby.ast.StrNode;
import org.jruby.ast.SymbolNode;
import org.jruby.ast.types.INameNode;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.parser.RubyParserResult;
import org.jruby.util.ByteList;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.gsf.api.CompilationInfo;
import org.netbeans.modules.gsf.api.ElementHandle;
import org.netbeans.modules.gsf.api.ElementKind;
import org.netbeans.modules.gsf.api.HtmlFormatter;
import org.netbeans.modules.gsf.api.Modifier;
import org.netbeans.modules.gsf.api.OffsetRange;
import org.netbeans.modules.gsf.api.StructureItem;
import org.netbeans.modules.gsf.api.StructureScanner;
import org.netbeans.modules.ruby.Arity;
import org.netbeans.modules.ruby.AstPath;
import org.netbeans.modules.ruby.AstUtilities;
import org.netbeans.modules.ruby.RubyParseResult;
import org.netbeans.modules.ruby.RubyUtils;
import org.netbeans.modules.ruby.elements.AstAttributeElement;
import org.netbeans.modules.ruby.elements.AstClassElement;
import org.netbeans.modules.ruby.elements.AstElement;
import org.netbeans.modules.ruby.elements.AstFieldElement;
import org.netbeans.modules.ruby.elements.AstMethodElement;
import org.netbeans.modules.ruby.elements.AstModuleElement;
import org.netbeans.modules.ruby.elements.AstNameElement;
import org.netbeans.modules.ruby.lexer.RubyTokenId;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RubyStructureAnalyzer
implements StructureScanner {
    private Set<AstClassElement> haveAccessModifiers;
    private List<AstElement> structure;
    private Map<AstClassElement, Set<InstAsgnNode>> fields;
    private Set<String> requires;
    private List<AstMethodElement> methods;
    private Map<AstClassElement, Set<AstAttributeElement>> attributes;
    private CompilationInfo info;
    private boolean isTestFile;
    private static final String RUBY_KEYWORD = "org/netbeans/modules/ruby/jruby.png";
    private static ImageIcon keywordIcon;
    private static final int MAX_RUBY_LABEL_LENGTH = 30;
    private static final String DEFAULT_LABEL = "<% %>";

    public List<? extends StructureItem> scan(CompilationInfo compilationInfo) {
        if (RubyUtils.isRhtmlOrYamlFile(compilationInfo.getFileObject())) {
            return this.scanRhtml(compilationInfo);
        }
        RubyParseResult rubyParseResult = AstUtilities.getParseResult(compilationInfo);
        this.info = compilationInfo;
        AnalysisResult analysisResult = rubyParseResult.getStructure();
        List<? extends AstElement> list = analysisResult.getElements();
        ArrayList<RubyStructureItem> arrayList = new ArrayList<RubyStructureItem>(list.size());
        for (AstElement astElement : list) {
            arrayList.add(new RubyStructureItem(astElement, compilationInfo));
        }
        return arrayList;
    }

    private AnalysisResult scan(RubyParseResult rubyParseResult) {
        Object object;
        Set<InstAsgnNode> set;
        AnalysisResult analysisResult = new AnalysisResult();
        Node node = AstUtilities.getRoot(rubyParseResult);
        if (node == null) {
            return analysisResult;
        }
        this.isTestFile = false;
        String string = rubyParseResult.getFile().getNameExt();
        int n = string.lastIndexOf(46);
        if (n != -1) {
            string = string.substring(0, n);
        }
        if (string.startsWith("test_") || string.endsWith("_test") || string.endsWith("_spec")) {
            this.isTestFile = true;
        }
        this.structure = new ArrayList<AstElement>();
        this.fields = new HashMap<AstClassElement, Set<InstAsgnNode>>();
        this.attributes = new HashMap<AstClassElement, Set<AstAttributeElement>>();
        this.requires = new HashSet<String>();
        this.methods = new ArrayList<AstMethodElement>();
        this.haveAccessModifiers = new HashSet<AstClassElement>();
        AstPath astPath = new AstPath();
        astPath.descend(node);
        this.scan(node, astPath, null, null, null);
        astPath.ascend();
        HashMap<String, InstAsgnNode> hashMap = new HashMap<String, InstAsgnNode>();
        for (AstClassElement astClassElement : this.fields.keySet()) {
            set = this.fields.get(astClassElement);
            if (set == null) continue;
            for (InstAsgnNode instAsgnNode : set) {
                hashMap.put(instAsgnNode.getName(), instAsgnNode);
            }
            for (InstAsgnNode instAsgnNode : hashMap.values()) {
                AstFieldElement astFieldElement = new AstFieldElement(this.info, (Node)instAsgnNode);
                astFieldElement.setIn(astClassElement.getFqn());
                object = instAsgnNode.getName();
                if (((String)object).startsWith("@@")) {
                    object = ((String)object).substring(2);
                } else if (((String)object).startsWith("@")) {
                    object = ((String)object).substring(1);
                }
                boolean bl = false;
                for (AstElement astElement : astClassElement.getChildren()) {
                    if (astElement.getKind() != ElementKind.ATTRIBUTE || !astElement.getName().equals(object)) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                astClassElement.addChild(astFieldElement);
            }
            hashMap.clear();
        }
        for (AstClassElement astClassElement : this.haveAccessModifiers) {
            set = new HashSet<InstAsgnNode>();
            Iterator iterator = new HashSet();
            AstUtilities.findPrivateMethods(astClassElement.getNode(), set, iterator);
            if (iterator.size() > 0) {
                for (AstMethodElement astMethodElement : this.methods) {
                    if (!(astMethodElement instanceof AstMethodElement) || !iterator.contains(((AstElement)(object = astMethodElement)).getNode())) continue;
                    ((AstMethodElement)object).setAccess(Modifier.PRIVATE);
                }
            }
            if (set.size() <= 0) continue;
            for (AstMethodElement astMethodElement : this.methods) {
                if (!(astMethodElement instanceof AstMethodElement) || !set.contains(((AstElement)(object = astMethodElement)).getNode())) continue;
                ((AstMethodElement)object).setAccess(Modifier.PROTECTED);
            }
        }
        analysisResult.setElements(this.structure);
        analysisResult.setAttributes(this.attributes);
        analysisResult.setRequires(this.requires);
        return analysisResult;
    }

    public Map<String, List<OffsetRange>> folds(CompilationInfo compilationInfo) {
        if (RubyUtils.isRhtmlFile(compilationInfo.getFileObject())) {
            return Collections.emptyMap();
        }
        Node node = AstUtilities.getRoot(compilationInfo);
        if (node == null) {
            return Collections.emptyMap();
        }
        RubyParseResult rubyParseResult = AstUtilities.getParseResult(compilationInfo);
        AnalysisResult analysisResult = rubyParseResult.getStructure();
        HashMap<String, List<OffsetRange>> hashMap = new HashMap<String, List<OffsetRange>>();
        ArrayList<OffsetRange> arrayList = new ArrayList<OffsetRange>();
        hashMap.put("codeblocks", arrayList);
        try {
            BaseDocument baseDocument = (BaseDocument)compilationInfo.getDocument();
            if (baseDocument != null) {
                this.addFolds(baseDocument, analysisResult.getElements(), hashMap, arrayList);
            }
        }
        catch (Exception exception) {
            Exceptions.printStackTrace((Throwable)exception);
        }
        return hashMap;
    }

    private void addFolds(BaseDocument baseDocument, List<? extends AstElement> list, Map<String, List<OffsetRange>> map, List<OffsetRange> list2) throws BadLocationException {
        for (AstElement astElement : list) {
            Object object;
            ElementKind elementKind = astElement.getKind();
            switch (elementKind) {
                case METHOD: 
                case CONSTRUCTOR: 
                case CLASS: 
                case MODULE: {
                    object = astElement.getNode();
                    OffsetRange offsetRange = AstUtilities.getRange((Node)object);
                    if (elementKind != ElementKind.METHOD && elementKind != ElementKind.CONSTRUCTOR && offsetRange.getStart() <= Utilities.getRowStart((BaseDocument)baseDocument, (int)offsetRange.getStart())) break;
                    int n = offsetRange.getStart();
                    n = Utilities.getRowEnd((BaseDocument)baseDocument, (int)n);
                    int n2 = offsetRange.getEnd();
                    if (n == -1 || n2 == -1 || n >= n2 || n2 > baseDocument.getLength()) break;
                    offsetRange = new OffsetRange(n, n2);
                    list2.add(offsetRange);
                    break;
                }
                case TEST: {
                    object = astElement.getNode();
                    OffsetRange offsetRange = AstUtilities.getRange((Node)object);
                    int n = offsetRange.getStart();
                    n = Utilities.getRowEnd((BaseDocument)baseDocument, (int)n);
                    int n2 = offsetRange.getEnd();
                    if (n == -1 || n2 == -1 || n >= n2 || n2 > baseDocument.getLength()) break;
                    offsetRange = new OffsetRange(n, n2);
                    list2.add(offsetRange);
                    break;
                }
            }
            if ((object = astElement.getChildren()) == null || object.size() <= 0) continue;
            this.addFolds(baseDocument, (List<? extends AstElement>)object, map, list2);
        }
    }

    private void scan(Node node, AstPath astPath, String string, Set<String> set, AstElement object) {
        Object object2;
        Object object3;
        switch (node.nodeId) {
            case CLASSNODE: {
                object3 = new AstClassElement(this.info, node);
                ((AstElement)object3).setIn(string);
                String string2 = AstUtilities.getFqnName(astPath);
                ((AstClassElement)object3).setFqn(string2);
                string = AstUtilities.getClassOrModuleName((IScopingNode)((ClassNode)node));
                set = new HashSet<String>();
                ((AstClassElement)object3).setIncludes(set);
                if (object != null) {
                    ((AstElement)object).addChild((AstElement)object3);
                } else {
                    this.structure.add((AstElement)object3);
                }
                object = object3;
                break;
            }
            case MODULENODE: {
                object3 = new AstModuleElement(this.info, node);
                ((AstElement)object3).setIn(string);
                ((AstModuleElement)object3).setFqn(AstUtilities.getFqnName(astPath));
                string = AstUtilities.getClassOrModuleName((IScopingNode)((ModuleNode)node));
                if (object != null) {
                    ((AstElement)object).addChild((AstElement)object3);
                } else {
                    this.structure.add((AstElement)object3);
                }
                object = object3;
                break;
            }
            case SCLASSNODE: {
                object3 = new AstClassElement(this.info, node);
                ((AstElement)object3).setIn(string);
                ((AstClassElement)object3).setFqn(AstUtilities.getFqnName(astPath));
                Node node2 = ((SClassNode)node).getReceiverNode();
                string = node2 instanceof INameNode ? ((INameNode)node2).getName() : null;
                set = new HashSet<String>();
                ((AstClassElement)object3).setIncludes(set);
                if (object != null) {
                    ((AstElement)object).addChild((AstElement)object3);
                } else {
                    this.structure.add((AstElement)object3);
                }
                object = object3;
                break;
            }
            case DEFNNODE: 
            case DEFSNODE: {
                String string3;
                object3 = new AstMethodElement(this.info, node);
                this.methods.add((AstMethodElement)object3);
                ((AstElement)object3).setIn(string);
                if (node instanceof DefnNode && "initialize".equals(((DefnNode)node).getName())) {
                    ((AstMethodElement)object3).setAccess(Modifier.PRIVATE);
                } else if (object != null && ((AstElement)object).getNode() instanceof SClassNode) {
                    ((AstMethodElement)object3).setModifiers(EnumSet.of(Modifier.STATIC));
                }
                if (node instanceof DefsNode && object instanceof AstModuleElement && "included".equals(((DefsNode)node).getName()) && (string3 = this.getExtendWith((MethodDefNode)((DefsNode)node))) != null) {
                    if (string3.indexOf(58) == -1) {
                        object2 = AstUtilities.getFqnName(astPath);
                        string3 = (String)object2 + "::" + string3;
                    }
                    ((AstModuleElement)object).setExtendWith(string3);
                }
                if (object != null) {
                    ((AstElement)object).addChild((AstElement)object3);
                    break;
                }
                this.structure.add((AstElement)object3);
                break;
            }
            case CONSTDECLNODE: {
                object3 = new AstNameElement(this.info, node, ((INameNode)node).getName(), ElementKind.CONSTANT);
                ((AstElement)object3).setIn(string);
                if (object != null) {
                    ((AstElement)object).addChild((AstElement)object3);
                    break;
                }
                this.structure.add((AstElement)object3);
                break;
            }
            case CLASSVARDECLNODE: {
                object3 = new AstFieldElement(this.info, node);
                ((AstElement)object3).setIn(string);
                if (object != null) {
                    ((AstElement)object).addChild((AstElement)object3);
                    break;
                }
                this.structure.add((AstElement)object3);
                break;
            }
            case INSTASGNNODE: {
                if (!(object instanceof AstClassElement)) break;
                object3 = this.fields.get(object);
                if (object3 == null) {
                    object3 = new HashSet();
                    this.fields.put((AstClassElement)object, (Set<InstAsgnNode>)object3);
                }
                object3.add((InstAsgnNode)node);
                break;
            }
            case VCALLNODE: {
                object3 = ((INameNode)node).getName();
                if (!"private".equals(object3) && !"protected".equals(object3) || !(object instanceof AstClassElement)) break;
                this.haveAccessModifiers.add((AstClassElement)object);
                break;
            }
            case LOCALASGNNODE: {
                if (object != null || AstUtilities.findMethod(astPath) != null) break;
                object3 = ((INameNode)node).getName();
                boolean bl = false;
                for (AstElement astElement : this.structure) {
                    if (astElement.getKind() != ElementKind.VARIABLE || !((String)object3).equals(astElement.getName())) continue;
                    bl = true;
                    break;
                }
                if (bl) break;
                object2 = new AstNameElement(this.info, node, (String)object3, ElementKind.VARIABLE);
                ((AstElement)object2).setIn(string);
                this.structure.add((AstElement)object2);
                break;
            }
            case FCALLNODE: {
                Object object4;
                ByteList byteList;
                Object object5;
                object3 = ((INameNode)node).getName();
                if (((String)object3).equals("require")) {
                    ByteList byteList2;
                    Node node3;
                    Node node4 = ((FCallNode)node).getArgsNode();
                    if (!(node4 instanceof ListNode) || (object2 = (ListNode)node4).size() <= 0 || !((node3 = object2.get(0)) instanceof StrNode) || (byteList2 = ((StrNode)node3).getValue()) == null || byteList2.length() <= 0) break;
                    this.requires.add(byteList2.toString());
                    break;
                }
                if (set != null && ((String)object3).equals("include")) {
                    Node node5 = ((FCallNode)node).getArgsNode();
                    if (!(node5 instanceof ListNode) || (object2 = (ListNode)node5).size() <= 0) break;
                    Node node6 = object2.get(0);
                    if (node6 instanceof Colon2Node) {
                        set.add(AstUtilities.getFqn((Colon2Node)node6));
                        break;
                    }
                    if (!(node6 instanceof INameNode)) break;
                    set.add(((INameNode)node6).getName());
                    break;
                }
                if (("private".equals(object3) || "protected".equals(object3)) && object instanceof AstClassElement) {
                    this.haveAccessModifiers.add((AstClassElement)object);
                    break;
                }
                if (AstUtilities.isAttr(node)) {
                    SymbolNode[] symbolNodeArray = AstUtilities.getAttrSymbols(node);
                    if (symbolNodeArray == null || symbolNodeArray.length <= 0) break;
                    for (SymbolNode symbolNode : symbolNodeArray) {
                        AstAttributeElement astAttributeElement = new AstAttributeElement(this.info, symbolNode, node);
                        if (object instanceof AstClassElement) {
                            object5 = this.attributes.get(object);
                            if (object5 == null) {
                                object5 = new HashSet();
                                this.attributes.put((AstClassElement)object, (Set<AstAttributeElement>)object5);
                            }
                            object5.add(astAttributeElement);
                        }
                        if (object != null) {
                            ((AstElement)object).addChild(astAttributeElement);
                            continue;
                        }
                        this.structure.add(astAttributeElement);
                    }
                    break;
                }
                if (((String)object3).equals("module_function")) {
                    Node node7 = ((FCallNode)node).getArgsNode();
                    if (!(node7 instanceof ListNode)) break;
                    object2 = (ListNode)node7;
                    int n = object2.size();
                    for (int i = 0; i < n; ++i) {
                        AstMethodElement astMethodElement2;
                        String string4;
                        Node node8 = object2.get(i);
                        if (!(node8 instanceof SymbolNode) || (string4 = ((SymbolNode)node8).getName()) == null || string4.length() <= 0) continue;
                        object5 = null;
                        for (AstMethodElement astMethodElement2 : this.methods) {
                            AstMethodElement astMethodElement3;
                            if (!(astMethodElement2 instanceof AstMethodElement) || !string4.equals((astMethodElement3 = astMethodElement2).getName())) continue;
                            object5 = astMethodElement3;
                            break;
                        }
                        if (object5 == null) continue;
                        byteList = ((AstElement)object5).getNode();
                        astMethodElement2 = new AstMethodElement(this.info, (Node)byteList);
                        astMethodElement2.setIn(string);
                        if (byteList instanceof DefnNode && "initialize".equals(((DefnNode)byteList).getName())) {
                            astMethodElement2.setAccess(Modifier.PRIVATE);
                        }
                        astMethodElement2.setModifiers(EnumSet.of(Modifier.STATIC));
                        if (object != null) {
                            ((AstElement)object).addChild(astMethodElement2);
                            continue;
                        }
                        this.structure.add(astMethodElement2);
                    }
                    break;
                }
                if (!this.isTestFile || !((String)object3).equals("test") && !((String)object3).equals("describe") && !((String)object3).equals("specify") && !((String)object3).equals("context") && !((String)object3).equals("should") && !((String)object3).equals("it")) break;
                Object object6 = object3;
                object2 = (FCallNode)node;
                if (object2.getIterNode() == null && !"it".equals(object3)) break;
                Node node9 = object2.getArgsNode();
                if (node9 instanceof ListNode) {
                    object4 = (ListNode)node9;
                    int n = object4.size();
                    for (int i = 0; i < n; ++i) {
                        object5 = object4.get(i);
                        if (!(object5 instanceof StrNode)) continue;
                        byteList = ((StrNode)object5).getValue();
                        if (byteList == null || byteList.length() <= 0) break;
                        object6 = byteList.toString();
                        if (((String)object3).equals("test")) break;
                        object6 = (String)object3 + ": " + (String)object6;
                        break;
                    }
                }
                object4 = new AstNameElement(this.info, node, (String)object6, ElementKind.TEST);
                if (object != null) {
                    ((AstElement)object).addChild((AstElement)object4);
                } else {
                    this.structure.add((AstElement)object4);
                }
                object = object4;
                break;
            }
        }
        object3 = node.childNodes();
        Iterator iterator = object3.iterator();
        while (iterator.hasNext()) {
            object2 = (Node)iterator.next();
            if (object2.isInvisible()) continue;
            astPath.descend((Node)object2);
            this.scan((Node)object2, astPath, string, set, (AstElement)object);
            astPath.ascend();
        }
    }

    private String getExtendWith(MethodDefNode methodDefNode) {
        ListNode listNode;
        List<String> list = AstUtilities.getDefArgs(methodDefNode, true);
        if (list == null || list.size() != 1) {
            return null;
        }
        String string = list.get(0);
        CallNode callNode = this.findExtendCall((Node)methodDefNode);
        if (callNode == null) {
            return null;
        }
        Node node = callNode.getReceiverNode();
        if (node == null || !(node instanceof INameNode)) {
            return null;
        }
        String string2 = ((INameNode)node).getName();
        if (!string.equals(string2)) {
            return null;
        }
        Node node2 = callNode.getArgsNode();
        if (node2 instanceof ListNode && (listNode = (ListNode)node2).size() == 1) {
            Node node3 = listNode.get(0);
            String string3 = null;
            if (node3 instanceof Colon2Node) {
                string3 = ((Colon2Node)node3).getName();
            } else if (node3 instanceof ConstNode) {
                string3 = ((ConstNode)node3).getName();
            }
            return string3;
        }
        return null;
    }

    private CallNode findExtendCall(Node node) {
        Object object;
        if (node instanceof CallNode && "extend".equals((object = (CallNode)node).getName())) {
            return object;
        }
        object = node.childNodes();
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            CallNode callNode;
            Node node2 = (Node)iterator.next();
            if (node2.isInvisible() || (callNode = this.findExtendCall(node2)) == null) continue;
            return callNode;
        }
        return null;
    }

    AnalysisResult analyze(RubyParseResult rubyParseResult, CompilationInfo compilationInfo) {
        this.info = compilationInfo;
        return this.scan(rubyParseResult);
    }

    public void addComments(RubyParseResult rubyParseResult) {
        Node node = rubyParseResult.getRootNode();
        if (node == null) {
            return;
        }
        RubyParserResult rubyParserResult = rubyParseResult.getJRubyResult();
        List list = rubyParserResult.getCommentNodes();
        for (CommentNode commentNode : list) {
            ISourcePosition iSourcePosition = commentNode.getPosition();
            int n = iSourcePosition.getStartOffset();
            int n2 = iSourcePosition.getEndOffset();
            Node node2 = this.findClosest(node, n, n2);
            assert (node2 != null);
            node2.addComment(commentNode);
        }
    }

    private Node findClosest(Node node, int n, int n2) {
        List list = node.childNodes();
        ISourcePosition iSourcePosition = node.getPosition();
        if (n2 < iSourcePosition.getStartOffset()) {
            return node;
        }
        if (n > iSourcePosition.getEndOffset()) {
            return null;
        }
        for (Node node2 : list) {
            Node node3;
            if (node2.isInvisible() || (node3 = this.findClosest(node2, n, n2)) == null) continue;
            return node3;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<? extends StructureItem> scanRhtml(CompilationInfo compilationInfo) {
        ArrayList<RhtmlStructureItem> arrayList = new ArrayList<RhtmlStructureItem>();
        AbstractDocument abstractDocument = (AbstractDocument)compilationInfo.getDocument();
        if (abstractDocument == null) {
            return Collections.emptyList();
        }
        abstractDocument.readLock();
        try {
            TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)abstractDocument);
            TokenSequence tokenSequence = tokenHierarchy.tokenSequence();
            if (tokenSequence == null) {
                ArrayList<RhtmlStructureItem> arrayList2 = arrayList;
                return arrayList2;
            }
            tokenSequence.moveStart();
            while (tokenSequence.moveNext()) {
                TokenId tokenId = tokenSequence.token().id();
                if (!tokenId.name().equals("DELIMITER")) continue;
                int n = tokenSequence.offset();
                if (!tokenSequence.moveNext()) continue;
                Token token = tokenSequence.token();
                int n2 = tokenSequence.offset() + token.length();
                if (!token.id().name().equals("DELIMITER")) {
                    while (tokenSequence.moveNext()) {
                        if (!tokenSequence.token().id().name().equals("DELIMITER")) continue;
                        n2 = tokenSequence.offset() + token.length();
                        break;
                    }
                }
                String string = RubyStructureAnalyzer.navigatorName(abstractDocument, tokenHierarchy, n);
                arrayList.add(new RhtmlStructureItem(string, n, n2));
            }
        }
        finally {
            abstractDocument.readUnlock();
        }
        return arrayList;
    }

    public static String navigatorName(Document document, TokenHierarchy tokenHierarchy, int n) {
        TokenSequence tokenSequence;
        TokenId tokenId;
        TokenSequence tokenSequence2 = tokenHierarchy.tokenSequence();
        tokenSequence2.move(n);
        if (tokenSequence2.moveNext() && (tokenId = tokenSequence2.token().id()).name().equals("DELIMITER") && tokenSequence2.moveNext() && (tokenId = tokenSequence2.token().id()).name().startsWith("RUBY") && (tokenSequence = tokenSequence2.embedded()) != null) {
            TokenId tokenId2;
            tokenSequence.moveStart();
            if (!tokenSequence.moveNext()) {
                return DEFAULT_LABEL;
            }
            while (tokenSequence.token().id() == RubyTokenId.WHITESPACE && tokenSequence.moveNext()) {
            }
            int n2 = tokenSequence.offset();
            tokenId = tokenSequence.token().id();
            if (tokenId == RubyTokenId.WHITESPACE) {
                return DEFAULT_LABEL;
            }
            if (tokenId == RubyTokenId.STRING_BEGIN || tokenId == RubyTokenId.QUOTED_STRING_BEGIN || tokenId == RubyTokenId.REGEXP_BEGIN) {
                while (tokenSequence.moveNext()) {
                    tokenId = tokenSequence.token().id();
                    if (tokenId != RubyTokenId.STRING_END && tokenId != RubyTokenId.QUOTED_STRING_END && tokenId != RubyTokenId.REGEXP_END) continue;
                    int n3 = tokenSequence.offset() + tokenSequence.token().length();
                    return RubyStructureAnalyzer.createName(document, n2, n3);
                }
            }
            int n4 = tokenSequence.offset() + tokenSequence.token().length();
            if (tokenSequence.moveNext() && ((tokenId2 = tokenSequence.token().id()) == RubyTokenId.DOT || tokenId == RubyTokenId.LPAREN) && tokenSequence.moveNext()) {
                n4 = tokenSequence.offset() + tokenSequence.token().length();
            }
            return RubyStructureAnalyzer.createName(document, n2, n4);
        }
        return DEFAULT_LABEL;
    }

    private static String createName(Document document, int n, int n2) {
        try {
            String string;
            int n3;
            boolean bl = false;
            int n4 = n2 - n;
            if (n + n4 > document.getLength()) {
                n4 = document.getLength() - n;
                bl = true;
            }
            if (n4 > 30) {
                n4 = 30;
                bl = true;
            }
            if ((n3 = (string = document.getText(n, n4)).indexOf(10)) != -1) {
                if (string.startsWith("<%\n") || string.startsWith("<%#\n")) {
                    if ((n3 = (string = string.substring(n3 + 1)).indexOf(10)) != -1) {
                        string = string.substring(0, n3);
                    }
                } else {
                    boolean bl2 = true;
                    for (int i = 0; i < n3; ++i) {
                        if (Character.isWhitespace(string.charAt(i))) continue;
                        bl2 = false;
                        break;
                    }
                    string = bl2 ? string.substring(n3 + 1) : string.substring(0, n3);
                }
            }
            if (bl) {
                return string + "...";
            }
            return string;
        }
        catch (BadLocationException badLocationException) {
            Exceptions.printStackTrace((Throwable)badLocationException);
            return DEFAULT_LABEL;
        }
    }

    public StructureScanner.Configuration getConfiguration() {
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RhtmlStructureItem
    implements StructureItem {
        private final String name;
        private final int start;
        private final int end;

        public RhtmlStructureItem(String string, int n, int n2) {
            this.name = string;
            this.start = n;
            this.end = n2;
        }

        public String getName() {
            return this.name;
        }

        public String getHtml(HtmlFormatter htmlFormatter) {
            htmlFormatter.appendText(this.name);
            return htmlFormatter.getText();
        }

        public ElementHandle getElementHandle() {
            return null;
        }

        public ElementKind getKind() {
            return ElementKind.OTHER;
        }

        public Set<Modifier> getModifiers() {
            return Collections.emptySet();
        }

        public boolean isLeaf() {
            return true;
        }

        public List<? extends StructureItem> getNestedItems() {
            return Collections.emptyList();
        }

        public long getPosition() {
            return this.start;
        }

        public long getEndPosition() {
            return this.end;
        }

        public int hashCode() {
            int n = 7;
            n = 29 * n + (this.getName() != null ? this.getName().hashCode() : 0);
            return n;
        }

        public String toString() {
            return this.getName();
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (!(object instanceof RubyStructureItem)) {
                return false;
            }
            RubyStructureItem rubyStructureItem = (RubyStructureItem)object;
            return this.getName().equals(rubyStructureItem.getName());
        }

        public ImageIcon getCustomIcon() {
            if (keywordIcon == null) {
                keywordIcon = new ImageIcon(ImageUtilities.loadImage((String)RubyStructureAnalyzer.RUBY_KEYWORD));
            }
            return keywordIcon;
        }

        public String getSortText() {
            return Integer.toHexString(10000 + (int)this.getPosition());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RubyStructureItem
    implements StructureItem {
        AstElement node;
        ElementKind kind;
        CompilationInfo info;

        private RubyStructureItem(AstElement astElement, CompilationInfo compilationInfo) {
            this.node = astElement;
            this.info = compilationInfo;
            this.kind = astElement.getKind();
        }

        public String getName() {
            return this.node.getName();
        }

        public String getHtml(HtmlFormatter htmlFormatter) {
            AstMethodElement astMethodElement;
            List<String> list;
            htmlFormatter.reset();
            htmlFormatter.appendText(this.node.getName());
            if ((this.kind == ElementKind.METHOD || this.kind == ElementKind.CONSTRUCTOR) && (list = (astMethodElement = (AstMethodElement)this.node).getParameters()) != null && list.size() > 0) {
                htmlFormatter.appendHtml("(");
                htmlFormatter.parameters(true);
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    htmlFormatter.appendText(string);
                    if (!iterator.hasNext()) continue;
                    htmlFormatter.appendHtml(", ");
                }
                htmlFormatter.parameters(false);
                htmlFormatter.appendHtml(")");
            }
            return htmlFormatter.getText();
        }

        public ElementHandle getElementHandle() {
            return this.node;
        }

        public ElementKind getKind() {
            return this.kind;
        }

        public Set<Modifier> getModifiers() {
            return this.node.getModifiers();
        }

        public boolean isLeaf() {
            switch (this.kind) {
                case METHOD: 
                case CONSTRUCTOR: 
                case ATTRIBUTE: 
                case CONSTANT: 
                case FIELD: 
                case KEYWORD: 
                case VARIABLE: 
                case OTHER: {
                    return true;
                }
                case CLASS: 
                case MODULE: {
                    return false;
                }
                case TEST: {
                    List<AstElement> list = this.node.getChildren();
                    return list == null || list.size() == 0;
                }
            }
            throw new RuntimeException("Unhandled kind: " + this.kind);
        }

        public List<? extends StructureItem> getNestedItems() {
            List<AstElement> list = this.node.getChildren();
            if (list != null && list.size() > 0) {
                ArrayList<RubyStructureItem> arrayList = new ArrayList<RubyStructureItem>(list.size());
                for (AstElement astElement : list) {
                    arrayList.add(new RubyStructureItem(astElement, this.info));
                }
                return arrayList;
            }
            return Collections.emptyList();
        }

        public long getPosition() {
            return this.node.getNode().getPosition().getStartOffset();
        }

        public long getEndPosition() {
            return this.node.getNode().getPosition().getEndOffset();
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (!(object instanceof RubyStructureItem)) {
                return false;
            }
            RubyStructureItem rubyStructureItem = (RubyStructureItem)object;
            if (this.kind != rubyStructureItem.kind) {
                return false;
            }
            if (!this.getName().equals(rubyStructureItem.getName())) {
                return false;
            }
            if (this.kind == ElementKind.METHOD || this.kind == ElementKind.CONSTRUCTOR) {
                Arity arity;
                Arity arity2 = Arity.getDefArity(this.node.getNode());
                if (!arity2.equals(arity = Arity.getDefArity(rubyStructureItem.node.getNode()))) {
                    return false;
                }
                if (!((Object)this.getModifiers()).equals(rubyStructureItem.getModifiers())) {
                    return false;
                }
                List<String> list = ((AstMethodElement)this.node).getParameters();
                List<String> list2 = ((AstMethodElement)rubyStructureItem.node).getParameters();
                if (list == null) {
                    return list2 == null;
                }
                return ((Object)list).equals(list2);
            }
            return true;
        }

        public int hashCode() {
            int n = 7;
            n = 29 * n + (this.getName() != null ? this.getName().hashCode() : 0);
            n = 29 * n + (this.kind != null ? this.kind.hashCode() : 0);
            if (this.kind == ElementKind.METHOD || this.kind == ElementKind.CONSTRUCTOR) {
                Arity arity = Arity.getDefArity(this.node.getNode());
                n = 37 * n + arity.hashCode();
            }
            return n;
        }

        public String toString() {
            return this.getName() + " (kind: " + this.kind + ')';
        }

        public ImageIcon getCustomIcon() {
            return null;
        }

        public String getSortText() {
            return this.getName();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AnalysisResult {
        private List<? extends AstElement> elements;
        private Map<AstClassElement, Set<AstAttributeElement>> attributes;
        private Set<String> requires;

        private AnalysisResult() {
        }

        public Set<String> getRequires() {
            return this.requires;
        }

        public void setRequires(Set<String> set) {
            this.requires = set;
        }

        private void setElements(List<? extends AstElement> list) {
            this.elements = list;
        }

        private void setAttributes(Map<AstClassElement, Set<AstAttributeElement>> map) {
            this.attributes = map;
        }

        public Map<AstClassElement, Set<AstAttributeElement>> getAttributes() {
            return this.attributes;
        }

        public List<? extends AstElement> getElements() {
            if (this.elements == null) {
                return Collections.emptyList();
            }
            return this.elements;
        }
    }
}

