/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import javax.swing.text.BadLocationException;
import org.jruby.ast.Node;
import org.jruby.ast.RootNode;
import org.jruby.common.IRubyWarnings;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.lexer.yacc.LexerSource;
import org.jruby.lexer.yacc.SyntaxException;
import org.jruby.parser.DefaultRubyParser;
import org.jruby.parser.ParserConfiguration;
import org.jruby.parser.RubyParserResult;
import org.netbeans.modules.gsf.api.CompilationInfo;
import org.netbeans.modules.gsf.api.ElementHandle;
import org.netbeans.modules.gsf.api.Error;
import org.netbeans.modules.gsf.api.OffsetRange;
import org.netbeans.modules.gsf.api.ParseEvent;
import org.netbeans.modules.gsf.api.ParseListener;
import org.netbeans.modules.gsf.api.Parser;
import org.netbeans.modules.gsf.api.ParserFile;
import org.netbeans.modules.gsf.api.ParserResult;
import org.netbeans.modules.gsf.api.PositionManager;
import org.netbeans.modules.gsf.api.Severity;
import org.netbeans.modules.gsf.api.SourceFileReader;
import org.netbeans.modules.gsf.api.TranslatedSource;
import org.netbeans.modules.ruby.AstNodeAdapter;
import org.netbeans.modules.ruby.AstUtilities;
import org.netbeans.modules.ruby.RubyParseResult;
import org.netbeans.modules.ruby.RubyPositionManager;
import org.netbeans.modules.ruby.RubyUtils;
import org.netbeans.modules.ruby.elements.AstElement;
import org.netbeans.modules.ruby.elements.RubyElement;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public final class RubyParser
implements Parser {
    private final PositionManager positions = this.createPositionManager();

    private static String asString(CharSequence charSequence) {
        if (charSequence instanceof String) {
            return (String)charSequence;
        }
        return ((Object)charSequence).toString();
    }

    public void parseFiles(Parser.Job job) {
        ParseListener parseListener = job.listener;
        SourceFileReader sourceFileReader = job.reader;
        for (ParserFile parserFile : job.files) {
            CharSequence charSequence;
            ParseEvent parseEvent = new ParseEvent(ParseEvent.Kind.PARSE, parserFile, null);
            parseListener.started(parseEvent);
            RubyParseResult rubyParseResult = null;
            try {
                charSequence = sourceFileReader.read(parserFile);
                String string = RubyParser.asString(charSequence);
                int n = sourceFileReader.getCaretOffset(parserFile);
                if (n != -1 && job.translatedSource != null) {
                    n = job.translatedSource.getAstOffset(n);
                }
                Context context = new Context(parserFile, parseListener, string, n, job.translatedSource);
                rubyParseResult = this.parseBuffer(context, Sanitize.NONE);
            }
            catch (IOException iOException) {
                parseListener.exception((Exception)iOException);
            }
            charSequence = new ParseEvent(ParseEvent.Kind.PARSE, parserFile, rubyParseResult);
            parseListener.finished((ParseEvent)charSequence);
        }
    }

    protected PositionManager createPositionManager() {
        return new RubyPositionManager();
    }

    private boolean sanitizeSource(Context context, Sanitize sanitize) {
        if (sanitize == Sanitize.MISSING_END) {
            context.sanitizedSource = context.source + ";end";
            int n = context.source.length();
            context.sanitizedRange = new OffsetRange(n, n + 4);
            context.sanitizedContents = "";
            return true;
        }
        int n = context.caretOffset;
        if (sanitize == Sanitize.ERROR_DOT || sanitize == Sanitize.ERROR_LINE) {
            n = context.errorOffset;
        }
        if (n == -1) {
            return false;
        }
        String string = context.source;
        if (n > string.length()) {
            return false;
        }
        if (sanitize == Sanitize.BLOCK_START) {
            try {
                int n2 = RubyUtils.getRowFirstNonWhite(string, n);
                if (n2 != -1 && n2 + 2 < string.length() && string.regionMatches(n2, "if", 0, 2)) {
                    char c = '\u0000';
                    if (n2 + 2 < string.length()) {
                        c = string.charAt(n2 + 2);
                    }
                    if (!Character.isLetter(c)) {
                        int n3 = n2;
                        int n4 = n3 + 2;
                        StringBuilder stringBuilder = new StringBuilder(string.length());
                        stringBuilder.append(string.substring(0, n3));
                        for (int i = n3; i < n4; ++i) {
                            stringBuilder.append(' ');
                        }
                        if (n4 < string.length()) {
                            stringBuilder.append(string.substring(n4, string.length()));
                        }
                        assert (stringBuilder.length() == string.length());
                        context.sanitizedRange = new OffsetRange(n3, n4);
                        context.sanitizedSource = stringBuilder.toString();
                        context.sanitizedContents = string.substring(n3, n4);
                        return true;
                    }
                }
                return false;
            }
            catch (BadLocationException badLocationException) {
                Exceptions.printStackTrace((Throwable)badLocationException);
                return false;
            }
        }
        try {
            if ((RubyUtils.isRowEmpty(string, n) || RubyUtils.isRowWhite(string, n)) && (n = RubyUtils.getRowStart(string, n) - 1) < 0) {
                n = 0;
            }
            if (!RubyUtils.isRowEmpty(string, n) && !RubyUtils.isRowWhite(string, n)) {
                if (sanitize == Sanitize.EDITED_LINE || sanitize == Sanitize.ERROR_LINE) {
                    int n5 = RubyUtils.getRowLastNonWhite(string, n);
                    if (n5 != -1) {
                        StringBuilder stringBuilder = new StringBuilder(string.length());
                        int n6 = RubyUtils.getRowStart(string, n);
                        int n7 = n6 + 1;
                        stringBuilder.append(string.substring(0, n6));
                        stringBuilder.append('#');
                        if (n7 < string.length()) {
                            stringBuilder.append(string.substring(n7, string.length()));
                        }
                        assert (stringBuilder.length() == string.length());
                        context.sanitizedRange = new OffsetRange(n6, n5);
                        context.sanitizedSource = stringBuilder.toString();
                        context.sanitizedContents = string.substring(n6, n5);
                        return true;
                    }
                } else {
                    int n8;
                    assert (sanitize == Sanitize.ERROR_DOT || sanitize == Sanitize.EDITED_DOT);
                    int n9 = RubyUtils.getRowStart(string, n);
                    for (n8 = n - 1; n8 >= n9 && n8 < string.length() && Character.isWhitespace(string.charAt(n8)); --n8) {
                    }
                    if (n8 > n9) {
                        StringBuilder stringBuilder = new StringBuilder(string.length());
                        String string2 = string.substring(n9, n8 + 1);
                        int n10 = 0;
                        int n11 = n8 + 1;
                        if (string2.endsWith(".") || string2.endsWith("(")) {
                            n10 = 1;
                        } else if (string2.endsWith(",")) {
                            n10 = 1;
                        } else if (string2.endsWith(",:")) {
                            n10 = 2;
                        } else if (string2.endsWith(", :")) {
                            n10 = 3;
                        } else if (string2.endsWith(", ")) {
                            n10 = 2;
                        } else if (string2.endsWith("=> :")) {
                            n10 = 4;
                        } else if (string2.endsWith("=>:")) {
                            n10 = 3;
                        } else if (string2.endsWith("=>")) {
                            n10 = 2;
                        } else if (string2.endsWith("::")) {
                            n10 = 2;
                        } else if (string2.endsWith(":")) {
                            n10 = 1;
                        } else if (string2.endsWith("@@")) {
                            n10 = 2;
                        } else if (string2.endsWith("@")) {
                            n10 = 1;
                        } else if (string2.endsWith(",)")) {
                            n10 = 1;
                            --n11;
                        } else if (string2.endsWith(", )")) {
                            n10 = 1;
                            n11 -= 2;
                        }
                        if (n10 == 0) {
                            return false;
                        }
                        int n12 = n11 - n10;
                        stringBuilder.append(string.substring(0, n12));
                        for (int i = 0; i < n10; ++i) {
                            stringBuilder.append(' ');
                        }
                        if (n11 < string.length()) {
                            stringBuilder.append(string.substring(n11, string.length()));
                        }
                        assert (stringBuilder.length() == string.length());
                        context.sanitizedRange = new OffsetRange(n12, n11);
                        context.sanitizedSource = stringBuilder.toString();
                        context.sanitizedContents = string.substring(n12, n11);
                        return true;
                    }
                }
            }
        }
        catch (BadLocationException badLocationException) {
            Exceptions.printStackTrace((Throwable)badLocationException);
        }
        return false;
    }

    private RubyParseResult sanitize(Context context, Sanitize sanitize) {
        switch (sanitize) {
            case NEVER: {
                return this.createParseResult(context.file, null, null, null, null);
            }
            case NONE: {
                if (context.caretOffset != -1) {
                    return this.parseBuffer(context, Sanitize.EDITED_DOT);
                }
            }
            case EDITED_DOT: {
                if (context.errorOffset != -1 && context.errorOffset != context.caretOffset) {
                    return this.parseBuffer(context, Sanitize.ERROR_DOT);
                }
            }
            case ERROR_DOT: {
                if (context.caretOffset != -1) {
                    return this.parseBuffer(context, Sanitize.BLOCK_START);
                }
            }
            case BLOCK_START: {
                if (context.errorOffset != -1) {
                    return this.parseBuffer(context, Sanitize.ERROR_LINE);
                }
            }
            case ERROR_LINE: {
                if (context.caretOffset != -1) {
                    return this.parseBuffer(context, Sanitize.EDITED_LINE);
                }
            }
            case EDITED_LINE: {
                return this.parseBuffer(context, Sanitize.MISSING_END);
            }
        }
        return this.createParseResult(context.file, null, null, null, null);
    }

    protected void notifyError(Context context, IRubyWarnings.ID iD, Severity severity, String string, int n, Sanitize sanitize, Object[] objectArray) {
        if (string.startsWith("syntax error, expecting\t")) {
            int n2 = string.indexOf(" but found ");
            assert (n2 != -1);
            int n3 = string.indexOf("instead", n2 += 11);
            assert (n3 != -1);
            String string2 = string.substring(n2, n3);
            string = NbBundle.getMessage(RubyParser.class, (String)"UnexpectedError", (Object)string2);
        }
        RubyError rubyError = new RubyError(string, iD, context.file.getFileObject(), n, n, severity, objectArray);
        context.listener.error((Error)rubyError);
        if (sanitize == Sanitize.NONE) {
            context.errorOffset = n;
        }
    }

    protected RubyParseResult parseBuffer(final Context context, final Sanitize sanitize) {
        Object object;
        Object object2;
        DefaultRubyParser defaultRubyParser;
        IRubyWarnings iRubyWarnings;
        RubyParserResult rubyParserResult;
        String string;
        block11: {
            boolean bl = false;
            string = context.source;
            if (sanitize != Sanitize.NONE && sanitize != Sanitize.NEVER) {
                boolean bl2 = this.sanitizeSource(context, sanitize);
                if (bl2) {
                    assert (context.sanitizedSource != null);
                    bl = true;
                    string = context.sanitizedSource;
                } else {
                    return this.sanitize(context, sanitize);
                }
            }
            rubyParserResult = null;
            final boolean bl3 = bl;
            try {
                iRubyWarnings = new IRubyWarnings(){

                    public boolean isVerbose() {
                        return false;
                    }

                    public void warn(IRubyWarnings.ID iD, ISourcePosition iSourcePosition, String string, Object ... objectArray) {
                        if (!bl3) {
                            RubyParser.this.notifyError(context, iD, Severity.WARNING, string, iSourcePosition.getStartOffset(), sanitize, objectArray);
                        }
                    }

                    public void warn(IRubyWarnings.ID iD, String string, int n, String string2, Object ... objectArray) {
                        if (!bl3) {
                            RubyParser.this.notifyError(context, iD, Severity.WARNING, string2, -1, sanitize, objectArray);
                        }
                    }

                    public void warn(IRubyWarnings.ID iD, String string, Object ... objectArray) {
                        if (!bl3) {
                            RubyParser.this.notifyError(context, iD, Severity.WARNING, string, -1, sanitize, objectArray);
                        }
                    }

                    public void warning(IRubyWarnings.ID iD, String string, Object ... objectArray) {
                        if (!bl3) {
                            RubyParser.this.notifyError(context, iD, Severity.WARNING, string, -1, sanitize, objectArray);
                        }
                    }

                    public void warning(IRubyWarnings.ID iD, ISourcePosition iSourcePosition, String string, Object ... objectArray) {
                        if (!bl3) {
                            RubyParser.this.notifyError(context, iD, Severity.WARNING, string, iSourcePosition.getStartOffset(), sanitize, objectArray);
                        }
                    }

                    public void warning(IRubyWarnings.ID iD, String string, int n, String string2, Object ... objectArray) {
                        if (!bl3) {
                            RubyParser.this.notifyError(context, iD, Severity.WARNING, string2, -1, sanitize, objectArray);
                        }
                    }
                };
                defaultRubyParser = new DefaultRubyParser();
                defaultRubyParser.setWarnings(iRubyWarnings);
                if (sanitize == Sanitize.NONE) {
                    context.errorOffset = -1;
                }
                object2 = "";
                if (context.file != null && context.file.getFileObject() != null) {
                    object2 = context.file.getFileObject().getNameExt();
                }
                object = new ParserConfiguration(0, true, false, true);
                final String string2 = string;
                final int n = string2.length();
                InputStream inputStream = new InputStream(){
                    int offset = 0;

                    public int read() throws IOException {
                        int n2;
                        if (this.offset == n) {
                            return -1;
                        }
                        if ((n2 = string2.charAt(this.offset++)) > 255) {
                            n2 = 63;
                        }
                        return n2;
                    }
                };
                LexerSource lexerSource = LexerSource.getSource((String)object2, (InputStream)inputStream, null, (ParserConfiguration)object);
                rubyParserResult = defaultRubyParser.parse((ParserConfiguration)object, lexerSource);
            }
            catch (SyntaxException syntaxException) {
                int n = syntaxException.getPosition().getStartOffset();
                if (n >= string.length() && (n = string.length() - 1) < 0) {
                    n = 0;
                }
                if (bl3) break block11;
                this.notifyError(context, IRubyWarnings.ID.SYNTAX_ERROR, Severity.ERROR, syntaxException.getMessage(), n, sanitize, new Object[]{syntaxException.getPid(), syntaxException});
            }
        }
        iRubyWarnings = rubyParserResult != null ? rubyParserResult.getAST() : null;
        defaultRubyParser = null;
        if (iRubyWarnings instanceof RootNode) {
            defaultRubyParser = (RootNode)iRubyWarnings;
            iRubyWarnings = defaultRubyParser.getBodyNode();
        }
        if (iRubyWarnings != null) {
            context.sanitized = sanitize;
            object2 = new AstNodeAdapter(null, (Node)iRubyWarnings);
            object = this.createParseResult(context.file, (ParserResult.AstTreeNode)object2, (Node)iRubyWarnings, (RootNode)defaultRubyParser, rubyParserResult);
            ((RubyParseResult)((Object)object)).setSanitized(context.sanitized, context.sanitizedRange, context.sanitizedContents);
            ((RubyParseResult)((Object)object)).setSource(string);
            return object;
        }
        return this.sanitize(context, sanitize);
    }

    protected RubyParseResult createParseResult(ParserFile parserFile, ParserResult.AstTreeNode astTreeNode, Node node, RootNode rootNode, RubyParserResult rubyParserResult) {
        return new RubyParseResult(this, parserFile, astTreeNode, node, rootNode, rubyParserResult);
    }

    public PositionManager getPositionManager() {
        return this.positions;
    }

    public static RubyElement resolveHandle(CompilationInfo compilationInfo, ElementHandle elementHandle) {
        if (elementHandle instanceof AstElement) {
            AstElement astElement = (AstElement)elementHandle;
            CompilationInfo compilationInfo2 = astElement.getInfo();
            if (compilationInfo2 == compilationInfo) {
                return astElement;
            }
            Node node = astElement.getNode();
            Node node2 = AstUtilities.getRoot(compilationInfo2);
            Node node3 = AstUtilities.getRoot(compilationInfo);
            if (node3 == null) {
                return null;
            }
            Node node4 = RubyParser.find(node2, node, node3);
            if (node4 != null) {
                AstElement astElement2 = AstElement.create(compilationInfo, node4);
                return astElement2;
            }
        } else if (elementHandle instanceof RubyElement) {
            return (RubyElement)elementHandle;
        }
        return null;
    }

    private static Node find(Node node, Node node2, Node node3) {
        List list = node.childNodes();
        List list2 = node3.childNodes();
        Iterator iterator = list.iterator();
        Iterator iterator2 = list2.iterator();
        while (iterator.hasNext()) {
            if (!iterator2.hasNext()) {
                return null;
            }
            Node node4 = (Node)iterator.next();
            Node node5 = (Node)iterator2.next();
            if (node4 == node2) {
                return node5;
            }
            Node node6 = RubyParser.find(node4, node2, node5);
            if (node6 == null) continue;
            return node6;
        }
        if (iterator2.hasNext()) {
            return null;
        }
        return null;
    }

    public static class RubyError
    implements Error {
        private final String displayName;
        private final IRubyWarnings.ID id;
        private final FileObject file;
        private final int startPosition;
        private final int endPosition;
        private final Severity severity;
        private final Object[] parameters;

        public RubyError(String string, IRubyWarnings.ID iD, FileObject fileObject, int n, int n2, Severity severity, Object[] objectArray) {
            this.displayName = string;
            this.id = iD;
            this.file = fileObject;
            this.startPosition = n;
            this.endPosition = n2;
            this.severity = severity;
            this.parameters = objectArray;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public int getStartPosition() {
            return this.startPosition;
        }

        public int getEndPosition() {
            return this.endPosition;
        }

        public FileObject getFile() {
            return this.file;
        }

        public String getKey() {
            return this.id != null ? this.id.name() : "";
        }

        public IRubyWarnings.ID getId() {
            return this.id;
        }

        public Object[] getParameters() {
            return this.parameters;
        }

        public Severity getSeverity() {
            return this.severity;
        }

        public String toString() {
            return "RubyError:" + this.displayName;
        }

        public String getDescription() {
            return null;
        }
    }

    public static class Context {
        private final ParserFile file;
        private final ParseListener listener;
        private int errorOffset;
        private String source;
        private String sanitizedSource;
        private OffsetRange sanitizedRange = OffsetRange.NONE;
        private String sanitizedContents;
        private int caretOffset;
        private Sanitize sanitized = Sanitize.NONE;
        private TranslatedSource translatedSource;

        public Context(ParserFile parserFile, ParseListener parseListener, String string, int n, TranslatedSource translatedSource) {
            this.file = parserFile;
            this.listener = parseListener;
            this.source = string;
            this.caretOffset = n;
            this.translatedSource = translatedSource;
        }

        public String toString() {
            return "RubyParser.Context(" + this.file.toString() + ")";
        }

        public OffsetRange getSanitizedRange() {
            return this.sanitizedRange;
        }

        public Sanitize getSanitized() {
            return this.sanitized;
        }

        public String getSanitizedSource() {
            return this.sanitizedSource;
        }

        public int getErrorOffset() {
            return this.errorOffset;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Sanitize {
        NEVER,
        NONE,
        EDITED_DOT,
        ERROR_DOT,
        BLOCK_START,
        ERROR_LINE,
        EDITED_LINE,
        MISSING_END;

    }
}

