/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.lexer.yacc.ISourcePosition;
import org.netbeans.modules.gsf.api.annotations.CheckForNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AstPath
implements Iterable<Node> {
    private ArrayList<Node> path = new ArrayList(30);

    public AstPath() {
    }

    public AstPath(AstPath astPath) {
        this.path.addAll(astPath.path);
    }

    public AstPath(ArrayList<Node> arrayList) {
        this.path = arrayList;
    }

    public AstPath(Node node, int n) {
        this.findPathTo(node, n);
    }

    public AstPath(Node node, Node node2) {
        if (!this.find(node, node2)) {
            this.path.clear();
        } else {
            Collections.reverse(this.path);
        }
    }

    public void descend(Node node) {
        this.path.add(node);
    }

    public void ascend() {
        this.path.remove(this.path.size() - 1);
    }

    public boolean contains(NodeType nodeType) {
        int n = this.path.size();
        for (int i = 0; i < n; ++i) {
            if (this.path.get((int)i).nodeId != nodeType) continue;
            return true;
        }
        return false;
    }

    public Node findPathTo(Node node, int n) {
        Node node2 = this.find(node, n);
        if (node2 != null) {
            this.path.add(node);
            Collections.reverse(this.path);
        }
        return node2;
    }

    private Node find(Node node, int n) {
        if (node.isInvisible()) {
            return null;
        }
        ISourcePosition iSourcePosition = node.getPosition();
        int n2 = iSourcePosition.getStartOffset();
        int n3 = iSourcePosition.getEndOffset();
        if (n >= n2 && n <= n3) {
            List list = node.childNodes();
            for (Node node2 : list) {
                Node node3;
                if (node2.isInvisible() || (node3 = this.find(node2, n)) == null) continue;
                this.path.add(node2);
                return node3;
            }
            return node;
        }
        List list = node.childNodes();
        if (list == null) {
            Logger logger = Logger.getLogger(AstPath.class.getName());
            logger.log(Level.WARNING, "JRuby AST node " + node + " of type " + node.getClass().getName() + " has null as children");
        }
        for (Node node4 : list) {
            Logger logger;
            if (node4 == null) {
                logger = Logger.getLogger(AstPath.class.getName());
                logger.log(Level.WARNING, "JRuby AST node " + node + " of type " + node.getClass().getName() + " has a null child");
                continue;
            }
            if (node4.isInvisible() || (logger = this.find(node4, n)) == null) continue;
            this.path.add(node4);
            return logger;
        }
        return null;
    }

    public boolean find(Node node, Node node2) {
        if (node == node2) {
            return true;
        }
        List list = node.childNodes();
        for (Node node3 : list) {
            boolean bl;
            if (node3.isInvisible() || !(bl = this.find(node3, node2))) continue;
            this.path.add(node3);
            return bl;
        }
        return false;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Path(");
        stringBuilder.append(this.path.size());
        stringBuilder.append(")=[");
        for (Node node : this.path) {
            String string = node.getClass().getName();
            string = string.substring(string.lastIndexOf(46) + 1);
            stringBuilder.append(string);
            stringBuilder.append(":");
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    @CheckForNull
    public Node leaf() {
        if (this.path.size() == 0) {
            return null;
        }
        return this.path.get(this.path.size() - 1);
    }

    public Node leafParent() {
        if (this.path.size() < 2) {
            return null;
        }
        return this.path.get(this.path.size() - 2);
    }

    public Node leafGrandParent() {
        if (this.path.size() < 3) {
            return null;
        }
        return this.path.get(this.path.size() - 3);
    }

    public Node root() {
        if (this.path.size() == 0) {
            return null;
        }
        return this.path.get(0);
    }

    @Override
    public Iterator<Node> iterator() {
        return new LeafToRootIterator(this.path);
    }

    public ListIterator<Node> rootToLeaf() {
        return this.path.listIterator();
    }

    public ListIterator<Node> leafToRoot() {
        return new LeafToRootIterator(this.path);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LeafToRootIterator
    implements ListIterator<Node> {
        private final ListIterator<Node> it;

        private LeafToRootIterator(ArrayList<Node> arrayList) {
            this.it = arrayList.listIterator(arrayList.size());
        }

        @Override
        public boolean hasNext() {
            return this.it.hasPrevious();
        }

        @Override
        public Node next() {
            return this.it.previous();
        }

        @Override
        public boolean hasPrevious() {
            return this.it.hasNext();
        }

        @Override
        public Node previous() {
            return this.it.next();
        }

        @Override
        public int nextIndex() {
            return this.it.previousIndex();
        }

        @Override
        public int previousIndex() {
            return this.it.nextIndex();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void set(Node node) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void add(Node node) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

