/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.outline;

import com.sun.rave.designtime.DesignBean;
import com.sun.rave.designtime.DesignContext;
import com.sun.rave.designtime.DesignEvent;
import com.sun.rave.designtime.DesignProject;
import com.sun.rave.designtime.DesignProperty;
import com.sun.rave.designtime.Position;
import com.sun.rave.designtime.event.DesignContextListener;
import com.sun.rave.designtime.event.DesignProjectListener;
import com.sun.rave.designtime.faces.FacesDesignProject;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventListener;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.netbeans.modules.visualweb.outline.OutlineManagerListener;
import org.netbeans.modules.visualweb.outline.OutlineUtilities;
import org.openide.ErrorManager;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerUtils;
import org.openide.explorer.view.BeanTreeView;
import org.openide.explorer.view.Visualizer;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.NodeOp;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.WeakListeners;

public class OutlinePanel
extends JPanel
implements ExplorerManager.Provider,
Lookup.Provider,
HelpCtx.Provider {
    private static final boolean DEBUG = ErrorManager.getDefault().getInstance(OutlinePanel.class.getName()).isLoggable(1);
    private static WeakReference<OutlinePanel> instanceWRef = new WeakReference<Object>(null);
    private final ExplorerManager manager = new ExplorerManager();
    private final Lookup lookup;
    private final OutlineTreeView treeView = new OutlineTreeView(this);
    private final PropertyChangeListener outlineManagerListener = new OutlineManagerListener(this);
    private final OutlineRootChildren outlineRootChildren = new OutlineRootChildren(this);

    private OutlinePanel() {
        ActionMap actionMap = this.getActionMap();
        actionMap.put("copy-to-clipboard", ExplorerUtils.actionCopy((ExplorerManager)this.manager));
        actionMap.put("cut-to-clipboard", ExplorerUtils.actionCut((ExplorerManager)this.manager));
        actionMap.put("paste-from-clipboard", ExplorerUtils.actionPaste((ExplorerManager)this.manager));
        actionMap.put("delete", ExplorerUtils.actionDelete((ExplorerManager)this.manager, (boolean)true));
        InputMap inputMap = this.getInputMap(1);
        inputMap.put(KeyStroke.getKeyStroke(113, 192), "rave-outline-dump-nodes");
        actionMap.put("rave-outline-dump-nodes", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                OutlinePanel.this.dumpActivatedNodes();
            }
        });
        this.lookup = ExplorerUtils.createLookup((ExplorerManager)this.manager, (ActionMap)actionMap);
        this.treeView.setRootVisible(false);
        this.setLayout(new BorderLayout());
        this.add((Component)((Object)this.treeView), "Center");
        this.manager.addPropertyChangeListener(this.outlineManagerListener);
        AbstractNode abstractNode = new AbstractNode((Children)this.outlineRootChildren);
        abstractNode.setName("Hidden Outline Root");
        this.manager.setRootContext((Node)abstractNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OutlinePanel getDefault() {
        Class<OutlinePanel> clazz = OutlinePanel.class;
        synchronized (OutlinePanel.class) {
            OutlinePanel outlinePanel = (OutlinePanel)instanceWRef.get();
            if (outlinePanel == null) {
                outlinePanel = new OutlinePanel();
                instanceWRef = new WeakReference<OutlinePanel>(outlinePanel);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return outlinePanel;
        }
    }

    public void requestFocus() {
        this.treeView.requestFocus();
    }

    public boolean requestFocusInWindow() {
        return this.treeView.requestFocusInWindow();
    }

    public ExplorerManager getExplorerManager() {
        return this.manager;
    }

    public Lookup getLookup() {
        return this.lookup;
    }

    public void addNotify() {
        super.addNotify();
        ExplorerUtils.activateActions((ExplorerManager)this.manager, (boolean)true);
    }

    public void removeNotify() {
        ExplorerUtils.activateActions((ExplorerManager)this.manager, (boolean)false);
        super.removeNotify();
    }

    public void setActiveBeans(DesignBean[] designBeanArray) {
        if (DEBUG) {
            OutlinePanel.debugLog("designBeans=" + Arrays.asList(designBeanArray));
        }
        if (designBeanArray.length == 0) {
            this.outlineRootChildren.setDesignBean(null);
            this.selectNodesForDesignBeans(new DesignBean[0]);
        } else {
            this.outlineRootChildren.setDesignBean(designBeanArray[0]);
            this.selectNodesForDesignBeans(designBeanArray);
        }
    }

    private void selectNodesForDesignBeans(final DesignBean[] designBeanArray) {
        if (this.isShowing()) {
            this.doSelectNodesForDesignBeans(designBeanArray);
        } else {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    OutlinePanel.this.doSelectNodesForDesignBeans(designBeanArray);
                }
            });
        }
    }

    private void doSelectNodesForDesignBeans(DesignBean[] designBeanArray) {
        Node[] nodeArray = OutlinePanel.getNodesForBeans(designBeanArray);
        this.selectNodes(nodeArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectNodes(Node[] nodeArray) {
        OutlinePanel.initializeParentNodes(nodeArray);
        if (!OutlinePanel.areNodesUnderRoot(nodeArray, this.manager.getRootContext())) {
            return;
        }
        this.expandNodes(nodeArray);
        this.scrollToNodes(nodeArray);
        this.manager.removePropertyChangeListener(this.outlineManagerListener);
        try {
            this.manager.setSelectedNodes(nodeArray);
        }
        catch (PropertyVetoException propertyVetoException) {
            ErrorManager.getDefault().notify(1, (Throwable)propertyVetoException);
        }
        finally {
            this.manager.addPropertyChangeListener(this.outlineManagerListener);
        }
    }

    private static Node[] getNodesForBeans(DesignBean[] designBeanArray) {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        for (DesignBean designBean : designBeanArray) {
            Node node = OutlineUtilities.getNodeForDesignBean(designBean);
            if (node == null) continue;
            arrayList.add(node);
        }
        return arrayList.toArray(new Node[arrayList.size()]);
    }

    private void expandNodes(Node[] nodeArray) {
        this.treeView.expandNodes(nodeArray);
    }

    private void scrollToNodes(Node[] nodeArray) {
        this.treeView.scrollToNodes(nodeArray);
    }

    private static void initializeParentNodes(Node[] nodeArray) {
        for (int i = 0; i < nodeArray.length; ++i) {
            OutlinePanel.initializeParentNodes(nodeArray[i]);
        }
    }

    private static void initializeParentNodes(Node node) {
        DesignBean designBean;
        while ((designBean = (DesignBean)node.getLookup().lookup(DesignBean.class)) != null) {
            DesignBean designBean2 = designBean.getBeanParent();
            if (designBean2 == null) {
                return;
            }
            node = OutlineUtilities.getNodeForDesignBean(designBean2);
            node.getChildren().getNodes(true);
        }
        return;
    }

    private static boolean areNodesUnderRoot(Node[] nodeArray, Node node) {
        if (node == null || nodeArray == null || nodeArray.length == 0) {
            return false;
        }
        for (int i = 0; i < nodeArray.length; ++i) {
            Node node2 = nodeArray[i];
            if (node == NodeOp.findRoot((Node)node2)) continue;
            if (DEBUG) {
                ErrorManager.getDefault().notify(1, (Throwable)new IllegalStateException("Node=" + node2 + " is not under root=" + node + "\n\n" + OutlinePanel.dumpNodeWithChildren(node, 0) + "\n\n" + OutlinePanel.dumpNodeWithChildren(NodeOp.findRoot((Node)node2), 0)));
            }
            return false;
        }
        return true;
    }

    private void dumpActivatedNodes() {
        OutlinePanel.log("Activated nodes:");
        Node[] nodeArray = this.getExplorerManager().getSelectedNodes();
        if (nodeArray == null) {
            return;
        }
        for (Node node : nodeArray) {
            OutlinePanel.log(OutlinePanel.dumpNodeWithChildren(node, 0));
        }
    }

    private static String dumpNodeWithChildren(Node node, int n) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\n" + OutlinePanel.getTabs(n) + node);
        Node[] nodeArray = node.getChildren().getNodes(true);
        for (int i = 0; i < nodeArray.length; ++i) {
            stringBuilder.append(OutlinePanel.dumpNodeWithChildren(nodeArray[i], n + 1));
        }
        return stringBuilder.toString();
    }

    private static String getTabs(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            stringBuilder.append('\t');
        }
        return stringBuilder.toString();
    }

    private static void debugLog(String string) {
        ErrorManager.getDefault().getInstance(OutlinePanel.class.getName()).log(string);
    }

    boolean isSelectionValid() {
        return OutlinePanel.areNodesUnderRoot(this.manager.getSelectedNodes(), this.manager.getRootContext());
    }

    public HelpCtx getHelpCtx() {
        return ExplorerUtils.getHelpCtx((Node[])this.getExplorerManager().getSelectedNodes(), (HelpCtx)new HelpCtx("projrave_ui_elements_navigator_win_about_navigator_win"));
    }

    private static void log(String string) {
        Logger logger = OutlinePanel.getLogger();
        logger.log(Level.INFO, string);
    }

    private static Logger getLogger() {
        return Logger.getLogger(OutlinePanel.class.getName());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class OutlineRootChildren
    extends Children.Keys<DesignBean> {
        private final DesignProjectListener designProjectListener = new OutlineDesignProjectListener(this);
        private DesignContextListener designContextListener;
        private final OutlinePanel outlinePanel;
        private DesignBean rootDesignBean;

        public OutlineRootChildren(OutlinePanel outlinePanel) {
            this.outlinePanel = outlinePanel;
        }

        protected Node[] createNodes(DesignBean designBean) {
            Node[] nodeArray;
            if (DEBUG) {
                OutlinePanel.debugLog("creatingNode for key=" + designBean);
            }
            if (designBean == null) {
                nodeArray = new Node[]{};
            } else {
                Node[] nodeArray2 = new Node[1];
                nodeArray = nodeArray2;
                nodeArray2[0] = OutlineUtilities.getNodeForDesignBean(designBean);
            }
            return nodeArray;
        }

        private void setDesignBean(DesignBean designBean) {
            this.setRootDesignBean(designBean == null ? null : designBean.getDesignContext().getRootContainer());
        }

        private void setRootDesignBean(DesignBean designBean) {
            if (this.rootDesignBean == designBean) {
                return;
            }
            this.removeDesignProjectListening(this.rootDesignBean);
            this.rootDesignBean = designBean;
            this.updateKeys();
            this.addDesignProjectListening(this.rootDesignBean);
        }

        private void updateKeys() {
            Collection<DesignBean> collection = OutlineRootChildren.getAllBeansCollection(this.rootDesignBean);
            this.setKeys(collection);
            this.updateDesignContextListening(collection);
        }

        private void addDesignProjectListening(DesignBean designBean) {
            if (designBean == null) {
                return;
            }
            DesignContext designContext = designBean.getDesignContext();
            if (designContext == null) {
                return;
            }
            DesignProject designProject = designContext.getProject();
            if (designProject == null) {
                return;
            }
            designProject.addDesignProjectListener(this.designProjectListener);
        }

        private void removeDesignProjectListening(DesignBean designBean) {
            if (designBean == null) {
                return;
            }
            DesignContext designContext = designBean.getDesignContext();
            if (designContext == null) {
                return;
            }
            DesignProject designProject = designContext.getProject();
            if (designProject == null) {
                return;
            }
            designProject.removeDesignProjectListener(this.designProjectListener);
        }

        private void updateDesignContextListening(Collection<DesignBean> collection) {
            this.designContextListener = null;
            HashSet<DesignContext> hashSet = new HashSet<DesignContext>();
            for (DesignBean designBean : collection) {
                hashSet.add(designBean.getDesignContext());
            }
            if (!hashSet.isEmpty()) {
                this.designContextListener = new OutlineDesignContextListener(this.outlinePanel);
            }
            for (DesignContext designContext : hashSet) {
                if (this.rootDesignBean != null && designContext == this.rootDesignBean.getDesignContext()) continue;
                designContext.addDesignContextListener((DesignContextListener)WeakListeners.create(DesignContextListener.class, (EventListener)this.designContextListener, (Object)designContext));
            }
        }

        private static DesignContext[] getDesignContexts(DesignContext designContext) {
            DesignProject designProject = designContext.getProject();
            DesignContext[] designContextArray = designProject instanceof FacesDesignProject ? ((FacesDesignProject)designProject).findDesignContexts(new String[]{"request", "session", "application"}) : new DesignContext[]{};
            DesignContext[] designContextArray2 = new DesignContext[designContextArray.length + 1];
            designContextArray2[0] = designContext;
            System.arraycopy(designContextArray, 0, designContextArray2, 1, designContextArray.length);
            return designContextArray2;
        }

        private static Collection<DesignBean> getAllBeansCollection(DesignBean designBean) {
            DesignContext[] designContextArray;
            if (designBean == null) {
                return Collections.emptyList();
            }
            ArrayList<DesignBean> arrayList = new ArrayList<DesignBean>();
            arrayList.add(designBean);
            DesignProject designProject = designBean.getDesignContext().getProject();
            if (designProject == null) {
                return Collections.emptyList();
            }
            DesignContext designContext = designBean.getDesignContext();
            if (designContext == null) {
                ErrorManager.getDefault().notify(1, (Throwable)new IllegalStateException("Design bean returns null design context, designBean=" + designBean));
                designContextArray = new DesignContext[]{};
            } else {
                designContextArray = OutlineRootChildren.getDesignContexts(designContext);
            }
            ArrayList<DesignContext> arrayList2 = new ArrayList<DesignContext>();
            arrayList2.addAll(Arrays.asList(designContextArray));
            Collections.sort(arrayList2, new AuxiliaryContextComparator());
            for (DesignContext designContext2 : arrayList2) {
                DesignBean designBean2 = designContext2.getRootContainer();
                if (arrayList.contains(designBean2)) continue;
                arrayList.add(designBean2);
            }
            if (DEBUG) {
                OutlinePanel.debugLog("beans=" + arrayList);
            }
            return new ArrayList<DesignBean>(arrayList);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class AuxiliaryContextComparator
        implements Comparator<DesignContext> {
            private AuxiliaryContextComparator() {
            }

            @Override
            public int compare(DesignContext designContext, DesignContext designContext2) {
                int n = AuxiliaryContextComparator.getScopeWeight(designContext);
                int n2 = AuxiliaryContextComparator.getScopeWeight(designContext2);
                return n2 - n;
            }

            private static int getScopeWeight(DesignContext designContext) {
                Object object = designContext.getContextData("scope");
                if ("request".equals(object)) {
                    return 4;
                }
                if ("session".equals(object)) {
                    return 3;
                }
                if ("application".equals(object)) {
                    return 2;
                }
                if ("none".equals(object)) {
                    return 1;
                }
                ErrorManager.getDefault().notify(1, (Throwable)new IllegalStateException("The design context doesn't provide valid scope, designContext=" + designContext + ", scope=" + object));
                return 0;
            }
        }

        private static class OutlineDesignContextListener
        implements DesignContextListener {
            private final OutlinePanel outlinePanel;

            public OutlineDesignContextListener(OutlinePanel outlinePanel) {
                this.outlinePanel = outlinePanel;
            }

            public void contextActivated(DesignContext designContext) {
            }

            public void contextDeactivated(DesignContext designContext) {
            }

            public void contextChanged(DesignContext designContext) {
            }

            public void beanCreated(DesignBean designBean) {
                this.expandNodeForDesignBean(designBean);
            }

            public void beanDeleted(DesignBean designBean) {
            }

            public void beanMoved(DesignBean designBean, DesignBean designBean2, Position position) {
            }

            public void beanContextActivated(DesignBean designBean) {
            }

            public void beanContextDeactivated(DesignBean designBean) {
            }

            public void instanceNameChanged(DesignBean designBean, String string) {
            }

            public void beanChanged(DesignBean designBean) {
            }

            public void propertyChanged(DesignProperty designProperty, Object object) {
            }

            public void eventChanged(DesignEvent designEvent) {
            }

            private void expandNodeForDesignBean(final DesignBean designBean) {
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        Node[] nodeArray = OutlinePanel.getNodesForBeans(new DesignBean[]{designBean});
                        OutlinePanel.initializeParentNodes(nodeArray);
                        if (OutlinePanel.areNodesUnderRoot(nodeArray, OutlineDesignContextListener.this.outlinePanel.getExplorerManager().getRootContext())) {
                            OutlineDesignContextListener.this.outlinePanel.expandNodes(nodeArray);
                        }
                    }
                });
            }
        }

        private static class OutlineDesignProjectListener
        implements DesignProjectListener {
            private final OutlineRootChildren outlineRootChildren;

            public OutlineDesignProjectListener(OutlineRootChildren outlineRootChildren) {
                this.outlineRootChildren = outlineRootChildren;
            }

            public void contextOpened(DesignContext designContext) {
                this.updateChildren();
            }

            public void contextClosed(DesignContext designContext) {
                this.updateChildren();
            }

            private void updateChildren() {
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        OutlineDesignProjectListener.this.outlineRootChildren.updateKeys();
                    }
                });
            }
        }
    }

    private static class OutlineTreeView
    extends BeanTreeView {
        private final OutlinePanel outlinePanel;

        public OutlineTreeView(OutlinePanel outlinePanel) {
            this.outlinePanel = outlinePanel;
        }

        public String toString() {
            ExplorerManager explorerManager = this.outlinePanel.manager;
            if (explorerManager == null) {
                return super.toString();
            }
            Node[] nodeArray = explorerManager.getSelectedNodes();
            return super.toString() + ", manager=" + explorerManager + ", selectedNodes=" + (nodeArray == null ? null : Arrays.asList(nodeArray));
        }

        public void expandNodes(Node[] nodeArray) {
            TreePath[] treePathArray = this.getTreePathsForNodes(nodeArray);
            for (int i = 0; i < treePathArray.length; ++i) {
                TreePath treePath = OutlineTreeView.getTreePathToExpand(treePathArray[i]);
                if (treePath == null) continue;
                this.tree.expandPath(treePath);
            }
        }

        public void scrollToNodes(Node[] nodeArray) {
            TreePath[] treePathArray = this.getTreePathsForNodes(nodeArray);
            Rectangle rectangle = new Rectangle();
            if (this.areTreePathsVisible(treePathArray)) {
                return;
            }
            for (int i = 0; i < treePathArray.length; ++i) {
                Rectangle rectangle2 = this.tree.getPathBounds(treePathArray[i]);
                if (rectangle2 == null) {
                    ErrorManager.getDefault().notify(1, (Throwable)new NullPointerException("No bounds for treePath=" + treePathArray[i]));
                    continue;
                }
                rectangle.add(rectangle2);
            }
            if (!rectangle.isEmpty()) {
                this.tree.scrollRectToVisible(rectangle);
            }
        }

        private boolean areTreePathsVisible(TreePath[] treePathArray) {
            for (int i = 0; i < treePathArray.length; ++i) {
                if (this.tree.isVisible(treePathArray[i])) continue;
                return false;
            }
            return true;
        }

        private static TreePath getTreePathToExpand(TreePath treePath) {
            Object[] objectArray = treePath.getPath();
            if (objectArray.length < 2) {
                return null;
            }
            ArrayList<Object> arrayList = new ArrayList<Object>(Arrays.asList(objectArray));
            arrayList.remove(objectArray.length - 1);
            return new TreePath(arrayList.toArray());
        }

        private TreePath[] getTreePathsForNodes(Node[] nodeArray) {
            ArrayList<TreePath> arrayList = new ArrayList<TreePath>();
            for (Node node : nodeArray) {
                TreePath treePath = this.getTreePathForNode(node);
                if (treePath == null) continue;
                arrayList.add(treePath);
            }
            return arrayList.toArray(new TreePath[arrayList.size()]);
        }

        private TreePath getTreePathForNode(Node node) {
            TreeNode treeNode = Visualizer.findVisualizer((Node)node);
            if (treeNode == null) {
                ErrorManager.getDefault().notify(1, (Throwable)new NullPointerException("TreeNode not found for node=" + node));
                return null;
            }
            TreeModel treeModel = this.tree.getModel();
            if (!(treeModel instanceof DefaultTreeModel)) {
                ErrorManager.getDefault().notify(1, (Throwable)new NullPointerException("DefaultTreeModel not found, model=" + treeModel));
                return null;
            }
            return new TreePath(((DefaultTreeModel)treeModel).getPathToRoot(treeNode));
        }
    }
}

