/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.metadata.model;

import java.lang.ref.WeakReference;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.db.explorer.ConnectionManager;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.metadata.model.MetadataModelImplementation;
import org.netbeans.modules.db.metadata.model.api.Action;
import org.netbeans.modules.db.metadata.model.api.Metadata;
import org.netbeans.modules.db.metadata.model.api.MetadataException;
import org.netbeans.modules.db.metadata.model.api.MetadataModelException;
import org.netbeans.modules.db.metadata.model.jdbc.JDBCMetadata;
import org.netbeans.modules.db.metadata.model.jdbc.mssql.MSSQLMetadata;
import org.netbeans.modules.db.metadata.model.jdbc.oracle.OracleMetadata;
import org.netbeans.modules.db.metadata.model.spi.MetadataFactory;
import org.openide.util.Mutex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBConnMetadataModel
implements MetadataModelImplementation {
    private static final Logger LOGGER = Logger.getLogger(DBConnMetadataModel.class.getName());
    private final ReentrantLock lock = new ReentrantLock();
    private final WeakReference<DatabaseConnection> dbconnRef;
    private JDBCMetadata metadataImpl;
    private Metadata metadata;

    public DBConnMetadataModel(DatabaseConnection databaseConnection) {
        this.dbconnRef = new WeakReference<DatabaseConnection>(databaseConnection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void runReadAction(Action<Metadata> action) throws MetadataModelException {
        this.lock.lock();
        try {
            DatabaseConnection databaseConnection = (DatabaseConnection)this.dbconnRef.get();
            if (databaseConnection == null) {
                return;
            }
            try {
                this.enterReadAccess(databaseConnection);
                if (this.metadata != null) {
                    action.run(this.metadata);
                }
            }
            catch (SQLException sQLException) {
                throw new MetadataModelException(sQLException);
            }
            catch (MetadataException metadataException) {
                throw new MetadataModelException(metadataException);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        LOGGER.fine("Refreshing model");
        this.lock.lock();
        try {
            this.metadataImpl = null;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshTable(String string) {
        LOGGER.log(Level.FINE, "Refreshing table ''{0}''", string);
        this.lock.lock();
        try {
            if (this.metadataImpl != null) {
                this.metadataImpl.refreshTable(string);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private void enterReadAccess(final DatabaseConnection databaseConnection) throws SQLException {
        Connection connection;
        Connection connection2 = databaseConnection.getJDBCConnection();
        if (connection2 == null) {
            connection2 = (Connection)Mutex.EVENT.readAccess((Mutex.Action)new Mutex.Action<Connection>(){

                public Connection run() {
                    ConnectionManager.getDefault().showConnectionDialog(databaseConnection);
                    return databaseConnection.getJDBCConnection();
                }
            });
        }
        Connection connection3 = connection = this.metadataImpl != null ? this.metadataImpl.getConnection() : null;
        if (connection != connection2) {
            String string = databaseConnection.getSchema();
            if (string.trim().length() == 0) {
                string = null;
            }
            if (connection2 != null) {
                this.metadataImpl = DBConnMetadataModel.createMetadata(connection2, string);
                this.metadata = MetadataFactory.createMetadata(this.metadataImpl);
            } else {
                this.metadataImpl = null;
                this.metadata = null;
            }
        }
    }

    private static JDBCMetadata createMetadata(Connection connection, String string) {
        try {
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            if ("Oracle".equals(databaseMetaData.getDatabaseProductName())) {
                return new OracleMetadata(connection, string);
            }
            String string2 = databaseMetaData.getDriverName();
            if (string2 != null && (string2.contains("Microsoft SQL Server") || string2.contains("jTDS"))) {
                return new MSSQLMetadata(connection, string);
            }
        }
        catch (SQLException sQLException) {
            LOGGER.log(Level.INFO, null, sQLException);
        }
        return new JDBCMetadata(connection, string);
    }
}

