/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.napi.gsfret.source;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import org.netbeans.modules.gsf.Language;
import org.netbeans.modules.gsf.LanguageRegistry;
import org.netbeans.modules.gsfpath.api.classpath.ClassPath;
import org.netbeans.modules.gsfpath.spi.classpath.support.ClassPathSupport;
import org.netbeans.modules.gsfret.source.CacheClassPath;
import org.netbeans.modules.gsfret.source.usages.ClasspathInfoAccessor;
import org.netbeans.napi.gsfret.source.ClassIndex;
import org.netbeans.napi.gsfret.source.CompilationInfo;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.WeakListeners;

public final class ClasspathInfo {
    private static final ClassPath EMPTY_PATH = ClassPathSupport.createClassPath((URL[])new URL[0]);
    private final ClassPath srcClassPath;
    private final ClassPath bootClassPath;
    private final ClassPath compileClassPath;
    private final ClassPath cachedBootClassPath;
    private final ClassPath cachedCompileClassPath;
    private ClassPath outputClassPath;
    private final ClassPathListener cpListener;
    private final boolean backgroundCompilation;
    private final boolean ignoreExcludes;
    private final Object filter;
    private EventListenerList listenerList = null;
    private List<ClassIndex> usagesQuery;

    private ClasspathInfo(ClassPath classPath, ClassPath classPath2, ClassPath classPath3, Object object, boolean bl, boolean bl2) {
        assert (classPath != null && classPath2 != null);
        this.cpListener = new ClassPathListener();
        this.bootClassPath = classPath;
        this.compileClassPath = classPath2;
        this.cachedBootClassPath = CacheClassPath.forBootPath(this.bootClassPath);
        this.cachedCompileClassPath = CacheClassPath.forClassPath(this.compileClassPath);
        this.cachedBootClassPath.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.cpListener, (Object)this.cachedBootClassPath));
        this.cachedCompileClassPath.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.cpListener, (Object)this.cachedCompileClassPath));
        if (classPath3 != null) {
            this.srcClassPath = classPath3;
            this.outputClassPath = CacheClassPath.forSourcePath(this.srcClassPath);
            this.srcClassPath.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.cpListener, (Object)this.srcClassPath));
        } else {
            this.srcClassPath = ClassPathSupport.createClassPath((URL[])new URL[0]);
            this.outputClassPath = ClassPathSupport.createClassPath((URL[])new URL[0]);
        }
        this.backgroundCompilation = bl;
        this.ignoreExcludes = bl2;
        this.filter = object;
    }

    public String toString() {
        return "ClasspathInfo boot:[" + this.cachedBootClassPath + "],compile:[" + this.cachedCompileClassPath + "],src:[" + this.srcClassPath + "]";
    }

    public static ClasspathInfo create(File file) {
        if (file == null) {
            throw new IllegalArgumentException("Cannot pass null as parameter of ClasspathInfo.create(java.io.File)");
        }
        FileObject fileObject = FileUtil.toFileObject((File)file);
        if (fileObject == null) {
            return null;
        }
        return ClasspathInfo.create(fileObject);
    }

    private static ClasspathInfo create(FileObject fileObject, Object object, boolean bl, boolean bl2) {
        ClassPath classPath;
        ClassPath classPath2;
        ClassPath classPath3 = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/boot");
        if (classPath3 == null) {
            classPath3 = EMPTY_PATH;
        }
        if ((classPath2 = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/compile")) == null) {
            classPath2 = EMPTY_PATH;
        }
        if ((classPath = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/source")) == null) {
            classPath = EMPTY_PATH;
        }
        return ClasspathInfo.create(classPath3, classPath2, classPath, object, bl, bl2);
    }

    public static ClasspathInfo create(FileObject fileObject) {
        return ClasspathInfo.create(fileObject, null, false, false);
    }

    private static ClasspathInfo create(ClassPath classPath, ClassPath classPath2, ClassPath classPath3, Object object, boolean bl, boolean bl2) {
        return new ClasspathInfo(classPath, classPath2, classPath3, object, bl, bl2);
    }

    public static ClasspathInfo create(ClassPath classPath, ClassPath classPath2, ClassPath classPath3) {
        return new ClasspathInfo(classPath, classPath2, classPath3, null, false, false);
    }

    public synchronized void addChangeListener(ChangeListener changeListener) {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        this.listenerList.add(ChangeListener.class, changeListener);
    }

    public synchronized void removeChangeListener(ChangeListener changeListener) {
        this.listenerList.remove(ChangeListener.class, changeListener);
    }

    public ClassPath getClassPath(PathKind pathKind) {
        switch (pathKind) {
            case BOOT: {
                return this.bootClassPath;
            }
            case COMPILE: {
                return this.compileClassPath;
            }
            case SOURCE: {
                return this.srcClassPath;
            }
        }
        assert (false) : "Unknown path type";
        return null;
    }

    ClassPath getCachedClassPath(PathKind pathKind) {
        switch (pathKind) {
            case BOOT: {
                return this.cachedBootClassPath;
            }
            case COMPILE: {
                return this.cachedCompileClassPath;
            }
            case SOURCE: {
                return this.srcClassPath;
            }
            case OUTPUT: {
                return this.outputClassPath;
            }
        }
        assert (false) : "Unknown path type";
        return null;
    }

    public synchronized ClassIndex getClassIndex(String string) {
        ClassIndex classIndex;
        if (this.usagesQuery == null) {
            this.usagesQuery = new ArrayList<ClassIndex>(8);
        } else {
            for (int i = 0; i < this.usagesQuery.size(); ++i) {
                classIndex = this.usagesQuery.get(i);
                if (!classIndex.getLanguage().getMimeType().equals(string)) continue;
                return classIndex;
            }
        }
        Language language = LanguageRegistry.getInstance().getLanguageByMimeType(string);
        assert (language != null) : string;
        classIndex = new ClassIndex(language, this.bootClassPath, this.compileClassPath, this.srcClassPath);
        this.usagesQuery.add(classIndex);
        return classIndex;
    }

    private void fireChangeListenerStateChanged() {
        ChangeEvent changeEvent = null;
        if (this.listenerList == null) {
            return;
        }
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ChangeListener.class) continue;
            if (changeEvent == null) {
                changeEvent = new ChangeEvent(this);
            }
            ((ChangeListener)objectArray[i + 1]).stateChanged(changeEvent);
        }
    }

    static {
        ClasspathInfoAccessor.INSTANCE = new ClasspathInfoAccessorImpl();
        try {
            Class.forName(ClassIndex.class.getName(), true, CompilationInfo.class.getClassLoader());
        }
        catch (ClassNotFoundException classNotFoundException) {
            ErrorManager.getDefault().notify((Throwable)classNotFoundException);
        }
    }

    private static class ClasspathInfoAccessorImpl
    extends ClasspathInfoAccessor {
        private ClasspathInfoAccessorImpl() {
        }

        public ClassPath getCachedClassPath(ClasspathInfo classpathInfo, PathKind pathKind) {
            return classpathInfo.getCachedClassPath(pathKind);
        }

        public ClasspathInfo create(ClassPath classPath, ClassPath classPath2, ClassPath classPath3, Object object, boolean bl, boolean bl2) {
            return ClasspathInfo.create(classPath, classPath2, classPath3, object, bl, bl2);
        }

        public ClasspathInfo create(FileObject fileObject, Object object, boolean bl, boolean bl2) {
            return ClasspathInfo.create(fileObject, object, bl, bl2);
        }
    }

    private class ClassPathListener
    implements PropertyChangeListener {
        private ClassPathListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("roots".equals(propertyChangeEvent.getPropertyName())) {
                ClassPathListener classPathListener = this;
                synchronized (classPathListener) {
                }
                ClasspathInfo.this.fireChangeListenerStateChanged();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PathKind {
        BOOT,
        COMPILE,
        SOURCE,
        OUTPUT;

    }
}

