/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsfret.source.usages;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.gsf.Language;
import org.netbeans.modules.gsf.api.IndexDocument;
import org.netbeans.modules.gsf.api.IndexDocumentFactory;
import org.netbeans.modules.gsf.api.Indexer;
import org.netbeans.modules.gsf.api.ParserFile;
import org.netbeans.modules.gsf.api.ParserResult;
import org.netbeans.modules.gsfret.source.usages.Index;
import org.netbeans.modules.gsfret.source.usages.IndexBatchEntry;
import org.netbeans.modules.gsfret.source.usages.IndexDocumentImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourceAnalyser
implements IndexDocumentFactory {
    private final Index index;
    private final Map<String, List<String>> references;

    public SourceAnalyser(Index index) {
        assert (index != null);
        this.index = index;
        this.references = new HashMap<String, List<String>>();
    }

    public final boolean isUpToDate(String string, long l) throws IOException {
        return this.index.isUpToDate(string, l);
    }

    public void store() throws IOException {
    }

    public boolean isValid() throws IOException {
        return this.index.isValid(true);
    }

    public void analyse(Language language, Iterable<ParserResult> iterable) throws IOException {
        Indexer indexer = language.getIndexer();
        if (indexer != null) {
            for (ParserResult parserResult : iterable) {
                String string = indexer.getPersistentUrl(parserResult.getFile().getFile());
                List<IndexDocument> list = indexer.index(parserResult, (IndexDocumentFactory)this);
                if (list == null) {
                    list = Collections.emptyList();
                }
                this.index.store(string, list);
            }
        }
    }

    void analyseUnitAndStore(Indexer indexer, ParserResult parserResult) throws IOException {
        String string = indexer.getPersistentUrl(parserResult.getFile().getFile());
        List<IndexDocument> list = indexer.index(parserResult, (IndexDocumentFactory)this);
        if (list == null) {
            list = Collections.emptyList();
        }
        this.index.store(string, list);
    }

    public void delete(ParserFile parserFile, Language language) throws IOException {
        if (!this.index.isValid(false)) {
            return;
        }
        Indexer indexer = language.getIndexer();
        if (indexer != null && indexer.isIndexable(parserFile)) {
            String string = indexer.getPersistentUrl(parserFile.getFile());
            this.index.store(string, null);
        }
    }

    Map<String, String> getTimeStamps() throws IOException {
        return this.index.getTimeStamps();
    }

    public IndexDocument createDocument(int n) {
        return new IndexDocumentImpl(n);
    }

    public IndexDocument createDocument(int n, String string) {
        return new IndexDocumentImpl(n, string);
    }

    public String toString() {
        return "SourceAnalyzer(" + ((Object)((Object)this.index)).toString().substring(((Object)((Object)this.index)).toString().indexOf("@") + 1) + ")";
    }

    boolean hasData() {
        try {
            return !this.index.isValid(false);
        }
        catch (IOException iOException) {
            return true;
        }
    }

    void batchStore(List<IndexBatchEntry> list, boolean bl) throws IOException {
        this.index.batchStore(list, bl);
    }
}

