/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsfret.editor.completion;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.List;
import java.util.Set;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import javax.swing.JToolTip;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.completion.Completion;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Registry;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.gsf.Language;
import org.netbeans.modules.gsf.LanguageRegistry;
import org.netbeans.modules.gsf.api.CancellableTask;
import org.netbeans.modules.gsf.api.CodeCompletionContext;
import org.netbeans.modules.gsf.api.CodeCompletionHandler;
import org.netbeans.modules.gsf.api.CodeCompletionResult;
import org.netbeans.modules.gsf.api.CompilationInfo;
import org.netbeans.modules.gsf.api.CompletionProposal;
import org.netbeans.modules.gsf.api.ElementHandle;
import org.netbeans.modules.gsf.api.NameKind;
import org.netbeans.modules.gsf.api.ParameterInfo;
import org.netbeans.modules.gsfret.editor.completion.GsfCompletionDoc;
import org.netbeans.modules.gsfret.editor.completion.GsfCompletionItem;
import org.netbeans.modules.gsfret.editor.completion.MethodParamsTipPaintComponent;
import org.netbeans.napi.gsfret.source.CompilationController;
import org.netbeans.napi.gsfret.source.Phase;
import org.netbeans.napi.gsfret.source.Source;
import org.netbeans.napi.gsfret.source.SourceUtils;
import org.netbeans.spi.editor.completion.CompletionDocumentation;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.netbeans.spi.editor.completion.CompletionProvider;
import org.netbeans.spi.editor.completion.CompletionResultSet;
import org.netbeans.spi.editor.completion.CompletionTask;
import org.netbeans.spi.editor.completion.support.AsyncCompletionQuery;
import org.netbeans.spi.editor.completion.support.AsyncCompletionTask;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;

public class GsfCompletionProvider
implements CompletionProvider {
    private static boolean caseSensitive = true;
    private static boolean autoPopup = true;
    private static boolean inited;
    private static PreferenceChangeListener settingsListener;

    public static CodeCompletionHandler getCompletable(org.netbeans.napi.gsfret.source.CompilationInfo compilationInfo, int n) {
        Document document = compilationInfo.getDocument();
        if (document != null) {
            return GsfCompletionProvider.getCompletable(document, n);
        }
        return null;
    }

    static CodeCompletionHandler getCompletable(Document document, int n) {
        BaseDocument baseDocument = (BaseDocument)document;
        List<Language> list = LanguageRegistry.getInstance().getEmbeddedLanguages(baseDocument, n);
        for (Language language : list) {
            if (language.getCompletionProvider() == null) continue;
            return language.getCompletionProvider();
        }
        return null;
    }

    public int getAutoQueryTypes(JTextComponent jTextComponent, String string) {
        CodeCompletionHandler codeCompletionHandler;
        if (!autoPopup) {
            return 0;
        }
        if (string.length() > 0 && (codeCompletionHandler = GsfCompletionProvider.getCompletable(jTextComponent.getDocument(), jTextComponent.getCaretPosition())) != null) {
            CodeCompletionHandler.QueryType queryType = codeCompletionHandler.getAutoQuery(jTextComponent, string);
            switch (queryType) {
                case NONE: {
                    return 0;
                }
                case STOP: {
                    Completion.get().hideAll();
                    return 0;
                }
                case COMPLETION: {
                    return 1;
                }
                case DOCUMENTATION: {
                    return 2;
                }
                case TOOLTIP: {
                    return 4;
                }
                case ALL_COMPLETION: {
                    return 9;
                }
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isJavaContext(JTextComponent jTextComponent, int n) {
        Document document = jTextComponent.getDocument();
        org.netbeans.api.lexer.Language language = (org.netbeans.api.lexer.Language)document.getProperty(org.netbeans.api.lexer.Language.class);
        if (language == null) {
            return true;
        }
        if (document instanceof AbstractDocument) {
            ((AbstractDocument)document).readLock();
        }
        try {
            TokenSequence tokenSequence = TokenHierarchy.get((Document)jTextComponent.getDocument()).tokenSequence();
            if (tokenSequence == null) {
                boolean bl = false;
                return bl;
            }
            if (!tokenSequence.moveNext() || tokenSequence.move(n) == 0) {
                boolean bl = true;
                return bl;
            }
            if (!tokenSequence.moveNext()) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            if (document instanceof AbstractDocument) {
                ((AbstractDocument)document).readUnlock();
            }
        }
    }

    public static boolean startsWith(String string, String string2) {
        if (string == null || string.length() == 0) {
            return false;
        }
        if (string2 == null || string2.length() == 0) {
            return true;
        }
        return GsfCompletionProvider.isCaseSensitive() ? string.startsWith(string2) : string.toLowerCase().startsWith(string2.toLowerCase());
    }

    public CompletionTask createTask(int n, JTextComponent jTextComponent) {
        if ((n & 1) != 0 || n == 4 || n == 2) {
            return new AsyncCompletionTask((AsyncCompletionQuery)new JavaCompletionQuery(n, jTextComponent.getSelectionStart()), jTextComponent);
        }
        return null;
    }

    static CompletionTask createDocTask(ElementHandle elementHandle, org.netbeans.napi.gsfret.source.CompilationInfo compilationInfo) {
        JavaCompletionQuery javaCompletionQuery = new JavaCompletionQuery(2, -1);
        javaCompletionQuery.element = elementHandle;
        return new AsyncCompletionTask((AsyncCompletionQuery)javaCompletionQuery, Registry.getMostActiveComponent());
    }

    private static boolean isCaseSensitive() {
        GsfCompletionProvider.lazyInit();
        return caseSensitive;
    }

    private static void setCaseSensitive(boolean bl) {
        GsfCompletionProvider.lazyInit();
        caseSensitive = bl;
    }

    private static void setAutoPopup(boolean bl) {
        GsfCompletionProvider.lazyInit();
        autoPopup = bl;
    }

    private static void lazyInit() {
        if (!inited) {
            inited = true;
            Preferences preferences = (Preferences)MimeLookup.getLookup((MimePath)MimePath.EMPTY).lookup(Preferences.class);
            preferences.addPreferenceChangeListener((PreferenceChangeListener)WeakListeners.create(PreferenceChangeListener.class, (EventListener)settingsListener, (Object)preferences));
            GsfCompletionProvider.setCaseSensitive(preferences.getBoolean("completion-case-sensitive", false));
            GsfCompletionProvider.setAutoPopup(preferences.getBoolean("completion-auto-popup", false));
        }
    }

    static {
        settingsListener = new SettingsListener();
    }

    private static class SettingsListener
    implements PreferenceChangeListener {
        private SettingsListener() {
        }

        public void preferenceChange(PreferenceChangeEvent preferenceChangeEvent) {
            if (preferenceChangeEvent.getKey() == null || "completion-case-sensitive".equals(preferenceChangeEvent.getKey())) {
                GsfCompletionProvider.setCaseSensitive(Boolean.valueOf(preferenceChangeEvent.getNewValue()));
            } else if ("completion-auto-popup".equals(preferenceChangeEvent.getKey())) {
                GsfCompletionProvider.setAutoPopup(Boolean.valueOf(preferenceChangeEvent.getNewValue()));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class JavaCompletionQuery
    extends AsyncCompletionQuery
    implements CancellableTask<CompilationController> {
        private Collection<CompletionItem> results;
        private JToolTip toolTip;
        private CompletionDocumentation documentation;
        private int anchorOffset;
        private JTextComponent component;
        private int queryType;
        private int caretOffset;
        private String filterPrefix;
        private ElementHandle element;
        private boolean isTruncated;
        private boolean isFilterable;

        private JavaCompletionQuery(int n, int n2) {
            this.queryType = n;
            this.caretOffset = n2;
        }

        protected void preQueryUpdate(JTextComponent jTextComponent) {
            int n = jTextComponent.getSelectionStart();
            if (n >= this.caretOffset) {
                try {
                    if (this.isJavaIdentifierPart(jTextComponent.getDocument().getText(this.caretOffset, n - this.caretOffset))) {
                        return;
                    }
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
            Completion.get().hideCompletion();
        }

        protected void prepareQuery(JTextComponent jTextComponent) {
            this.component = jTextComponent;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void query(CompletionResultSet completionResultSet, Document document, int n) {
            try {
                this.caretOffset = n;
                if (this.queryType == 4 || this.queryType == 2 || GsfCompletionProvider.isJavaContext(this.component, n)) {
                    this.results = null;
                    this.isTruncated = false;
                    this.isFilterable = true;
                    this.documentation = null;
                    this.toolTip = null;
                    this.anchorOffset = -1;
                    Source source = Source.forDocument(document);
                    if (source == null) {
                        FileObject fileObject = null;
                        if (this.element != null && (fileObject = this.element.getFileObject()) != null) {
                            source = Source.forFileObject(fileObject);
                        }
                    }
                    if (source != null) {
                        if (SourceUtils.isScanInProgress()) {
                            completionResultSet.setWaitText(NbBundle.getMessage(GsfCompletionProvider.class, (String)"scanning-in-progress"));
                        }
                        source.runUserActionTask(this, true);
                        if ((this.queryType & 1) != 0) {
                            if (this.results != null) {
                                completionResultSet.addAllItems(this.results);
                            }
                        } else if (this.queryType == 4) {
                            if (this.toolTip != null) {
                                completionResultSet.setToolTip(this.toolTip);
                            }
                        } else if (this.queryType == 2 && this.documentation != null) {
                            completionResultSet.setDocumentation(this.documentation);
                        }
                        if (this.anchorOffset > -1) {
                            completionResultSet.setAnchorOffset(this.anchorOffset);
                        }
                    }
                }
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
            finally {
                completionResultSet.finish();
            }
        }

        protected boolean canFilter(JTextComponent jTextComponent) {
            this.filterPrefix = null;
            int n = jTextComponent.getSelectionStart();
            if ((this.queryType & 1) != 0) {
                if (this.isTruncated || !this.isFilterable) {
                    return false;
                }
                if (n >= this.caretOffset && this.anchorOffset > -1) {
                    try {
                        String string = jTextComponent.getDocument().getText(this.anchorOffset, n - this.anchorOffset);
                        if (this.isJavaIdentifierPart(string)) {
                            this.filterPrefix = string;
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
                return this.filterPrefix != null;
            }
            if (this.queryType == 4) {
                try {
                    if (n == this.caretOffset) {
                        this.filterPrefix = "";
                    } else if (n - this.caretOffset > 0) {
                        this.filterPrefix = jTextComponent.getDocument().getText(this.caretOffset, n - this.caretOffset);
                    } else if (n - this.caretOffset < 0) {
                        this.filterPrefix = jTextComponent.getDocument().getText(n, this.caretOffset - n);
                    }
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
                return this.filterPrefix != null && this.filterPrefix.indexOf(44) == -1 && this.filterPrefix.indexOf(40) == -1 && this.filterPrefix.indexOf(41) == -1;
            }
            return false;
        }

        protected void filter(CompletionResultSet completionResultSet) {
            try {
                if ((this.queryType & 1) != 0) {
                    if (this.results != null) {
                        if (this.filterPrefix != null) {
                            completionResultSet.addAllItems(this.getFilteredData(this.results, this.filterPrefix));
                        } else {
                            Completion.get().hideDocumentation();
                            Completion.get().hideCompletion();
                        }
                    }
                } else if (this.queryType == 4) {
                    completionResultSet.setToolTip(this.toolTip);
                }
                completionResultSet.setAnchorOffset(this.anchorOffset);
            }
            catch (Exception exception) {
                Exceptions.printStackTrace((Throwable)exception);
            }
            completionResultSet.finish();
        }

        public void run(CompilationController compilationController) throws Exception {
            if (compilationController.getDocument() == null) {
                return;
            }
            if ((this.queryType & 1) != 0) {
                this.resolveCompletion(compilationController);
            } else if (this.queryType == 4) {
                this.resolveToolTip(compilationController);
            } else if (this.queryType == 2) {
                this.resolveDocumentation(compilationController);
            }
            GsfCompletionItem.tipProposal = null;
        }

        public void cancel() {
        }

        private void resolveToolTip(CompilationController compilationController) throws IOException {
            int n;
            ParameterInfo parameterInfo;
            CompletionProposal completionProposal = GsfCompletionItem.tipProposal;
            Env env = this.getCompletionEnvironment(compilationController, false);
            CodeCompletionHandler codeCompletionHandler = env.getCompletable();
            if (codeCompletionHandler != null && (parameterInfo = codeCompletionHandler.parameters((CompilationInfo)compilationController, n = env.getOffset(), completionProposal)) != ParameterInfo.NONE) {
                List list = parameterInfo.getNames();
                int n2 = 50;
                int n3 = 0;
                ArrayList<List<String>> arrayList = new ArrayList<List<String>>();
                ArrayList<String> arrayList2 = new ArrayList<String>();
                int n4 = list.size();
                for (int i = 0; i < n4; ++i) {
                    String string = (String)list.get(i);
                    if (i < n4 - 1) {
                        string = string + ", ";
                    }
                    arrayList2.add(string);
                    if ((n3 += string.length()) <= n2) continue;
                    n3 = 0;
                    arrayList.add(arrayList2);
                    arrayList2 = new ArrayList();
                }
                if (arrayList2.size() > 0) {
                    arrayList.add(arrayList2);
                }
                n4 = parameterInfo.getCurrentIndex();
                this.anchorOffset = parameterInfo.getAnchorOffset();
                this.toolTip = new MethodParamsTipPaintComponent(arrayList, n4, this.component);
                return;
            }
        }

        private void resolveDocumentation(CompilationController compilationController) throws IOException {
            compilationController.toPhase(Phase.RESOLVED);
            if (this.element != null) {
                this.documentation = GsfCompletionDoc.create(compilationController, this.element);
            } else {
                Env env = this.getCompletionEnvironment(compilationController, false);
                int n = env.getOffset();
                String string = env.getPrefix();
                this.results = new ArrayList<CompletionItem>();
                this.isTruncated = false;
                this.isFilterable = true;
                this.anchorOffset = env.getOffset() - (string != null ? string.length() : 0);
                CodeCompletionHandler codeCompletionHandler = env.getCompletable();
                if (codeCompletionHandler != null) {
                    CodeCompletionContextImpl codeCompletionContextImpl = new CodeCompletionContextImpl(n, compilationController, string, NameKind.EXACT_NAME, CodeCompletionHandler.QueryType.DOCUMENTATION);
                    CodeCompletionResult codeCompletionResult = codeCompletionHandler.complete((CodeCompletionContext)codeCompletionContextImpl);
                    assert (codeCompletionResult != null) : codeCompletionHandler.getClass().getName() + " should return CodeCompletionResult.NONE rather than null";
                    if (codeCompletionResult != CodeCompletionResult.NONE) {
                        for (CompletionProposal completionProposal : codeCompletionResult.getItems()) {
                            ElementHandle elementHandle = completionProposal.getElement();
                            if (elementHandle == null) continue;
                            this.documentation = GsfCompletionDoc.create(compilationController, elementHandle);
                            if (this.documentation.getText() == null || this.documentation.getText().length() <= 0) continue;
                            break;
                        }
                    }
                }
            }
        }

        private void resolveCompletion(CompilationController compilationController) throws IOException {
            Env env = this.getCompletionEnvironment(compilationController, true);
            int n = env.getOffset();
            String string = env.getPrefix();
            this.results = new ArrayList<CompletionItem>();
            this.isTruncated = false;
            this.isFilterable = true;
            this.anchorOffset = env.getOffset() - (string != null ? string.length() : 0);
            CodeCompletionHandler codeCompletionHandler = env.getCompletable();
            if (codeCompletionHandler != null) {
                this.addCodeCompletionItems(compilationController, codeCompletionHandler, n, string);
                if (this.isTruncated) {
                    GsfCompletionItem gsfCompletionItem = GsfCompletionItem.createTruncationItem();
                    this.results.add(gsfCompletionItem);
                }
            }
        }

        private void addCodeCompletionItems(CompilationController compilationController, CodeCompletionHandler codeCompletionHandler, int n, String string) {
            CodeCompletionContextImpl codeCompletionContextImpl = new CodeCompletionContextImpl(n, compilationController, string, GsfCompletionProvider.isCaseSensitive() ? NameKind.PREFIX : NameKind.CASE_INSENSITIVE_PREFIX, CodeCompletionHandler.QueryType.COMPLETION);
            CodeCompletionResult codeCompletionResult = codeCompletionHandler.complete((CodeCompletionContext)codeCompletionContextImpl);
            assert (codeCompletionResult != null) : codeCompletionHandler.getClass().getName() + " should return CodeCompletionResult.NONE rather than null";
            if (codeCompletionResult != CodeCompletionResult.NONE) {
                Object object;
                if (codeCompletionResult.isTruncated()) {
                    this.isTruncated = true;
                }
                if (!codeCompletionResult.isFilterable()) {
                    this.isFilterable = false;
                }
                for (Object object2 : codeCompletionResult.getItems()) {
                    object = GsfCompletionItem.createItem((CompletionProposal)object2, codeCompletionResult, compilationController);
                    if (object == null) continue;
                    this.results.add((CompletionItem)object);
                }
                Set set = codeCompletionResult.embeddedTypes();
                if (set != null) {
                    Object object2;
                    object2 = set.iterator();
                    while (object2.hasNext()) {
                        CodeCompletionHandler codeCompletionHandler2;
                        object = (String)object2.next();
                        Language language = LanguageRegistry.getInstance().getLanguageByMimeType((String)object);
                        if (language == null || (codeCompletionHandler2 = language.getCompletionProvider()) == null) continue;
                        this.addCodeCompletionItems(compilationController, codeCompletionHandler2, n, string);
                    }
                }
            }
        }

        private boolean isJavaIdentifierPart(String string) {
            for (int i = 0; i < string.length(); ++i) {
                if (Character.isJavaIdentifierPart(string.charAt(i))) continue;
                return false;
            }
            return true;
        }

        private Collection getFilteredData(Collection<CompletionItem> collection, String string) {
            if (string.length() == 0) {
                return collection;
            }
            ArrayList<CompletionItem> arrayList = new ArrayList<CompletionItem>();
            for (CompletionItem completionItem : collection) {
                if (!GsfCompletionProvider.startsWith(((Object)completionItem.getInsertPrefix()).toString(), string)) continue;
                arrayList.add(completionItem);
            }
            return arrayList;
        }

        private Env getCompletionEnvironment(CompilationController compilationController, boolean bl) throws IOException {
            int n;
            Document document = compilationController.getDocument();
            int n2 = n = document != null ? document.getLength() : (int)compilationController.getFileObject().getSize();
            if (this.caretOffset > n) {
                this.caretOffset = n;
            }
            int n3 = this.caretOffset;
            String string = null;
            CodeCompletionHandler codeCompletionHandler = GsfCompletionProvider.getCompletable(compilationController, n3);
            try {
                int n4;
                int[] nArray;
                if (codeCompletionHandler != null) {
                    string = codeCompletionHandler.getPrefix((CompilationInfo)compilationController, n3, bl);
                }
                if (string == null && (nArray = Utilities.getIdentifierBlock((BaseDocument)((BaseDocument)document), (int)n3)) != null && (n4 = nArray[0]) < n3) {
                    string = bl ? document.getText(n4, n3 - n4) : document.getText(n4, nArray[1] - n4);
                }
            }
            catch (BadLocationException badLocationException) {
                ErrorManager.getDefault().notify((Throwable)badLocationException);
            }
            compilationController.toPhase(Phase.PARSED);
            return new Env(n3, string, compilationController, codeCompletionHandler);
        }

        private class Env {
            private int offset;
            private String prefix;
            private CompilationController controller;
            private CodeCompletionHandler completable;
            private boolean autoCompleting;

            private Env(int n, String string, CompilationController compilationController, CodeCompletionHandler codeCompletionHandler) {
                this.offset = n;
                this.prefix = string;
                this.controller = compilationController;
                this.completable = codeCompletionHandler;
            }

            public int getOffset() {
                return this.offset;
            }

            public String getPrefix() {
                return this.prefix;
            }

            public boolean isAutoCompleting() {
                return this.autoCompleting;
            }

            public void setAutoCompleting(boolean bl) {
                this.autoCompleting = bl;
            }

            public CompilationController getController() {
                return this.controller;
            }

            public CodeCompletionHandler getCompletable() {
                return this.completable;
            }
        }

        private static class CodeCompletionContextImpl
        extends CodeCompletionContext {
            private final int caretOffset;
            private final org.netbeans.napi.gsfret.source.CompilationInfo info;
            private final String prefix;
            private final NameKind kind;
            private final CodeCompletionHandler.QueryType queryType;

            public CodeCompletionContextImpl(int n, org.netbeans.napi.gsfret.source.CompilationInfo compilationInfo, String string, NameKind nameKind, CodeCompletionHandler.QueryType queryType) {
                this.caretOffset = n;
                this.info = compilationInfo;
                this.prefix = string;
                this.kind = nameKind;
                this.queryType = queryType;
            }

            public int getCaretOffset() {
                return this.caretOffset;
            }

            public CompilationInfo getInfo() {
                return this.info;
            }

            public String getPrefix() {
                return this.prefix;
            }

            public NameKind getNameKind() {
                return this.kind;
            }

            public CodeCompletionHandler.QueryType getQueryType() {
                return this.queryType;
            }

            public boolean isCaseSensitive() {
                return GsfCompletionProvider.isCaseSensitive();
            }
        }
    }
}

