/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.dataview.output;

import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.print.PrinterException;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultCellEditor;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import org.netbeans.modules.db.dataview.meta.DBColumn;
import org.netbeans.modules.db.dataview.meta.DBException;
import org.netbeans.modules.db.dataview.meta.DBTable;
import org.netbeans.modules.db.dataview.output.DataView;
import org.netbeans.modules.db.dataview.output.DataViewActionHandler;
import org.netbeans.modules.db.dataview.output.DataViewTablePanel;
import org.netbeans.modules.db.dataview.output.DataViewTableSorter;
import org.netbeans.modules.db.dataview.output.SQLStatementGenerator;
import org.netbeans.modules.db.dataview.output.ShowSQLDialog;
import org.netbeans.modules.db.dataview.output.UpdatedRowContext;
import org.netbeans.modules.db.dataview.util.DBReadWriteHelper;
import org.openide.awt.StatusDisplayer;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.datatransfer.ExClipboard;
import org.openide.windows.WindowManager;

class DataViewTableUI
extends JTable {
    private String[] columnToolTips;
    private JPopupMenu tablePopupMenu;
    private final int multiplier;
    private final DataViewTablePanel tablePanel;
    private static final String data = "WE WILL EITHER FIND A WAY, OR MAKE ONE.";
    private static Logger mLogger = Logger.getLogger(DataViewTableUI.class.getName());

    public DataViewTableUI(DataViewTablePanel dataViewTablePanel, DataViewActionHandler dataViewActionHandler, DataView dataView) {
        this.tablePanel = dataViewTablePanel;
        this.addKeyListener(new Control0KeyListener());
        this.getTableHeader().setReorderingAllowed(false);
        this.setDefaultRenderer(Object.class, new ResultSetCellRenderer());
        this.setDefaultRenderer(Number.class, new ResultSetCellRenderer());
        this.setDefaultRenderer(java.util.Date.class, new ResultSetCellRenderer());
        this.setDefaultEditor(Object.class, new ResultSetTableCellEditor(new JTextField()));
        this.setDefaultEditor(Number.class, new NumberEditor(new JTextField()));
        TableSelectionListener tableSelectionListener = new TableSelectionListener(this);
        this.getSelectionModel().addListSelectionListener(tableSelectionListener);
        this.getColumnModel().getSelectionModel().addListSelectionListener(tableSelectionListener);
        this.setAutoResizeMode(0);
        this.multiplier = this.getFontMetrics(this.getFont()).stringWidth(data) / data.length() + 2;
        this.setRowHeight(this.getFontMetrics(this.getFont()).getHeight() + 1);
        this.createPopupMenu(dataViewActionHandler, dataView);
    }

    protected JTableHeader createDefaultTableHeader() {
        return new JTableHeaderImpl(this.columnModel);
    }

    protected int getMultiplier() {
        return this.multiplier;
    }

    protected void setColumnToolTips(String[] stringArray) {
        this.columnToolTips = stringArray;
    }

    private String getColumnToolTipText(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        int n = this.columnModel.getColumnIndexAtX(point.x);
        try {
            int n2 = this.columnModel.getColumn(n).getModelIndex();
            return this.columnToolTips[n2];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return null;
        }
    }

    private UpdatedRowContext getResultSetRowContext() {
        return this.tablePanel.getUpdatedRowContext();
    }

    private void createPopupMenu(final DataViewActionHandler dataViewActionHandler, final DataView dataView) {
        this.tablePopupMenu = new JPopupMenu();
        final JMenuItem jMenuItem = new JMenuItem(NbBundle.getMessage(DataViewTableUI.class, (String)"TOOLTIP_insert"));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                dataViewActionHandler.insertActionPerformed();
            }
        });
        this.tablePopupMenu.add(jMenuItem);
        final JMenuItem jMenuItem2 = new JMenuItem(NbBundle.getMessage(DataViewTableUI.class, (String)"TOOLTIP_deleterow"));
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                dataViewActionHandler.deleteRecordActionPerformed();
            }
        });
        this.tablePopupMenu.add(jMenuItem2);
        final JMenuItem jMenuItem3 = new JMenuItem(NbBundle.getMessage(DataViewTableUI.class, (String)"TOOLTIP_commit"));
        jMenuItem3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                dataViewActionHandler.commitActionPerformed(true);
            }
        });
        this.tablePopupMenu.add(jMenuItem3);
        final JMenuItem jMenuItem4 = new JMenuItem(NbBundle.getMessage(DataViewTableUI.class, (String)"TOOLTIP_cancel_edits"));
        jMenuItem4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                dataViewActionHandler.cancelEditPerformed();
            }
        });
        this.tablePopupMenu.add(jMenuItem4);
        final JMenuItem jMenuItem5 = new JMenuItem(NbBundle.getMessage(DataViewTableUI.class, (String)"TOOLTIP_truncate_table"));
        jMenuItem5.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                dataViewActionHandler.truncateActionPerformed();
            }
        });
        this.tablePopupMenu.add(jMenuItem5);
        this.tablePopupMenu.addSeparator();
        JMenuItem jMenuItem6 = new JMenuItem(NbBundle.getMessage(DataViewTableUI.class, (String)"TOOLTIP_copy_cell_value"));
        jMenuItem6.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    Object object = DataViewTableUI.this.getValueAt(DataViewTableUI.this.getSelectedRow(), DataViewTableUI.this.getSelectedColumn());
                    String string = object != null ? object.toString() : "";
                    ExClipboard exClipboard = (ExClipboard)Lookup.getDefault().lookup(ExClipboard.class);
                    StringSelection stringSelection = new StringSelection(string);
                    exClipboard.setContents((Transferable)stringSelection, (ClipboardOwner)stringSelection);
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    // empty catch block
                }
            }
        });
        this.tablePopupMenu.add(jMenuItem6);
        JMenuItem jMenuItem7 = new JMenuItem(NbBundle.getMessage(DataViewTableUI.class, (String)"TOOLTIP_copy_row_value"));
        jMenuItem7.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DataViewTableUI.this.copyRowValues(false);
            }
        });
        this.tablePopupMenu.add(jMenuItem7);
        JMenuItem jMenuItem8 = new JMenuItem(NbBundle.getMessage(DataViewTableUI.class, (String)"TOOLTIP_copy_row_header"));
        jMenuItem8.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DataViewTableUI.this.copyRowValues(true);
            }
        });
        this.tablePopupMenu.add(jMenuItem8);
        this.tablePopupMenu.addSeparator();
        final JMenuItem jMenuItem9 = new JMenuItem(NbBundle.getMessage(DataViewTableUI.class, (String)"TOOLTIP_show_create_sql"));
        jMenuItem9.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    DBTable dBTable = dataView.getDataViewDBTable().geTable(0);
                    String string = dataView.getSQLStatementGenerator().generateCreateStatement(dBTable);
                    ShowSQLDialog showSQLDialog = new ShowSQLDialog();
                    showSQLDialog.setLocationRelativeTo(WindowManager.getDefault().getMainWindow());
                    showSQLDialog.setText(string + ";\n");
                    showSQLDialog.setVisible(true);
                }
                catch (Exception exception) {
                    Exceptions.printStackTrace((Throwable)exception);
                }
            }
        });
        this.tablePopupMenu.add(jMenuItem9);
        final JMenuItem jMenuItem10 = new JMenuItem(NbBundle.getMessage(DataViewTableUI.class, (String)"TOOLTIP_show_insert_sql"));
        jMenuItem10.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    int[] nArray = DataViewTableUI.this.getSelectedRows();
                    String string = "";
                    for (int i = 0; i < nArray.length; ++i) {
                        Object[] objectArray = dataView.getDataViewPageContext().getCurrentRows().get(nArray[i]);
                        String string2 = dataView.getSQLStatementGenerator().generateInsertStatement(objectArray)[1];
                        string = string + string2.replaceAll("\n", " ").replaceAll("\t", " ") + ";\n";
                    }
                    ShowSQLDialog showSQLDialog = new ShowSQLDialog();
                    showSQLDialog.setLocationRelativeTo(WindowManager.getDefault().getMainWindow());
                    showSQLDialog.setText(string);
                    showSQLDialog.setVisible(true);
                }
                catch (DBException dBException) {
                    Exceptions.printStackTrace((Throwable)dBException);
                }
            }
        });
        this.tablePopupMenu.add(jMenuItem10);
        final JMenuItem jMenuItem11 = new JMenuItem(NbBundle.getMessage(DataViewTableUI.class, (String)"TOOLTIP_show_delete_sql"));
        jMenuItem11.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int[] nArray = DataViewTableUI.this.getSelectedRows();
                String string = "";
                for (int i = 0; i < nArray.length; ++i) {
                    ArrayList<Object> arrayList = new ArrayList<Object>();
                    ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
                    SQLStatementGenerator sQLStatementGenerator = dataView.getSQLStatementGenerator();
                    String[] stringArray = sQLStatementGenerator.generateDeleteStatement(arrayList2, arrayList, nArray[i], DataViewTableUI.this.getModel());
                    string = string + stringArray[1] + ";\n";
                }
                ShowSQLDialog showSQLDialog = new ShowSQLDialog();
                showSQLDialog.setLocationRelativeTo(WindowManager.getDefault().getMainWindow());
                showSQLDialog.setText(string);
                showSQLDialog.setVisible(true);
            }
        });
        this.tablePopupMenu.add(jMenuItem11);
        final JMenuItem jMenuItem12 = new JMenuItem(NbBundle.getMessage(DataViewTableUI.class, (String)"TOOLTIP_show_update_sql"));
        jMenuItem12.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = "";
                UpdatedRowContext updatedRowContext = dataView.getUpdatedRowContext();
                if (updatedRowContext.getUpdateKeys().isEmpty()) {
                    return;
                }
                for (String string2 : updatedRowContext.getUpdateKeys()) {
                    string = string + updatedRowContext.getRawUpdateStmt(string2) + ";\n";
                }
                ShowSQLDialog showSQLDialog = new ShowSQLDialog();
                showSQLDialog.setLocationRelativeTo(WindowManager.getDefault().getMainWindow());
                showSQLDialog.setText(string);
                showSQLDialog.setVisible(true);
            }
        });
        this.tablePopupMenu.add(jMenuItem12);
        this.tablePopupMenu.addSeparator();
        JMenuItem jMenuItem13 = new JMenuItem(NbBundle.getMessage(DataViewTableUI.class, (String)"TOOLTIP_print_data"));
        jMenuItem13.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    if (!DataViewTableUI.this.print()) {
                        mLogger.log(Level.INFO, NbBundle.getMessage(DataViewTableUI.class, (String)"MSG_cancel_printing"));
                    }
                }
                catch (PrinterException printerException) {
                    mLogger.log(Level.INFO, NbBundle.getMessage(DataViewTableUI.class, (String)("MSG_failure_to_print" + printerException.getMessage())));
                }
            }
        });
        this.tablePopupMenu.add(jMenuItem13);
        JMenuItem jMenuItem14 = new JMenuItem(NbBundle.getMessage(DataViewTableUI.class, (String)"TOOLTIP_refresh"));
        jMenuItem14.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                dataViewActionHandler.refreshActionPerformed();
            }
        });
        this.tablePopupMenu.add(jMenuItem14);
        this.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() == 3) {
                    int n = DataViewTableUI.this.rowAtPoint(mouseEvent.getPoint());
                    int n2 = DataViewTableUI.this.columnAtPoint(mouseEvent.getPoint());
                    boolean bl = false;
                    int[] nArray = DataViewTableUI.this.getSelectedRows();
                    for (int i = 0; i < nArray.length; ++i) {
                        if (nArray[i] != n) continue;
                        bl = true;
                        break;
                    }
                    if (!DataViewTableUI.this.getRowSelectionAllowed()) {
                        bl = false;
                        int[] nArray2 = DataViewTableUI.this.getSelectedColumns();
                        for (int i = 0; i < nArray2.length; ++i) {
                            if (nArray2[i] != n2) continue;
                            bl = true;
                            break;
                        }
                    }
                    if (!bl) {
                        DataViewTableUI.this.changeSelection(n, n2, false, false);
                    }
                    if (!DataViewTableUI.this.tablePanel.isEditable()) {
                        jMenuItem.setEnabled(false);
                        jMenuItem2.setEnabled(false);
                        jMenuItem5.setEnabled(false);
                        jMenuItem10.setEnabled(false);
                        jMenuItem9.setEnabled(false);
                        jMenuItem11.setEnabled(false);
                    }
                    if (!DataViewTableUI.this.tablePanel.isCommitEnabled()) {
                        jMenuItem3.setEnabled(false);
                        jMenuItem4.setEnabled(false);
                        jMenuItem12.setEnabled(false);
                    } else {
                        jMenuItem3.setEnabled(true);
                        jMenuItem4.setEnabled(true);
                        jMenuItem12.setEnabled(true);
                    }
                    DataViewTableUI.this.tablePopupMenu.show(DataViewTableUI.this, mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
    }

    private void copyRowValues(boolean bl) {
        try {
            int[] nArray;
            int[] nArray2 = this.getSelectedRows();
            if (this.getRowSelectionAllowed()) {
                nArray = new int[this.getColumnCount()];
                for (int i = 0; i < nArray.length; ++i) {
                    nArray[i] = i;
                }
            } else {
                nArray = this.getSelectedColumns();
            }
            if (nArray2 != null && nArray != null) {
                int n;
                StringBuffer stringBuffer = new StringBuffer();
                if (bl) {
                    for (n = 0; n < nArray.length; ++n) {
                        Object object;
                        if (n > 0) {
                            stringBuffer.append('\t');
                        }
                        stringBuffer.append((object = this.getColumnModel().getColumn(n).getHeaderValue()) != null ? object.toString() : "");
                    }
                    stringBuffer.append('\n');
                }
                for (n = 0; n < nArray2.length; ++n) {
                    for (int i = 0; i < nArray.length; ++i) {
                        Object object;
                        if (i > 0) {
                            stringBuffer.append('\t');
                        }
                        stringBuffer.append((object = this.getValueAt(nArray2[n], nArray[i])) != null ? object.toString() : "");
                    }
                    stringBuffer.append('\n');
                }
                ExClipboard exClipboard = (ExClipboard)Lookup.getDefault().lookup(ExClipboard.class);
                StringSelection stringSelection = new StringSelection(stringBuffer.toString());
                exClipboard.setContents((Transferable)stringSelection, (ClipboardOwner)stringSelection);
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            Exceptions.printStackTrace((Throwable)arrayIndexOutOfBoundsException);
        }
    }

    public TableCellRenderer getCellRenderer(int n, int n2) {
        DataViewTableSorter dataViewTableSorter = (DataViewTableSorter)this.getModel();
        n = dataViewTableSorter.modelIndex(n);
        DBColumn dBColumn = this.tablePanel.getDataViewDBTable().getColumn(n2);
        if (dBColumn.isGenerated()) {
            return new GeneratedResultSetCellRenderer();
        }
        if (this.getResultSetRowContext().getValueList(n + 1 + ";" + (n2 + 1)) != null) {
            return new UpdatedResultSetCellRenderer();
        }
        return super.getCellRenderer(n, n2);
    }

    public class TableSelectionListener
    implements ListSelectionListener {
        JTable table;

        TableSelectionListener(JTable jTable) {
            this.table = jTable;
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (listSelectionEvent.getSource() == this.table.getSelectionModel() && this.table.getRowSelectionAllowed()) {
                int n = listSelectionEvent.getFirstIndex();
                if (n >= 0) {
                    DataViewTableUI.this.tablePanel.enableDeleteBtn(true);
                } else {
                    DataViewTableUI.this.tablePanel.enableDeleteBtn(false);
                }
            }
        }
    }

    private class Control0KeyListener
    implements KeyListener {
        public void keyTyped(KeyEvent keyEvent) {
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.isControlDown() && keyEvent.getKeyChar() == '0') {
                int n = DataViewTableUI.this.getSelectedRow();
                int n2 = DataViewTableUI.this.getSelectedColumn();
                if (n == -1) {
                    return;
                }
                DataViewTableUI.this.editCellAt(n, n2);
                TableCellEditor tableCellEditor = DataViewTableUI.this.getCellEditor();
                if (tableCellEditor != null) {
                    DBColumn dBColumn = DataViewTableUI.this.tablePanel.getDataViewDBTable().getColumn(n2);
                    if (dBColumn.isGenerated() || !dBColumn.isNullable()) {
                        Toolkit.getDefaultToolkit().beep();
                        tableCellEditor.stopCellEditing();
                    } else {
                        tableCellEditor.getTableCellEditorComponent(DataViewTableUI.this, null, DataViewTableUI.this.rowSelectionAllowed, n, n2);
                        DataViewTableUI.this.setValueAt(null, n, n2);
                        tableCellEditor.stopCellEditing();
                    }
                    DataViewTableUI.this.setRowSelectionInterval(n, n);
                }
            }
        }

        public void keyReleased(KeyEvent keyEvent) {
        }
    }

    private class NumberEditor
    extends ResultSetTableCellEditor {
        public NumberEditor(JTextField jTextField) {
            super(jTextField);
            ((JTextField)this.getComponent()).setHorizontalAlignment(4);
        }
    }

    private class ResultSetTableCellEditor
    extends DefaultCellEditor {
        Object val;

        public ResultSetTableCellEditor(final JTextField jTextField) {
            super(jTextField);
            this.delegate = new DefaultCellEditor.EditorDelegate(){

                public void setValue(Object object) {
                    ResultSetTableCellEditor.this.val = object;
                    jTextField.setText(object != null ? object.toString() : "");
                }

                public Object getCellEditorValue() {
                    String string = jTextField.getText();
                    if (ResultSetTableCellEditor.this.val == null && string.equals("")) {
                        return null;
                    }
                    try {
                        int n = DataViewTableUI.this.getEditingColumn();
                        DBColumn dBColumn = DataViewTableUI.this.tablePanel.getDataViewDBTable().getColumn(n);
                        return DBReadWriteHelper.validate(string, dBColumn);
                    }
                    catch (Exception exception) {
                        StatusDisplayer.getDefault().setStatusText(exception.getMessage());
                        return string;
                    }
                }
            };
            jTextField.addActionListener(this.delegate);
            jTextField.addKeyListener(new Control0KeyListener());
        }
    }

    private class JTableHeaderImpl
    extends JTableHeader {
        public JTableHeaderImpl(TableColumnModel tableColumnModel) {
            super(tableColumnModel);
        }

        public String getToolTipText(MouseEvent mouseEvent) {
            return DataViewTableUI.this.getColumnToolTipText(mouseEvent);
        }
    }

    private static class UpdatedResultSetCellRenderer
    extends ResultSetCellRenderer {
        static Color green = new Color(0, 128, 0);

        private UpdatedResultSetCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (bl) {
                component.setForeground(Color.ORANGE);
            } else {
                component.setForeground(green);
            }
            return component;
        }
    }

    private static class ResultSetCellRenderer
    extends DefaultTableCellRenderer.UIResource {
        final TableCellRenderer NULL_RENDERER = new NullObjectCellRenderer();
        final TableCellRenderer NUMNBER_RENDERER = new NumberObjectCellRenderer();
        final TableCellRenderer TIME_RENDERER = new TimeRenderer();
        final TableCellRenderer DATE_RENDERER = new DateRenderer();
        final TableCellRenderer DATETIME_RENDERER = new DateTimeRenderer();

        private ResultSetCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (null == object) {
                return this.NULL_RENDERER.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            }
            if (object instanceof Number) {
                return this.NUMNBER_RENDERER.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            }
            if (object instanceof Timestamp) {
                return this.DATETIME_RENDERER.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            }
            if (object instanceof Date) {
                return this.DATE_RENDERER.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            }
            if (object instanceof Time) {
                return this.TIME_RENDERER.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            }
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (component instanceof JComponent) {
                ((JComponent)component).setToolTipText(object.toString());
            }
            return component;
        }
    }

    private static class GeneratedResultSetCellRenderer
    extends ResultSetCellRenderer {
        static Color gray = new Color(245, 245, 245);

        private GeneratedResultSetCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (!bl) {
                component.setBackground(gray);
            } else {
                component.setBackground(jTable.getSelectionBackground());
            }
            return component;
        }
    }

    private static class DateRenderer
    extends DefaultTableCellRenderer.UIResource {
        DateFormat formatter;

        public void setValue(Object object) {
            if (this.formatter == null) {
                this.formatter = DateFormat.getDateInstance();
            }
            this.setText(object == null ? "" : this.formatter.format(object));
            this.setToolTipText(this.getText());
        }
    }

    private static class TimeRenderer
    extends DefaultTableCellRenderer.UIResource {
        DateFormat formatter;

        public void setValue(Object object) {
            if (this.formatter == null) {
                this.formatter = DateFormat.getTimeInstance();
            }
            this.setText(object == null ? "" : this.formatter.format(object));
            this.setToolTipText(this.getText());
        }
    }

    private static class DateTimeRenderer
    extends DefaultTableCellRenderer.UIResource {
        DateFormat formatter;

        public void setValue(Object object) {
            if (this.formatter == null) {
                this.formatter = DateFormat.getDateTimeInstance();
            }
            this.setText(object == null ? "" : this.formatter.format(object));
            this.setToolTipText(this.getText());
        }
    }

    private static class NumberObjectCellRenderer
    extends DefaultTableCellRenderer.UIResource {
        private NumberObjectCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            ((JLabel)component).setHorizontalAlignment(4);
            this.setToolTipText(object.toString());
            return component;
        }
    }

    private static class NullObjectCellRenderer
    extends DefaultTableCellRenderer {
        static final String NULL_LABEL = "<NULL>";

        private NullObjectCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            this.setValue(NULL_LABEL);
            this.setToolTipText(NULL_LABEL);
            component.setForeground(Color.GRAY);
            return component;
        }
    }
}

