/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.cldcplatform;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.netbeans.modules.mobility.cldcplatform.J2MEPlatform;
import org.netbeans.modules.mobility.cldcplatform.PlatformConvertor;
import org.openide.ErrorManager;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.io.NullOutputStream;
import org.openide.util.io.ReaderInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UEIEmulatorConfiguratorImpl {
    private static final String CMD_VERSION = "-version";
    private static final String CMD_QUERY = "-Xquery";
    private static final String[][] APIs = new String[][]{{"CLDC", "1.1", "java/lang/Object.class", "java/lang/Double.class", "java/io/InputStream.class", "java/util/Date.class", "javax/microedition/io/Connection.class"}, {"CLDC", "1.0", "java/lang/Object.class", "java/io/InputStream.class", "java/util/Date.class", "javax/microedition/io/Connection.class"}, {"MIDP", "2.0", "java/lang/IllegalStateException.class", "java/util/Timer.class", "javax/microedition/io/PushRegistry.class", "javax/microedition/lcdui/CustomItem.class", "javax/microedition/lcdui/game/GameCanvas.class", "javax/microedition/rms/RecordStore.class", "javax/microedition/midlet/MIDlet.class", "javax/microedition/pki/Certificate.class"}, {"MIDP", "1.0", "java/lang/IllegalStateException.class", "java/util/Timer.class", "javax/microedition/io/HttpConnection.class", "javax/microedition/lcdui/Display.class", "javax/microedition/rms/RecordStore.class", "javax/microedition/midlet/MIDlet.class"}, {"JSR172", "1.0", "javax/microedition/xml/rpc/Element.class"}, {"JSR82", "1.0", "javax/bluetooth/DiscoveryAgent.class"}, {"OBEX", "1.0", "javax/obex/ClientSession.class"}, {"JSR75", "1.0", "javax/microedition/io/file/FileConnection.class", "javax/microedition/pim/PIM.class"}, {"JSR177", "1.0", "javax/microedition/apdu/APDUConnection.class", "javax/microedition/jcrmi/JavaCardRMIConnection.class"}, {"JSR179", "1.0", "javax/microedition/location/Location.class"}, {"JSR184", "1.0", "javax/microedition/m3g/Object3D.class"}, {"JSR211", "1.0", "javax/microedition/content/ContentHandler.class"}, {"JSR238", "1.0", "javax/microedition/global/ResourceManager.class"}, {"MMAPI", "1.0", "javax/microedition/media/TimeBase.class", "javax/microedition/media/control/VolumeControl.class", "javax/microedition/media/protocol/ContentDescriptor.class"}, {"WMA", "2.0", "javax/wireless/messaging/MultipartMessage.class"}, {"WMA", "1.1", "javax/wireless/messaging/Message.class"}, {"NOKIAUI", "1.0", "com/nokia/mid/ui/FullCanvas.class"}, {"IMP", "1.0", "java/lang/IllegalStateException.class", "java/util/Timer.class", "javax/microedition/io/HttpConnection.class", "javax/microedition/rms/RecordStore.class", "javax/microedition/midlet/MIDlet.class"}, {"IMP-NG", "1.0", "java/lang/IllegalStateException.class", "java/util/Timer.class", "javax/microedition/rms/RecordStore.class", "javax/microedition/midlet/MIDlet.class", "javax/microedition/pki/Certificate.class"}, {"AJOF", "1.0", "com/siemens/icm/ajof/WmMIDlet.class"}};
    private String platformPath;
    private String process;
    private String platformName;
    private Properties properties;
    private String platformType;
    private Process emulatorProcess;
    private StringBuffer emulatorOutput;
    private StringBuffer emulatorError;

    private static File getFile(File file, String string) {
        File file2 = new File(string = string.trim());
        if (!file2.exists()) {
            file2 = new File(file, string);
        }
        return FileUtil.normalizeFile((File)file2);
    }

    private static String cutPath(File file, Object object) {
        String string;
        String string2 = file.getPath();
        String string3 = string = object instanceof JarFile ? ((JarFile)object).getName() : ((File)object).getPath();
        if (string.length() > string2.length() && string.startsWith(string2)) {
            string = "${platform.home}/" + string.substring(string2.length() + 1);
        }
        return string.replace('\\', '/');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static List<J2MEPlatform.J2MEProfile> analyzePath(File file, String string, String string2) {
        ArrayList<J2MEPlatform.J2MEProfile> arrayList = new ArrayList<J2MEPlatform.J2MEProfile>();
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
        HashSet<String> hashSet = new HashSet<String>();
        while (stringTokenizer.hasMoreTokens()) {
            hashSet.add(UEIEmulatorConfiguratorImpl.cutPath(file, UEIEmulatorConfiguratorImpl.getFile(file, stringTokenizer.nextToken())));
        }
        stringTokenizer = new StringTokenizer(string, ",");
        HashSet<Object> hashSet2 = new HashSet<Object>();
        try {
            Object object3;
            Object object2;
            Object object5;
            Serializable serializable;
            HashSet<Serializable> hashSet3 = new HashSet<Serializable>();
            while (stringTokenizer.hasMoreTokens()) {
                try {
                    serializable = UEIEmulatorConfiguratorImpl.getFile(file, stringTokenizer.nextToken());
                    if (!hashSet3.add(serializable)) continue;
                    if (((File)serializable).isDirectory()) {
                        hashSet2.add(serializable);
                        continue;
                    }
                    if (!((File)serializable).isFile() || !((String)(object5 = ((File)serializable).getName().toLowerCase())).endsWith(".zip") && !((String)object5).endsWith(".jar")) continue;
                    hashSet2.add(new JarFile((File)serializable));
                }
                catch (IOException iOException) {}
            }
            serializable = new HashMap();
            object5 = new HashMap();
            HashMap<String, String> hashMap = new HashMap<String, String>();
            HashMap<Object, String> hashMap2 = new HashMap<Object, String>();
            boolean bl = false;
            for (Object object42 : hashSet2) {
                HashSet hashSet4;
                Manifest manifest = UEIEmulatorConfiguratorImpl.getManifest(object42);
                if (manifest == null) continue;
                object2 = manifest.getMainAttributes().getValue("API");
                String string3 = manifest.getMainAttributes().getValue("API-Specification-Version");
                if (object2 == null) continue;
                boolean bl2 = bl = bl || "MIDP".equals(object2);
                if (string3 == null) {
                    string3 = "1.0";
                }
                object3 = (String)object2 + '-' + string3;
                String string4 = manifest.getMainAttributes().getValue("API-Dependencies");
                if (string4 != null) {
                    hashMap.put((String)object3, string4);
                }
                if ((string4 = manifest.getMainAttributes().getValue("API-Name")) != null) {
                    hashMap2.put(object2, string4);
                }
                if ((hashSet4 = (HashSet)((HashMap)object5).get(object3)) != null) {
                    hashSet4 = new HashSet(hashSet4);
                    hashSet4.add(object42);
                    ((HashMap)object5).put(object3, hashSet4);
                } else {
                    ((HashMap)object5).put(object3, Collections.singleton(object42));
                }
                HashSet hashSet5 = (HashSet)((HashMap)serializable).get(object2);
                if (hashSet5 == null) {
                    hashSet5 = new HashSet();
                    ((HashMap)serializable).put(object2, hashSet5);
                }
                hashSet5.add(object42);
            }
            for (int i = 0; i < APIs.length; ++i) {
                void var14_25;
                void var14_23;
                void var15_33;
                if (((HashMap)object5).containsKey(APIs[i][0] + '-' + APIs[i][1])) continue;
                Object var14_19 = null;
                Set set = (Set)((HashMap)serializable).get(APIs[i][0]);
                if (set == null) {
                    HashSet hashSet6 = new HashSet();
                    ((HashMap)serializable).put(APIs[i][0], hashSet6);
                }
                object2 = new boolean[APIs[i].length - 2];
                for (Object object3 : hashSet2) {
                    void var14_20;
                    if (var15_33.contains(object3)) continue;
                    boolean bl3 = true;
                    boolean bl4 = false;
                    for (int j = 2; j < APIs[i].length; ++j) {
                        if (UEIEmulatorConfiguratorImpl.contains(object3, APIs[i][j])) {
                            object2[j - 2] = true;
                            bl4 = true;
                            continue;
                        }
                        bl3 = false;
                    }
                    if (bl3) {
                        Set<Object> set2 = Collections.singleton(object3);
                        break;
                    }
                    if (!bl4) continue;
                    if (var14_20 == null) {
                        HashSet hashSet7 = new HashSet();
                    }
                    var14_20.add(object3);
                }
                if (var14_23 instanceof HashSet) {
                    for (int j = 0; j < ((Object)object2).length; ++j) {
                        if (object2[j] != false) continue;
                        Object var14_24 = null;
                        break;
                    }
                }
                if (var14_25 == null) continue;
                bl = bl || "MIDP".equals(APIs[i][0]);
                var15_33.addAll(var14_25);
                ((HashMap)object5).put(APIs[i][0] + '-' + APIs[i][1], var14_25);
            }
            HashSet hashSet6 = new HashSet(hashSet2);
            for (Map.Entry entry : ((HashMap)object5).entrySet()) {
                object2 = (String)entry.getKey();
                int n = ((String)object2).lastIndexOf(45);
                object3 = ((String)object2).substring(n + 1);
                object2 = ((String)object2).substring(0, n);
                if (bl && ("IMP".equals(object2) || "IMP-NG".equals(object2))) continue;
                String string5 = (String)hashMap2.get(object2);
                try {
                    string5 = NbBundle.getMessage(UEIEmulatorConfiguratorImpl.class, (String)object2);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                String string6 = "CLDC".equals(object2) ? "configuration" : ("MIDP".equals(object2) || "IMP".equals(object2) || "IMP-NG".equals(object2) ? "profile" : "optional");
                StringBuffer stringBuffer = new StringBuffer();
                boolean bl5 = true;
                for (Object e : (Set)entry.getValue()) {
                    String string7 = UEIEmulatorConfiguratorImpl.cutPath(file, e);
                    if (stringBuffer.length() > 0) {
                        stringBuffer.append(':');
                    }
                    stringBuffer.append(string7);
                    if (hashSet.contains(string7)) continue;
                    bl5 = false;
                }
                arrayList.add(new J2MEPlatform.J2MEProfile((String)object2, (String)object3, string5, string6, (String)hashMap.get(entry.getKey()), stringBuffer.toString(), bl5));
                hashSet6.removeAll((Collection)entry.getValue());
            }
            for (Object e : hashSet6) {
                object2 = UEIEmulatorConfiguratorImpl.cutPath(file, e);
                String string8 = ((String)object2).startsWith("${platform.home}/") ? ((String)object2).substring("${platform.home}/".length()) : object2;
                object3 = new J2MEPlatform.J2MEProfile(string8, "1.0", string8, "optional", null, (String)object2, hashSet.contains(object2));
                arrayList.add((J2MEPlatform.J2MEProfile)object3);
            }
            ArrayList<J2MEPlatform.J2MEProfile> arrayList2 = arrayList;
            return arrayList2;
        }
        finally {
            for (Object object2 : hashSet2) {
                if (!(object2 instanceof JarFile)) continue;
                try {
                    ((JarFile)object2).close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static boolean contains(Object object, String string) {
        if (object instanceof JarFile) {
            return ((JarFile)object).getEntry(string) != null;
        }
        return new File((File)object, string).isFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Manifest getManifest(Object object) {
        try {
            if (object instanceof JarFile) {
                return ((JarFile)object).getManifest();
            }
            File file = new File((File)object, "META-INF/manifest.mf");
            if (!file.isFile()) return null;
            if (!file.canRead()) return null;
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(file);
                Manifest manifest = new Manifest(fileInputStream);
                return manifest;
            }
            catch (IOException iOException) {
                return null;
            }
            finally {
                if (fileInputStream != null) {
                    try {
                        fileInputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        catch (IOException iOException4) {
            // empty catch block
        }
        return null;
    }

    public UEIEmulatorConfiguratorImpl(String string) {
        this.platformPath = FileUtil.normalizeFile((File)new File(string)).getPath();
        this.process = string + File.separatorChar + "bin" + File.separatorChar + "emulator";
        if (Utilities.isWindows()) {
            this.process = this.process + ".exe";
        }
    }

    public String getPlatformPath() {
        return this.platformPath;
    }

    public J2MEPlatform getPlatform() {
        return this.getPlatform(new OutputStreamWriter((OutputStream)new NullOutputStream()));
    }

    public J2MEPlatform getPlatform(Writer writer) {
        PrintWriter printWriter;
        PrintWriter printWriter2 = printWriter = writer != null ? new PrintWriter(writer) : null;
        if (printWriter != null) {
            printWriter.println(NbBundle.getMessage(UEIEmulatorConfiguratorImpl.class, (String)"LAB_GettingConfiguration"));
        }
        if (!this.processVersion(printWriter)) {
            if (printWriter != null) {
                printWriter.println(NbBundle.getMessage(UEIEmulatorConfiguratorImpl.class, (String)"LAB_Failed"));
            }
            if (printWriter != null) {
                printWriter.flush();
            }
            return null;
        }
        if (printWriter != null) {
            printWriter.println(NbBundle.getMessage(UEIEmulatorConfiguratorImpl.class, (String)"LAB_GettingProperties"));
        }
        if (!this.processProperties(printWriter)) {
            if (printWriter != null) {
                printWriter.println(NbBundle.getMessage(UEIEmulatorConfiguratorImpl.class, (String)"LAB_Failed"));
            }
            if (printWriter != null) {
                printWriter.flush();
            }
            return null;
        }
        if (printWriter != null) {
            printWriter.println(NbBundle.getMessage(UEIEmulatorConfiguratorImpl.class, (String)"LAB_GettingAllProfiles"));
        }
        this.platformType = "UEI-1.0";
        ArrayList<J2MEPlatform.Device> arrayList = this.resolveDevices(printWriter);
        if (printWriter != null) {
            printWriter.println(NbBundle.getMessage(UEIEmulatorConfiguratorImpl.class, (String)"LAB_Success"));
        }
        if (printWriter != null) {
            printWriter.flush();
        }
        String string = null;
        String string2 = this.findDocsPath();
        J2MEPlatform.Device[] deviceArray = arrayList.toArray(new J2MEPlatform.Device[arrayList.size()]);
        if (deviceArray.length <= 0) {
            if (printWriter != null) {
                printWriter.println(NbBundle.getMessage(UEIEmulatorConfiguratorImpl.class, (String)"LAB_Failed"));
            }
            if (printWriter != null) {
                printWriter.flush();
            }
            return null;
        }
        return new J2MEPlatform(J2MEPlatform.computeUniqueName(this.platformName), this.platformPath, this.platformType, this.platformName, string, string2, null, null, null, deviceArray);
    }

    private ArrayList<J2MEPlatform.Device> resolveDevices(PrintWriter printWriter) {
        ArrayList<J2MEPlatform.Device> arrayList = new ArrayList<J2MEPlatform.Device>();
        StringTokenizer stringTokenizer = new StringTokenizer(this.properties.getProperty("device.list", ""), ",");
        File file = new File(this.platformPath);
        File file2 = new File(this.platformPath, "lib");
        File[] fileArray = null;
        if (file2.exists() && file2.isDirectory()) {
            fileArray = file2.listFiles();
        }
        File file3 = new File(this.platformPath, "lib/ext");
        File[] fileArray2 = null;
        if (file3.exists() && file3.isDirectory()) {
            fileArray2 = file3.listFiles();
        }
        while (stringTokenizer.hasMoreTokens()) {
            String string;
            Object object;
            CharSequence charSequence;
            String string2 = stringTokenizer.nextToken().trim();
            String string3 = this.properties.getProperty(string2 + ".description");
            String string4 = this.properties.getProperty(string2 + ".security.domains");
            String[] stringArray = PlatformConvertor.string2array(string4);
            String string5 = this.properties.getProperty(string2 + ".bootclasspath");
            if (string5 == null) {
                charSequence = null;
                if (fileArray != null) {
                    for (int i = 0; i < fileArray.length; ++i) {
                        File file4 = fileArray[i];
                        if (!file4.exists() || !file4.isFile() || (object = file4.getName().toLowerCase()) == null || !((String)object).endsWith(".jar") && !((String)object).endsWith(".zip")) continue;
                        if (charSequence == null) {
                            charSequence = new StringBuffer(file4.getAbsolutePath().length() * fileArray.length);
                        } else {
                            ((StringBuffer)charSequence).append(',');
                        }
                        ((StringBuffer)charSequence).append(file4.getAbsolutePath());
                    }
                }
                if (charSequence != null) {
                    string5 = ((StringBuffer)charSequence).toString();
                }
            }
            if ((charSequence = this.properties.getProperty(string2 + ".apis")) != null) {
                this.platformType = "UEI-1.0.1";
            } else {
                charSequence = string5;
                if (fileArray2 != null) {
                    StringBuffer stringBuffer = null;
                    for (int i = 0; i < fileArray2.length; ++i) {
                        object = fileArray2[i];
                        if (!((File)object).exists() || !((File)object).isFile() || (string = ((File)object).getName().toLowerCase()) == null || !string.endsWith(".jar") && !string.endsWith(".zip")) continue;
                        if (stringBuffer == null) {
                            stringBuffer = new StringBuffer(((File)object).getAbsolutePath().length() * fileArray2.length);
                        } else {
                            stringBuffer.append(',');
                        }
                        stringBuffer.append(((File)object).getAbsolutePath());
                    }
                    if (stringBuffer != null) {
                        charSequence = charSequence == null || "".equals(charSequence) ? stringBuffer.toString() : string5 + "," + stringBuffer.toString();
                    }
                }
                if (charSequence == null) {
                    if (printWriter == null) continue;
                    printWriter.println(NbBundle.getMessage(UEIEmulatorConfiguratorImpl.class, (String)"WARN_IgnoringDevice", (Object)string2));
                    continue;
                }
            }
            List<J2MEPlatform.J2MEProfile> list = UEIEmulatorConfiguratorImpl.analyzePath(file, (String)charSequence, string5);
            String string6 = this.properties.getProperty(string2 + ".screen.width");
            object = this.properties.getProperty(string2 + ".screen.height");
            string = this.properties.getProperty(string2 + ".screen.bitDepth");
            String string7 = this.properties.getProperty(string2 + ".screen.isColor");
            String string8 = this.properties.getProperty(string2 + ".screen.isTouch");
            J2MEPlatform.Screen screen = new J2MEPlatform.Screen(string6, (String)object, string, string7, string8);
            J2MEPlatform.J2MEProfile[] j2MEProfileArray = list.toArray(new J2MEPlatform.J2MEProfile[list.size()]);
            arrayList.add(new J2MEPlatform.Device(string2, string3, stringArray, j2MEProfileArray, screen));
        }
        return arrayList;
    }

    private void findDocAPIDirs(ArrayList<File> arrayList, File file, int n) {
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                File file2 = fileArray[i];
                if (!file2.isDirectory()) continue;
                if (file2.getName().toLowerCase().indexOf("doc") >= 0) {
                    this.findDocRoots(arrayList, file2, 3);
                    continue;
                }
                if (n <= 0) continue;
                this.findDocAPIDirs(arrayList, file2, n - 1);
            }
        }
    }

    private void findDocRoots(ArrayList<File> arrayList, File file, int n) {
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                File file2 = fileArray[i];
                if (file2.isFile() && "index.html".equals(file2.getName().toLowerCase())) {
                    arrayList.add(file);
                    continue;
                }
                if (n <= 0 || !file2.isDirectory()) continue;
                this.findDocRoots(arrayList, file2, n - 1);
            }
        }
    }

    private String findDocsPath() {
        ArrayList<File> arrayList = new ArrayList<File>();
        this.findDocAPIDirs(arrayList, new File(this.platformPath), 3);
        StringBuffer stringBuffer = null;
        for (int i = 0; i < arrayList.size(); ++i) {
            if (stringBuffer == null) {
                stringBuffer = new StringBuffer(arrayList.get(i).getAbsolutePath().length() * arrayList.size());
            } else {
                stringBuffer.append(", ");
            }
            stringBuffer.append(FileUtil.normalizeFile((File)arrayList.get(i)).getPath());
        }
        return stringBuffer == null ? null : stringBuffer.toString();
    }

    private void execute(String string, PrintWriter printWriter) throws IOException {
        File file = new File(this.process);
        File file2 = file.exists() ? file.getParentFile() : null;
        String[] stringArray = new String[]{this.process, string};
        this.emulatorProcess = file2 != null ? Runtime.getRuntime().exec(stringArray, null, file2) : Runtime.getRuntime().exec(stringArray);
        InputStream inputStream = this.emulatorProcess.getInputStream();
        InputStream inputStream2 = this.emulatorProcess.getErrorStream();
        this.emulatorOutput = new StringBuffer(1024);
        this.emulatorError = new StringBuffer(1024);
        StreamCatcher streamCatcher = new StreamCatcher(inputStream, this.emulatorOutput, printWriter);
        StreamCatcher streamCatcher2 = new StreamCatcher(inputStream2, this.emulatorError, printWriter);
        streamCatcher.start();
        streamCatcher2.start();
        try {
            this.emulatorProcess.waitFor();
            streamCatcher.join(10000L);
            streamCatcher2.join(10000L);
        }
        catch (InterruptedException interruptedException) {
            throw (IOException)ErrorManager.getDefault().annotate((Throwable)new IOException(), (Throwable)interruptedException);
        }
        finally {
            this.emulatorProcess.destroy();
        }
        if (this.emulatorProcess.exitValue() != 0) {
            throw new IOException("exec, exitCode != 0");
        }
    }

    private boolean resolveVersion(StringBuffer stringBuffer) throws IOException {
        this.platformName = null;
        BufferedReader bufferedReader = new BufferedReader(new StringReader(stringBuffer.toString()));
        this.platformName = bufferedReader.readLine();
        bufferedReader.close();
        return this.platformName != null;
    }

    private boolean processVersion(PrintWriter printWriter) {
        try {
            this.execute(CMD_VERSION, printWriter);
            if (!this.resolveVersion(this.emulatorOutput) && !this.resolveVersion(this.emulatorError)) {
                return false;
            }
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify(1, (Throwable)iOException);
            return false;
        }
        return true;
    }

    private boolean processProperties(PrintWriter printWriter) {
        this.properties = new Properties();
        try {
            this.execute(CMD_QUERY, printWriter);
            String string = this.emulatorOutput.toString();
            if ("".equals(string)) {
                string = this.emulatorError.toString();
            }
            this.properties.load((InputStream)new ReaderInputStream((Reader)new StringReader(string)));
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify(1, (Throwable)iOException);
            return false;
        }
        return true;
    }

    public static void main(String[] stringArray) throws Exception {
        UEIEmulatorConfiguratorImpl uEIEmulatorConfiguratorImpl = new UEIEmulatorConfiguratorImpl("/opt/nokia/Devices/Series_60_MIDP_Concept_SDK_Beta_0_3_1_Nokia_edition");
        uEIEmulatorConfiguratorImpl.getPlatform(new OutputStreamWriter(System.out));
    }

    private static class StreamCatcher
    extends Thread {
        InputStream is;
        StringBuffer sb;
        private final PrintWriter pw;

        StreamCatcher(InputStream inputStream, StringBuffer stringBuffer, PrintWriter printWriter) {
            this.is = inputStream;
            this.sb = stringBuffer;
            this.pw = printWriter;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block6: {
                try {
                    InputStreamReader inputStreamReader = new InputStreamReader(this.is);
                    try {
                        int n;
                        char[] cArray = new char[256];
                        while ((n = inputStreamReader.read(cArray)) >= 0) {
                            this.sb.append(cArray, 0, n);
                        }
                    }
                    finally {
                        inputStreamReader.close();
                    }
                }
                catch (IOException iOException) {
                    if (this.pw == null) break block6;
                    iOException.printStackTrace(this.pw);
                }
            }
        }

        public StringBuffer getBuffer() {
            return this.sb;
        }
    }
}

