/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.analyzer.ui;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.java.hints.analyzer.ui.FixDescription;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.project.ui.LogicalViewProvider;
import org.openide.actions.OpenAction;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.nodes.NodeOp;
import org.openide.text.Line;
import org.openide.text.PositionRef;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Nodes {
    public static Node constructSemiLogicalView(Map<FileObject, List<ErrorDescription>> map, List<FixDescription> list) {
        HashMap<Object, Project> hashMap = new HashMap<Object, Project>();
        for (FileObject object2 : map.keySet()) {
            Object object;
            Project project = FileOwnerQuery.getOwner((FileObject)object2);
            if (project == null) {
                Logger.getLogger(Nodes.class.getName()).log(Level.WARNING, "Cannot find project for: {0}", FileUtil.getFileDisplayName((FileObject)object2));
            }
            if ((object = (Project)hashMap.get(project)) == null) {
                object = new HashMap();
                hashMap.put(project, (Project)object);
            }
            object.put(object2, map.get(object2));
        }
        hashMap.remove(null);
        LinkedList linkedList = new LinkedList();
        HashMap<ErrorDescription, List<FixDescription>> hashMap2 = new HashMap<ErrorDescription, List<FixDescription>>();
        for (Object object : hashMap.keySet()) {
            linkedList.add(Nodes.constructSemiLogicalView(object, (Map)hashMap.get(object), hashMap2));
        }
        for (Object object : hashMap2.values()) {
            list.addAll((Collection<FixDescription>)object);
        }
        return new AbstractNode((Children)new DirectChildren(linkedList));
    }

    private static Node constructSemiLogicalView(Project project, Map<FileObject, List<ErrorDescription>> map, Map<ErrorDescription, List<FixDescription>> map2) {
        Node node;
        LogicalViewProvider logicalViewProvider = (LogicalViewProvider)project.getLookup().lookup(LogicalViewProvider.class);
        if (logicalViewProvider != null) {
            node = logicalViewProvider.createLogicalView();
        } else {
            try {
                node = DataObject.find((FileObject)project.getProjectDirectory()).getNodeDelegate();
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                Exceptions.printStackTrace((Throwable)dataObjectNotFoundException);
                return new AbstractNode(Children.LEAF);
            }
        }
        HashMap<Node, List<ErrorDescription>> hashMap = new HashMap<Node, List<ErrorDescription>>();
        for (FileObject fileObject : map.keySet()) {
            List<ErrorDescription> list = map.get(fileObject);
            hashMap.put(Nodes.locateChild(node, logicalViewProvider, fileObject), list);
            for (ErrorDescription errorDescription : list) {
                LinkedList<FixDescription> linkedList = new LinkedList<FixDescription>();
                for (Fix fix : errorDescription.getFixes().getFixes()) {
                    linkedList.add(new FixDescription(errorDescription, fix));
                }
                map2.put(errorDescription, linkedList);
            }
        }
        map = Collections.unmodifiableMap(new HashMap<FileObject, List<ErrorDescription>>(map));
        return new Wrapper(node, hashMap, map2);
    }

    private static Node locateChild(Node node, LogicalViewProvider logicalViewProvider, FileObject fileObject) {
        if (logicalViewProvider != null) {
            return logicalViewProvider.findPath(node, (Object)fileObject);
        }
        throw new UnsupportedOperationException("Not done yet");
    }

    private static Lookup lookupForNode(Node node, Map<Node, List<ErrorDescription>> map, Map<ErrorDescription, List<FixDescription>> map2) {
        LinkedList<FixDescription> linkedList = new LinkedList<FixDescription>();
        for (Map.Entry<Node, List<ErrorDescription>> entry : map.entrySet()) {
            if (!Nodes.isParent(node, entry.getKey())) continue;
            for (ErrorDescription errorDescription : entry.getValue()) {
                for (FixDescription fixDescription : map2.get(errorDescription)) {
                    linkedList.add(fixDescription);
                }
            }
        }
        return Lookups.fixed((Object[])linkedList.toArray(new FixDescription[0]));
    }

    private static Lookup lookupForNode(Node node, List<ErrorDescription> list, Map<ErrorDescription, List<FixDescription>> map) {
        LinkedList<FixDescription> linkedList = new LinkedList<FixDescription>();
        for (ErrorDescription errorDescription : list) {
            for (FixDescription fixDescription : map.get(errorDescription)) {
                linkedList.add(fixDescription);
            }
        }
        return Lookups.fixed((Object[])linkedList.toArray(new FixDescription[0]));
    }

    private static boolean isParent(Node node, Node node2) {
        if (NodeOp.isSon((Node)node, (Node)node2)) {
            return true;
        }
        Node node3 = node2.getParentNode();
        if (node3 == null) {
            return false;
        }
        return Nodes.isParent(node, node3);
    }

    private static final class OpenCookieImpl
    implements OpenCookie {
        private ErrorDescription ed;

        public OpenCookieImpl(ErrorDescription errorDescription) {
            this.ed = errorDescription;
        }

        public void open() {
            try {
                PositionRef positionRef = this.ed.getRange().getBegin();
                int n = positionRef.getLine();
                int n2 = positionRef.getColumn();
                Line line = positionRef.getCloneableEditorSupport().getLineSet().getCurrent(n);
                line.show(2, n2);
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
    }

    private static final class FixNode
    extends AbstractNode
    implements ChangeListener {
        private FixDescription fix;

        public FixNode(ErrorDescription errorDescription, FixDescription fixDescription) {
            super(Children.LEAF, Lookups.fixed((Object[])new Object[]{new OpenCookieImpl(errorDescription), fixDescription}));
            this.fix = fixDescription;
            int n = -1;
            try {
                n = errorDescription.getRange().getBegin().getLine();
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
            this.setDisplayName((n != -1 ? n + ":" : "") + fixDescription.getText() + "(" + errorDescription.getDescription() + ")");
            this.setIconBaseWithExtension("org/netbeans/modules/java/hints/analyzer/ui/suggestion.png");
            fixDescription.addChangeListener(this);
        }

        public String getHtmlDisplayName() {
            System.err.println("fix.isFixed()=" + this.fix.isFixed());
            if (this.fix.isFixed()) {
                return "<html><s>" + this.getDisplayName();
            }
            return "<html>" + this.getDisplayName();
        }

        public void stateChanged(ChangeEvent changeEvent) {
            System.err.println("state changed");
            this.fireDisplayNameChange(null, null);
        }

        public Action getPreferredAction() {
            return OpenAction.get(OpenAction.class);
        }

        public Action[] getActions(boolean bl) {
            return new Action[]{OpenAction.get(OpenAction.class)};
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class FixChildren
    extends Children.Keys<FixDescription> {
        private ErrorDescription ed;

        public FixChildren(ErrorDescription errorDescription, List<FixDescription> list) {
            this.ed = errorDescription;
            this.setKeys(list);
        }

        protected Node[] createNodes(FixDescription fixDescription) {
            return new Node[]{new FixNode(this.ed, fixDescription)};
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ErrorDescriptionNode
    extends AbstractNode {
        private ErrorDescription ed;

        public ErrorDescriptionNode(ErrorDescription errorDescription, Map<ErrorDescription, List<FixDescription>> map) {
            super((Children)new FixChildren(errorDescription, map.get(errorDescription)));
            this.ed = errorDescription;
            int n = -1;
            try {
                n = errorDescription.getRange().getBegin().getLine();
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
            this.setDisplayName((n != -1 ? n + ":" : "") + errorDescription.getDescription());
            this.setIconBaseWithExtension("org/netbeans/modules/java/hints/analyzer/ui/warning-glyph.gif");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ErrorDescriptionChildren
    extends Children.Keys<ErrorDescription> {
        private Map<ErrorDescription, List<FixDescription>> errors2Fixes;

        public ErrorDescriptionChildren(List<ErrorDescription> list, Map<ErrorDescription, List<FixDescription>> map) {
            this.setKeys(list);
            this.errors2Fixes = map;
        }

        protected Node[] createNodes(ErrorDescription errorDescription) {
            LinkedList<FixNode> linkedList = new LinkedList<FixNode>();
            for (FixDescription fixDescription : this.errors2Fixes.get(errorDescription)) {
                linkedList.add(new FixNode(errorDescription, fixDescription));
            }
            return linkedList.toArray(new Node[0]);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class DirectChildren
    extends Children.Keys<Node> {
        public DirectChildren(Collection<Node> collection) {
            this.setKeys(collection);
        }

        protected Node[] createNodes(Node node) {
            return new Node[]{node};
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class WrapperChildren
    extends Children.Keys<Node> {
        private final Node orig;
        private final Map<Node, List<ErrorDescription>> fileNodes;
        private final Map<ErrorDescription, List<FixDescription>> errors2Fixes;

        public WrapperChildren(Node node, Map<Node, List<ErrorDescription>> map, Map<ErrorDescription, List<FixDescription>> map2) {
            this.orig = node;
            this.fileNodes = map;
            this.errors2Fixes = map2;
        }

        protected void addNotify() {
            super.addNotify();
            this.doSetKeys();
        }

        private void doSetKeys() {
            Node[] nodeArray = this.orig.getChildren().getNodes(true);
            LinkedList<Node> linkedList = new LinkedList<Node>();
            block0: for (Node node : nodeArray) {
                for (Node node2 : this.fileNodes.keySet()) {
                    if (node != node2 && !Nodes.isParent(node, node2)) continue;
                    linkedList.add(node);
                    continue block0;
                }
            }
            this.setKeys(linkedList);
        }

        protected Node[] createNodes(Node node) {
            if (this.fileNodes.containsKey(node)) {
                return new Node[]{new Wrapper(node, this.fileNodes.get(node), this.errors2Fixes)};
            }
            return new Node[]{new Wrapper(node, this.fileNodes, this.errors2Fixes)};
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Wrapper
    extends FilterNode {
        public Wrapper(Node node, Map<Node, List<ErrorDescription>> map, Map<ErrorDescription, List<FixDescription>> map2) {
            super(node, (Children)new WrapperChildren(node, map, map2), Nodes.lookupForNode(node, map, (Map<ErrorDescription, List<FixDescription>>)map2));
        }

        public Wrapper(Node node, List<ErrorDescription> list, Map<ErrorDescription, List<FixDescription>> map) {
            super(node, (Children)new ErrorDescriptionChildren(list, map), Nodes.lookupForNode(node, list, (Map<ErrorDescription, List<FixDescription>>)map));
        }

        public Action[] getActions(boolean bl) {
            return new Action[0];
        }
    }
}

