/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.analyzer;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.prefs.Preferences;
import javax.swing.SwingUtilities;
import javax.swing.text.StyledDocument;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.java.hints.analyzer.ui.AnalyzerTopComponent;
import org.netbeans.modules.java.hints.infrastructure.HintsTask;
import org.netbeans.modules.java.hints.options.HintsSettings;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.Cancellable;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.lookup.Lookups;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Analyzer
implements Runnable {
    private final Lookup context;
    private final AtomicBoolean cancel;
    private final ProgressHandle handle;
    private final Map<String, Preferences> preferencesOverlay;

    public Analyzer(Lookup lookup, AtomicBoolean atomicBoolean, ProgressHandle progressHandle, Map<String, Preferences> map) {
        this.context = lookup;
        this.cancel = atomicBoolean;
        this.handle = progressHandle;
        this.preferencesOverlay = map;
    }

    @Override
    public void run() {
        Object object;
        this.handle.start();
        LinkedList<FileObject> linkedList = new LinkedList<FileObject>();
        LinkedList<Object> linkedList2 = new LinkedList<Object>();
        linkedList2.addAll(Analyzer.toAnalyze(this.context));
        while (!linkedList2.isEmpty()) {
            object = (FileObject)linkedList2.poll();
            if (object.isData() && "text/x-java".equals(FileUtil.getMIMEType((FileObject)object))) {
                linkedList.add((FileObject)object);
            }
            if (!object.isFolder()) continue;
            linkedList2.addAll(Arrays.asList(object.getChildren()));
        }
        object = new LinkedList();
        if (!linkedList.isEmpty()) {
            this.handle.switchToDeterminate(linkedList.size());
            ClasspathInfo classpathInfo = ClasspathInfo.create((FileObject)((FileObject)linkedList.get(0)));
            JavaSource javaSource = JavaSource.create((ClasspathInfo)classpathInfo, linkedList);
            final AtomicInteger atomicInteger = new AtomicInteger();
            try {
                javaSource.runUserActionTask((Task)new Task<CompilationController>((List)object){
                    final /* synthetic */ List val$eds;
                    {
                        this.val$eds = list;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run(CompilationController compilationController) throws Exception {
                        if (Analyzer.this.cancel.get()) {
                            return;
                        }
                        HintsSettings.setPreferencesOverride((Map)Analyzer.this.preferencesOverlay);
                        DataObject dataObject = DataObject.find((FileObject)compilationController.getFileObject());
                        EditorCookie editorCookie = (EditorCookie)dataObject.getLookup().lookup(EditorCookie.class);
                        StyledDocument styledDocument = editorCookie.openDocument();
                        try {
                            Analyzer.this.handle.progress(FileUtil.getFileDisplayName((FileObject)compilationController.getFileObject()));
                            if (compilationController.toPhase(JavaSource.Phase.RESOLVED).compareTo((Enum)JavaSource.Phase.RESOLVED) < 0) {
                                return;
                            }
                            Analyzer.this.handle.progress(atomicInteger.incrementAndGet());
                            this.val$eds.addAll(new HintsTask().computeHints((CompilationInfo)compilationController));
                        }
                        finally {
                            HintsSettings.setPreferencesOverride(null);
                        }
                    }
                }, true);
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
        this.handle.finish();
        if (!this.cancel.get()) {
            SwingUtilities.invokeLater(new Runnable((List)object){
                final /* synthetic */ List val$eds;
                {
                    this.val$eds = list;
                }

                public void run() {
                    AnalyzerTopComponent analyzerTopComponent = AnalyzerTopComponent.findInstance();
                    analyzerTopComponent.open();
                    analyzerTopComponent.requestActive();
                    analyzerTopComponent.setData(Analyzer.this.context, Analyzer.this.preferencesOverlay, this.val$eds);
                }
            });
        }
    }

    public static void process(Lookup lookup, Map<String, Preferences> map) {
        AtomicBoolean atomicBoolean = new AtomicBoolean();
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class Cancel
        implements Cancellable {
            final /* synthetic */ AtomicBoolean val$abCancel;

            Cancel(AtomicBoolean atomicBoolean) {
                this.val$abCancel = atomicBoolean;
            }

            public boolean cancel() {
                this.val$abCancel.set(true);
                return true;
            }
        }
        ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(Analyzer.class, (String)"LBL_AnalyzingJavadoc"), (Cancellable)new Cancel(atomicBoolean));
        RequestProcessor.getDefault().post((Runnable)new Analyzer(lookup, atomicBoolean, progressHandle, map));
    }

    public static Lookup normalizeLookup(Lookup lookup) {
        if (!lookup.lookupAll(Project.class).isEmpty()) {
            return Lookups.fixed((Object[])lookup.lookupAll(Project.class).toArray(new Object[0]));
        }
        Collection<? extends FileObject> collection = Analyzer.toAnalyze(lookup);
        if (!collection.isEmpty()) {
            return Lookups.fixed((Object[])collection.toArray(new Object[0]));
        }
        return null;
    }

    private static Collection<? extends FileObject> toAnalyze(Lookup lookup) {
        LinkedHashSet<FileObject> linkedHashSet = new LinkedHashSet<FileObject>();
        linkedHashSet.addAll(lookup.lookupAll(FileObject.class));
        for (DataObject dataObject : lookup.lookupAll(DataObject.class)) {
            linkedHashSet.add(dataObject.getPrimaryFile());
        }
        for (DataObject dataObject : lookup.lookupAll(Project.class)) {
            Sources sources = ProjectUtils.getSources((Project)dataObject);
            for (SourceGroup sourceGroup : sources.getSourceGroups("java")) {
                linkedHashSet.add(sourceGroup.getRootFolder());
            }
        }
        return linkedHashSet;
    }
}

