/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.compapp.projects.jbi.anttasks;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;
import javax.xml.namespace.QName;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.netbeans.modules.compapp.projects.jbi.anttasks.WSDLCatalogModel;
import org.netbeans.modules.compapp.projects.jbi.descriptor.endpoints.model.PtConnection;
import org.netbeans.modules.compapp.projects.jbi.util.MyFileUtil;
import org.netbeans.modules.sun.manager.jbi.management.model.ComponentInformationParser;
import org.netbeans.modules.sun.manager.jbi.management.model.JBIComponentStatus;
import org.netbeans.modules.xml.retriever.catalog.Utilities;
import org.netbeans.modules.xml.wsdl.model.Binding;
import org.netbeans.modules.xml.wsdl.model.Definitions;
import org.netbeans.modules.xml.wsdl.model.ExtensibilityElement;
import org.netbeans.modules.xml.wsdl.model.Port;
import org.netbeans.modules.xml.wsdl.model.PortType;
import org.netbeans.modules.xml.wsdl.model.Service;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.wsdl.model.WSDLModelFactory;
import org.netbeans.modules.xml.wsdl.model.extensions.bpel.PartnerLinkType;
import org.netbeans.modules.xml.wsdl.model.extensions.bpel.Role;
import org.netbeans.modules.xml.xam.ModelSource;
import org.netbeans.modules.xml.xam.locator.CatalogModelException;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class wsdlRepository {
    private Project project;
    private Task task;
    private List<WSDLModel> wsdlModels = null;
    private Map<String, PortType> portTypes = new HashMap<String, PortType>();
    private Map<String, Binding> bindings = new HashMap<String, Binding>();
    private Map<String, PartnerLinkType> partnerLinkTypes = new HashMap<String, PartnerLinkType>();
    private Map<String, Service> services = new HashMap<String, Service>();
    private Map<String, Port> ports = new HashMap<String, Port>();
    private Map<Port, String> port2BC = new HashMap<Port, String>();
    private Map<String, PtConnection> connections = new HashMap<String, PtConnection>();
    private Map<String, String> bcNsMap = new HashMap<String, String>();
    private static final String WSDL_FILE_EXTENSION = "wsdl";
    private static QName SOAP_ADDRESS_QNAME = new QName("http://schemas.xmlsoap.org/wsdl/soap/", "address");
    private String DUMMY_SOAP_LOCATION = "REPLACE_WITH_ACTUAL_URL";

    public wsdlRepository(Project project, Task task) {
        this.project = project;
        this.task = task;
        this.wsdlModels = this.getAllWsdlModels(project);
        this.bcNsMap = wsdlRepository.buildBindingComponentMap(project);
        this.initLists();
    }

    public static Map<String, String> buildBindingComponentMap(Project project) {
        HashMap<String, String> bcMap = new HashMap<String, String>();
        String projPath = project.getProperty("basedir") + File.separator;
        String cnfDir = project.getProperty("meta.inf");
        String bcInfo = projPath + cnfDir + File.separator + "BindingComponentInformation.xml";
        File bcFile = new File(bcInfo);
        if (bcFile.exists()) {
            try {
                List compList = ComponentInformationParser.parse((File)bcFile);
                for (JBIComponentStatus comp : compList) {
                    String compName = comp.getName();
                    List nsList = comp.getNamespaces();
                    for (String ns : nsList) {
                        bcMap.put(ns, compName);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return bcMap;
    }

    public List<WSDLModel> getWsdlCollection() {
        return this.wsdlModels;
    }

    private List<File> getAllWsdlFiles(Project project) {
        ArrayList<File> ret = new ArrayList<File>();
        String srcPath = project.getProperty("basedir") + File.separator + "src" + File.separator;
        String serviceUnitsDirLoc = srcPath + "jbiServiceUnits";
        String jbiAsaDirLoc = srcPath + "jbiasa";
        File serviceUnitsDir = new File(serviceUnitsDirLoc);
        File jbiASADir = new File(jbiAsaDirLoc);
        FilenameFilter filter = new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(".wsdl");
            }
        };
        ArrayList<String> jbiASAChildNames = new ArrayList<String>();
        for (File file : jbiASADir.listFiles()) {
            jbiASAChildNames.add(file.getName());
        }
        ret.addAll(MyFileUtil.listFiles((File)jbiASADir, (FilenameFilter)filter, (boolean)true));
        for (File file : serviceUnitsDir.listFiles()) {
            String fileName = file.getName();
            if (jbiASAChildNames.contains(fileName)) continue;
            ret.addAll(MyFileUtil.listFiles((File)file, (FilenameFilter)filter, (boolean)true));
        }
        return ret;
    }

    private List<WSDLModel> getAllWsdlModels(Project project) {
        ArrayList<WSDLModel> ret = new ArrayList<WSDLModel>();
        WSDLModelFactory wsdlModelFactory = WSDLModelFactory.getDefault();
        for (File file : this.getAllWsdlFiles(project)) {
            try {
                ModelSource ms = null;
                try {
                    FileObject fo = FileUtil.toFileObject((File)file);
                    fo.refresh();
                    ms = Utilities.createModelSource((FileObject)fo, (boolean)false);
                }
                catch (Exception e) {
                    Lookup lookup = Lookups.fixed((Object[])new Object[]{file, this.getDocument(file), WSDLCatalogModel.getDefault()});
                    ms = new ModelSource(lookup, false);
                }
                WSDLModel wm = (WSDLModel)wsdlModelFactory.createFreshModel(ms);
                ret.add(wm);
            }
            catch (CatalogModelException ex) {
                ex.printStackTrace();
            }
        }
        return ret;
    }

    protected Document getDocument(File file) throws CatalogModelException {
        PlainDocument result = null;
        try {
            FileInputStream fis = new FileInputStream(file);
            byte[] buffer = new byte[fis.available()];
            result = new PlainDocument();
            result.remove(0, result.getLength());
            fis.read(buffer);
            fis.close();
            String str = new String(buffer);
            result.insertString(0, str, null);
        }
        catch (Exception ex) {
            throw new CatalogModelException(file.getAbsolutePath() + " not found.");
        }
        return result;
    }

    public static String getWsdlFilePath(WSDLModel doc) {
        String wsdlFilePath = null;
        Lookup lookup = doc.getModelSource().getLookup();
        File wsdlFile = (File)lookup.lookup(File.class);
        if (wsdlFile == null) {
            FileObject wsdlFileObject = (FileObject)lookup.lookup(FileObject.class);
            wsdlFile = FileUtil.toFile((FileObject)wsdlFileObject);
        }
        wsdlFilePath = wsdlFile.getPath();
        return wsdlFilePath;
    }

    public boolean isJavaEEWsdl(WSDLModel doc) {
        String wsdlFilePath = wsdlRepository.getWsdlFilePath(doc).toUpperCase().replace('\\', '/');
        int idx = wsdlFilePath.indexOf("META-INF");
        if (idx < 0) {
            return false;
        }
        boolean inJavaEEProject = wsdlFilePath.indexOf("META-INF/CATALOGDATA/") < 0;
        return inJavaEEProject;
    }

    public void initLists() {
        String key;
        for (WSDLModel wsdlModel : this.wsdlModels) {
            String key2;
            String wsdlFilePath = wsdlRepository.getWsdlFilePath(wsdlModel);
            Definitions def = wsdlModel.getDefinitions();
            if (def == null) {
                this.task.log("ERROR: Malformed WSDL file: " + wsdlFilePath);
            }
            String tns = def.getTargetNamespace();
            for (PortType pt : def.getPortTypes()) {
                key2 = this.getQName(tns, pt.getName());
                if (this.portTypes.get(key2) != null) {
                    System.out.println("Duplicate PortType: " + key2);
                    continue;
                }
                this.portTypes.put(key2, pt);
                PtConnection con = new PtConnection(key2);
                this.connections.put(key2, con);
            }
            for (Binding b : def.getBindings()) {
                key2 = this.getQName(tns, b.getName());
                if (this.bindings.get(key2) != null) {
                    System.out.println("Duplicate Binding: " + key2);
                    continue;
                }
                this.bindings.put(key2, b);
            }
            for (ExtensibilityElement ee : def.getExtensibilityElements()) {
                if (!ee.getQName().getLocalPart().equals("partnerLinkType")) continue;
                String pltNS = ee.getQName().getNamespaceURI();
                if (!pltNS.equals("http://docs.oasis-open.org/wsbpel/2.0/plnktype")) {
                    this.task.log("The Partnerlink namespace URI in " + wsdlFilePath + " is \"" + pltNS + "\". " + "It should be changed to \"http://docs.oasis-open.org/wsbpel/2.0/plnktype\".", 0);
                    return;
                }
                PartnerLinkType plt = (PartnerLinkType)ee;
                key = this.getQName(tns, plt.getName());
                if (this.partnerLinkTypes.get(key) != null) {
                    System.out.println("Duplicate ParnerLinkType: " + key);
                    continue;
                }
                this.partnerLinkTypes.put(key, plt);
            }
        }
        for (WSDLModel wsdlModel : this.wsdlModels) {
            Definitions def = wsdlModel.getDefinitions();
            String tns = def.getTargetNamespace();
            for (Service s : def.getServices()) {
                String sQName = this.getQName(tns, s.getName());
                if (this.services.get(sQName) != null) {
                    System.out.println("Duplicate Service: " + sQName);
                } else {
                    this.services.put(sQName, s);
                }
                for (Port p : s.getPorts()) {
                    key = sQName + "." + p.getName();
                    if (this.ports.get(key) != null) {
                        System.out.println("Duplicate Port: " + key);
                        continue;
                    }
                    List xts = p.getExtensibilityElements();
                    if (xts.size() > 0) {
                        String location;
                        ExtensibilityElement ee = (ExtensibilityElement)xts.get(0);
                        QName eeQName = ee.getQName();
                        if (SOAP_ADDRESS_QNAME.equals(eeQName) && this.DUMMY_SOAP_LOCATION.equals(location = ee.getAttribute("location"))) {
                            this.task.log("INFO: WSDL Port with dummy SOAP address \"REPLACE_WITH_ACTUAL_URL\" is ignored: " + sQName + ":" + p.getName());
                            continue;
                        }
                        String bcNs = ee.getQName().getNamespaceURI();
                        if (bcNs != null) {
                            String bcName = this.bcNsMap.get(bcNs);
                            if (bcName != null) {
                                this.port2BC.put(p, bcName);
                            } else {
                                this.task.log("WARNING: Missing WSDL extension plug-in for \"" + bcNs + "\" or missing binding component definition in the config file.", 1);
                            }
                        }
                    }
                    this.ports.put(key, p);
                    Binding binding = (Binding)p.getBinding().get();
                    if (binding == null) {
                        throw new BuildException("ERROR: Missing binding for WSDL port " + key);
                    }
                    String ptQName = binding.getType().getQName().toString();
                    PtConnection ptCon = this.connections.get(ptQName);
                    if (ptCon == null) continue;
                    ptCon.addPort(p);
                }
            }
        }
    }

    public String getBindingComponentName(Port p) {
        return this.port2BC.get(p);
    }

    private String getQName(String namespace, String name) {
        if (namespace == null) {
            return name;
        }
        return "{" + namespace + "}" + name;
    }

    public Map<String, PtConnection> getConnections() {
        return this.connections;
    }

    public PtConnection getPtConnection(String pt) {
        return this.connections.get(pt);
    }

    private Role[] getRoles(PartnerLinkType plt) {
        Role r1 = plt.getRole1();
        Role r2 = plt.getRole2();
        ArrayList<Role> rs = new ArrayList<Role>();
        if (r1 != null) {
            rs.add(r1);
        }
        if (r2 != null) {
            rs.add(r2);
        }
        return rs.toArray(new Role[0]);
    }

    public PortType getPartnerLinkPortType(String pname) {
        PartnerLinkType plt = this.partnerLinkTypes.get(pname);
        if (plt == null) {
            return null;
        }
        Role[] rs = this.getRoles(plt);
        if (rs == null || rs.length < 1) {
            return null;
        }
        Role r = rs[0];
        return (PortType)r.getPortType().get();
    }

    public PortType getPartnerLinkPortType(String pname, String rname) {
        PartnerLinkType plt = this.partnerLinkTypes.get(pname);
        if (plt == null) {
            return null;
        }
        Role[] rs = this.getRoles(plt);
        if (rs == null || rs.length < 1) {
            return null;
        }
        for (int i = 0; i < rs.length; ++i) {
            Role r = rs[i];
            if (!r.getName().equalsIgnoreCase(rname)) continue;
            return (PortType)r.getPortType().get();
        }
        return null;
    }

    public Map<String, PortType> getPortTypes() {
        return this.portTypes;
    }

    public Map<String, Binding> getBindings() {
        return this.bindings;
    }

    public Map<String, PartnerLinkType> getServiceLTs() {
        return this.partnerLinkTypes;
    }

    public Map<String, Service> getServices() {
        return this.services;
    }

    public Map<String, Port> getPorts() {
        return this.ports;
    }

    static class WSDLFileFilter
    implements FileFilter {
        WSDLFileFilter() {
        }

        public boolean accept(File pathname) {
            boolean result = false;
            if (pathname.isDirectory()) {
                return true;
            }
            String fileName = pathname.getName();
            String fileExtension = null;
            int dotIndex = fileName.lastIndexOf(46);
            if (dotIndex != -1) {
                fileExtension = fileName.substring(dotIndex + 1);
            }
            if (fileExtension != null && fileExtension.equalsIgnoreCase(wsdlRepository.WSDL_FILE_EXTENSION)) {
                result = true;
            }
            return result;
        }
    }
}

