/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.compapp.projects.jbi.anttasks;

import com.sun.esb.management.api.deployment.DeploymentService;
import com.sun.esb.management.common.ManagementRemoteException;
import com.sun.jbi.ui.common.ServiceAssemblyInfo;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.StringReader;
import java.nio.channels.FileChannel;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.netbeans.modules.compapp.jbiserver.JbiManager;
import org.netbeans.modules.compapp.projects.jbi.AdministrationServiceHelper;
import org.netbeans.modules.sun.manager.jbi.management.JBIMBeanTaskResultHandler;
import org.netbeans.modules.sun.manager.jbi.management.wrapper.api.RuntimeManagementServiceWrapper;
import org.netbeans.modules.sun.manager.jbi.util.ServerInstance;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class DeployServiceAssembly
extends Task {
    private static final String SERVER_TARGET = "server";
    private String serviceAssemblyID;
    private String serviceAssemblyLocation;
    private String undeployServiceAssembly = "false";
    private String hostName;
    private String port;
    private String userName;
    private String password;
    private String serverInstanceLocation;
    private String netBeansUserDir;
    private String j2eeServerInstance;
    private boolean FORCE = true;

    public String getServiceAssemblyID() {
        return this.serviceAssemblyID;
    }

    public void setServiceAssemblyID(String serviceAssemblyID) {
        this.serviceAssemblyID = serviceAssemblyID;
    }

    public String getServiceAssemblyLocation() {
        return this.serviceAssemblyLocation;
    }

    public void setServiceAssemblyLocation(String serviceAssemblyLocation) {
        this.serviceAssemblyLocation = serviceAssemblyLocation;
    }

    public String getUndeployServiceAssembly() {
        return this.undeployServiceAssembly;
    }

    public void setUndeployServiceAssembly(String undeployServiceAssembly) {
        this.undeployServiceAssembly = undeployServiceAssembly;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public String getPort() {
        return this.port;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getPassword() {
        return this.password;
    }

    public void setServerInstanceLocation(String serverInstanceLocation) {
        this.serverInstanceLocation = serverInstanceLocation;
    }

    public String getServerInstanceLocation() {
        return this.serverInstanceLocation;
    }

    public void setNetBeansUserDir(String netBeansUserDir) {
        this.netBeansUserDir = netBeansUserDir;
    }

    public String getNetBeansUserDir() {
        return this.netBeansUserDir;
    }

    public void setJ2eeServerInstance(String j2eeServerInstance) {
        this.j2eeServerInstance = j2eeServerInstance;
    }

    public String getJ2eeServerInstance() {
        return this.j2eeServerInstance;
    }

    public void execute() throws BuildException {
        block39: {
            Project p = this.getProject();
            String osgisupport = p.getProperty("osgi.support");
            if (osgisupport != null && osgisupport.equalsIgnoreCase("true")) {
                String osgiDirPath = p.getProperty("osgi.container.dir");
                if (osgiDirPath == null || osgiDirPath.trim().length() == 0) {
                    throw new BuildException("OSGi container directory is not specified.");
                }
                File osgiDir = new File(osgiDirPath);
                if (!osgiDir.exists() || osgiDir.isFile()) {
                    throw new BuildException("Invalid OSGi container directory: " + osgiDirPath);
                }
                File autoDeployDir = new File(osgiDirPath + "/jbi/autodeploy/");
                File srcFile = new File(this.serviceAssemblyLocation);
                File targetFile = new File(autoDeployDir, srcFile.getName());
                if (this.undeployServiceAssembly.equalsIgnoreCase("true")) {
                    this.log("  remove " + targetFile.getAbsolutePath());
                    targetFile.delete();
                } else {
                    try {
                        this.log("  copy " + srcFile.getAbsolutePath() + " to " + autoDeployDir.getAbsolutePath());
                        DeployServiceAssembly.copyFile(srcFile, targetFile);
                    }
                    catch (IOException ex) {
                        throw new BuildException(ex.getMessage());
                    }
                }
                return;
            }
            if (this.serviceAssemblyID != null && this.serviceAssemblyID.equals("${org.netbeans.modules.compapp.projects.jbi.descriptor.uuid.assembly-unit}")) {
                String msg = "Unknown Service Assembly ID: " + this.serviceAssemblyID + System.getProperty("line.separator") + "Please re-open your CompApp project using the latest NetBeans to refresh your CompApp project." + System.getProperty("line.separator") + "See http://www.netbeans.org/issues/show_bug.cgi?id=108702 for more info.";
                throw new BuildException(msg);
            }
            String nbUserDir = this.getNetBeansUserDir();
            String serverInstanceID = this.getJ2eeServerInstance();
            try {
                JbiManager.startServer((String)serverInstanceID, (boolean)true);
            }
            catch (Exception e) {
                // empty catch block
            }
            ServerInstance serverInstance = AdministrationServiceHelper.getServerInstance((String)nbUserDir, (String)serverInstanceID);
            try {
                String status;
                RuntimeManagementServiceWrapper mgmtServiceWrapper = AdministrationServiceHelper.getRuntimeManagementServiceWrapper((ServerInstance)serverInstance);
                DeploymentService deploymentService = AdministrationServiceHelper.getDeploymentService((ServerInstance)serverInstance);
                this.hostName = serverInstance.getHostName();
                this.port = serverInstance.getAdminPort();
                this.userName = serverInstance.getUserName();
                this.password = serverInstance.getPassword();
                mgmtServiceWrapper.clearServiceAssemblyStatusCache();
                ServiceAssemblyInfo assembly = mgmtServiceWrapper.getServiceAssembly(this.serviceAssemblyID, SERVER_TARGET);
                String string = status = assembly == null ? null : assembly.getState();
                if ("Unknown".equals(status)) {
                    String msg = "Unknown status for Service Assembly " + this.serviceAssemblyID;
                    throw new BuildException(msg);
                }
                if (this.undeployServiceAssembly.equalsIgnoreCase("true")) {
                    if ("Started".equals(status)) {
                        this.stopServiceAssembly(mgmtServiceWrapper);
                        this.shutdownServiceAssembly(mgmtServiceWrapper);
                        this.undeployServiceAssembly(deploymentService);
                    } else if ("Stopped".equals(status)) {
                        this.shutdownServiceAssembly(mgmtServiceWrapper);
                        this.undeployServiceAssembly(deploymentService);
                    } else if ("Shutdown".equals(status)) {
                        this.undeployServiceAssembly(deploymentService);
                    }
                    break block39;
                }
                if ("Started".equals(status)) {
                    this.stopServiceAssembly(mgmtServiceWrapper);
                    this.shutdownServiceAssembly(mgmtServiceWrapper);
                    this.undeployServiceAssembly(deploymentService);
                } else if ("Stopped".equals(status)) {
                    this.shutdownServiceAssembly(mgmtServiceWrapper);
                    this.undeployServiceAssembly(deploymentService);
                } else if ("Shutdown".equals(status)) {
                    this.undeployServiceAssembly(deploymentService);
                }
                try {
                    this.deployServiceAssembly(deploymentService);
                }
                catch (BuildException e) {
                    Object[] processResult = JBIMBeanTaskResultHandler.getProcessResult((String)"deployServiceAssembly", (String)this.serviceAssemblyID, (String)e.getMessage(), (boolean)false);
                    this.log("ERROR: " + processResult[0], 0);
                    ServiceAssemblyInfo saInfo = mgmtServiceWrapper.getServiceAssembly(this.serviceAssemblyID, SERVER_TARGET);
                    if (saInfo != null) {
                        this.log("Cleaning up...");
                        try {
                            this.undeployServiceAssembly(deploymentService);
                        }
                        catch (BuildException ex) {
                            this.log("ERROR: " + ex.getMessage(), 0);
                        }
                    }
                    throw new BuildException("Deployment failure.");
                }
                try {
                    this.startServiceAssembly(mgmtServiceWrapper);
                }
                catch (BuildException e) {
                    Object[] processResult = JBIMBeanTaskResultHandler.getProcessResult((String)"startServiceAssembly", (String)this.serviceAssemblyID, (String)e.getMessage(), (boolean)false);
                    this.log("ERROR: " + processResult[0], 0);
                    this.log("Cleaning up...");
                    boolean rollbackFailure = false;
                    try {
                        this.stopServiceAssembly(mgmtServiceWrapper);
                    }
                    catch (BuildException ex) {
                        rollbackFailure = true;
                        this.log("ERROR: " + ex.getMessage(), 0);
                    }
                    if (!rollbackFailure) {
                        try {
                            this.shutdownServiceAssembly(mgmtServiceWrapper);
                        }
                        catch (BuildException ex) {
                            rollbackFailure = true;
                            this.log("ERROR: " + ex.getMessage(), 0);
                        }
                    }
                    if (!rollbackFailure) {
                        try {
                            this.undeployServiceAssembly(deploymentService);
                        }
                        catch (BuildException ex) {
                            rollbackFailure = true;
                            this.log("ERROR: " + ex.getMessage(), 0);
                        }
                    }
                    throw new BuildException("Start failure.");
                }
            }
            catch (ManagementRemoteException e) {
                Object[] processResult = JBIMBeanTaskResultHandler.getProcessResult((String)"deployServiceAssembly", (String)this.serviceAssemblyID, (String)e.getMessage(), (boolean)false);
                throw new BuildException((String)processResult[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deployServiceAssembly(DeploymentService adminService) throws BuildException {
        block5: {
            this.log("[deploy-service-assembly]");
            this.log("    Deploying a service assembly...");
            this.log("        host=" + this.hostName);
            this.log("        port=" + this.port);
            this.log("        file=" + this.serviceAssemblyLocation);
            String result = null;
            try {
                result = adminService.deployServiceAssembly(this.serviceAssemblyLocation, SERVER_TARGET);
            }
            catch (ManagementRemoteException e) {
                result = e.getMessage();
            }
            finally {
                Object[] value = JBIMBeanTaskResultHandler.getProcessResult((String)"Deploy", (String)this.serviceAssemblyLocation, (String)result, (boolean)false);
                if (value[0] == null) break block5;
                throw new BuildException((String)value[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startServiceAssembly(RuntimeManagementServiceWrapper adminService) throws BuildException {
        block5: {
            this.log("[start-service-assembly]");
            this.log("    Starting a service assembly...");
            this.log("        host=" + this.hostName);
            this.log("        port=" + this.port);
            this.log("        name=" + this.serviceAssemblyID);
            String result = null;
            try {
                result = adminService.startServiceAssembly(this.serviceAssemblyID, SERVER_TARGET);
            }
            catch (ManagementRemoteException e) {
                result = e.getMessage();
            }
            finally {
                Object[] value = JBIMBeanTaskResultHandler.getProcessResult((String)"Start", (String)this.serviceAssemblyID, (String)result, (boolean)false);
                if (value[0] == null) break block5;
                throw new BuildException((String)value[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopServiceAssembly(RuntimeManagementServiceWrapper adminService) throws BuildException {
        block5: {
            this.log("[stop-service-assembly]");
            this.log("    Stopping a service assembly...");
            this.log("        host=" + this.hostName);
            this.log("        port=" + this.port);
            this.log("        name=" + this.serviceAssemblyID);
            String result = null;
            try {
                result = adminService.stopServiceAssembly(this.serviceAssemblyID, SERVER_TARGET);
            }
            catch (ManagementRemoteException e) {
                result = e.getMessage();
            }
            finally {
                Object[] value = JBIMBeanTaskResultHandler.getProcessResult((String)"Stop", (String)this.serviceAssemblyID, (String)result, (boolean)false);
                if (value[0] == null) break block5;
                throw new BuildException((String)value[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutdownServiceAssembly(RuntimeManagementServiceWrapper adminService) throws BuildException {
        block5: {
            this.log("[shutdown-service-assembly]");
            this.log("    Shutting down a service assembly...");
            this.log("        host=" + this.hostName);
            this.log("        port=" + this.port);
            this.log("        name=" + this.serviceAssemblyID);
            String result = null;
            try {
                result = adminService.shutdownServiceAssembly(this.serviceAssemblyID, this.FORCE, SERVER_TARGET);
            }
            catch (ManagementRemoteException e) {
                result = e.getMessage();
            }
            finally {
                Object[] value = JBIMBeanTaskResultHandler.getProcessResult((String)"Shutdown", (String)this.serviceAssemblyID, (String)result, (boolean)false);
                if (value[0] == null) break block5;
                throw new BuildException((String)value[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void undeployServiceAssembly(DeploymentService adminService) throws BuildException {
        block5: {
            this.log("[undeploy-service-assembly]");
            this.log("    Undeploying a service assembly...");
            this.log("        host=" + this.hostName);
            this.log("        port=" + this.port);
            this.log("        name=" + this.serviceAssemblyID);
            String result = null;
            try {
                result = adminService.undeployServiceAssembly(this.serviceAssemblyID, this.FORCE, SERVER_TARGET);
            }
            catch (ManagementRemoteException e) {
                result = e.getMessage();
            }
            finally {
                Object[] value = JBIMBeanTaskResultHandler.getProcessResult((String)"Undeploy", (String)this.serviceAssemblyID, (String)result, (boolean)false);
                if (value[0] == null) break block5;
                throw new BuildException((String)value[0]);
            }
        }
    }

    static Document loadXML(String xmlSource) {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            return documentBuilder.parse(new InputSource(new StringReader(xmlSource)));
        }
        catch (Exception e) {
            System.out.println("Error parsing XML: " + e);
            return null;
        }
    }

    private static void copyFile(File src, File target) throws IOException {
        FileChannel inChannel = new FileInputStream(src).getChannel();
        FileChannel outChannel = new FileOutputStream(target).getChannel();
        try {
            inChannel.transferTo(0L, inChannel.size(), outChannel);
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (inChannel != null) {
                inChannel.close();
            }
            if (outChannel != null) {
                outChannel.close();
            }
        }
    }

    public static void main(String[] args) {
        System.out.println("here");
        DeployServiceAssembly deploy = new DeployServiceAssembly();
        deploy.setServiceAssemblyID("01000000-C40493EE0B0100-8199A774-01");
        deploy.setServiceAssemblyLocation("C:\\Documents and Settings\\jqian\\CompositeApp10\\dist\\CompositeApp10.zip");
        deploy.setUserName("admin");
        deploy.setPassword("adminadmin");
        deploy.setHostName("localhost");
        deploy.setPort("4848");
        deploy.setServerInstanceLocation("C:\\Alaska\\Sun\\AppServer");
        deploy.execute();
    }
}

