/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.filter;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.AbstractButton;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.BadLocationException;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.tasklist.filter.FilterRepository;
import org.netbeans.modules.tasklist.filter.KeywordsFilter;
import org.netbeans.modules.tasklist.filter.KeywordsPanel;
import org.netbeans.modules.tasklist.filter.TaskFilter;
import org.netbeans.modules.tasklist.filter.TypesFilter;
import org.netbeans.modules.tasklist.filter.TypesPanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class FilterEditor
extends JPanel
implements PropertyChangeListener {
    private HashMap<KeywordsFilter, KeywordsPanel> filter2keywords = new HashMap(10);
    private HashMap<TypesFilter, TypesPanel> filter2types = new HashMap(10);
    private FilterRepository filterRepository;
    private FilterModel filterModel;
    private JButton btnOk;
    private JButton btnCancel;
    private JButton btnNewFilter;
    private JButton btnRemoveFilter;
    private JLabel lblFilterName;
    private JLabel lblFilters;
    private JList lstFilters;
    private JPanel panelKeywords;
    private JPanel panelTypes;
    private JScrollPane scrollFilters;
    private JTabbedPane tabs;
    private JTextField txtFilterName;

    public FilterEditor(FilterRepository filterRepository) {
        this.initComponents();
        this.filterRepository = filterRepository;
        if (this.filterRepository.size() == 0) {
            this.filterRepository.add(this.filterRepository.createNewFilter());
        }
        this.filterModel = new FilterModel(this.filterRepository);
        this.init();
    }

    public boolean showWindow() {
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)this, NbBundle.getMessage(FilterEditor.class, (String)"LBL_FilterEditor"), true, new Object[]{this.btnOk, this.btnCancel}, (Object)this.btnOk, 0, HelpCtx.DEFAULT_HELP, null);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.setVisible(true);
        if (this.btnOk.equals(dialogDescriptor.getValue())) {
            this.updateFilters();
            return true;
        }
        return false;
    }

    private void init() {
        this.initComponents();
        this.lstFilters.setModel(this.filterModel);
        this.lstFilters.setSelectionModel(this.filterModel.selection);
        this.lstFilters.setSelectionMode(0);
        TaskFilter taskFilter = this.filterRepository.getActive();
        if (null != taskFilter) {
            int n = this.filterModel.getIndexOf(taskFilter);
            this.lstFilters.setSelectedIndex(n);
        }
        if (this.filterModel.getSelectedIndex() == -1 && this.filterModel.getSize() > 0) {
            this.lstFilters.setSelectedIndex(0);
        }
        this.txtFilterName.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                this.update(documentEvent);
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                this.update(documentEvent);
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                this.update(documentEvent);
            }

            private void update(DocumentEvent documentEvent) {
                try {
                    FilterEditor.this.filterModel.setCurrentFilterName(documentEvent.getDocument().getText(0, documentEvent.getDocument().getLength()));
                    FilterEditor.this.propertyChange(null);
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        });
        this.lstFilters.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    FilterEditor.this.showFilter(FilterEditor.this.filterModel.getSelectedFilter());
                    FilterEditor.this.btnRemoveFilter.setEnabled(FilterEditor.this.filterModel.getSelectedIndex() != -1);
                    FilterEditor.this.txtFilterName.setEnabled(FilterEditor.this.filterModel.getSelectedIndex() != -1);
                }
            }
        });
        this.showFilter(this.filterModel.getSelectedFilter());
        this.btnRemoveFilter.setEnabled(this.filterModel.getSelectedIndex() != -1);
        this.btnOk = new JButton("Ok");
        this.btnCancel = new JButton("Cancel");
    }

    private void showFilter(TaskFilter taskFilter) {
        if (null == taskFilter) {
            this.txtFilterName.setText(null);
            this.panelKeywords.removeAll();
            this.panelTypes.removeAll();
            this.panelKeywords.add((Component)new KeywordsPanel(null), "Center");
            this.panelTypes.add((Component)new TypesPanel(null), "Center");
        } else {
            KeywordsPanel keywordsPanel = this.filter2keywords.get(taskFilter.getKeywordsFilter());
            if (keywordsPanel == null) {
                keywordsPanel = new KeywordsPanel(taskFilter.getKeywordsFilter() == null ? new KeywordsFilter() : taskFilter.getKeywordsFilter());
                this.filter2keywords.put(taskFilter.getKeywordsFilter(), keywordsPanel);
                keywordsPanel.addPropertyChangeListener("value-valid", this);
            }
            this.panelKeywords.removeAll();
            this.panelKeywords.add((Component)keywordsPanel, "Center");
            keywordsPanel.setVisible(true);
            TypesPanel typesPanel = this.filter2types.get(taskFilter.getTypesFilter());
            if (typesPanel == null) {
                typesPanel = new TypesPanel(taskFilter.getTypesFilter() == null ? new TypesFilter() : taskFilter.getTypesFilter());
                this.filter2types.put(taskFilter.getTypesFilter(), typesPanel);
                typesPanel.addPropertyChangeListener("value-valid", this);
            }
            this.panelTypes.removeAll();
            this.panelTypes.add((Component)typesPanel, "Center");
            typesPanel.setVisible(true);
            this.tabs.requestFocus();
            if (this.filterModel.getSelectedFilter() != taskFilter) {
                this.lstFilters.setSelectedIndex(this.filterModel.getIndexOf(taskFilter));
            }
            this.txtFilterName.setText(taskFilter.getName());
        }
        this.panelKeywords.validate();
        this.panelKeywords.repaint();
        this.panelTypes.validate();
        this.panelTypes.repaint();
    }

    public boolean isValueValid() {
        for (KeywordsPanel jPanel : this.filter2keywords.values()) {
            if (jPanel.isValueValid()) continue;
            return false;
        }
        for (TypesPanel typesPanel : this.filter2types.values()) {
            if (typesPanel.isValueValid()) continue;
            return false;
        }
        return this.txtFilterName.getText().length() != 0;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (null != this.btnOk) {
            this.btnOk.setEnabled(this.isValueValid());
        }
    }

    void updateFilters() {
        this.filterRepository.clear();
        Iterator iterator = this.filterModel.iterator();
        while (iterator.hasNext()) {
            TaskFilter taskFilter = (TaskFilter)iterator.next();
            if (this.filter2keywords.get(taskFilter.getKeywordsFilter()) != null) {
                taskFilter.setKeywordsFilter(this.filter2keywords.get(taskFilter.getKeywordsFilter()).getFilter());
            }
            if (this.filter2types.get(taskFilter.getTypesFilter()) != null) {
                taskFilter.setTypesFilter(this.filter2types.get(taskFilter.getTypesFilter()).getFilter());
            }
            this.filterRepository.add(taskFilter);
        }
        if (this.filterModel.getSelectedFilter() != null) {
            this.filterRepository.setActive(this.filterModel.getSelectedFilter());
        }
    }

    private void initComponents() {
        this.lblFilters = new JLabel();
        this.scrollFilters = new JScrollPane();
        this.lstFilters = new JList();
        this.btnNewFilter = new JButton();
        this.btnRemoveFilter = new JButton();
        this.tabs = new JTabbedPane();
        this.panelTypes = new JPanel();
        this.panelKeywords = new JPanel();
        this.lblFilterName = new JLabel();
        this.txtFilterName = new JTextField();
        this.lblFilters.setLabelFor(this.lstFilters);
        Mnemonics.setLocalizedText((JLabel)this.lblFilters, (String)NbBundle.getMessage(FilterEditor.class, (String)"FilterEditor.lblFilters.text"));
        this.lstFilters.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            public int getSize() {
                return this.strings.length;
            }

            public Object getElementAt(int n) {
                return this.strings[n];
            }
        });
        this.lstFilters.setToolTipText(NbBundle.getMessage(FilterEditor.class, (String)"FilterEditor.lstFilters.toolTipText"));
        this.scrollFilters.setViewportView(this.lstFilters);
        Mnemonics.setLocalizedText((AbstractButton)this.btnNewFilter, (String)NbBundle.getMessage(FilterEditor.class, (String)"FilterEditor.btnNewFilter.text"));
        this.btnNewFilter.setToolTipText(NbBundle.getMessage(FilterEditor.class, (String)"FilterEditor.btnNewFilter.toolTipText"));
        this.btnNewFilter.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FilterEditor.this.onNewFilter(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.btnRemoveFilter, (String)NbBundle.getMessage(FilterEditor.class, (String)"FilterEditor.btnRemoveFilter.text"));
        this.btnRemoveFilter.setToolTipText(NbBundle.getMessage(FilterEditor.class, (String)"FilterEditor.btnRemoveFilter.toolTipText"));
        this.btnRemoveFilter.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FilterEditor.this.onRemoveFilter(actionEvent);
            }
        });
        this.panelTypes.setOpaque(false);
        this.panelTypes.setLayout(new BorderLayout());
        this.tabs.addTab(NbBundle.getMessage(FilterEditor.class, (String)"FilterEditor.panelTypes.TabConstraints.tabTitle"), this.panelTypes);
        this.panelKeywords.setOpaque(false);
        this.panelKeywords.setLayout(new BorderLayout());
        this.tabs.addTab(NbBundle.getMessage(FilterEditor.class, (String)"FilterEditor.panelKeywords.TabConstraints.tabTitle"), this.panelKeywords);
        this.lblFilterName.setLabelFor(this.txtFilterName);
        Mnemonics.setLocalizedText((JLabel)this.lblFilterName, (String)NbBundle.getMessage(FilterEditor.class, (String)"FilterEditor.lblFilterName.text"));
        this.txtFilterName.setToolTipText(NbBundle.getMessage(FilterEditor.class, (String)"FilterEditor.txtFilterName.toolTipText"));
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1, false).add((Component)this.lblFilters).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.btnNewFilter).addPreferredGap(0).add((Component)this.btnRemoveFilter)).add((Component)this.scrollFilters)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.lblFilterName).addPreferredGap(0).add((Component)this.txtFilterName, -1, 459, Short.MAX_VALUE)).add((Component)this.tabs, -1, 494, Short.MAX_VALUE)).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.lblFilters).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.scrollFilters, -1, 229, Short.MAX_VALUE).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.btnNewFilter).add((Component)this.btnRemoveFilter))).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.lblFilterName).add((Component)this.txtFilterName, -2, -1, -2)).addPreferredGap(0).add((Component)this.tabs, -1, 233, Short.MAX_VALUE))).addContainerGap()));
    }

    private void onRemoveFilter(ActionEvent actionEvent) {
        int n = this.filterModel.getSelectedIndex();
        if (n != -1) {
            TaskFilter taskFilter = this.filterModel.get(n);
            this.filterModel.remove(n);
            this.filter2keywords.remove(taskFilter.getKeywordsFilter());
            this.filter2types.remove(taskFilter.getTypesFilter());
        }
    }

    private void onNewFilter(ActionEvent actionEvent) {
        TaskFilter taskFilter = this.filterRepository.createNewFilter();
        this.filterModel.add(taskFilter);
        this.showFilter(taskFilter);
    }

    private static class FilterModel
    extends AbstractListModel {
        public DefaultListSelectionModel selection = new DefaultListSelectionModel();
        public ArrayList<TaskFilter> filters;

        public FilterModel(FilterRepository filterRepository) {
            this.filters = new ArrayList(filterRepository.size() * 2);
            int n = 0;
            for (TaskFilter taskFilter : filterRepository.getFilters()) {
                if (taskFilter == filterRepository.getActive()) {
                    this.selection.setSelectionInterval(n, n);
                }
                this.filters.add((TaskFilter)taskFilter.clone());
                ++n;
            }
        }

        public Iterator iterator() {
            return this.filters.iterator();
        }

        public Object getElementAt(int n) {
            return this.filters.get(n).getName();
        }

        public int getSize() {
            return this.filters.size();
        }

        public TaskFilter getSelectedFilter() {
            if (this.getSelectedIndex() > -1) {
                return this.filters.get(this.getSelectedIndex());
            }
            return null;
        }

        public int getSelectedIndex() {
            int n;
            int n2 = this.selection.getMinSelectionIndex();
            if (n2 == (n = this.selection.getMaxSelectionIndex()) && n2 >= 0 && n2 < this.filters.size()) {
                return n2;
            }
            return -1;
        }

        public void remove(int n) {
            int n2 = this.getSelectedIndex();
            if (n2 != -1) {
                this.filters.remove(n);
                this.fireIntervalRemoved(this, n, n);
                if (n < n2) {
                    this.selection.setSelectionInterval(n2 - 1, n2 - 1);
                }
                if (n == n2) {
                    this.selection.setSelectionInterval(100, 0);
                }
            }
        }

        public TaskFilter get(int n) {
            return this.filters.get(n);
        }

        public boolean add(TaskFilter taskFilter) {
            if (this.filters.add(taskFilter)) {
                this.fireIntervalAdded(this, this.filters.size() - 1, this.filters.size() - 1);
                return true;
            }
            return false;
        }

        public int getIndexOf(TaskFilter taskFilter) {
            return this.filters.indexOf(taskFilter);
        }

        public void setCurrentFilterName(String string) {
            int n = this.getSelectedIndex();
            if (n >= 0) {
                this.get(n).setName(string);
                this.fireContentsChanged(this, n, n);
            }
        }
    }
}

