/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.deployment.impl.ui.wizard;

import java.awt.Dialog;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Set;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.j2ee.deployment.impl.Server;
import org.netbeans.modules.j2ee.deployment.impl.ui.wizard.ServerChooserPanel;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.netbeans.modules.j2ee.deployment.plugins.spi.OptionalDeploymentManagerFactory;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.WizardDescriptor;
import org.openide.util.NbBundle;

public class AddServerInstanceWizard
extends WizardDescriptor {
    public static final String PROP_DISPLAY_NAME = "ServInstWizard_displayName";
    public static final String PROP_SERVER = "ServInstWizard_server";
    private static final String PROP_AUTO_WIZARD_STYLE = "WizardPanel_autoWizardStyle";
    private static final String PROP_CONTENT_DISPLAYED = "WizardPanel_contentDisplayed";
    private static final String PROP_CONTENT_NUMBERED = "WizardPanel_contentNumbered";
    private static final String PROP_CONTENT_DATA = "WizardPanel_contentData";
    private static final String PROP_CONTENT_SELECTED_INDEX = "WizardPanel_contentSelectedIndex";
    private static final String PROP_ERROR_MESSAGE = "WizardPanel_errorMessage";
    private AddServerInstanceWizardIterator iterator;
    private ServerChooserPanel chooser;
    private static final Logger LOGGER = Logger.getLogger("org.netbeans.modules.j2ee.deployment");

    private AddServerInstanceWizard() {
        this(new AddServerInstanceWizardIterator());
        this.putProperty(PROP_AUTO_WIZARD_STYLE, Boolean.TRUE);
        this.putProperty(PROP_CONTENT_DISPLAYED, Boolean.TRUE);
        this.putProperty(PROP_CONTENT_NUMBERED, Boolean.TRUE);
        this.setTitle(NbBundle.getMessage(AddServerInstanceWizard.class, (String)"LBL_ASIW_Title"));
        this.setTitleFormat(new MessageFormat(NbBundle.getMessage(AddServerInstanceWizard.class, (String)"LBL_ASIW_TitleFormat")));
        this.initialize();
    }

    private AddServerInstanceWizard(AddServerInstanceWizardIterator addServerInstanceWizardIterator) {
        super((WizardDescriptor.Iterator)addServerInstanceWizardIterator);
        this.iterator = addServerInstanceWizardIterator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String showAddServerInstanceWizard() {
        Set set;
        Object var3_2;
        AddServerInstanceWizard addServerInstanceWizard = new AddServerInstanceWizard();
        Dialog dialog = DialogDisplayer.getDefault().createDialog((DialogDescriptor)addServerInstanceWizard);
        try {
            dialog.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AddServerInstanceWizard.class, (String)"ACSD_Add_Server_Instance"));
            dialog.setVisible(true);
            var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            dialog.dispose();
            throw throwable;
        }
        dialog.dispose();
        if (addServerInstanceWizard.getValue() == WizardDescriptor.FINISH_OPTION && (set = addServerInstanceWizard.getInstantiatedObjects()) != null && set.size() > 0) {
            var3_2 = set.iterator().next();
            if (var3_2 instanceof InstanceProperties) {
                return ((InstanceProperties)var3_2).getProperty("url");
            }
            LOGGER.warning(addServerInstanceWizard.iterator.getSelectedServer() + "'s add server instance wizard iterator should return " + "a Set containing new server instance InstanceProperties object as a result of the " + "WizardDescriptor.InstantiatingIterator.instantiate() method.");
            return null;
        }
        return null;
    }

    public void setErrorMessage(String string) {
        this.putProperty(PROP_ERROR_MESSAGE, string);
    }

    protected void updateState() {
        super.updateState();
        String[] stringArray = this.getContentData();
        if (stringArray != null) {
            this.putProperty(PROP_CONTENT_DATA, stringArray);
            this.putProperty(PROP_CONTENT_SELECTED_INDEX, this.getContentSelectedIndex());
        }
    }

    private ServerChooserPanel getChooser() {
        if (this.chooser == null) {
            this.chooser = new ServerChooserPanel();
        }
        return this.chooser;
    }

    private String[] getContentData() {
        JComponent jComponent = (JComponent)this.getChooser().getComponent();
        String[] stringArray = (String[])jComponent.getClientProperty(PROP_CONTENT_DATA);
        if (this.iterator.current().equals(this.getChooser())) {
            return stringArray;
        }
        JComponent jComponent2 = (JComponent)this.iterator.current().getComponent();
        String[] stringArray2 = (String[])jComponent2.getClientProperty(PROP_CONTENT_DATA);
        if (stringArray2 == null) {
            return stringArray;
        }
        String[] stringArray3 = new String[stringArray2.length + 1];
        stringArray3[0] = stringArray[0];
        System.arraycopy(stringArray2, 0, stringArray3, 1, stringArray2.length);
        return stringArray3;
    }

    private int getContentSelectedIndex() {
        if (this.iterator.current().equals(this.getChooser())) {
            return 0;
        }
        JComponent jComponent = (JComponent)this.iterator.current().getComponent();
        Integer n = (Integer)jComponent.getClientProperty(PROP_CONTENT_SELECTED_INDEX);
        if (n != null) {
            return n + 1;
        }
        return 1;
    }

    private static class AddServerInstanceWizardIterator
    implements WizardDescriptor.InstantiatingIterator {
        private AddServerInstanceWizard wd;
        public boolean showingChooser = true;
        private WizardDescriptor.InstantiatingIterator iterator;
        private HashMap iterators = new HashMap();

        public void addChangeListener(ChangeListener changeListener) {
        }

        public WizardDescriptor.Panel current() {
            if (this.showingChooser) {
                return this.wd.getChooser();
            }
            if (this.iterator != null) {
                return this.iterator.current();
            }
            return null;
        }

        public boolean hasNext() {
            if (this.showingChooser) {
                return true;
            }
            if (this.iterator != null) {
                return this.iterator.hasNext();
            }
            return false;
        }

        public boolean hasPrevious() {
            return !this.showingChooser;
        }

        public String name() {
            return null;
        }

        public void nextPanel() {
            if (this.iterator == null) {
                this.iterator = this.getServerIterator();
            } else if (!this.showingChooser) {
                this.iterator.nextPanel();
            }
            this.showingChooser = false;
        }

        public void previousPanel() {
            if (this.iterator.hasPrevious()) {
                this.iterator.previousPanel();
            } else {
                this.showingChooser = true;
                this.iterator = null;
            }
        }

        public void removeChangeListener(ChangeListener changeListener) {
        }

        public void uninitialize(WizardDescriptor wizardDescriptor) {
        }

        public void initialize(WizardDescriptor wizardDescriptor) {
            this.wd = (AddServerInstanceWizard)wizardDescriptor;
            JComponent jComponent = (JComponent)this.wd.getChooser().getComponent();
            jComponent.putClientProperty(AddServerInstanceWizard.PROP_CONTENT_DATA, new String[]{NbBundle.getMessage(AddServerInstanceWizard.class, (String)"LBL_ASIW_ChooseServer"), NbBundle.getMessage(AddServerInstanceWizard.class, (String)"LBL_ASIW_Ellipsis")});
        }

        public Set instantiate() throws IOException {
            if (this.iterator != null) {
                return this.iterator.instantiate();
            }
            return null;
        }

        private WizardDescriptor.InstantiatingIterator getServerIterator() {
            Server server = this.getSelectedServer();
            if (server == null) {
                return null;
            }
            WizardDescriptor.InstantiatingIterator instantiatingIterator = (WizardDescriptor.InstantiatingIterator)this.iterators.get(server);
            if (instantiatingIterator != null) {
                return instantiatingIterator;
            }
            OptionalDeploymentManagerFactory optionalDeploymentManagerFactory = server.getOptionalFactory();
            if (optionalDeploymentManagerFactory != null) {
                instantiatingIterator = optionalDeploymentManagerFactory.getAddInstanceIterator();
                instantiatingIterator.initialize((WizardDescriptor)this.wd);
                this.iterators.put(server, instantiatingIterator);
                return instantiatingIterator;
            }
            return null;
        }

        public Server getSelectedServer() {
            return (Server)this.wd.getProperty(AddServerInstanceWizard.PROP_SERVER);
        }
    }
}

