/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.editor.javadoc;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.ExecutableMemberDoc;
import com.sun.javadoc.MemberDoc;
import com.sun.javadoc.Parameter;
import com.sun.javadoc.ProgramElementDoc;
import com.sun.javadoc.Tag;
import com.sun.javadoc.Type;
import com.sun.source.tree.Scope;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.swing.text.Document;
import org.netbeans.api.java.lexer.JavadocTokenId;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.editor.java.JavaCompletionItem;
import org.netbeans.modules.editor.java.LazyTypeCompletionItem;
import org.netbeans.modules.editor.java.Utilities;
import org.netbeans.modules.java.editor.javadoc.DocPositions;
import org.netbeans.modules.java.editor.javadoc.JavaReference;
import org.netbeans.modules.java.editor.javadoc.JavadocCompletionItem;
import org.netbeans.modules.java.editor.javadoc.JavadocCompletionProvider;
import org.netbeans.modules.java.editor.javadoc.JavadocCompletionUtils;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.netbeans.spi.editor.completion.CompletionResultSet;
import org.netbeans.spi.editor.completion.support.AsyncCompletionQuery;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class JavadocCompletionQuery
extends AsyncCompletionQuery {
    private static final String CLASS_KEYWORD = "class";
    private final int queryType;
    private int caretOffset;
    private List<CompletionItem> items;
    private boolean hasAdditionalItems;

    public JavadocCompletionQuery(int n) {
        this.queryType = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void query(CompletionResultSet completionResultSet, Document document, int n) {
        try {
            this.queryImpl(completionResultSet, document, n);
        }
        catch (InterruptedException interruptedException) {
            Exceptions.printStackTrace((Throwable)interruptedException);
        }
        catch (ExecutionException executionException) {
            Exceptions.printStackTrace((Throwable)executionException);
        }
        finally {
            completionResultSet.finish();
        }
    }

    private void queryImpl(CompletionResultSet completionResultSet, Document document, int n) throws InterruptedException, ExecutionException {
        if (!JavadocCompletionUtils.isJavadocContext(document, n)) {
            return;
        }
        JavadocContext javadocContext = new JavadocContext();
        this.items = new ArrayList<CompletionItem>();
        this.caretOffset = n;
        Future<Void> future = this.runInJavac(JavaSource.forDocument((Document)document), javadocContext);
        if (future != null && !future.isDone()) {
            completionResultSet.setWaitText(NbBundle.getMessage(JavadocCompletionProvider.class, (String)"scanning-in-progress"));
            future.get();
        }
        if (this.isTaskCancelled()) {
            return;
        }
        if ((this.queryType & 1) != 0) {
            if (!this.items.isEmpty()) {
                completionResultSet.addAllItems(this.items);
            }
            completionResultSet.setHasAdditionalItems(this.hasAdditionalItems);
        }
        if (javadocContext.anchorOffset >= 0) {
            completionResultSet.setAnchorOffset(javadocContext.anchorOffset);
        }
    }

    private Future<Void> runInJavac(JavaSource javaSource, final JavadocContext javadocContext) {
        try {
            if (javaSource == null) {
                return null;
            }
            return javaSource.runWhenScanFinished((Task)new Task<CompilationController>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run(CompilationController compilationController) throws Exception {
                    compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                    if (JavadocCompletionQuery.this.isTaskCancelled()) {
                        return;
                    }
                    try {
                        javadocContext.javac = compilationController;
                        if (JavadocCompletionQuery.this.resolveContext((CompilationInfo)compilationController, javadocContext)) {
                            JavadocCompletionQuery.this.analyzeContext(javadocContext);
                        }
                    }
                    finally {
                        javadocContext.javac = null;
                    }
                }
            }, true);
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
            return null;
        }
    }

    private boolean resolveContext(CompilationInfo compilationInfo, JavadocContext javadocContext) throws IOException {
        javadocContext.doc = compilationInfo.getDocument();
        Doc doc = JavadocCompletionUtils.findJavadoc(compilationInfo, javadocContext.doc, this.caretOffset);
        if (doc == null) {
            return false;
        }
        javadocContext.jdoc = doc;
        Element element = compilationInfo.getElementUtilities().elementFor(doc);
        if (element == null) {
            return false;
        }
        javadocContext.handle = ElementHandle.create((Element)element);
        javadocContext.jdts = JavadocCompletionUtils.findJavadocTokenSequence(compilationInfo, this.caretOffset);
        if (javadocContext.jdts == null) {
            return false;
        }
        javadocContext.positions = DocPositions.get(compilationInfo, doc, javadocContext.jdts);
        return javadocContext.positions != null;
    }

    private void analyzeContext(JavadocContext javadocContext) {
        TokenSequence<JavadocTokenId> tokenSequence = javadocContext.jdts;
        if (tokenSequence == null) {
            return;
        }
        tokenSequence.move(this.caretOffset);
        if (!tokenSequence.moveNext() && !tokenSequence.movePrevious()) {
            return;
        }
        if (this.caretOffset - tokenSequence.offset() == 0) {
            tokenSequence.movePrevious();
        }
        switch ((JavadocTokenId)tokenSequence.token().id()) {
            case TAG: {
                this.resolveTagToken(javadocContext);
                break;
            }
            case IDENT: {
                this.resolveIdent(javadocContext);
                break;
            }
            case DOT: {
                this.resolveDotToken(javadocContext);
                break;
            }
            case HASH: {
                this.resolveHashToken(javadocContext);
                break;
            }
            case OTHER_TEXT: {
                this.resolveOtherText(javadocContext, tokenSequence);
                break;
            }
            case HTML_TAG: {
                this.resolveHTMLToken(javadocContext);
            }
        }
    }

    void resolveTagToken(JavadocContext javadocContext) {
        assert (javadocContext.jdts.token() != null);
        assert (javadocContext.jdts.token().id() == JavadocTokenId.TAG);
        Tag tag = javadocContext.positions.getTag(this.caretOffset);
        if (tag == null) {
            return;
        }
        if (JavadocCompletionUtils.isBlockTag(tag)) {
            this.resolveBlockTag(tag, javadocContext);
        } else {
            this.resolveInlineTag(tag, javadocContext);
        }
    }

    void resolveBlockTag(Tag tag, JavadocContext javadocContext) {
        int n;
        String string;
        if (tag != null) {
            int[] nArray = javadocContext.positions.getTagSpan(tag);
            string = ((Object)JavadocCompletionUtils.getCharSequence(javadocContext.doc, nArray[0], this.caretOffset)).toString();
            n = nArray[0];
        } else {
            string = "";
            n = this.caretOffset;
        }
        this.items.addAll(JavadocCompletionItem.addBlockTagItems(javadocContext.jdoc, javadocContext.handle.getKind(), string, n));
        javadocContext.anchorOffset = n;
    }

    void resolveInlineTag(Tag tag, JavadocContext javadocContext) {
        String string;
        int n;
        if (tag != null) {
            int[] nArray = javadocContext.positions.getTagSpan(tag);
            n = nArray[0] + 1;
            string = ((Object)JavadocCompletionUtils.getCharSequence(javadocContext.doc, n, this.caretOffset)).toString();
            javadocContext.anchorOffset = n;
        } else {
            n = this.caretOffset;
            string = "";
            javadocContext.anchorOffset = n;
        }
        this.items.addAll(JavadocCompletionItem.addInlineTagItems(javadocContext.jdoc, javadocContext.handle.getKind(), string, n));
    }

    void resolveIdent(JavadocContext javadocContext) {
        TokenSequence<JavadocTokenId> tokenSequence = javadocContext.jdts;
        assert (tokenSequence.token() != null);
        assert (tokenSequence.token().id() == JavadocTokenId.IDENT);
        Tag tag = javadocContext.positions.getTag(this.caretOffset);
        if (tag != null) {
            this.insideTag(tag, javadocContext);
        }
    }

    void resolveDotToken(JavadocContext javadocContext) {
        assert (javadocContext.jdts.token() != null);
        assert (javadocContext.jdts.token().id() == JavadocTokenId.DOT);
        Tag tag = javadocContext.positions.getTag(this.caretOffset);
        if (tag != null) {
            this.insideTag(tag, javadocContext);
        }
    }

    void resolveHashToken(JavadocContext javadocContext) {
        assert (javadocContext.jdts.token() != null);
        assert (javadocContext.jdts.token().id() == JavadocTokenId.HASH);
        Tag tag = javadocContext.positions.getTag(this.caretOffset);
        if (tag != null) {
            this.insideTag(tag, javadocContext);
        }
    }

    void resolveHTMLToken(JavadocContext javadocContext) {
        assert (javadocContext.jdts.token() != null);
        assert (javadocContext.jdts.token().id() == JavadocTokenId.HTML_TAG);
        Tag tag = javadocContext.positions.getTag(this.caretOffset);
        if (tag != null && "@param".equals(tag.name())) {
            this.insideParamTag(tag, javadocContext);
        }
    }

    private void insideTag(Tag tag, JavadocContext javadocContext) {
        String string = tag.kind();
        if ("@param".equals(string)) {
            this.insideParamTag(tag, javadocContext);
        } else if ("@see".equals(string) || "@throws".equals(string) || "@value".equals(string) || "@UnclosedInlineTag" == string && ("@link".equals(tag.name()) || "@linkplain".equals(tag.name()) || "@value".equals(tag.name()))) {
            this.insideSeeTag(tag, javadocContext);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void insideSeeTag(Tag tag, JavadocContext javadocContext) {
        CharSequence charSequence;
        TokenSequence<JavadocTokenId> tokenSequence = javadocContext.jdts;
        assert (tokenSequence.token() != null);
        int[] nArray = javadocContext.positions.getTagSpan(tag);
        boolean bl = "@throws".equals(tag.kind());
        if (bl && !javadocContext.jdoc.isMethod() && !javadocContext.jdoc.isConstructor()) {
            return;
        }
        tokenSequence.move(nArray[0] + (JavadocCompletionUtils.isBlockTag(tag) ? 0 : 1));
        if (!tokenSequence.moveNext() || this.caretOffset <= tokenSequence.offset() + tokenSequence.token().length()) {
            return;
        }
        if (!tokenSequence.moveNext() || this.caretOffset <= tokenSequence.offset()) {
            return;
        }
        boolean bl2 = false;
        if (this.caretOffset <= tokenSequence.offset() + tokenSequence.token().length()) {
            int n = this.caretOffset - tokenSequence.offset();
            CharSequence charSequence2 = charSequence = n < (charSequence = tokenSequence.token().text()).length() ? charSequence.subSequence(0, n) : charSequence;
            if (!JavadocCompletionUtils.isWhiteSpace(charSequence) && !JavadocCompletionUtils.isLineBreak((Token<JavadocTokenId>)tokenSequence.token(), n)) return;
            bl2 = true;
        } else if (!JavadocCompletionUtils.isWhiteSpace((Token<JavadocTokenId>)tokenSequence.token()) && !JavadocCompletionUtils.isLineBreak((Token<JavadocTokenId>)tokenSequence.token())) {
            return;
        }
        if (bl2) {
            if (bl) {
                this.completeThrowsOrPkg(null, "", this.caretOffset, javadocContext);
            } else {
                this.completeClassOrPkg(null, "", this.caretOffset, javadocContext);
            }
            javadocContext.anchorOffset = this.caretOffset;
            return;
        }
        tokenSequence.moveNext();
        JavaReference javaReference = JavaReference.resolve(javadocContext.jdts, tokenSequence.offset(), nArray[1]);
        if (!javaReference.isReference() || this.caretOffset > javaReference.end) return;
        charSequence = JavadocCompletionUtils.getCharSequence(javadocContext.doc, javaReference.begin, this.caretOffset);
        StringBuilder stringBuilder = new StringBuilder();
        javadocContext.anchorOffset = javaReference.begin;
        for (int i = charSequence.length() - 1; i >= 0; --i) {
            char c = charSequence.charAt(i);
            if (c == '#') {
                String string = stringBuilder.toString();
                String string2 = javaReference.fqn == null ? null : ((Object)javaReference.fqn).toString();
                int n = this.caretOffset - stringBuilder.length();
                this.completeClassMember(string2, string, n, javadocContext);
                return;
            }
            if (c == '.') {
                String string = stringBuilder.toString();
                String string3 = ((Object)charSequence.subSequence(0, i)).toString();
                int n = this.caretOffset - stringBuilder.length();
                if (bl) {
                    this.completeThrowsOrPkg(string3, string, n, javadocContext);
                    return;
                } else {
                    this.completeClassOrPkg(string3, string, n, javadocContext);
                }
                return;
            }
            stringBuilder.insert(0, c);
        }
        String string = stringBuilder.toString();
        String string4 = null;
        int n = this.caretOffset - stringBuilder.length();
        if (bl) {
            this.completeThrowsOrPkg(string4, string, n, javadocContext);
            return;
        } else {
            this.completeClassOrPkg(string4, string, n, javadocContext);
        }
    }

    private void insideParamTag(Tag tag, JavadocContext javadocContext) {
        TokenSequence<JavadocTokenId> tokenSequence = javadocContext.jdts;
        assert (tokenSequence.token() != null);
        int[] nArray = javadocContext.positions.getTagSpan(tag);
        tokenSequence.move(nArray[0]);
        if (!tokenSequence.moveNext() || this.caretOffset <= tokenSequence.offset() + tokenSequence.token().length()) {
            return;
        }
        if (!tokenSequence.moveNext() || this.caretOffset <= tokenSequence.offset()) {
            return;
        }
        if (this.caretOffset <= tokenSequence.offset() + tokenSequence.token().length()) {
            CharSequence charSequence;
            int n = this.caretOffset - tokenSequence.offset();
            CharSequence charSequence2 = charSequence = n < (charSequence = tokenSequence.token().text()).length() ? charSequence.subSequence(0, n) : charSequence;
            if (JavadocCompletionUtils.isWhiteSpace(charSequence) || JavadocCompletionUtils.isLineBreak((Token<JavadocTokenId>)tokenSequence.token(), n)) {
                javadocContext.anchorOffset = this.caretOffset;
                this.completeParamName(tag, "", this.caretOffset, javadocContext);
                return;
            }
            return;
        }
        tokenSequence.moveNext();
        if (tokenSequence.token().id() != JavadocTokenId.IDENT && tokenSequence.token().id() != JavadocTokenId.HTML_TAG) {
            return;
        }
        if (this.caretOffset <= tokenSequence.offset() + tokenSequence.token().length()) {
            CharSequence charSequence = tokenSequence.token().text().subSequence(0, this.caretOffset - tokenSequence.offset());
            javadocContext.anchorOffset = tokenSequence.offset();
            this.completeParamName(tag, ((Object)charSequence).toString(), tokenSequence.offset(), javadocContext);
            return;
        }
    }

    private void completeParamName(Tag tag, String string, int n, JavadocContext javadocContext) {
        if (javadocContext.jdoc.isMethod() || javadocContext.jdoc.isConstructor()) {
            ExecutableMemberDoc executableMemberDoc = (ExecutableMemberDoc)javadocContext.jdoc;
            Parameter[] parameterArray = executableMemberDoc.parameters();
            for (int i = 0; i < parameterArray.length; ++i) {
                Parameter parameter = parameterArray[i];
                if (!parameter.name().startsWith(string)) continue;
                this.items.add(JavadocCompletionItem.createNameItem(parameter.name(), n));
            }
            this.completeTypeVarName((Doc)executableMemberDoc, string, n);
        } else if (javadocContext.jdoc.isClass()) {
            this.completeTypeVarName(javadocContext.jdoc, string, n);
        }
    }

    private void completeTypeVarName(Doc doc, String string, int n) {
        com.sun.javadoc.TypeVariable[] typeVariableArray;
        if (string.length() > 0) {
            if (string.charAt(0) == '<') {
                string = string.substring(1, string.length());
            } else {
                return;
            }
        }
        for (com.sun.javadoc.TypeVariable typeVariable : typeVariableArray = doc.isClass() ? ((ClassDoc)doc).typeParameters() : ((ExecutableMemberDoc)doc).typeParameters()) {
            if (!typeVariable.simpleTypeName().startsWith(string)) continue;
            this.items.add(JavadocCompletionItem.createNameItem('<' + typeVariable.simpleTypeName() + '>', n));
        }
    }

    private void completeClassOrPkg(String string, String string2, int n, JavadocContext javadocContext) {
        String string3;
        if (string == null) {
            string3 = string2;
            this.addTypes(EnumSet.of(ElementKind.CLASS, ElementKind.INTERFACE, ElementKind.ENUM, ElementKind.ANNOTATION_TYPE), null, null, string2, n, javadocContext);
        } else {
            Object object;
            string3 = string + '.' + string2;
            PackageElement packageElement = javadocContext.javac.getElements().getPackageElement(string);
            if (packageElement != null) {
                this.addPackageContent(packageElement, EnumSet.of(ElementKind.CLASS, ElementKind.INTERFACE, ElementKind.ENUM, ElementKind.ANNOTATION_TYPE), null, string2, n, javadocContext);
            }
            if ((object = javadocContext.javac.getElements().getTypeElement(string)) != null) {
                this.addInnerClasses((TypeElement)object, EnumSet.of(ElementKind.CLASS, ElementKind.INTERFACE, ElementKind.ENUM, ElementKind.ANNOTATION_TYPE), null, string2, n, javadocContext);
            }
        }
        for (Object object : javadocContext.javac.getClasspathInfo().getClassIndex().getPackageNames(string3, true, EnumSet.allOf(ClassIndex.SearchScope.class))) {
            if (((String)object).length() <= 0) continue;
            this.items.add(JavaCompletionItem.createPackageItem((String)object, n, false));
        }
    }

    private void completeThrowsOrPkg(String string, String string2, int n, JavadocContext javadocContext) {
        PackageElement packageElement;
        String string3;
        Elements elements = javadocContext.javac.getElements();
        if (string == null) {
            string3 = string2;
            this.addTypes(EnumSet.of(ElementKind.CLASS), JavadocCompletionQuery.findDeclaredType("java.lang.RuntimeException", elements), null, string2, n, javadocContext);
        } else {
            Object object;
            string3 = string + '.' + string2;
            packageElement = elements.getPackageElement(string);
            if (packageElement != null) {
                this.addPackageContent(packageElement, EnumSet.of(ElementKind.CLASS), JavadocCompletionQuery.findDeclaredType("java.lang.RuntimeException", elements), string2, n, javadocContext);
            }
            if ((object = elements.getTypeElement(string)) != null) {
                this.addInnerClasses((TypeElement)object, EnumSet.of(ElementKind.CLASS), JavadocCompletionQuery.findDeclaredType("java.lang.RuntimeException", elements), string2, n, javadocContext);
            }
        }
        packageElement = (ExecutableMemberDoc)javadocContext.jdoc;
        for (Type type : packageElement.thrownExceptionTypes()) {
            String string4;
            TypeElement typeElement;
            String string5 = type.typeName();
            if (!string5.startsWith(string2) || (typeElement = elements.getTypeElement(string4 = type.qualifiedTypeName())) == null) continue;
            this.items.add(JavaCompletionItem.createTypeItem(typeElement, (DeclaredType)typeElement.asType(), n, string5 != string4, elements.isDeprecated(typeElement), false, true));
        }
        for (String string6 : javadocContext.javac.getClasspathInfo().getClassIndex().getPackageNames(string3, true, EnumSet.allOf(ClassIndex.SearchScope.class))) {
            if (string6.length() <= 0) continue;
            this.items.add(JavaCompletionItem.createPackageItem(string6, n, false));
        }
    }

    private static DeclaredType findDeclaredType(CharSequence charSequence, Elements elements) {
        TypeMirror typeMirror;
        TypeElement typeElement = elements.getTypeElement(charSequence);
        if (typeElement != null && (typeMirror = typeElement.asType()).getKind() == TypeKind.DECLARED) {
            return (DeclaredType)typeMirror;
        }
        return null;
    }

    private void completeClassMember(String string, String string2, int n, JavadocContext javadocContext) {
        TypeElement typeElement;
        if (string == null) {
            typeElement = null;
            this.addLocalMembersAndVars(javadocContext, string2, n);
        } else {
            typeElement = JavadocCompletionQuery.lookAroundForClass(javadocContext.jdoc, string, javadocContext.javac.getElements());
        }
        if (typeElement != null) {
            this.addMembers(javadocContext, string2, n, typeElement.asType(), typeElement, EnumSet.of(ElementKind.ENUM_CONSTANT, ElementKind.FIELD, ElementKind.METHOD, ElementKind.CONSTRUCTOR), null);
        }
    }

    private static TypeElement lookAroundForClass(Doc doc, String string, Elements elements) {
        ClassDoc classDoc;
        ClassDoc classDoc2 = null;
        if (doc instanceof MemberDoc) {
            classDoc2 = ((ProgramElementDoc)doc).containingClass();
        } else if (doc instanceof ClassDoc) {
            classDoc2 = (ClassDoc)doc;
        }
        if (classDoc2 != null && (classDoc = classDoc2.findClass(string)) != null) {
            return elements.getTypeElement(classDoc.qualifiedName());
        }
        return null;
    }

    private void addMembers(JavadocContext javadocContext, final String string, int n, TypeMirror typeMirror, final Element element, EnumSet<ElementKind> enumSet, DeclaredType declaredType) {
        Object var8_8 = null;
        CompilationInfo compilationInfo = javadocContext.javac;
        Trees trees = compilationInfo.getTrees();
        final Elements elements = compilationInfo.getElements();
        Types types = compilationInfo.getTypes();
        final TreeUtilities treeUtilities = compilationInfo.getTreeUtilities();
        TypeElement typeElement = typeMirror.getKind() == TypeKind.DECLARED ? (TypeElement)((DeclaredType)typeMirror).asElement() : null;
        Element element2 = javadocContext.handle.resolve(compilationInfo);
        TreePath treePath = trees.getPath(element2);
        final Scope scope = trees.getScope(treePath);
        final boolean[] blArray = new boolean[]{false};
        TypeElement typeElement2 = scope.getEnclosingClass();
        TypeMirror typeMirror2 = typeElement2 != null ? typeElement2.asType() : null;
        ElementUtilities.ElementAcceptor elementAcceptor = new ElementUtilities.ElementAcceptor(){

            public boolean accept(Element element2, TypeMirror typeMirror) {
                switch (element2.getKind()) {
                    case FIELD: {
                        String string2 = element2.getSimpleName().toString();
                        return Utilities.startsWith(string2, string) && !JavadocCompletionQuery.CLASS_KEYWORD.equals(string2) && (Utilities.isShowDeprecatedMembers() || !elements.isDeprecated(element2));
                    }
                    case ENUM_CONSTANT: {
                        return Utilities.startsWith(element2.getSimpleName().toString(), string) && (Utilities.isShowDeprecatedMembers() || !elements.isDeprecated(element2)) && treeUtilities.isAccessible(scope, element2, typeMirror);
                    }
                    case METHOD: {
                        return Utilities.startsWith(element2.getSimpleName().toString(), string) && (Utilities.isShowDeprecatedMembers() || !elements.isDeprecated(element2));
                    }
                    case CONSTRUCTOR: {
                        blArray[0] = true;
                        return (Utilities.isShowDeprecatedMembers() || !elements.isDeprecated(element2)) && (treeUtilities.isAccessible(scope, element2, typeMirror) || element.getModifiers().contains((Object)Modifier.ABSTRACT) && !element2.getModifiers().contains((Object)Modifier.PRIVATE));
                    }
                }
                return false;
            }
        };
        for (Element element3 : compilationInfo.getElementUtilities().getMembers(typeMirror, elementAcceptor)) {
            switch (element3.getKind()) {
                case FIELD: 
                case ENUM_CONSTANT: {
                    TypeMirror typeMirror3 = typeMirror.getKind() == TypeKind.DECLARED ? types.asMemberOf((DeclaredType)typeMirror, element3) : element3.asType();
                    this.items.add(JavaCompletionItem.createVariableItem((VariableElement)element3, typeMirror3, n, typeElement != element3.getEnclosingElement(), elements.isDeprecated(element3), false));
                    break;
                }
                case METHOD: 
                case CONSTRUCTOR: {
                    ExecutableType executableType = (ExecutableType)(typeMirror.getKind() == TypeKind.DECLARED ? types.asMemberOf((DeclaredType)typeMirror, element3) : element3.asType());
                    this.items.add(JavadocCompletionItem.createExecutableItem((ExecutableElement)element3, executableType, n, typeElement != element3.getEnclosingElement(), elements.isDeprecated(element3)));
                }
            }
        }
        if (!blArray[0] && enumSet.contains((Object)ElementKind.CONSTRUCTOR) && element.getKind().isInterface()) {
            this.items.add(JavaCompletionItem.createDefaultConstructorItem((TypeElement)element, n, false));
        }
    }

    private void addLocalMembersAndVars(JavadocContext javadocContext, final String string, int n) {
        CompilationInfo compilationInfo = javadocContext.javac;
        final Elements elements = compilationInfo.getElements();
        Types types = compilationInfo.getTypes();
        final TreeUtilities treeUtilities = compilationInfo.getTreeUtilities();
        Trees trees = compilationInfo.getTrees();
        Element element = javadocContext.handle.resolve(compilationInfo);
        TreePath treePath = trees.getPath(element);
        final Scope scope = trees.getScope(treePath);
        Object var12_12 = null;
        TypeElement typeElement = scope.getEnclosingClass();
        ExecutableElement executableElement = scope.getEnclosingMethod();
        ElementUtilities.ElementAcceptor elementAcceptor = new ElementUtilities.ElementAcceptor(){

            public boolean accept(Element element, TypeMirror typeMirror) {
                switch (element.getKind()) {
                    case CONSTRUCTOR: {
                        return false;
                    }
                    case FIELD: {
                        String string2 = element.getSimpleName().toString();
                        return Utilities.startsWith(string2, string) && !JavadocCompletionQuery.CLASS_KEYWORD.equals(string2) && (Utilities.isShowDeprecatedMembers() || !elements.isDeprecated(element));
                    }
                    case ENUM_CONSTANT: {
                        return Utilities.startsWith(element.getSimpleName().toString(), string) && (Utilities.isShowDeprecatedMembers() || !elements.isDeprecated(element)) && treeUtilities.isAccessible(scope, element, typeMirror);
                    }
                    case METHOD: {
                        return Utilities.startsWith(element.getSimpleName().toString(), string) && (Utilities.isShowDeprecatedMembers() || !elements.isDeprecated(element)) && treeUtilities.isAccessible(scope, element, typeMirror);
                    }
                }
                return false;
            }
        };
        for (Element element2 : compilationInfo.getElementUtilities().getLocalMembersAndVars(scope, elementAcceptor)) {
            switch (element2.getKind()) {
                case ENUM_CONSTANT: {
                    this.items.add(JavaCompletionItem.createVariableItem((VariableElement)element2, element2.asType(), n, scope.getEnclosingClass() != element2.getEnclosingElement(), elements.isDeprecated(element2), false));
                    break;
                }
                case FIELD: {
                    String string2 = element2.getSimpleName().toString();
                    TypeMirror typeMirror = JavadocCompletionQuery.asMemberOf(element2, typeElement != null ? typeElement.asType() : null, types);
                    this.items.add(JavaCompletionItem.createVariableItem((VariableElement)element2, typeMirror, n, scope.getEnclosingClass() != element2.getEnclosingElement(), elements.isDeprecated(element2), false));
                    break;
                }
                case METHOD: {
                    ExecutableType executableType = (ExecutableType)JavadocCompletionQuery.asMemberOf(element2, typeElement != null ? typeElement.asType() : null, types);
                    this.items.add(JavadocCompletionItem.createExecutableItem((ExecutableElement)element2, executableType, n, scope.getEnclosingClass() != element2.getEnclosingElement(), elements.isDeprecated(element2)));
                }
            }
        }
    }

    private static TypeMirror asMemberOf(Element element, TypeMirror typeMirror, Types types) {
        TypeMirror typeMirror2 = element.asType();
        TypeMirror typeMirror3 = element.getEnclosingElement().asType();
        if (typeMirror3.getKind() == TypeKind.DECLARED) {
            typeMirror3 = types.erasure(typeMirror3);
        }
        while (typeMirror != null && typeMirror.getKind() == TypeKind.DECLARED) {
            if (types.isSubtype(typeMirror, typeMirror3)) {
                typeMirror2 = types.asMemberOf((DeclaredType)typeMirror, element);
                break;
            }
            typeMirror = ((DeclaredType)typeMirror).getEnclosingType();
        }
        return typeMirror2;
    }

    private void addTypes(EnumSet<ElementKind> enumSet, DeclaredType declaredType, Set<? extends Element> set, String string, int n, JavadocContext javadocContext) {
        if (this.queryType == 9) {
            if (declaredType == null) {
                this.addAllTypes(javadocContext, enumSet, string, n);
            } else {
                Elements elements = javadocContext.javac.getElements();
                for (DeclaredType declaredType2 : this.getSubtypesOf(declaredType, string, javadocContext)) {
                    TypeElement typeElement = (TypeElement)declaredType2.asElement();
                    if (!Utilities.isShowDeprecatedMembers() && elements.isDeprecated(typeElement)) continue;
                    this.items.add(JavaCompletionItem.createTypeItem(typeElement, declaredType2, n, true, elements.isDeprecated(typeElement), false, false));
                }
            }
        } else {
            this.addLocalAndImportedTypes(javadocContext, enumSet, declaredType, set, string, n);
            this.hasAdditionalItems = true;
        }
    }

    private void addLocalAndImportedTypes(JavadocContext javadocContext, final EnumSet<ElementKind> enumSet, final DeclaredType declaredType, final Set<? extends Element> set, final String string, int n) {
        CompilationInfo compilationInfo = javadocContext.javac;
        final Trees trees = compilationInfo.getTrees();
        final Elements elements = compilationInfo.getElements();
        final Types types = compilationInfo.getTypes();
        TreeUtilities treeUtilities = compilationInfo.getTreeUtilities();
        Element element = javadocContext.handle.resolve(compilationInfo);
        TreePath treePath = trees.getPath(element);
        final Scope scope = trees.getScope(treePath);
        TypeElement typeElement = scope.getEnclosingClass();
        final boolean bl = typeElement == null ? false : treeUtilities.isStaticContext(scope);
        Object object = new ElementUtilities.ElementAcceptor(){

            public boolean accept(Element element, TypeMirror typeMirror) {
                if (!(set != null && set.contains(element) || !element.getKind().isClass() && !element.getKind().isInterface() && element.getKind() != ElementKind.TYPE_PARAMETER)) {
                    String string2 = element.getSimpleName().toString();
                    return !(string2.length() <= 0 || Character.isDigit(string2.charAt(0)) || !JavadocCompletionQuery.this.startsWith(string2, string) || bl && !element.getModifiers().contains((Object)Modifier.STATIC) || !Utilities.isShowDeprecatedMembers() && elements.isDeprecated(element) || !JavadocCompletionQuery.this.isOfKindAndType(element.asType(), element, enumSet, declaredType, scope, trees, types));
                }
                return false;
            }
        };
        for (Element element2 : compilationInfo.getElementUtilities().getLocalMembersAndVars(scope, object)) {
            switch (element2.getKind()) {
                case CLASS: 
                case ENUM: 
                case INTERFACE: 
                case ANNOTATION_TYPE: {
                    this.items.add(JavadocCompletionItem.createTypeItem((TypeElement)element2, n, false, elements.isDeprecated(element2)));
                }
            }
        }
        object = new ElementUtilities.ElementAcceptor(){

            public boolean accept(Element element, TypeMirror typeMirror) {
                if (element.getKind().isClass() || element.getKind().isInterface()) {
                    return !(set != null && set.contains(element) || !JavadocCompletionQuery.this.startsWith(element.getSimpleName().toString(), string) || !Utilities.isShowDeprecatedMembers() && elements.isDeprecated(element) || !trees.isAccessible(scope, (TypeElement)element) || !JavadocCompletionQuery.this.isOfKindAndType(element.asType(), element, enumSet, declaredType, scope, trees, types));
                }
                return false;
            }
        };
        for (Element element2 : compilationInfo.getElementUtilities().getGlobalTypes(object)) {
            this.items.add(JavadocCompletionItem.createTypeItem((TypeElement)element2, n, false, elements.isDeprecated(element2)));
        }
    }

    private void addAllTypes(JavadocContext javadocContext, EnumSet<ElementKind> enumSet, String string, int n) {
        CompilationInfo compilationInfo = javadocContext.javac;
        boolean bl = false;
        ClassIndex.NameKind nameKind = bl ? ClassIndex.NameKind.PREFIX : ClassIndex.NameKind.CASE_INSENSITIVE_PREFIX;
        for (ElementHandle elementHandle : compilationInfo.getJavaSource().getClasspathInfo().getClassIndex().getDeclaredTypes(string, nameKind, EnumSet.allOf(ClassIndex.SearchScope.class))) {
            LazyTypeCompletionItem lazyTypeCompletionItem = LazyTypeCompletionItem.create((ElementHandle<TypeElement>)elementHandle, enumSet, n, compilationInfo.getJavaSource(), false);
            this.items.add(lazyTypeCompletionItem);
        }
    }

    private void addInnerClasses(TypeElement typeElement, EnumSet<ElementKind> enumSet, DeclaredType declaredType, String string, int n, JavadocContext javadocContext) {
        CompilationInfo compilationInfo = javadocContext.javac;
        Element element = javadocContext.handle.resolve(compilationInfo);
        Elements elements = compilationInfo.getElements();
        Types types = compilationInfo.getTypes();
        Trees trees = compilationInfo.getTrees();
        Scope scope = trees.getScope(trees.getPath(element));
        for (Element element2 : compilationInfo.getElementUtilities().getMembers(typeElement.asType(), null)) {
            String string2;
            if (!element2.getKind().isClass() && !element2.getKind().isInterface() || !Utilities.startsWith(string2 = element2.getSimpleName().toString(), string) || !Utilities.isShowDeprecatedMembers() && elements.isDeprecated(element2) || !trees.isAccessible(scope, (TypeElement)element2) || !this.isOfKindAndType(element2.asType(), element2, enumSet, declaredType, scope, trees, types)) continue;
            this.items.add(JavadocCompletionItem.createTypeItem((TypeElement)element2, n, false, elements.isDeprecated(element2)));
        }
    }

    private void addPackageContent(PackageElement packageElement, EnumSet<ElementKind> enumSet, DeclaredType declaredType, String string, int n, JavadocContext javadocContext) {
        CompilationInfo compilationInfo = javadocContext.javac;
        Element element = javadocContext.handle.resolve(compilationInfo);
        Elements elements = compilationInfo.getElements();
        Types types = compilationInfo.getTypes();
        Trees trees = compilationInfo.getTrees();
        Scope scope = trees.getScope(trees.getPath(element));
        for (Element element2 : packageElement.getEnclosedElements()) {
            String string2;
            if (!element2.getKind().isClass() && !element2.getKind().isInterface() || !Utilities.startsWith(string2 = element2.getSimpleName().toString(), string) || !Utilities.isShowDeprecatedMembers() && elements.isDeprecated(element2) || !trees.isAccessible(scope, (TypeElement)element2) || !this.isOfKindAndType(element2.asType(), element2, enumSet, declaredType, scope, trees, types)) continue;
            this.items.add(JavadocCompletionItem.createTypeItem((TypeElement)element2, n, false, elements.isDeprecated(element2)));
        }
    }

    private boolean isOfKindAndType(TypeMirror typeMirror, Element element, EnumSet<ElementKind> enumSet, TypeMirror typeMirror2, Scope scope, Trees trees, Types types) {
        if (enumSet.contains((Object)element.getKind())) {
            if (typeMirror2 == null) {
                return true;
            }
            if (types.isSubtype(typeMirror, typeMirror2)) {
                return true;
            }
        }
        if ((element.getKind().isClass() || element.getKind().isInterface()) && (enumSet.contains((Object)ElementKind.ANNOTATION_TYPE) || enumSet.contains((Object)ElementKind.CLASS) || enumSet.contains((Object)ElementKind.ENUM) || enumSet.contains((Object)ElementKind.INTERFACE))) {
            DeclaredType declaredType = (DeclaredType)element.asType();
            for (Element element2 : element.getEnclosedElements()) {
                if (!trees.isAccessible(scope, element2, declaredType) || !this.isOfKindAndType(element2.asType(), element2, enumSet, typeMirror2, scope, trees, types)) continue;
                return true;
            }
        }
        return false;
    }

    private List<DeclaredType> getSubtypesOf(DeclaredType declaredType, String string, JavadocContext javadocContext) {
        if (((TypeElement)declaredType.asElement()).getQualifiedName().contentEquals("java.lang.Object")) {
            return Collections.emptyList();
        }
        LinkedList<DeclaredType> linkedList = new LinkedList<DeclaredType>();
        CompilationInfo compilationInfo = javadocContext.javac;
        Types types = compilationInfo.getTypes();
        Trees trees = compilationInfo.getTrees();
        Element element = javadocContext.handle.resolve(compilationInfo);
        Scope scope = trees.getScope(trees.getPath(element));
        if (string != null && string.length() > 2 && declaredType.getTypeArguments().isEmpty()) {
            ClassIndex.NameKind nameKind = Utilities.isCaseSensitive() ? ClassIndex.NameKind.PREFIX : ClassIndex.NameKind.CASE_INSENSITIVE_PREFIX;
            for (ElementHandle elementHandle : compilationInfo.getJavaSource().getClasspathInfo().getClassIndex().getDeclaredTypes(string, nameKind, EnumSet.allOf(ClassIndex.SearchScope.class))) {
                TypeElement typeElement = (TypeElement)elementHandle.resolve(compilationInfo);
                if (typeElement == null || !trees.isAccessible(scope, typeElement) || !types.isSubtype(types.getDeclaredType(typeElement, new TypeMirror[0]), declaredType)) continue;
                linkedList.add(types.getDeclaredType(typeElement, new TypeMirror[0]));
            }
        } else {
            HashSet<TypeElement> hashSet = new HashSet<TypeElement>();
            LinkedList<Object> linkedList2 = new LinkedList<Object>();
            linkedList2.add(declaredType);
            ClassIndex classIndex = compilationInfo.getJavaSource().getClasspathInfo().getClassIndex();
            while (!linkedList2.isEmpty()) {
                List<? extends TypeMirror> list;
                DeclaredType declaredType2 = (DeclaredType)linkedList2.remove();
                TypeElement typeElement = (TypeElement)declaredType2.asElement();
                if (!hashSet.add(typeElement)) continue;
                if (this.startsWith(typeElement.getSimpleName().toString(), string) && trees.isAccessible(scope, typeElement)) {
                    linkedList.add(declaredType2);
                }
                boolean bl = !(list = declaredType2.getTypeArguments()).iterator().hasNext();
                block2: for (ElementHandle elementHandle : classIndex.getElements(ElementHandle.create((Element)typeElement), EnumSet.of(ClassIndex.SearchKind.IMPLEMENTORS), EnumSet.allOf(ClassIndex.SearchScope.class))) {
                    TypeElement typeElement2 = (TypeElement)elementHandle.resolve(compilationInfo);
                    if (typeElement2 != null) {
                        Object object;
                        Object object2;
                        Object object3;
                        Object object4;
                        if (!trees.isAccessible(scope, typeElement2)) continue;
                        if (bl) {
                            object4 = types.getDeclaredType(typeElement2, new TypeMirror[0]);
                            linkedList2.add(object4);
                            continue;
                        }
                        object4 = new HashMap();
                        TypeMirror typeMirror = typeElement2.getSuperclass();
                        if (typeMirror.getKind() == TypeKind.DECLARED && ((DeclaredType)typeMirror).asElement() == typeElement) {
                            DeclaredType declaredType3 = (DeclaredType)typeMirror;
                            Iterator<? extends TypeMirror> iterator = list.iterator();
                            object3 = declaredType3.getTypeArguments().iterator();
                            while (object3.hasNext() && iterator.hasNext()) {
                                object2 = iterator.next();
                                if (object2 == (object = (TypeMirror)object3.next())) continue;
                                if (object.getKind() != TypeKind.TYPEVAR) continue block2;
                                ((HashMap)object4).put(((TypeVariable)object).asElement(), object2);
                            }
                            if (object3.hasNext() != iterator.hasNext()) {
                                continue;
                            }
                        } else {
                            for (TypeMirror typeMirror2 : typeElement2.getInterfaces()) {
                                if (((DeclaredType)typeMirror2).asElement() != typeElement) continue;
                                object3 = (DeclaredType)typeMirror2;
                                object2 = list.iterator();
                                object = object3.getTypeArguments().iterator();
                                while (object.hasNext() && object2.hasNext()) {
                                    TypeMirror typeMirror3;
                                    TypeMirror typeMirror4 = (TypeMirror)object2.next();
                                    if (typeMirror4 == (typeMirror3 = (TypeMirror)object.next())) continue;
                                    if (typeMirror3.getKind() != TypeKind.TYPEVAR) continue block2;
                                    ((HashMap)object4).put(((TypeVariable)typeMirror3).asElement(), typeMirror4);
                                }
                                if (object.hasNext() != object2.hasNext()) continue block2;
                            }
                        }
                        linkedList2.add(this.getDeclaredType(typeElement2, (HashMap<? extends Element, ? extends TypeMirror>)object4, types));
                        continue;
                    }
                    Logger.getLogger("global").log(Level.FINE, String.format("Cannot resolve: %s on bootpath: %s classpath: %s sourcepath: %s\n", elementHandle.toString(), compilationInfo.getClasspathInfo().getClassPath(ClasspathInfo.PathKind.BOOT), compilationInfo.getClasspathInfo().getClassPath(ClasspathInfo.PathKind.COMPILE), compilationInfo.getClasspathInfo().getClassPath(ClasspathInfo.PathKind.SOURCE)));
                }
            }
        }
        return linkedList;
    }

    private DeclaredType getDeclaredType(TypeElement typeElement, HashMap<? extends Element, ? extends TypeMirror> hashMap, Types types) {
        List<? extends TypeParameterElement> list = typeElement.getTypeParameters();
        TypeMirror[] typeMirrorArray = new TypeMirror[list.size()];
        int n = 0;
        for (TypeParameterElement typeParameterElement : list) {
            TypeMirror typeMirror = hashMap.get(typeParameterElement);
            typeMirrorArray[n++] = typeMirror != null ? typeMirror : typeParameterElement.asType();
        }
        Element element = typeElement.getEnclosingElement();
        if ((element.getKind().isClass() || element.getKind().isInterface()) && !((TypeElement)element).getTypeParameters().isEmpty()) {
            return types.getDeclaredType(this.getDeclaredType((TypeElement)element, hashMap, types), typeElement, typeMirrorArray);
        }
        return types.getDeclaredType(typeElement, typeMirrorArray);
    }

    private boolean startsWith(String string, String string2) {
        return Utilities.startsWith(string, string2);
    }

    void resolveOtherText(JavadocContext javadocContext, TokenSequence<JavadocTokenId> tokenSequence) {
        Token token = tokenSequence.token();
        assert (token != null);
        assert (token.id() == JavadocTokenId.OTHER_TEXT);
        CharSequence charSequence = token.text();
        int n = this.caretOffset - tokenSequence.offset();
        Tag tag = javadocContext.positions.getTag(this.caretOffset);
        if (n > 0 && n <= charSequence.length() && charSequence.charAt(n - 1) == '{') {
            int[] nArray;
            if (tag != null && !JavadocCompletionUtils.isBlockTag(tag) && (nArray = javadocContext.positions.getTagSpan(tag))[0] + 1 != this.caretOffset) {
                return;
            }
            this.resolveInlineTag(null, javadocContext);
            return;
        }
        if (tag != null) {
            this.insideTag(tag, javadocContext);
            if (JavadocCompletionUtils.isBlockTag(tag) && JavadocCompletionUtils.isLineBreak((Token<JavadocTokenId>)token, n)) {
                this.resolveBlockTag(null, javadocContext);
            }
        } else if (JavadocCompletionUtils.isLineBreak((Token<JavadocTokenId>)token, n)) {
            this.resolveBlockTag(null, javadocContext);
        }
    }

    static final class JavadocContext {
        int anchorOffset = -1;
        ElementHandle<Element> handle;
        Doc jdoc;
        DocPositions positions;
        TokenSequence<JavadocTokenId> jdts;
        Document doc;
        CompilationInfo javac;

        JavadocContext() {
        }
    }
}

