/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.editor;

import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.JTextComponent;
import javax.swing.text.View;
import org.netbeans.api.editor.EditorRegistry;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.view.spi.EstimatedSpanView;
import org.netbeans.editor.view.spi.LockView;
import org.netbeans.lib.editor.view.GapDocumentView;
import org.netbeans.modules.editor.java.JavaKit;
import org.openide.ErrorManager;
import org.openide.util.RequestProcessor;

public class JavaEditorWarmUpTask
implements Runnable {
    private static final int ARTIFICIAL_DOCUMENT_LINE_COUNT = 151;
    private static final int VIEW_HIERARCHY_CREATION_COUNT = 1;
    private static final int IMAGE_WIDTH = 600;
    private static final int IMAGE_HEIGHT = 400;
    private static final int PAINT_COUNT = 1;
    private static final boolean debug = Boolean.getBoolean("netbeans.debug.editor.warmup");
    private static final int STATUS_INIT = 0;
    private static final int STATUS_CREATE_PANE = 1;
    private static final int STATUS_CREATE_DOCUMENTS = 2;
    private static final int STATUS_SWITCH_DOCUMENTS = 3;
    private static final int STATUS_TRAVERSE_VIEWS = 4;
    private static final int STATUS_RENDER_FRAME = 5;
    private int status = 0;
    private JEditorPane pane;
    private JFrame frame;
    private Document emptyDoc;
    private Document longDoc;
    private Graphics bGraphics;
    private BaseKit javaKit;
    private long startTime;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        switch (this.status) {
            case 0: {
                if (debug) {
                    this.startTime = System.currentTimeMillis();
                }
                this.javaKit = BaseKit.getKit(JavaKit.class);
                this.javaKit.getActions();
                if (debug) {
                    System.out.println("Kit instances initialized: " + (System.currentTimeMillis() - this.startTime));
                    this.startTime = System.currentTimeMillis();
                }
                if (EditorRegistry.lastFocusedComponent() != null) break;
                this.status = 1;
                SwingUtilities.invokeLater(this);
                break;
            }
            case 1: {
                assert (SwingUtilities.isEventDispatchThread());
                this.pane = new JEditorPane();
                this.pane.setEditorKit((EditorKit)this.javaKit);
                EditorUI editorUI = Utilities.getEditorUI((JTextComponent)this.pane);
                if (editorUI != null) {
                    editorUI.getExtComponent();
                }
                this.status = 2;
                RequestProcessor.getDefault().post((Runnable)this);
                break;
            }
            case 2: {
                this.emptyDoc = this.javaKit.createDefaultDocument();
                this.longDoc = this.pane.getDocument();
                try {
                    StringBuffer stringBuffer = new StringBuffer();
                    for (int i = 151; i > 0; --i) {
                        stringBuffer.append("int ident = 1; // comment\n");
                    }
                    this.longDoc.insertString(0, stringBuffer.toString(), null);
                    this.status = 3;
                    SwingUtilities.invokeLater(this);
                }
                catch (BadLocationException badLocationException) {
                    ErrorManager.getDefault().notify((Throwable)badLocationException);
                }
                break;
            }
            case 3: {
                for (int i = 0; i < 1; ++i) {
                    this.pane.setDocument(this.emptyDoc);
                    this.pane.setDocument(this.longDoc);
                }
                this.status = 4;
                RequestProcessor.getDefault().post((Runnable)this);
                break;
            }
            case 4: {
                try {
                    BufferedImage bufferedImage = new BufferedImage(600, 400, 1);
                    this.bGraphics = bufferedImage.getGraphics();
                    this.bGraphics.setClip(0, 0, 600, 400);
                    AbstractDocument abstractDocument = (AbstractDocument)this.pane.getDocument();
                    abstractDocument.readLock();
                    try {
                        final View view = Utilities.getDocumentView((JTextComponent)this.pane);
                        LockView lockView = LockView.get((View)view);
                        lockView.lock();
                        try {
                            int n;
                            int n2 = view.getViewCount();
                            Runnable runnable = new Runnable(){

                                public void run() {
                                    int n = view.getViewCount();
                                    for (int i = 0; i < n; ++i) {
                                        View view2 = view.getView(i);
                                        if (!(view2 instanceof EstimatedSpanView)) continue;
                                        ((EstimatedSpanView)view2).setEstimatedSpan(false);
                                    }
                                }
                            };
                            if (view instanceof GapDocumentView) {
                                ((GapDocumentView)view).renderWithUpdateLayout(runnable);
                            } else {
                                runnable.run();
                            }
                            for (n = 0; n < n2; ++n) {
                                Rectangle rectangle = new Rectangle(0, 0, (int)view.getPreferredSpan(0), (int)view.getPreferredSpan(1));
                                view.getChildAllocation(n, rectangle);
                            }
                            n = (int)view.getPreferredSpan(0);
                            int n3 = (int)view.getPreferredSpan(1);
                            Rectangle rectangle = new Rectangle(0, 0, n, n3);
                            for (int i = 0; i >= 0; --i) {
                                view.paint(this.bGraphics, rectangle);
                            }
                        }
                        finally {
                            lockView.unlock();
                        }
                    }
                    finally {
                        abstractDocument.readUnlock();
                    }
                }
                catch (BadLocationException badLocationException) {
                    ErrorManager.getDefault().notify((Throwable)badLocationException);
                }
                this.status = 5;
                SwingUtilities.invokeLater(this);
                break;
            }
            case 5: {
                this.frame = new JFrame();
                EditorUI editorUI = Utilities.getEditorUI((JTextComponent)this.pane);
                JComponent jComponent = null;
                if (editorUI != null) {
                    jComponent = editorUI.getExtComponent();
                }
                if (jComponent == null) {
                    jComponent = new JScrollPane(this.pane);
                }
                this.frame.getContentPane().add(jComponent);
                this.frame.pack();
                this.frame.paint(this.bGraphics);
                this.frame.getContentPane().removeAll();
                this.frame.dispose();
                this.pane.setEditorKit(null);
                if (!debug) break;
                System.out.println("View hierarchy initialized: " + (System.currentTimeMillis() - this.startTime));
                this.startTime = System.currentTimeMillis();
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }
}

