/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midpnb.components.svg.form;

import java.io.FileNotFoundException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.netbeans.modules.vmd.api.io.ProjectUtils;
import org.netbeans.modules.vmd.api.io.providers.IOSupport;
import org.netbeans.modules.vmd.api.model.DescriptorRegistry;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.api.model.TypeID;
import org.netbeans.modules.vmd.midp.components.MidpTypes;
import org.netbeans.modules.vmd.midpnb.components.svg.form.SVGButtonCD;
import org.netbeans.modules.vmd.midpnb.components.svg.form.SVGCheckBoxCD;
import org.netbeans.modules.vmd.midpnb.components.svg.form.SVGComboBoxCD;
import org.netbeans.modules.vmd.midpnb.components.svg.form.SVGComponentCD;
import org.netbeans.modules.vmd.midpnb.components.svg.form.SVGLabelCD;
import org.netbeans.modules.vmd.midpnb.components.svg.form.SVGListCD;
import org.netbeans.modules.vmd.midpnb.components.svg.form.SVGRadioButtonCD;
import org.netbeans.modules.vmd.midpnb.components.svg.form.SVGSliderCD;
import org.netbeans.modules.vmd.midpnb.components.svg.form.SVGSpinnerCD;
import org.netbeans.modules.vmd.midpnb.components.svg.form.SVGTextFieldCD;
import org.netbeans.modules.vmd.midpnb.components.svg.parsers.SVGFormImageParser;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SVGFormFileObjectListener
implements FileChangeListener {
    private WeakReference<DesignComponent> component;
    private WeakReference<DesignComponent> imageComponent;
    private String propertyName;

    public SVGFormFileObjectListener(DesignComponent designComponent, DesignComponent designComponent2, String string) {
        assert (designComponent != null);
        assert (designComponent2 != null);
        this.component = new WeakReference<DesignComponent>(designComponent);
        this.imageComponent = new WeakReference<DesignComponent>(designComponent2);
        this.propertyName = string;
    }

    public void fileFolderCreated(FileEvent fileEvent) {
    }

    public void fileDataCreated(FileEvent fileEvent) {
    }

    public void fileChanged(FileEvent fileEvent) {
        this.regenerateComponents(fileEvent.getFile());
    }

    public void fileDeleted(FileEvent fileEvent) {
        this.regenerateComponents(fileEvent.getFile());
        fileEvent.getFile().removeFileChangeListener((FileChangeListener)this);
    }

    public void fileRenamed(FileRenameEvent fileRenameEvent) {
    }

    public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
    }

    private void regenerateComponents(FileObject fileObject) {
        if (this.component == null || this.component.get() == null || ((DesignComponent)this.component.get()).getDocument() == null) {
            return;
        }
        DesignComponent designComponent = (DesignComponent)this.component.get();
        SVGFormFileObjectListener.regenerateSVGComponentsStructure(fileObject, designComponent);
    }

    public static synchronized void regenerateSVGComponentsStructure(FileObject fileObject, final DesignComponent designComponent) {
        InputStream inputStream = null;
        try {
            if (fileObject.isValid()) {
                inputStream = fileObject.getInputStream();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            Exceptions.printStackTrace((Throwable)fileNotFoundException);
        }
        if (fileObject == null && inputStream == null) {
            return;
        }
        String[][] stringArray = SVGFormImageParser.getComponentsInformation(inputStream);
        final HashMap hashMap = new HashMap();
        designComponent.getDocument().getTransactionManager().readAccess(new Runnable(){

            public void run() {
                DescriptorRegistry descriptorRegistry = designComponent.getDocument().getDescriptorRegistry();
                for (DesignComponent designComponent2 : designComponent.getComponents()) {
                    if (!descriptorRegistry.isInHierarchy(SVGComponentCD.TYPEID, designComponent2.getType())) continue;
                    String string = (String)designComponent2.readProperty("id").getPrimitiveValue();
                    hashMap.put(string, designComponent2.getType().toString());
                }
            }
        });
        HashMap<String, String> hashMap2 = new HashMap<String, String>();
        for (int i = 0; i < stringArray.length; ++i) {
            hashMap2.put(stringArray[i][1], stringArray[i][0]);
        }
        final HashSet<Object> hashSet = new HashSet<Object>();
        for (Object object : hashMap.keySet()) {
            if (hashMap2.containsKey(object)) continue;
            hashSet.add(object);
        }
        final HashMap hashMap3 = new HashMap();
        for (String string : hashMap2.keySet()) {
            if (hashMap.containsKey(string)) continue;
            hashMap3.put(string, hashMap2.get(string));
        }
        if (!hashMap3.isEmpty() || !hashSet.isEmpty()) {
            Object object;
            designComponent.getDocument().getTransactionManager().writeAccess(new Runnable(){

                public void run() {
                    DescriptorRegistry descriptorRegistry = designComponent.getDocument().getDescriptorRegistry();
                    HashSet hashSet2 = new HashSet(designComponent.getComponents());
                    for (DesignComponent designComponent2 : hashSet2) {
                        String string;
                        if (!descriptorRegistry.isInHierarchy(SVGComponentCD.TYPEID, designComponent2.getType()) || !hashSet.contains(string = (String)designComponent2.readProperty("id").getPrimitiveValue())) continue;
                        designComponent.getDocument().deleteComponent(designComponent2);
                    }
                    SVGFormFileObjectListener.addComponents(hashMap3, designComponent);
                }
            });
            object = ProjectUtils.getDataObjectContextForDocument((DesignDocument)designComponent.getDocument());
            if (object != null && object.getDataObject() != null) {
                IOSupport.forceUpdateCode((DataObject)object.getDataObject());
            }
        }
    }

    private static void addComponents(Map<String, String> map, DesignComponent designComponent) {
        for (String string : map.keySet()) {
            String string2 = map.get(string);
            if (MidpTypes.getSimpleClassName((TypeID)SVGButtonCD.TYPEID).equals(string2)) {
                SVGFormFileObjectListener.creeateComponent(SVGButtonCD.TYPEID, designComponent, string);
                continue;
            }
            if (MidpTypes.getSimpleClassName((TypeID)SVGCheckBoxCD.TYPEID).equals(string2)) {
                SVGFormFileObjectListener.creeateComponent(SVGCheckBoxCD.TYPEID, designComponent, string);
                continue;
            }
            if (MidpTypes.getSimpleClassName((TypeID)SVGComboBoxCD.TYPEID).equals(string2)) {
                SVGFormFileObjectListener.creeateComponent(SVGComboBoxCD.TYPEID, designComponent, string);
                continue;
            }
            if (MidpTypes.getSimpleClassName((TypeID)SVGLabelCD.TYPEID).equals(string2)) {
                SVGFormFileObjectListener.creeateComponent(SVGLabelCD.TYPEID, designComponent, string);
                continue;
            }
            if (MidpTypes.getSimpleClassName((TypeID)SVGListCD.TYPEID).equals(string2)) {
                SVGFormFileObjectListener.creeateComponent(SVGListCD.TYPEID, designComponent, string);
                continue;
            }
            if (MidpTypes.getSimpleClassName((TypeID)SVGRadioButtonCD.TYPEID).equals(string2)) {
                SVGFormFileObjectListener.creeateComponent(SVGRadioButtonCD.TYPEID, designComponent, string);
                continue;
            }
            if (MidpTypes.getSimpleClassName((TypeID)SVGSliderCD.TYPEID).equals(string2)) {
                SVGFormFileObjectListener.creeateComponent(SVGSliderCD.TYPEID, designComponent, string);
                continue;
            }
            if (MidpTypes.getSimpleClassName((TypeID)SVGSpinnerCD.TYPEID).equals(string2)) {
                SVGFormFileObjectListener.creeateComponent(SVGSpinnerCD.TYPEID, designComponent, string);
                continue;
            }
            if (!MidpTypes.getSimpleClassName((TypeID)SVGTextFieldCD.TYPEID).equals(string2)) continue;
            SVGFormFileObjectListener.creeateComponent(SVGTextFieldCD.TYPEID, designComponent, string);
        }
    }

    private static void creeateComponent(TypeID typeID, DesignComponent designComponent, String string) {
        DesignComponent designComponent2 = designComponent.getDocument().createComponent(typeID);
        designComponent2.writeProperty("id", MidpTypes.createStringValue((String)string));
        designComponent.addComponent(designComponent2);
    }
}

