/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xslt.tmap.navigator;

import java.awt.Component;
import javax.swing.JComboBox;
import javax.swing.SwingUtilities;
import org.netbeans.core.api.multiview.MultiViewHandler;
import org.netbeans.core.api.multiview.MultiViewPerspective;
import org.netbeans.core.api.multiview.MultiViews;
import org.netbeans.modules.xslt.tmap.navigator.TMapLogicalNavigatorPanel;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class TMapNavigatorController {
    private TMapNavigatorController() {
    }

    public static TopComponent getNavigatorTC() {
        return WindowManager.getDefault().findTopComponent("navigatorTC");
    }

    public static void activateLogicalPanel() {
        TMapNavigatorController.switchNavPanel(TMapLogicalNavigatorPanel.getUName());
    }

    public static void switchNavPanel(final Object object) {
        if (object == null) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                TopComponent topComponent = TMapNavigatorController.getNavigatorTC();
                if (topComponent == null) {
                    return;
                }
                JComboBox jComboBox = TMapNavigatorController.getNavigatorComboBox(topComponent);
                if (jComboBox == null) {
                    return;
                }
                int n = jComboBox.getSelectedIndex();
                int n2 = jComboBox.getItemCount();
                for (int i = 0; i < n2; ++i) {
                    if (!object.equals(jComboBox.getItemAt(i))) continue;
                    if (i == n) break;
                    jComboBox.setSelectedIndex(i);
                    break;
                }
            }
        });
    }

    private static JComboBox getNavigatorComboBox(TopComponent topComponent) {
        Component[] componentArray;
        assert (topComponent != null);
        JComboBox jComboBox = null;
        for (Component component : componentArray = topComponent.getComponents()) {
            if (!(component instanceof JComboBox)) continue;
            jComboBox = (JComboBox)component;
            break;
        }
        return jComboBox;
    }

    private static String getMVEditorActivePanelPrefferedId() {
        TopComponent topComponent = WindowManager.getDefault().getRegistry().getActivated();
        MultiViewHandler multiViewHandler = MultiViews.findMultiViewHandler((TopComponent)topComponent);
        if (multiViewHandler == null) {
            return null;
        }
        MultiViewPerspective multiViewPerspective = multiViewHandler.getSelectedPerspective();
        if (multiViewPerspective != null) {
            return multiViewPerspective.preferredID();
        }
        return null;
    }
}

