/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xslt.tmap.model.xsltmap;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.netbeans.api.project.Project;
import org.netbeans.modules.xslt.tmap.model.xsltmap.AbstractTransformationDesc;
import org.netbeans.modules.xslt.tmap.model.xsltmap.AbstractTransformationUC;
import org.netbeans.modules.xslt.tmap.model.xsltmap.ChangeXsltMapSupport;
import org.netbeans.modules.xslt.tmap.model.xsltmap.FilterOneWayUC;
import org.netbeans.modules.xslt.tmap.model.xsltmap.FilterRequestReplyUC;
import org.netbeans.modules.xslt.tmap.model.xsltmap.InputTransformationDesc;
import org.netbeans.modules.xslt.tmap.model.xsltmap.OutputTransformationDesc;
import org.netbeans.modules.xslt.tmap.model.xsltmap.RequestReplyServiceUC;
import org.netbeans.modules.xslt.tmap.model.xsltmap.TransformationDesc;
import org.netbeans.modules.xslt.tmap.model.xsltmap.TransformationDescType;
import org.netbeans.modules.xslt.tmap.model.xsltmap.TransformationType;
import org.netbeans.modules.xslt.tmap.model.xsltmap.TransformationUC;
import org.netbeans.modules.xslt.tmap.model.xsltmap.XmlUtil;
import org.netbeans.modules.xslt.tmap.model.xsltmap.XsltMapAccessor;
import org.netbeans.modules.xslt.tmap.model.xsltmap.XsltMapPropertyChangeListener;
import org.netbeans.modules.xslt.tmap.util.Util;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XsltMapModel {
    private FileChangeListener xsltMapFileChangeListener;
    private FileObject xsltMapFile;
    private boolean isInit = false;
    private Document myDocument;
    private List<TransformationUC> transformationUCs;
    private ChangeXsltMapSupport changeModelSupport;

    protected XsltMapModel(FileObject fileObject) {
        if (!XsltMapAccessor.isValidXsltMapFile(fileObject)) {
            throw new IllegalArgumentException("Invalid xsltmap file");
        }
        this.xsltMapFile = fileObject;
        this.xsltMapFileChangeListener = new XsltMapFileChangeListener();
        fileObject.addFileChangeListener(this.xsltMapFileChangeListener);
        this.changeModelSupport = new ChangeXsltMapSupport();
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.xsltMapFile != null && this.xsltMapFileChangeListener != null) {
            this.xsltMapFile.removeFileChangeListener(this.xsltMapFileChangeListener);
        }
    }

    public static synchronized XsltMapModel getDefault(Project project) throws IOException {
        FileObject fileObject = Util.getXsltMapFo(project);
        if (fileObject == null) {
            fileObject = XmlUtil.createTemplateXsltMapFo(project);
        }
        if (fileObject == null) {
            return null;
        }
        XsltMapModel xsltMapModel = new XsltMapModel(fileObject);
        xsltMapModel.initXsltMapModel();
        return xsltMapModel.isInitModel() ? xsltMapModel : null;
    }

    public FileObject getXsltMapFile() {
        return this.xsltMapFile;
    }

    public synchronized void sync() throws IOException {
        this.syncImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncImpl() throws IOException {
        if (!this.isInitModel()) {
            throw new IllegalStateException("xsltMapModel hasn't been initialized");
        }
        FileObject fileObject = this.getXsltMapFile();
        FileLock fileLock = null;
        OutputStream outputStream = null;
        try {
            fileLock = fileObject.lock();
            outputStream = fileObject.getOutputStream(fileLock);
            XMLUtil.write((Document)this.myDocument, (OutputStream)outputStream, (String)"UTF-8");
            outputStream.flush();
            outputStream.close();
        }
        finally {
            if (outputStream != null) {
                outputStream.flush();
                outputStream.close();
            }
            if (fileLock != null) {
                fileLock.releaseLock();
            }
        }
    }

    public synchronized void addTransformationUC(TransformationUC transformationUC) {
        if (transformationUC == null) {
            return;
        }
        if (!this.isInitModel()) {
            throw new IllegalStateException("xsltMapModel hasn't been initialized");
        }
        Node node = XmlUtil.getElementByTagName(this.myDocument, "xsltmap");
        assert (node != null);
        Element element = this.myDocument.createElement(transformationUC.getTransformationType().getTagName());
        assert (element != null);
        List<TransformationDesc> list = transformationUC.getTransformationDescs();
        if (list != null) {
            for (TransformationDesc transformationDesc : list) {
                String string;
                String string2;
                String string3;
                String string4;
                String string5;
                String string6;
                Element element2 = this.myDocument.createElement(transformationDesc.getType().getTagName());
                String string7 = transformationDesc.getPartnerLink();
                if (string7 != null) {
                    element2.setAttribute("partnerLink", string7);
                }
                if ((string6 = transformationDesc.getRoleName()) != null) {
                    element2.setAttribute("roleName", string6);
                }
                if ((string5 = transformationDesc.getPortType()) != null) {
                    element2.setAttribute("portType", string5);
                }
                if ((string4 = transformationDesc.getOperation()) != null) {
                    element2.setAttribute("operation", string4);
                }
                if ((string3 = transformationDesc.getMessageType()) != null) {
                    element2.setAttribute("messageType", string3);
                }
                if ((string2 = transformationDesc.getFile()) != null) {
                    element2.setAttribute("file", string2);
                }
                if ((string = transformationDesc.getTransformJBI()) != null) {
                    element2.setAttribute("transformJBI", string);
                }
                element.appendChild(element2);
            }
        }
        node.appendChild(element);
    }

    public synchronized List<TransformationUC> getTransformationUCs() {
        return this.transformationUCs;
    }

    public synchronized List<TransformationDesc> getTransformationDescs() {
        ArrayList<TransformationDesc> arrayList = new ArrayList<TransformationDesc>();
        List<TransformationUC> list = this.getTransformationUCs();
        if (list == null) {
            return arrayList;
        }
        for (TransformationUC transformationUC : list) {
            List<TransformationDesc> list2 = transformationUC.getTransformationDescs();
            if (list2 == null || list2.size() <= 0) continue;
            arrayList.addAll(list2);
        }
        return arrayList;
    }

    public boolean isInitModel() {
        return this.isInit;
    }

    public synchronized void initXsltMapModel() {
        Document document = XmlUtil.getDocument(this.xsltMapFile);
        if (document == null) {
            return;
        }
        this.myDocument = document;
        HashMap hashMap = new HashMap();
        ArrayList<TransformationUC> arrayList = new ArrayList<TransformationUC>();
        for (TransformationType transformationType : TransformationType.values()) {
            NodeList nodeList = document.getElementsByTagName(transformationType.getTagName());
            if (nodeList == null) continue;
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                TransformationUC transformationUC = this.createTransformationUCs(transformationType, node);
                if (transformationUC == null) continue;
                arrayList.add(transformationUC);
            }
        }
        this.transformationUCs = arrayList;
        this.isInit = true;
    }

    public synchronized TransformationDesc getFirstTransformationDesc(FileObject fileObject) {
        if (fileObject == null) {
            return null;
        }
        TransformationDesc transformationDesc = null;
        List<TransformationDesc> list = this.getTransformationDescs();
        for (TransformationDesc transformationDesc2 : list) {
            if (!transformationDesc2.isEqualInputFile(fileObject)) continue;
            transformationDesc = transformationDesc2;
            break;
        }
        return transformationDesc;
    }

    private List<TransformationDesc> getTransformationDescs(TransformationUC transformationUC, Node node, TransformationType transformationType) {
        TransformationDescType[] transformationDescTypeArray;
        ArrayList<TransformationDesc> arrayList = new ArrayList<TransformationDesc>();
        for (TransformationDescType transformationDescType : transformationDescTypeArray = transformationType.getTransformationDescs()) {
            Node node2 = XmlUtil.getElementByTagName(node.getChildNodes(), transformationDescType.getTagName());
            TransformationDesc transformationDesc = this.createTransformationDesc(transformationUC, transformationDescType, node2);
            if (transformationDesc == null) continue;
            arrayList.add(transformationDesc);
        }
        return arrayList;
    }

    private TransformationUC createTransformationUCs(TransformationType transformationType, Node node) {
        if (node == null || transformationType == null) {
            return null;
        }
        AbstractTransformationUC abstractTransformationUC = null;
        switch (transformationType) {
            case FILTER_ONE_WAY: {
                abstractTransformationUC = new FilterOneWayUC(this);
                break;
            }
            case FILTER_REQUEST_REPLY: {
                abstractTransformationUC = new FilterRequestReplyUC(this);
                break;
            }
            case REQUEST_REPLY_SERVICE: {
                abstractTransformationUC = new RequestReplyServiceUC(this);
            }
        }
        if (abstractTransformationUC != null) {
            abstractTransformationUC.setTransformationDescs(this.getTransformationDescs(abstractTransformationUC, node, transformationType));
        }
        return abstractTransformationUC;
    }

    private TransformationDesc createTransformationDesc(TransformationUC transformationUC, TransformationDescType transformationDescType, Node node) {
        NamedNodeMap namedNodeMap;
        if (node == null || transformationDescType == null) {
            return null;
        }
        AbstractTransformationDesc abstractTransformationDesc = null;
        switch (transformationDescType) {
            case INPUT: {
                abstractTransformationDesc = new InputTransformationDesc(this, transformationUC);
                break;
            }
            case OUTPUT: {
                abstractTransformationDesc = new OutputTransformationDesc(this, transformationUC);
            }
        }
        if (abstractTransformationDesc != null && (namedNodeMap = node.getAttributes()) != null) {
            abstractTransformationDesc.setFile(XmlUtil.getAttrValue(namedNodeMap, "file"));
            abstractTransformationDesc.setMessageType(XmlUtil.getAttrValue(namedNodeMap, "messageType"));
            abstractTransformationDesc.setOperation(XmlUtil.getAttrValue(namedNodeMap, "operation"));
            abstractTransformationDesc.setPartnerLink(XmlUtil.getAttrValue(namedNodeMap, "partnerLink"));
            abstractTransformationDesc.setPortType(XmlUtil.getAttrValue(namedNodeMap, "portType"));
            abstractTransformationDesc.setRoleName(XmlUtil.getAttrValue(namedNodeMap, "roleName"));
            abstractTransformationDesc.setTransformJBI(XmlUtil.getAttrValue(namedNodeMap, "transformJBI"));
        }
        return abstractTransformationDesc;
    }

    public void addPropertyChangeListener(XsltMapPropertyChangeListener xsltMapPropertyChangeListener) {
        this.changeModelSupport.addPropertyChangeListener(xsltMapPropertyChangeListener);
    }

    public void removePropertyChangeListener(XsltMapPropertyChangeListener xsltMapPropertyChangeListener) {
        this.changeModelSupport.removePropertyChangeListener(xsltMapPropertyChangeListener);
    }

    private synchronized void updateXsltMapModel() {
        List<TransformationDesc> list = this.getTransformationDescs();
        ArrayList<TransformationDesc> arrayList = null;
        if (list != null && list.size() > 0) {
            arrayList = new ArrayList<TransformationDesc>(list);
            Collections.copy(arrayList, list);
        }
        this.initXsltMapModel();
        list = this.getTransformationDescs();
        ArrayList<TransformationDesc> arrayList2 = null;
        if (list != null && list.size() > 0) {
            arrayList2 = new ArrayList<TransformationDesc>(list);
            Collections.copy(arrayList2, list);
        }
        if (arrayList == null || arrayList.size() == 0) {
            return;
        }
        ArrayList<TransformationDesc> arrayList3 = new ArrayList<TransformationDesc>();
        if (arrayList2 != null) {
            block0: for (TransformationDesc transformationDesc : arrayList2) {
                assert (transformationDesc.getType() != null);
                TransformationUC transformationUC = transformationDesc.getParent();
                if (transformationUC == null) continue;
                for (TransformationDesc transformationDesc2 : arrayList) {
                    assert (transformationDesc2.getType() != null);
                    if (!transformationUC.equals(transformationDesc2.getParent()) || !transformationDesc.getType().equals((Object)transformationDesc2.getType())) continue;
                    arrayList3.add(transformationDesc2);
                    if (transformationDesc.equals(transformationDesc2)) continue;
                    this.fireTransformationDescChanged(transformationDesc2, transformationDesc);
                    continue block0;
                }
            }
        }
        arrayList.removeAll(arrayList3);
        for (TransformationDesc transformationDesc : arrayList) {
            this.fireTransformationDescChanged(transformationDesc, null);
        }
    }

    private void fireTransformationDescChanged(TransformationDesc transformationDesc, TransformationDesc transformationDesc2) {
        this.changeModelSupport.fireTransformationDescChanged(transformationDesc, transformationDesc2);
    }

    private class XsltMapFileChangeListener
    implements FileChangeListener {
        private XsltMapFileChangeListener() {
        }

        public void fileFolderCreated(FileEvent fileEvent) {
        }

        public void fileDataCreated(FileEvent fileEvent) {
        }

        public void fileChanged(FileEvent fileEvent) {
            XsltMapModel.this.updateXsltMapModel();
        }

        public void fileDeleted(FileEvent fileEvent) {
        }

        public void fileRenamed(FileRenameEvent fileRenameEvent) {
        }

        public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
        }
    }
}

