/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb.proxy;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.logging.Logger;
import org.netbeans.modules.cnd.debugger.gdb.GdbDebugger;
import org.netbeans.modules.cnd.debugger.gdb.proxy.GdbConsoleWindow;
import org.netbeans.modules.cnd.debugger.gdb.proxy.GdbProxy;

public class GdbLogger {
    private GdbConsoleWindow gdbConsoleWindow = null;
    private FileWriter logFile;
    private Logger log = Logger.getLogger("gdb.gdbproxy.logger");

    public GdbLogger(GdbDebugger gdbDebugger, GdbProxy gdbProxy) {
        try {
            File file = File.createTempFile("gdb-cmds", ".log");
            if (!Boolean.getBoolean("gdb.console.savelog")) {
                file.deleteOnExit();
            }
            this.logFile = new FileWriter(file);
        }
        catch (IOException iOException) {
            this.logFile = null;
        }
        if (Boolean.getBoolean("gdb.console.window")) {
            this.gdbConsoleWindow = GdbConsoleWindow.getInstance(gdbDebugger, gdbProxy);
            this.gdbConsoleWindow.openConsole();
        }
    }

    public void logMessage(String string) {
        if (string != null && string.length() > 0) {
            if (!string.endsWith("\n")) {
                string = string + '\n';
            }
            if (this.logFile != null) {
                try {
                    this.logFile.write(string);
                    this.logFile.flush();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (this.gdbConsoleWindow != null) {
                this.gdbConsoleWindow.add(string);
            }
        }
    }
}

