/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb.profiles;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.util.ArrayList;
import org.netbeans.modules.cnd.actions.BuildToolsAction;
import org.netbeans.modules.cnd.api.compilers.CompilerSet;
import org.netbeans.modules.cnd.api.compilers.CompilerSetManager;
import org.netbeans.modules.cnd.api.compilers.Tool;
import org.netbeans.modules.cnd.api.remote.ServerList;
import org.netbeans.modules.cnd.api.utils.Path;
import org.netbeans.modules.cnd.api.xml.XMLDecoder;
import org.netbeans.modules.cnd.api.xml.XMLEncoder;
import org.netbeans.modules.cnd.debugger.gdb.profiles.GdbProfileXMLCodec;
import org.netbeans.modules.cnd.makeproject.api.configurations.CompilerSet2Configuration;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationAuxObject;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.settings.CppSettings;
import org.netbeans.modules.cnd.ui.options.LocalToolsPanelModel;
import org.netbeans.modules.cnd.ui.options.ToolsPanelModel;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;

public class GdbProfile
implements ConfigurationAuxObject {
    public static final String GDB_PROFILE_ID = "gdbdebugger";
    public static final String PROP_GDB_COMMAND = "gdb_command";
    public static final String PROP_ARRAY_REPEAT_THRESHOLD = "array_repeat_threshold";
    private PropertyChangeSupport pcs = null;
    private boolean needSave = false;
    private String gdb_command;

    public GdbProfile() {
        this.initialize();
    }

    protected GdbProfile(PropertyChangeSupport propertyChangeSupport) {
        this.pcs = propertyChangeSupport;
        this.initialize();
    }

    public void initialize() {
        if (this.gdb_command == null) {
            this.gdb_command = CppSettings.getDefault().getGdbName();
        }
    }

    public boolean shared() {
        return false;
    }

    public String getId() {
        return GDB_PROFILE_ID;
    }

    public String getGdbCommand() {
        return this.gdb_command;
    }

    public void setGdbCommand(String string) {
        int n = string.length();
        boolean bl = this.gdb_command.equals(string);
        if (string.length() > 0 && !this.gdb_command.equals(string)) {
            if (this.pcs != null) {
                this.pcs.firePropertyChange(PROP_GDB_COMMAND, this.gdb_command, string);
            }
            this.gdb_command = string;
        }
    }

    public String getGdbPath(MakeConfiguration makeConfiguration) {
        String string;
        String string2;
        CompilerSet compilerSet;
        String string3;
        CompilerSet2Configuration compilerSet2Configuration = makeConfiguration.getCompilerSet();
        if (compilerSet2Configuration.isValid()) {
            string3 = compilerSet2Configuration.getOption();
            compilerSet = CompilerSetManager.getDefault((String)makeConfiguration.getDevelopmentHost().getName()).getCompilerSet(string3);
        } else {
            string3 = compilerSet2Configuration.getOldName();
            compilerSet = CompilerSet.getCompilerSet((String)makeConfiguration.getDevelopmentHost().getName(), (String)string3, (int)makeConfiguration.getPlatformInfo().getPlatform());
            CompilerSetManager.getDefault((String)makeConfiguration.getDevelopmentHost().getName()).add(compilerSet);
            compilerSet2Configuration.setValid();
        }
        Tool tool = compilerSet.getTool(6);
        if (tool != null) {
            string2 = tool.getPath();
            string = makeConfiguration.getDevelopmentHost().getName();
            if (string.equals("localhost")) {
                File file = new File(string2);
                if (file.exists() && !file.isDirectory()) {
                    return string2;
                }
                String string4 = Path.findCommand((String)string2);
                if (string4 != null) {
                    return string4;
                }
            } else {
                ServerList serverList = (ServerList)Lookup.getDefault().lookup(ServerList.class);
                if (serverList != null && serverList.isValidExecutable(string, string2)) {
                    return string2;
                }
            }
        }
        string2 = new LocalToolsPanelModel();
        string2.setCRequired(false);
        string2.setCppRequired(false);
        string2.setFortranRequired(false);
        string2.setMakeRequired(false);
        string2.setGdbRequired(true);
        string2.setShowRequiredBuildTools(false);
        string2.setShowRequiredDebugTools(true);
        string2.setCompilerSetName(null);
        string2.setSelectedCompilerSetName(string3);
        string = (BuildToolsAction)SystemAction.get(BuildToolsAction.class);
        string.setTitle(NbBundle.getMessage(GdbProfile.class, (String)"LBL_ResolveMissingGdb_Title"));
        if (string.initBuildTools((ToolsPanelModel)string2, new ArrayList())) {
            makeConfiguration.getCompilerSet().setValue(string2.getSelectedCompilerSetName());
            compilerSet = CompilerSetManager.getDefault((String)makeConfiguration.getDevelopmentHost().getName()).getCompilerSet(string2.getSelectedCompilerSetName());
            return compilerSet.getTool(6).getPath();
        }
        return null;
    }

    public int getArrayRepeatThreshold() {
        return CppSettings.getDefault().getArrayRepeatThreshold();
    }

    public void setArrayRepeatThreshold(int n) {
        CppSettings.getDefault().setArrayRepeatThreshold(n);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.pcs != null) {
            this.pcs.addPropertyChangeListener(propertyChangeListener);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(propertyChangeListener);
        }
    }

    public XMLDecoder getXMLDecoder() {
        return new GdbProfileXMLCodec(this);
    }

    public XMLEncoder getXMLEncoder() {
        return new GdbProfileXMLCodec(this);
    }

    public boolean hasChanged() {
        return this.needSave;
    }

    public void clearChanged() {
        this.needSave = false;
    }

    public void assign(ConfigurationAuxObject configurationAuxObject) {
        assert (configurationAuxObject instanceof GdbProfile);
        GdbProfile gdbProfile = (GdbProfile)configurationAuxObject;
        this.setGdbCommand(gdbProfile.getGdbCommand());
    }

    public Object clone() {
        GdbProfile gdbProfile = new GdbProfile();
        gdbProfile.setGdbCommand(this.getGdbCommand());
        return gdbProfile;
    }

    public Sheet getSheet() {
        Sheet sheet = new Sheet();
        Sheet.Set set = new Sheet.Set();
        set.setName("General");
        set.setDisplayName(NbBundle.getMessage(GdbProfile.class, (String)"LBL_GENERAL"));
        set.setShortDescription(NbBundle.getMessage(GdbProfile.class, (String)"HINT_GENERAL"));
        set.put((Node.Property)new GdbCommandNodeProp());
        set.put((Node.Property)new ArrayRepeatThresholdNodeProp());
        sheet.put(set);
        return sheet;
    }

    private class ArrayRepeatThresholdNodeProp
    extends PropertySupport {
        public ArrayRepeatThresholdNodeProp() {
            super(GdbProfile.PROP_ARRAY_REPEAT_THRESHOLD, Integer.class, NbBundle.getMessage(GdbProfile.class, (String)"LBL_ArrayRepeatThreshold"), NbBundle.getMessage(GdbProfile.class, (String)"HINT_ArrayRepeatThreshold"), true, true);
        }

        public Object getValue() {
            return GdbProfile.this.getArrayRepeatThreshold();
        }

        public void setValue(Object object) {
            if (object instanceof Integer) {
                GdbProfile.this.setArrayRepeatThreshold((Integer)object);
            }
        }
    }

    private class GdbCommandNodeProp
    extends PropertySupport {
        public GdbCommandNodeProp() {
            super(GdbProfile.PROP_GDB_COMMAND, String.class, NbBundle.getMessage(GdbProfile.class, (String)"LBL_GDB_COMMAND"), NbBundle.getMessage(GdbProfile.class, (String)"HINT_GDB_COMMAND"), true, false);
        }

        public Object getValue() {
            return GdbProfile.this.getGdbCommand();
        }

        public void setValue(Object object) {
            GdbProfile.this.setGdbCommand((String)object);
        }
    }
}

