/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb.models;

import java.beans.Customizer;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Logger;
import org.netbeans.modules.cnd.debugger.gdb.CallStackFrame;
import org.netbeans.modules.cnd.debugger.gdb.GdbDebugger;
import org.netbeans.modules.cnd.debugger.gdb.LocalVariable;
import org.netbeans.modules.cnd.debugger.gdb.models.AbstractVariable;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.TreeExpansionModel;
import org.netbeans.spi.viewmodel.TreeModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakSet;

public class LocalsTreeModel
implements TreeModel,
TreeExpansionModel,
PropertyChangeListener {
    private GdbDebugger debugger;
    private Listener listener;
    private Vector listeners = new Vector();
    private Set expandedNodes = new WeakSet();
    private Set collapsedNodes = new WeakSet();
    private static Logger log = Logger.getLogger("gdb.logger");

    public LocalsTreeModel(ContextProvider contextProvider) {
        this.debugger = (GdbDebugger)contextProvider.lookupFirst(null, GdbDebugger.class);
        if (this.debugger != null) {
            this.debugger.addPropertyChangeListener("localsRefresh", this);
        }
    }

    public Object getRoot() {
        return "Root";
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.fireTableValueChangedChanged(propertyChangeEvent.getSource(), null);
    }

    public Object[] getChildren(Object object, int n, int n2) throws UnknownTypeException {
        Object[] objectArray = this.getChildrenImpl(object, n, n2);
        for (int i = 0; i < objectArray.length; ++i) {
            if (!(objectArray[i] instanceof Customizer)) continue;
            ((Customizer)objectArray[i]).addPropertyChangeListener(this);
        }
        return objectArray;
    }

    public Object[] getChildrenImpl(Object object, int n, int n2) throws UnknownTypeException {
        if (object.equals("Root")) {
            return this.getLocalVariables(n, n2);
        }
        if (object instanceof AbstractVariable) {
            AbstractVariable abstractVariable = (AbstractVariable)object;
            return abstractVariable.getFields(n, n2);
        }
        return new Object[0];
    }

    public int getChildrenCount(Object object) throws UnknownTypeException {
        if (object.equals("Root")) {
            CallStackFrame callStackFrame = this.debugger.getCurrentCallStackFrame();
            if (callStackFrame == null) {
                return 1;
            }
            LocalVariable[] localVariableArray = callStackFrame.getLocalVariables();
            return localVariableArray.length;
        }
        if (object instanceof AbstractVariable) {
            AbstractVariable abstractVariable = (AbstractVariable)object;
            return abstractVariable.getFieldsCount();
        }
        return 0;
    }

    public boolean isLeaf(Object object) throws UnknownTypeException {
        if (object.equals("Root")) {
            return false;
        }
        if (object instanceof AbstractVariable) {
            int n = ((AbstractVariable)object).getFieldsCount();
            return n == 0;
        }
        if (object instanceof LocalVariable) {
            return true;
        }
        if (object.equals("NoInfo")) {
            return true;
        }
        if (object.equals("No current thread")) {
            return true;
        }
        if (object instanceof AbstractVariable.ErrorField) {
            return true;
        }
        throw new UnknownTypeException(object);
    }

    public void addModelListener(ModelListener modelListener) {
        this.listeners.add(modelListener);
        if (this.listener == null) {
            this.listener = new Listener(this, this.debugger);
        }
    }

    public void removeModelListener(ModelListener modelListener) {
        this.listeners.remove(modelListener);
        if (this.listeners.size() == 0) {
            this.listener.destroy();
            this.listener = null;
        }
    }

    void fireTreeChanged() {
        log.fine("LTM.fireTreeChanged:");
        Vector vector = (Vector)this.listeners.clone();
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            ((ModelListener)vector.get(i)).modelChanged((ModelEvent)new ModelEvent.TreeChanged((Object)this));
        }
    }

    private void fireTableValueChangedChanged(Object object, String string) {
        Vector vector = (Vector)this.listeners.clone();
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            ((ModelListener)vector.get(i)).modelChanged((ModelEvent)new ModelEvent.TableValueChanged((Object)this, object, string));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object[] getLocalVariables(int n, int n2) {
        Object object = this.debugger.LOCK;
        synchronized (object) {
            CallStackFrame callStackFrame = this.debugger.getCurrentCallStackFrame();
            if (callStackFrame == null) {
                return new String[]{"No current thread"};
            }
            return callStackFrame.getLocalVariables();
        }
    }

    GdbDebugger getDebugger() {
        return this.debugger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isExpanded(Object object) throws UnknownTypeException {
        LocalsTreeModel localsTreeModel = this;
        synchronized (localsTreeModel) {
            if (this.expandedNodes.contains(object)) {
                return true;
            }
            if (this.collapsedNodes.contains(object)) {
                return false;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void nodeExpanded(Object object) {
        LocalsTreeModel localsTreeModel = this;
        synchronized (localsTreeModel) {
            this.expandedNodes.add(object);
            this.collapsedNodes.remove(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void nodeCollapsed(Object object) {
        LocalsTreeModel localsTreeModel = this;
        synchronized (localsTreeModel) {
            this.collapsedNodes.add(object);
            this.expandedNodes.remove(object);
        }
    }

    private static class Listener
    implements PropertyChangeListener {
        private GdbDebugger debugger;
        private WeakReference model;
        private RequestProcessor.Task task;

        public Listener(LocalsTreeModel localsTreeModel, GdbDebugger gdbDebugger) {
            this.debugger = gdbDebugger;
            this.model = new WeakReference<LocalsTreeModel>(localsTreeModel);
            gdbDebugger.addPropertyChangeListener(this);
        }

        void destroy() {
            this.debugger.removePropertyChangeListener(this);
            if (this.task != null) {
                this.task.cancel();
                this.task = null;
            }
        }

        private LocalsTreeModel getModel() {
            LocalsTreeModel localsTreeModel = (LocalsTreeModel)this.model.get();
            if (localsTreeModel == null) {
                this.destroy();
            }
            return localsTreeModel;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ((propertyChangeEvent.getPropertyName().equals("currentCallStackFrame") || propertyChangeEvent.getPropertyName().equals("currentThread")) && this.debugger.getState().equals("state_stopped")) {
                log.fine("LTM.propertyChange: Change for " + propertyChangeEvent.getPropertyName());
                final LocalsTreeModel localsTreeModel = this.getModel();
                if (localsTreeModel == null) {
                    return;
                }
                if (this.task != null) {
                    this.task.cancel();
                    this.task = null;
                }
                this.task = RequestProcessor.getDefault().post(new Runnable(){

                    public void run() {
                        if (Listener.this.debugger.getState().equals("state_stopped")) {
                            localsTreeModel.fireTreeChanged();
                        }
                    }
                }, 500);
            } else if (propertyChangeEvent.getPropertyName().equals("state") && !this.debugger.getState().equals("state_stopped") && this.task != null) {
                this.task.cancel();
                this.task = null;
            }
        }
    }
}

