/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb.actions;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.Set;
import org.netbeans.api.debugger.ActionsManager;
import org.netbeans.modules.cnd.debugger.gdb.CallStackFrame;
import org.netbeans.modules.cnd.debugger.gdb.GdbDebugger;
import org.netbeans.spi.debugger.ActionsProviderSupport;
import org.netbeans.spi.debugger.ContextProvider;

public class MakeCallerCurrentActionProvider
extends ActionsProviderSupport
implements PropertyChangeListener {
    private ContextProvider lookupProvider;
    private GdbDebugger debugger;

    public MakeCallerCurrentActionProvider(ContextProvider contextProvider) {
        this.debugger = (GdbDebugger)contextProvider.lookupFirst(null, GdbDebugger.class);
        this.lookupProvider = contextProvider;
        this.debugger.addPropertyChangeListener("currentCallStackFrame", this);
    }

    public Set getActions() {
        return Collections.singleton(ActionsManager.ACTION_MAKE_CALLER_CURRENT);
    }

    public void doAction(Object object) {
        int n = MakeCallerCurrentActionProvider.getCurrentCallStackFrameIndex(this.debugger);
        if (n < this.debugger.getStackDepth() - 1) {
            MakeCallerCurrentActionProvider.setCurrentCallStackFrameIndex(this.debugger, n + 1);
        }
    }

    protected void checkEnabled(String string) {
        if ("state_stopped".equals(string)) {
            int n = MakeCallerCurrentActionProvider.getCurrentCallStackFrameIndex(this.debugger);
            this.setEnabled(ActionsManager.ACTION_MAKE_CALLER_CURRENT, n < this.debugger.getStackDepth() - 1);
        } else {
            this.setEnabled(ActionsManager.ACTION_MAKE_CALLER_CURRENT, false);
        }
    }

    static int getCurrentCallStackFrameIndex(GdbDebugger gdbDebugger) {
        CallStackFrame callStackFrame = gdbDebugger.getCurrentCallStackFrame();
        if (callStackFrame != null) {
            return callStackFrame.getFrameNumber();
        }
        return -1;
    }

    static void setCurrentCallStackFrameIndex(GdbDebugger gdbDebugger, int n) {
        if (n < gdbDebugger.getStackDepth()) {
            CallStackFrame callStackFrame = gdbDebugger.getCallStack().get(n);
            callStackFrame.makeCurrent();
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.checkEnabled(this.debugger.getState());
    }
}

