/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2me.cdc.project.bdj;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class BdjBuildPermTask
extends Task {
    private File jarFile;
    private String xletClass;
    private String orgId;
    private String appId;
    private boolean fileAccess;
    private boolean appLifecycle;
    private boolean serviceSelect;
    private boolean prefRead;
    private boolean prefWrite;
    private String networkPerm;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        int cnt;
        StringWriter sw = new StringWriter();
        PrintWriter pw = null;
        try {
            pw = new PrintWriter(sw);
            pw.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            pw.println("<n:permissionrequestfile xmlns:n=\"urn:BDA:bdmv;PRF\" orgid=\"" + this.orgId + "\" appid=\"" + this.appId + "\">");
            pw.println("    <file value=\"" + this.fileAccess + "\"></file>");
            pw.println("    <applifecyclecontrol value=\"" + this.appLifecycle + "\"></applifecyclecontrol>");
            pw.println("    <servicesel value=\"" + this.serviceSelect + "\"></servicesel>");
            pw.println("    <userpreferences read=\"" + this.prefRead + "\" write=\"" + this.prefWrite + "\"></userpreferences>");
            try {
                if (this.networkPerm != null && this.networkPerm.length() != 0) {
                    pw.println("    <network>");
                    StringTokenizer st = new StringTokenizer(this.networkPerm, ";");
                    while (st.hasMoreTokens()) {
                        String perm = st.nextToken();
                        int i = perm.indexOf(61);
                        if (i == -1) continue;
                        String action = perm.substring(0, i - 1);
                        String target = perm.substring(i + 1);
                        pw.println("        <host action=\"" + action + "\">" + target + "</host>");
                    }
                    pw.println("    </network>");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            pw.println("</n:permissionrequestfile>");
        }
        finally {
            pw.close();
        }
        File tmpJarFile = null;
        ZipInputStream jis = null;
        ZipOutputStream jos = null;
        byte[] data = new byte[1024];
        try {
            JarEntry je;
            tmpJarFile = File.createTempFile(this.orgId, null);
            tmpJarFile.deleteOnExit();
            jis = new JarInputStream(new FileInputStream(this.jarFile));
            Manifest mf = ((JarInputStream)jis).getManifest();
            jos = new JarOutputStream((OutputStream)new FileOutputStream(tmpJarFile), mf);
            while ((je = ((JarInputStream)jis).getNextJarEntry()) != null) {
                if (je.getName().endsWith(".perm")) continue;
                ((JarOutputStream)jos).putNextEntry(new JarEntry(je.getName()));
                if (!je.isDirectory()) {
                    while ((cnt = jis.read(data)) != -1) {
                        jos.write(data, 0, cnt);
                    }
                }
                jis.closeEntry();
                jos.closeEntry();
            }
            ((JarOutputStream)jos).putNextEntry(new JarEntry(this.getXletPermFile()));
            jos.write(sw.toString().getBytes());
            jos.closeEntry();
        }
        catch (IOException ex) {
            throw new BuildException((Throwable)ex);
        }
        finally {
            try {
                jos.close();
            }
            catch (IOException ex) {
                throw new BuildException((Throwable)ex);
            }
            try {
                jis.close();
            }
            catch (IOException ex) {
                throw new BuildException((Throwable)ex);
            }
        }
        FilterOutputStream dos = null;
        FilterInputStream dis = null;
        try {
            dos = new DataOutputStream(new FileOutputStream(this.jarFile));
            dis = new DataInputStream(new FileInputStream(tmpJarFile));
            while ((cnt = ((DataInputStream)dis).read(data)) != -1) {
                ((DataOutputStream)dos).write(data, 0, cnt);
            }
        }
        catch (IOException ioEx) {
            throw new BuildException((Throwable)ioEx);
        }
        finally {
            try {
                dos.close();
            }
            catch (IOException ex) {
                throw new BuildException((Throwable)ex);
            }
            try {
                dis.close();
            }
            catch (IOException ex) {
                throw new BuildException((Throwable)ex);
            }
        }
    }

    private String getXletPermFile() {
        String subpath = "";
        String className = this.xletClass;
        int dotIndex = this.xletClass.lastIndexOf(46);
        if (dotIndex != -1) {
            subpath = this.xletClass.substring(0, dotIndex).replace('.', File.separatorChar);
            className = this.xletClass.substring(dotIndex + 1);
        }
        return subpath + File.separator + "bluray." + className + ".perm";
    }

    public File getJarFile() {
        return this.jarFile;
    }

    public void setJarFile(File jarFile) {
        this.jarFile = jarFile;
    }

    public String getXletClass() {
        return this.xletClass;
    }

    public void setXletClass(String xletClass) {
        this.xletClass = xletClass;
    }

    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public boolean isAppLifecycle() {
        return this.appLifecycle;
    }

    public void setAppLifecycle(boolean appLifecycle) {
        this.appLifecycle = appLifecycle;
    }

    public boolean isFileAccess() {
        return this.fileAccess;
    }

    public void setFileAccess(boolean fileAccess) {
        this.fileAccess = fileAccess;
    }

    public String getNetworkPerm() {
        return this.networkPerm;
    }

    public void setNetworkPerm(String networkPerm) {
        this.networkPerm = networkPerm;
    }

    public String getOrgId() {
        return this.orgId;
    }

    public void setOrgId(String orgId) {
        this.orgId = orgId;
    }

    public boolean isPrefRead() {
        return this.prefRead;
    }

    public void setPrefRead(boolean prefRead) {
        this.prefRead = prefRead;
    }

    public boolean isPrefWrite() {
        return this.prefWrite;
    }

    public void setPrefWrite(boolean prefWrite) {
        this.prefWrite = prefWrite;
    }

    public boolean isServiceSelect() {
        return this.serviceSelect;
    }

    public void setServiceSelect(boolean serviceSelect) {
        this.serviceSelect = serviceSelect;
    }
}

