/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.project.ui.wizard;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.mobility.project.J2MEProjectGenerator;
import org.netbeans.modules.mobility.project.ui.wizard.ConfigurationsSelectionPanel;
import org.netbeans.modules.mobility.project.ui.wizard.PlatformInstallPanel;
import org.netbeans.modules.mobility.project.ui.wizard.PlatformSelectionPanel;
import org.netbeans.modules.mobility.project.ui.wizard.ProjectPanel;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.TemplateWizard;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewProjectIterator
implements TemplateWizard.Iterator {
    private static final long serialVersionUID = 4589834546983L;
    boolean platformInstall;
    int currentIndex;
    PlatformInstallPanel.WizardPanel platformPanel;
    ProjectPanel.WizardPanel projectPanel;
    PlatformSelectionPanel psPanel;
    ConfigurationsSelectionPanel csPanel;

    static Object create() {
        return new NewProjectIterator();
    }

    public void addChangeListener(ChangeListener changeListener) {
    }

    public void removeChangeListener(ChangeListener changeListener) {
    }

    public WizardDescriptor.Panel current() {
        if (this.platformInstall) {
            switch (this.currentIndex) {
                case 0: {
                    return this.platformPanel;
                }
                case 1: {
                    return this.projectPanel;
                }
                case 2: {
                    return this.psPanel;
                }
                case 3: {
                    return this.csPanel;
                }
            }
        } else {
            switch (this.currentIndex) {
                case 0: {
                    return this.projectPanel;
                }
                case 1: {
                    return this.psPanel;
                }
                case 2: {
                    return this.csPanel;
                }
            }
        }
        throw new IllegalStateException();
    }

    public boolean hasNext() {
        if (this.platformInstall) {
            return this.currentIndex < 3;
        }
        return this.currentIndex < 2;
    }

    public boolean hasPrevious() {
        return this.currentIndex > 0;
    }

    public void initialize(TemplateWizard templateWizard) {
        boolean bl = true;
        if (!(Templates.getTemplate((WizardDescriptor)templateWizard).getAttribute("application") instanceof Boolean)) {
            bl = false;
        }
        this.platformInstall = PlatformInstallPanel.isPlatformInstalled("j2me") ^ true;
        if (this.platformInstall) {
            this.platformPanel = new PlatformInstallPanel.WizardPanel("j2me");
            ((JComponent)this.platformPanel.getComponent()).putClientProperty("NewProjectWizard_Title", bl ? NbBundle.getMessage(NewProjectIterator.class, (String)"TXT_MobileApplication") : NbBundle.getMessage(NewProjectIterator.class, (String)"TXT_MobileLibrary"));
        }
        this.projectPanel = new ProjectPanel.WizardPanel(bl, bl);
        ((JComponent)this.projectPanel.getComponent()).putClientProperty("NewProjectWizard_Title", bl ? NbBundle.getMessage(NewProjectIterator.class, (String)"TXT_MobileApplication") : NbBundle.getMessage(NewProjectIterator.class, (String)"TXT_MobileLibrary"));
        this.psPanel = new PlatformSelectionPanel();
        this.csPanel = new ConfigurationsSelectionPanel();
        templateWizard.putProperty("RequiredConfiguration", null);
        templateWizard.putProperty("RequiredProfile", null);
        templateWizard.putProperty("PlatformDescription", null);
        templateWizard.putProperty("configuration_templates", null);
        DataObject dataObject = templateWizard.getTemplate();
        templateWizard.putProperty("ProjectName", dataObject != null ? dataObject.getPrimaryFile().getName() + '1' : null);
        this.currentIndex = 0;
        this.updateStepsList();
    }

    public void uninitialize(TemplateWizard templateWizard) {
        this.platformPanel = null;
        this.projectPanel = null;
        this.psPanel = null;
        this.csPanel = null;
        this.currentIndex = -1;
    }

    public Set<DataObject> instantiate(TemplateWizard templateWizard) throws IOException {
        Boolean bl;
        File file = (File)templateWizard.getProperty("ProjectLocation");
        String string = (String)templateWizard.getProperty("ProjectName");
        PlatformSelectionPanel.PlatformDescription platformDescription = (PlatformSelectionPanel.PlatformDescription)templateWizard.getProperty("PlatformDescription");
        if (platformDescription == null) {
            this.psPanel.readSettings(templateWizard);
            this.psPanel.storeSettings(templateWizard);
            platformDescription = (PlatformSelectionPanel.PlatformDescription)templateWizard.getProperty("PlatformDescription");
        }
        HashSet<Object> hashSet = (bl = (Boolean)templateWizard.getProperty("CreateMidlet")) != null && bl != false ? new HashSet<DataObject>() : null;
        AntProjectHelper antProjectHelper = J2MEProjectGenerator.createNewProject(file, string, platformDescription, hashSet, (Set)templateWizard.getProperty("configuration_templates"));
        if (hashSet == null) {
            hashSet = new HashSet();
        }
        hashSet.add(DataObject.find((FileObject)antProjectHelper.getProjectDirectory()));
        return hashSet;
    }

    public String name() {
        return this.current().getComponent().getName();
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.currentIndex;
        this.updateStepsList();
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.currentIndex;
        this.updateStepsList();
    }

    void updateStepsList() {
        JComponent jComponent = (JComponent)this.current().getComponent();
        if (jComponent == null) {
            return;
        }
        String[] stringArray = this.platformInstall ? new String[]{NbBundle.getMessage(PlatformInstallPanel.class, (String)"TITLE_Platform"), NbBundle.getMessage(ProjectPanel.class, (String)"TITLE_Project"), NbBundle.getMessage(PlatformSelectionPanel.class, (String)"TITLE_PlatformSelection"), NbBundle.getMessage(PlatformSelectionPanel.class, (String)"TITLE_ConfigurationsSelection")} : new String[]{NbBundle.getMessage(ProjectPanel.class, (String)"TITLE_Project"), NbBundle.getMessage(PlatformSelectionPanel.class, (String)"TITLE_PlatformSelection"), NbBundle.getMessage(PlatformSelectionPanel.class, (String)"TITLE_ConfigurationsSelection")};
        jComponent.putClientProperty("WizardPanel_contentData", stringArray);
        jComponent.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(this.currentIndex));
    }
}

