/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.project.ui.security;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.platform.Specification;
import org.netbeans.modules.mobility.cldcplatform.J2MEPlatform;
import org.netbeans.modules.mobility.project.security.KeyStoreRepository;
import org.netbeans.modules.mobility.project.security.MEKeyTool;
import org.netbeans.modules.mobility.project.ui.customizer.ErrorPanel;
import org.netbeans.modules.mobility.project.ui.security.KeyAliasCellRenderer;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class ExportPanel
extends JPanel
implements ItemListener,
ListSelectionListener {
    private static final Dimension PREFERRED_SIZE = new Dimension(500, 500);
    private DialogDescriptor dd;
    private final KeyStoreRepository.KeyStoreBean bean;
    private final KeyStoreRepository.KeyStoreBean.KeyAliasBean alias;
    private final JButton bExport;
    String keyString = NbBundle.getMessage(ExportPanel.class, (String)"LBL_Key");
    private JButton bDelete;
    private JComboBox cDomain;
    private JComboBox cPlatform;
    private JScrollPane jScrollPane1;
    private JLabel lAlias;
    private JLabel lDetails;
    private JLabel lDomain;
    private JLabel lKeys;
    private JLabel lKeystore;
    private JLabel lPlatform;
    private JList list;
    private JPanel pDetails;
    private ErrorPanel pError;
    private JTextField tAlias;
    private JTextField tKeystore;

    public ExportPanel(KeyStoreRepository.KeyStoreBean keyStoreBean, KeyStoreRepository.KeyStoreBean.KeyAliasBean keyAliasBean, J2MEPlatform j2MEPlatform, String string) {
        this.bean = keyStoreBean;
        this.alias = keyAliasBean;
        this.initComponents();
        this.initAccessibility();
        this.bDelete.setEnabled(false);
        this.bExport = new JButton(NbBundle.getMessage(ExportPanel.class, (String)"LBL_Export"));
        this.bExport.setDefaultCapable(true);
        this.bExport.setEnabled(false);
        this.bExport.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ExportPanel.this.export();
                ExportPanel.this.reloadList((J2MEPlatform)ExportPanel.this.cPlatform.getSelectedItem());
            }
        });
        this.tKeystore.setText(keyStoreBean.getKeyStorePath());
        this.tAlias.setText(keyAliasBean.getAlias());
        this.lDetails.setText(KeyAliasCellRenderer.getHtmlFormattedText(keyAliasBean));
        this.cPlatform.addItemListener(this);
        this.list.setCellRenderer(new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                if (object instanceof MEKeyTool.KeyDetail) {
                    MEKeyTool.KeyDetail keyDetail = (MEKeyTool.KeyDetail)object;
                    Color color = bl ? jList.getSelectionForeground() : jList.getForeground();
                    StringBuffer stringBuffer = new StringBuffer("<html><font color=\"#" + Integer.toHexString(color.getRGB() & 0xFFFFFF) + "\"><b>" + ExportPanel.this.keyString + ": " + keyDetail.getOrder() + "</b>");
                    String[] stringArray = keyDetail.getInfo();
                    if (stringArray != null) {
                        for (int i = 0; i < stringArray.length; ++i) {
                            stringBuffer.append("<br>").append(stringArray[i]);
                        }
                    }
                    object = stringBuffer.toString();
                }
                return super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            }
        });
        this.list.addListSelectionListener(this);
        JavaPlatform[] javaPlatformArray = JavaPlatformManager.getDefault().getPlatforms(null, new Specification("j2me", null));
        this.cPlatform.removeAllItems();
        if (javaPlatformArray != null) {
            for (int i = 0; i < javaPlatformArray.length; ++i) {
                JavaPlatform javaPlatform = javaPlatformArray[i];
                if (!(javaPlatform instanceof J2MEPlatform)) continue;
                this.cPlatform.addItem(javaPlatform);
            }
        }
        if (j2MEPlatform != null) {
            this.cPlatform.setSelectedItem(j2MEPlatform);
            if (string != null) {
                this.cDomain.setSelectedItem(string);
            }
        }
    }

    private void initComponents() {
        this.lKeystore = new JLabel();
        this.tKeystore = new JTextField();
        this.lAlias = new JLabel();
        this.tAlias = new JTextField();
        this.pDetails = new JPanel();
        this.lDetails = new JLabel();
        this.lPlatform = new JLabel();
        this.cPlatform = new JComboBox();
        this.lDomain = new JLabel();
        this.cDomain = new JComboBox();
        this.lKeys = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.list = new JList();
        this.bDelete = new JButton();
        this.pError = new ErrorPanel();
        this.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        this.setMinimumSize(new Dimension(500, 250));
        this.setPreferredSize(new Dimension(500, 250));
        this.setLayout(new GridBagLayout());
        this.lKeystore.setLabelFor(this.tKeystore);
        Mnemonics.setLocalizedText((JLabel)this.lKeystore, (String)NbBundle.getMessage(ExportPanel.class, (String)"LBL_Export_File"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.add((Component)this.lKeystore, gridBagConstraints);
        this.tKeystore.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 12, 0);
        this.add((Component)this.tKeystore, gridBagConstraints);
        this.tKeystore.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ExportPanel.class, (String)"ACSD_Export_Keystore"));
        this.lAlias.setLabelFor(this.tAlias);
        Mnemonics.setLocalizedText((JLabel)this.lAlias, (String)NbBundle.getMessage(ExportPanel.class, (String)"LBL_Export_Alias"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.add((Component)this.lAlias, gridBagConstraints);
        this.tAlias.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 12, 0);
        this.add((Component)this.tAlias, gridBagConstraints);
        this.tAlias.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ExportPanel.class, (String)"ACSD_Export_Alias"));
        this.pDetails.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(ExportPanel.class, (String)"LBL_Export_Details")));
        this.pDetails.setPreferredSize(new Dimension(300, 100));
        this.pDetails.setEnabled(false);
        this.pDetails.setLayout(new GridBagLayout());
        this.lDetails.setVerticalAlignment(1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.pDetails.add((Component)this.lDetails, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.add((Component)this.pDetails, gridBagConstraints);
        this.lPlatform.setLabelFor(this.cPlatform);
        Mnemonics.setLocalizedText((JLabel)this.lPlatform, (String)NbBundle.getMessage(ExportPanel.class, (String)"LBL_Export_Platform"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.add((Component)this.lPlatform, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 12, 0);
        this.add((Component)this.cPlatform, gridBagConstraints);
        this.cPlatform.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ExportPanel.class, (String)"ACSD_Export_Platform"));
        this.lDomain.setLabelFor(this.cDomain);
        Mnemonics.setLocalizedText((JLabel)this.lDomain, (String)NbBundle.getMessage(ExportPanel.class, (String)"LBL_Export_Domain"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.add((Component)this.lDomain, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 12, 0);
        this.add((Component)this.cDomain, gridBagConstraints);
        this.cDomain.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ExportPanel.class, (String)"ACSD_Export_Domain"));
        this.lKeys.setLabelFor(this.list);
        Mnemonics.setLocalizedText((JLabel)this.lKeys, (String)NbBundle.getMessage(ExportPanel.class, (String)"LBL_Export_Keys"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.lKeys, gridBagConstraints);
        this.list.setSelectionMode(0);
        this.jScrollPane1.setViewportView(this.list);
        this.list.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ExportPanel.class, (String)"ACSD_Export_Keys"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 3.0;
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.bDelete, (String)NbBundle.getMessage(ExportPanel.class, (String)"LBL_Export_DeleteKey"));
        this.bDelete.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ExportPanel.this.bDeleteActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(0, 6, 12, 0);
        this.add((Component)this.bDelete, gridBagConstraints);
        this.bDelete.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ExportPanel.class, (String)"ACSD_Export_DeleteKey"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.pError, gridBagConstraints);
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ExportPanel.class, (String)"ACSN_Export"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ExportPanel.class, (String)"ACSD_Export"));
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.bDelete.setEnabled(this.list.getSelectedValue() instanceof MEKeyTool.KeyDetail);
    }

    public Dimension getPreferredSize() {
        return PREFERRED_SIZE;
    }

    protected void setDialogDescriptor(DialogDescriptor dialogDescriptor) {
        this.dd = dialogDescriptor;
        this.dd.setHelpCtx(new HelpCtx(ExportPanel.class));
        this.checkErrors();
    }

    public String getErrorMessage() {
        ListModel listModel = this.list.getModel();
        for (int i = 0; i < listModel.getSize(); ++i) {
            MEKeyTool.KeyDetail keyDetail;
            String string;
            Object e = listModel.getElementAt(i);
            if (!(e instanceof MEKeyTool.KeyDetail) || (string = (keyDetail = (MEKeyTool.KeyDetail)e).getOwner()) == null || !string.equals(this.alias.getSubjectName())) continue;
            return NbBundle.getMessage(ExportPanel.class, (String)"ERR_KeyIsAlreadyInPlatform", (Object)string, (Object)Integer.toString(keyDetail.getOrder()));
        }
        return null;
    }

    public void checkErrors() {
        String string = this.getErrorMessage();
        this.pError.setErrorMessage(string);
        boolean bl = string == null;
        this.bExport.setEnabled(bl && this.cPlatform.getSelectedItem() != null);
        if (this.dd != null && bl != this.dd.isValid()) {
            this.dd.setValid(bl);
        }
    }

    private void bDeleteActionPerformed(ActionEvent actionEvent) {
        J2MEPlatform j2MEPlatform = (J2MEPlatform)this.cPlatform.getSelectedItem();
        Object e = this.list.getSelectedValue();
        String string = MEKeyTool.getMEKeyToolPath(j2MEPlatform);
        if (e instanceof MEKeyTool.KeyDetail && string != null) {
            MEKeyTool.KeyDetail keyDetail = (MEKeyTool.KeyDetail)e;
            if (DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(ExportPanel.class, (String)"MSG_DeleteKeyConfirmation", (Object)Integer.toString(keyDetail.getOrder()), (Object)j2MEPlatform.getDisplayName()), NbBundle.getMessage(ExportPanel.class, (String)"TITLE_ConfirmKeyDeletion"), 0)) == NotifyDescriptor.YES_OPTION) {
                try {
                    MEKeyTool.execute(new String[]{string, "-delete", "-number", Integer.toString(keyDetail.getOrder())});
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(ExportPanel.class, (String)"ERR_WhileDeletingKey"), 0));
                }
                this.reloadList(j2MEPlatform);
            }
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        J2MEPlatform.Device[] deviceArray;
        J2MEPlatform j2MEPlatform = (J2MEPlatform)this.cPlatform.getSelectedItem();
        ArrayList<String> arrayList = new ArrayList<String>();
        if (j2MEPlatform != null && (deviceArray = j2MEPlatform.getDevices()) != null) {
            for (int i = 0; i < deviceArray.length; ++i) {
                J2MEPlatform.Device device = deviceArray[i];
                String[] stringArray = device.getSecurityDomains();
                if (stringArray == null) continue;
                for (int j = 0; j < stringArray.length; ++j) {
                    String string = stringArray[j];
                    if (arrayList.contains(string)) continue;
                    arrayList.add(string);
                }
            }
        }
        this.cDomain.removeAllItems();
        for (int i = 0; i < arrayList.size(); ++i) {
            this.cDomain.addItem(arrayList.get(i));
        }
        this.reloadList(j2MEPlatform);
    }

    protected void reloadList(J2MEPlatform j2MEPlatform) {
        this.bDelete.setEnabled(false);
        if (j2MEPlatform != null) {
            this.setListLoading();
            this.setList(MEKeyTool.listKeys(j2MEPlatform));
        } else {
            this.setListNotLoaded();
        }
        this.checkErrors();
    }

    private void setListNotLoaded() {
        DefaultListModel<String> defaultListModel = new DefaultListModel<String>();
        defaultListModel.addElement(NbBundle.getMessage(ExportPanel.class, (String)"LBL_NotLoaded"));
        this.list.setModel(defaultListModel);
    }

    private void setListLoading() {
        DefaultListModel<String> defaultListModel = new DefaultListModel<String>();
        defaultListModel.addElement(NbBundle.getMessage(ExportPanel.class, (String)"LBL_Loading"));
        this.list.setModel(defaultListModel);
    }

    private void setList(MEKeyTool.KeyDetail[] keyDetailArray) {
        DefaultListModel<Object> defaultListModel = new DefaultListModel<Object>();
        if (keyDetailArray != null) {
            if (keyDetailArray.length > 0) {
                for (int i = 0; i < keyDetailArray.length; ++i) {
                    MEKeyTool.KeyDetail keyDetail = keyDetailArray[i];
                    defaultListModel.addElement(keyDetail);
                }
            } else {
                defaultListModel.addElement(NbBundle.getMessage(ExportPanel.class, (String)"LBL_NoKey"));
            }
        } else {
            defaultListModel.addElement(NbBundle.getMessage(ExportPanel.class, (String)"LBL_ErrorLoadingKeys"));
        }
        this.list.setModel(defaultListModel);
    }

    public static void showExportKeyIntoPlatform(KeyStoreRepository.KeyStoreBean keyStoreBean, KeyStoreRepository.KeyStoreBean.KeyAliasBean keyAliasBean, J2MEPlatform j2MEPlatform, String string) {
        if (!(keyStoreBean != null && keyAliasBean != null && keyStoreBean.isOpened() && keyAliasBean.isValid() && keyAliasBean.isOpened())) {
            return;
        }
        ExportPanel exportPanel = new ExportPanel(keyStoreBean, keyAliasBean, j2MEPlatform, string);
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)exportPanel, NbBundle.getMessage(ExportPanel.class, (String)"TITLE_ExportKey"), true, null);
        dialogDescriptor.setOptions(new Object[]{exportPanel.bExport, NotifyDescriptor.CLOSED_OPTION});
        dialogDescriptor.setClosingOptions(new Object[]{NotifyDescriptor.CLOSED_OPTION});
        exportPanel.setDialogDescriptor(dialogDescriptor);
        exportPanel.checkErrors();
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void export() {
        J2MEPlatform j2MEPlatform = (J2MEPlatform)this.cPlatform.getSelectedItem();
        String string = (String)this.cDomain.getSelectedItem();
        String string2 = MEKeyTool.getMEKeyToolPath(j2MEPlatform);
        if (j2MEPlatform != null && string != null && string2 != null) {
            File file = new File(System.getProperty("user.home", ""), ".keystore");
            if (file.exists()) {
                if (DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(ExportPanel.class, (String)"MSG_PromptDeleteFile", (Object)this.bean.getKeyStorePath(), (Object)file.getAbsolutePath()), NbBundle.getMessage(ExportPanel.class, (String)"MSG_PromptDeleteFileTitle"), 0)) != NotifyDescriptor.YES_OPTION) {
                    return;
                }
                if (!file.delete()) {
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(ExportPanel.class, (String)"ERR_CannotDeleteFile", (Object)file.getAbsolutePath()), 0));
                    return;
                }
            }
            boolean bl = false;
            if (!KeyStoreRepository.KeyStoreBean.equalFiles(this.bean.getKeyStoreFile(), file)) {
                bl = true;
                FileInputStream fileInputStream = null;
                FileOutputStream fileOutputStream = null;
                try {
                    fileInputStream = new FileInputStream(this.bean.getKeyStoreFile());
                    fileOutputStream = new FileOutputStream(file);
                    FileUtil.copy((InputStream)fileInputStream, (OutputStream)fileOutputStream);
                }
                catch (IOException iOException) {
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(ExportPanel.class, (String)"ERR_IOErrorWhileCopying", (Object)this.bean.getKeyStorePath(), (Object)file.getAbsolutePath()), 0));
                    iOException.printStackTrace();
                    return;
                }
                finally {
                    if (fileInputStream != null) {
                        try {
                            fileInputStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (fileOutputStream != null) {
                        try {
                            fileOutputStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
            try {
                MEKeyTool.execute(new String[]{string2, "-import", "-storepass", this.bean.getPassword(), "-alias", this.alias.getAlias(), "-domain", string});
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(ExportPanel.class, (String)"MSG_ErrorExportingKey"), 0));
            }
            if (bl) {
                file.delete();
            }
        }
    }
}

