/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor.gsf;

import java.util.Collections;
import java.util.Set;
import org.netbeans.editor.ext.html.parser.AstNode;
import org.netbeans.editor.ext.html.parser.AstPath;
import org.netbeans.modules.gsf.api.CompilationInfo;
import org.netbeans.modules.gsf.api.ElementHandle;
import org.netbeans.modules.gsf.api.ElementKind;
import org.netbeans.modules.gsf.api.Modifier;
import org.openide.filesystems.FileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlElementHandle
implements ElementHandle {
    private AstNode node;
    private CompilationInfo ci;

    HtmlElementHandle(AstNode astNode, CompilationInfo compilationInfo) {
        this.node = astNode;
        this.ci = compilationInfo;
    }

    public FileObject getFileObject() {
        return this.ci.getFileObject();
    }

    public String getMimeType() {
        return "text/html";
    }

    public String getName() {
        return this.node.name();
    }

    public String getIn() {
        return null;
    }

    public ElementKind getKind() {
        return ElementKind.TAG;
    }

    public Set<Modifier> getModifiers() {
        return Collections.emptySet();
    }

    public boolean signatureEquals(ElementHandle elementHandle) {
        if (!(elementHandle instanceof HtmlElementHandle)) {
            return false;
        }
        AstNode astNode = ((HtmlElementHandle)elementHandle).node();
        if (this.node == astNode) {
            return true;
        }
        AstPath astPath = astNode.path();
        AstPath astPath2 = this.node.path();
        return astPath2.equals((Object)astPath);
    }

    public AstNode node() {
        return this.node;
    }

    public CompilationInfo compilationInfo() {
        return this.ci;
    }
}

