/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.schema.completion.util;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.netbeans.modules.xml.retriever.catalog.Utilities;
import org.netbeans.modules.xml.schema.completion.spi.CompletionContext;
import org.netbeans.modules.xml.schema.completion.spi.CompletionModelProvider;
import org.netbeans.modules.xml.schema.completion.util.CatalogModelProvider;
import org.netbeans.modules.xml.schema.completion.util.CompletionContextImpl;
import org.netbeans.modules.xml.schema.completion.util.CompletionModelEx;
import org.netbeans.modules.xml.schema.completion.util.CompletionUtil;
import org.netbeans.modules.xml.schema.model.SchemaModel;
import org.netbeans.modules.xml.schema.model.SchemaModelFactory;
import org.netbeans.modules.xml.xam.ModelSource;
import org.netbeans.modules.xml.xam.locator.CatalogModel;
import org.netbeans.modules.xml.xam.locator.CatalogModelFactory;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultModelProvider
extends CompletionModelProvider {
    private CompletionContextImpl context;

    public DefaultModelProvider() {
    }

    public DefaultModelProvider(CompletionContextImpl completionContextImpl) {
        this.context = completionContextImpl;
    }

    @Override
    public synchronized List<CompletionModelProvider.CompletionModel> getModels(CompletionContext completionContext) {
        if (completionContext.getPrimaryFile() == null) {
            return null;
        }
        this.context = (CompletionContextImpl)completionContext;
        List<URI> list = this.context.getSchemas();
        if (list == null || list.size() == 0) {
            return null;
        }
        ArrayList<CompletionModelProvider.CompletionModel> arrayList = new ArrayList<CompletionModelProvider.CompletionModel>();
        for (URI uRI : list) {
            CompletionModelProvider.CompletionModel completionModel = this.getCompletionModel(uRI, true);
            if (completionModel == null) continue;
            arrayList.add(completionModel);
        }
        return arrayList;
    }

    CompletionModelProvider.CompletionModel getCompletionModel(URI uRI, boolean bl) {
        CompletionModelEx completionModelEx = null;
        try {
            Object object;
            ModelSource modelSource = null;
            CatalogModel catalogModel = null;
            CatalogModelProvider catalogModelProvider = this.getCatalogModelProvider();
            if (catalogModelProvider == null) {
                modelSource = Utilities.getModelSource((FileObject)this.context.getPrimaryFile(), (boolean)true);
                object = CatalogModelFactory.getDefault();
                catalogModel = object.getCatalogModel(modelSource);
            } else {
                modelSource = catalogModelProvider.getModelSource(this.context.getPrimaryFile(), true);
                catalogModel = catalogModelProvider.getCatalogModel();
            }
            object = new URI(uRI.toString() + "?fetch=" + bl + "&&sync=" + true);
            ModelSource modelSource2 = catalogModel.getModelSource((URI)object, modelSource);
            SchemaModel schemaModel = null;
            schemaModel = modelSource2.getLookup().lookup(FileObject.class) == null ? (SchemaModel)SchemaModelFactory.getDefault().createFreshModel(modelSource2) : SchemaModelFactory.getDefault().getModel(modelSource2);
            String string = schemaModel.getSchema().getTargetNamespace();
            List<String> list = CompletionUtil.getPrefixesAgainstNamespace(this.context, string);
            completionModelEx = list != null && list.size() > 0 ? new CompletionModelEx(this.context, list.get(0), schemaModel) : new CompletionModelEx(this.context, this.context.suggestPrefix(string), schemaModel);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return completionModelEx;
    }

    private CatalogModelProvider getCatalogModelProvider() {
        Lookup.Template template = new Lookup.Template(CatalogModelProvider.class);
        Lookup.Result result = Lookup.getDefault().lookup(template);
        Collection collection = result.allInstances();
        if (collection == null || collection.size() == 0) {
            return null;
        }
        return (CatalogModelProvider)collection.iterator().next();
    }
}

