/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.project.anttasks.util;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class Util {
    private static final String WSDL_FILE_EXTENSION = "wsdl";
    private static final String XSD_FILE_EXTENSION = "xsd";
    private static final String BPEL_FILE_EXTENSION = "bpel";

    private Util() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File source, File destination) throws IOException {
        if (!source.exists() || !source.isFile()) {
            throw new IOException("Source is not valid for copying.");
        }
        if (!destination.exists()) {
            destination.getParentFile().mkdirs();
            destination.createNewFile();
        }
        File realDest = destination.isDirectory() ? new File(destination, source.getName()) : destination;
        FileInputStream input = null;
        FileOutputStream output = null;
        try {
            input = new FileInputStream(source);
            output = new FileOutputStream(realDest);
            byte[] buffer = new byte[4096];
            while (input.available() > 0) {
                output.write(buffer, 0, input.read(buffer));
            }
        }
        finally {
            if (input != null) {
                input.close();
            }
            if (output != null) {
                output.close();
            }
        }
    }

    public static String getRelativePath(File home, File f) {
        return Util.matchPathLists(Util.getPathList(home), Util.getPathList(f));
    }

    private static List getPathList(File f) {
        ArrayList<String> l = new ArrayList<String>();
        try {
            for (File r = f.getCanonicalFile(); r != null; r = r.getParentFile()) {
                l.add(r.getName());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            l = null;
        }
        return l;
    }

    private static String matchPathLists(List r, List f) {
        int j;
        String s = "";
        int i = r.size() - 1;
        for (j = f.size() - 1; i >= 0 && j >= 0 && r.get(i).equals(f.get(j)); --i, --j) {
        }
        while (i >= 0) {
            s = s + ".." + File.separator;
            --i;
        }
        while (j >= 1) {
            s = s + f.get(j) + File.separator;
            --j;
        }
        s = s + f.get(j);
        return s;
    }

    public static class WsdlFileFilter
    implements FileFilter {
        public boolean accept(File pathname) {
            boolean result = false;
            String fileName = pathname.getName();
            String fileExtension = null;
            int dotIndex = fileName.lastIndexOf(46);
            if (dotIndex != -1) {
                fileExtension = fileName.substring(dotIndex + 1);
            }
            if (fileExtension != null && fileExtension.equalsIgnoreCase(Util.WSDL_FILE_EXTENSION)) {
                result = true;
            }
            return result;
        }
    }

    public static class BpelFileFilter
    implements FileFilter {
        public boolean accept(File pathname) {
            if (pathname.isDirectory()) {
                return true;
            }
            String fileName = pathname.getName();
            int dotIndex = fileName.lastIndexOf(46);
            String fileExtension = null;
            if (dotIndex != -1) {
                fileExtension = fileName.substring(dotIndex + 1);
            }
            if (fileExtension == null) {
                return false;
            }
            return fileExtension.equalsIgnoreCase(Util.BPEL_FILE_EXTENSION);
        }
    }

    public static class ProjectFileFilter
    implements FileFilter {
        public boolean accept(File pathname) {
            boolean result = false;
            String fileName = pathname.getName();
            String fileExtension = null;
            int dotIndex = fileName.lastIndexOf(46);
            if (dotIndex != -1) {
                fileExtension = fileName.substring(dotIndex + 1);
            }
            if (fileExtension != null && (fileExtension.equalsIgnoreCase(Util.WSDL_FILE_EXTENSION) || fileExtension.equalsIgnoreCase(Util.XSD_FILE_EXTENSION))) {
                result = true;
            }
            return result;
        }
    }
}

