/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.project.anttasks.util;

import java.io.File;
import java.io.FileReader;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import org.apache.xml.resolver.CatalogManager;
import org.apache.xml.resolver.tools.ResolvingXMLReader;
import org.netbeans.modules.bpel.project.anttasks.util.Util;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CatalogReader {
    private MyContentHandler mContentHandler = new MyContentHandler();
    private Stack<File> nextCatalogs = new Stack();
    private File rootCatalog;
    private File currentCatalog;
    private List<String> namespaces = new LinkedList<String>();
    private List<String> locations = new LinkedList<String>();

    public CatalogReader(String catalogXML) throws Exception {
        CatalogManager manager = new CatalogManager(null);
        manager.setUseStaticCatalog(false);
        manager.setPreferPublic(false);
        ResolvingXMLReader saxParser = new ResolvingXMLReader(manager);
        saxParser.setContentHandler((ContentHandler)this.mContentHandler);
        this.rootCatalog = new File(catalogXML);
        this.nextCatalogs.push(this.rootCatalog);
        do {
            this.currentCatalog = this.nextCatalogs.pop();
            if (!this.currentCatalog.exists() || this.currentCatalog.length() <= 0L) continue;
            saxParser.parse(new InputSource(new FileReader(this.currentCatalog)));
        } while (this.nextCatalogs.size() > 0);
    }

    public List<String> getNamespaces() {
        return this.namespaces;
    }

    public List<String> getLocations() {
        return this.locations;
    }

    private class MyContentHandler
    extends DefaultHandler {
        private static final String SYSTEM_CONST = "system";
        private static final String SYSTEM_ID_CONST = "systemId";
        private static final String URI_CONST = "uri";
        private static final String NEXT_CATALOG_CONST = "nextCatalog";
        private static final String CATALOG_CONST = "catalog";
        boolean isSystem = false;

        private MyContentHandler() {
        }

        public void startElement(String uri, String localName, String qName, Attributes atts) {
            if (qName.equals(SYSTEM_CONST)) {
                String namespace = atts.getValue(SYSTEM_ID_CONST);
                String location = atts.getValue(URI_CONST);
                if (namespace != null && !CatalogReader.this.namespaces.contains(namespace)) {
                    if (CatalogReader.this.currentCatalog != CatalogReader.this.rootCatalog) {
                        location = Util.getRelativePath(CatalogReader.this.rootCatalog.getParentFile(), CatalogReader.this.currentCatalog.getParentFile()) + "/" + location;
                    }
                    CatalogReader.this.namespaces.add(namespace);
                    CatalogReader.this.locations.add(location.replace("\\", "/"));
                }
            }
            if (qName.equals(NEXT_CATALOG_CONST)) {
                String catalog = atts.getValue(CATALOG_CONST);
                CatalogReader.this.nextCatalogs.push(new File(CatalogReader.this.currentCatalog.getParentFile(), catalog));
            }
        }
    }
}

