/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.project.anttasks.ide;

import java.io.File;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.bpel.model.api.BpelModel;
import org.netbeans.modules.bpel.project.anttasks.cli.CliJbiGenerator;
import org.netbeans.modules.bpel.project.anttasks.ide.IdeBpelCatalogModel;

public class IdeJbiGenerator
extends CliJbiGenerator {
    private Logger logger = Logger.getLogger(IdeJbiGenerator.class.getName());

    public IdeJbiGenerator() {
    }

    public IdeJbiGenerator(List sourceDirs) {
        super(sourceDirs);
    }

    protected void processFile(File file, File sourceDir) {
        String fileName = file.getName();
        String fileExtension = null;
        int dotIndex = fileName.lastIndexOf(46);
        if (dotIndex != -1) {
            fileExtension = fileName.substring(dotIndex + 1);
        }
        if (fileExtension != null && fileExtension.equalsIgnoreCase("bpel")) {
            BpelModel bpelModel = null;
            try {
                bpelModel = IdeBpelCatalogModel.getDefault().getBPELModel(file);
            }
            catch (Exception ex) {
                this.logger.log(Level.SEVERE, "Error while creating BPEL Model ", ex);
                throw new RuntimeException("Error while creating BPEL Model ", ex);
            }
            try {
                this.populateProviderConsumer(bpelModel, file, sourceDir);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                this.logger.log(Level.SEVERE, "Error encountered while processing BPEL file - " + file.getAbsolutePath());
                throw new RuntimeException(ex);
            }
        }
    }
}

