/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.customization.multiview;

import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.EventListener;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.websvc.customization.model.BindingCustomization;
import org.netbeans.modules.websvc.customization.model.CustomizationComponentFactory;
import org.netbeans.modules.websvc.customization.model.DefinitionsCustomization;
import org.netbeans.modules.websvc.customization.model.EnableMIMEContent;
import org.netbeans.modules.websvc.customization.multiview.SaveableSectionInnerPanel;
import org.netbeans.modules.xml.multiview.ui.SectionView;
import org.netbeans.modules.xml.wsdl.model.Binding;
import org.netbeans.modules.xml.wsdl.model.Definitions;
import org.netbeans.modules.xml.wsdl.model.ExtensibilityElement;
import org.netbeans.modules.xml.wsdl.model.WSDLComponent;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;

public class BindingPanel
extends SaveableSectionInnerPanel {
    private Binding binding;
    private WSDLModel model;
    private boolean wsdlDirty;
    private ModelChangeListener modelListener;
    private BindingActionListener actionListener;
    private Definitions primaryDefinitions;
    private ButtonGroup emcButtonGroup;
    private JCheckBox enableMIMEContentCB;

    public BindingPanel(SectionView sectionView, Binding binding, Definitions definitions) {
        super(sectionView);
        this.binding = binding;
        this.primaryDefinitions = definitions;
        this.model = this.binding.getModel();
        this.initComponents();
        this.sync();
        this.modelListener = new ModelChangeListener();
        WSDLModel wSDLModel = definitions.getModel();
        PropertyChangeListener propertyChangeListener = WeakListeners.propertyChange((PropertyChangeListener)this.modelListener, (Object)wSDLModel);
        wSDLModel.addPropertyChangeListener(propertyChangeListener);
        this.actionListener = new BindingActionListener();
        ActionListener actionListener = (ActionListener)WeakListeners.create(ActionListener.class, (EventListener)this.actionListener, (Object)this.enableMIMEContentCB);
        this.enableMIMEContentCB.addActionListener(actionListener);
    }

    private boolean getMIMEContentOfParent() {
        DefinitionsCustomization definitionsCustomization;
        EnableMIMEContent enableMIMEContent;
        List list = this.primaryDefinitions.getExtensibilityElements(DefinitionsCustomization.class);
        if (list.size() > 0 && (enableMIMEContent = (definitionsCustomization = (DefinitionsCustomization)list.get(0)).getEnableMIMEContent()) != null) {
            return enableMIMEContent.isEnabled();
        }
        return false;
    }

    private void sync() {
        List list = this.binding.getExtensibilityElements(BindingCustomization.class);
        if (list.size() == 1) {
            BindingCustomization bindingCustomization = (BindingCustomization)list.get(0);
            EnableMIMEContent enableMIMEContent = bindingCustomization.getEnableMIMEContent();
            if (enableMIMEContent != null) {
                this.setEnableMIMEContent(enableMIMEContent.isEnabled());
            } else {
                this.setEnableMIMEContent(this.getMIMEContentOfParent());
            }
        } else {
            this.setEnableMIMEContent(this.getMIMEContentOfParent());
        }
    }

    public void setEnableMIMEContent(boolean bl) {
        this.enableMIMEContentCB.setSelected(bl);
    }

    public boolean getEnableMIMEContent() {
        return this.enableMIMEContentCB.isSelected();
    }

    public JComponent getErrorComponent(String string) {
        return new JButton("error");
    }

    public void linkButtonPressed(Object object, String string) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(JComponent jComponent, Object object) {
        List list = this.binding.getExtensibilityElements(BindingCustomization.class);
        CustomizationComponentFactory customizationComponentFactory = CustomizationComponentFactory.getDefault();
        if (jComponent == this.enableMIMEContentCB) {
            if (list.size() > 0) {
                BindingCustomization bindingCustomization = (BindingCustomization)list.get(0);
                EnableMIMEContent enableMIMEContent = bindingCustomization.getEnableMIMEContent();
                if (enableMIMEContent == null) {
                    try {
                        this.model.startTransaction();
                        enableMIMEContent = customizationComponentFactory.createEnableMIMEContent(this.model);
                        enableMIMEContent.setEnabled(this.getEnableMIMEContent());
                        bindingCustomization.setEnableMIMEContent(enableMIMEContent);
                        this.wsdlDirty = true;
                    }
                    finally {
                        this.model.endTransaction();
                    }
                } else {
                    try {
                        this.model.startTransaction();
                        enableMIMEContent.setEnabled(this.getEnableMIMEContent());
                        this.wsdlDirty = true;
                    }
                    finally {
                        this.model.endTransaction();
                    }
                }
            } else {
                BindingCustomization bindingCustomization = customizationComponentFactory.createBindingCustomization(this.model);
                EnableMIMEContent enableMIMEContent = customizationComponentFactory.createEnableMIMEContent(this.model);
                try {
                    this.model.startTransaction();
                    enableMIMEContent.setEnabled(this.getEnableMIMEContent());
                    bindingCustomization.setEnableMIMEContent(enableMIMEContent);
                    this.binding.addExtensibilityElement((ExtensibilityElement)bindingCustomization);
                    this.wsdlDirty = true;
                }
                finally {
                    this.model.endTransaction();
                }
            }
        }
    }

    public boolean wsdlIsDirty() {
        return this.wsdlDirty;
    }

    public void save() {
        if (this.wsdlDirty) {
            this.setModelDirty(this.model);
        }
    }

    private void initComponents() {
        this.emcButtonGroup = new ButtonGroup();
        this.enableMIMEContentCB = new JCheckBox();
        this.enableMIMEContentCB.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/websvc/customization/multiview/Bundle").getString("MNEMONIC_ENABLE_MIME_CONTENT").charAt(0));
        this.enableMIMEContentCB.setText(NbBundle.getBundle(BindingPanel.class).getString("LBL_ENABLE_MIME_CONTENT"));
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org/netbeans/modules/websvc/customization/multiview/Bundle");
        this.enableMIMEContentCB.setToolTipText(resourceBundle.getString("TOOLTIP_ENABLE_MIME"));
        this.enableMIMEContentCB.setActionCommand(resourceBundle.getString("LBL_ENABLE_MIME_CONTENT"));
        this.enableMIMEContentCB.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.enableMIMEContentCB.setContentAreaFilled(false);
        this.enableMIMEContentCB.setMargin(new Insets(0, 0, 0, 0));
        GroupLayout groupLayout = new GroupLayout((Container)((Object)this));
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.enableMIMEContentCB).addContainerGap(409, Short.MAX_VALUE)));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(25, 25, 25).add((Component)this.enableMIMEContentCB).addContainerGap(30, Short.MAX_VALUE)));
        this.enableMIMEContentCB.getAccessibleContext().setAccessibleName(resourceBundle.getString("LBL_ENABLE_MIME_CONTENT"));
        this.enableMIMEContentCB.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("LBL_ENABLE_MIME_CONTENT"));
    }

    class BindingActionListener
    implements ActionListener {
        BindingActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            BindingPanel.this.setValue((JComponent)actionEvent.getSource(), null);
        }
    }

    class ModelChangeListener
    implements PropertyChangeListener {
        ModelChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            EnableMIMEContent enableMIMEContent;
            WSDLComponent wSDLComponent;
            Object object = propertyChangeEvent.getSource();
            if (object instanceof EnableMIMEContent && (wSDLComponent = (WSDLComponent)(enableMIMEContent = (EnableMIMEContent)object).getParent()) instanceof DefinitionsCustomization) {
                BindingPanel.this.sync();
            }
        }
    }
}

