/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.customization.core.ui;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import org.netbeans.modules.websvc.api.jaxws.project.config.Client;
import org.netbeans.modules.websvc.api.jaxws.project.config.JaxWsModel;
import org.netbeans.modules.websvc.api.jaxws.project.config.Service;
import org.netbeans.modules.websvc.api.jaxws.project.config.WsimportOption;
import org.netbeans.modules.websvc.api.jaxws.project.config.WsimportOptions;
import org.netbeans.modules.websvc.core.wseditor.spi.WSEditor;
import org.netbeans.modules.websvc.customization.jaxwssettings.panel.WsimportOptionsPanel;
import org.openide.ErrorManager;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JaxwsSettingsEditor
implements WSEditor {
    private Service service;
    private Client client;
    private WsimportOptionsPanel panel;

    public JComponent createWSEditorComponent(Node node, JaxWsModel jaxWsModel) {
        this.service = (Service)node.getLookup().lookup(Service.class);
        this.client = (Client)node.getLookup().lookup(Client.class);
        WsimportOptions wsimportOptions = null;
        if (this.service != null) {
            wsimportOptions = this.service.getWsImportOptions();
        } else if (this.client != null) {
            wsimportOptions = this.client.getWsImportOptions();
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (wsimportOptions != null) {
            WsimportOption[] wsimportOptionArray = wsimportOptions.getWsimportOptions();
            for (int i = 0; i < wsimportOptionArray.length; ++i) {
                WsimportOption wsimportOption = wsimportOptionArray[i];
                hashMap.put(wsimportOption.getWsimportOptionName(), wsimportOption.getWsimportOptionValue());
            }
        }
        this.panel = new WsimportOptionsPanel(hashMap);
        return this.panel;
    }

    public String getTitle() {
        return NbBundle.getMessage(JaxwsSettingsEditor.class, (String)"JAXWS_SETTINGS_TITLE");
    }

    public void save(Node node, JaxWsModel jaxWsModel) {
        try {
            Map<String, String> map = this.getWsimportOptions();
            Set<String> set = map.keySet();
            WsimportOptions wsimportOptions = null;
            if (this.service != null) {
                wsimportOptions = this.service.getWsImportOptions();
            } else if (this.client != null) {
                wsimportOptions = this.client.getWsImportOptions();
            }
            if (wsimportOptions != null) {
                wsimportOptions.clearWsimportOptions();
                for (String string : set) {
                    WsimportOption wsimportOption = wsimportOptions.newWsimportOption();
                    wsimportOption.setWsimportOptionName(string);
                    wsimportOption.setWsimportOptionValue(map.get(string));
                    wsimportOptions.addWsimportOption(wsimportOption);
                }
                jaxWsModel.write();
            }
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
        }
    }

    public void cancel(Node node, JaxWsModel jaxWsModel) {
    }

    public String getDescription() {
        return NbBundle.getMessage(JaxwsSettingsEditor.class, (String)"JAXWS_SETTINGS_DESC");
    }

    private Map<String, String> getWsimportOptions() {
        return this.panel.getWsimportOptions();
    }
}

