/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.design.view.panels;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.project.Project;
import org.netbeans.modules.websvc.design.view.panels.ImportSchemaDialog;
import org.netbeans.modules.xml.schema.model.Schema;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportedSchemasPanel
extends JPanel {
    private Project project;
    private Schema[] importedSchemas;
    private DefaultListModel listModel;
    private JButton addBtn;
    private JList importedSchemasList;
    private JScrollPane jScrollPane1;
    private JButton removeBtn;
    private JLabel schemasLabel;

    public ImportedSchemasPanel(Project project, Schema[] schemaArray) {
        this.project = project;
        this.importedSchemas = schemaArray;
        this.initComponents();
        this.addBtn.addActionListener(new AddButtonActionListener());
        this.removeBtn.addActionListener(new RemoveButtonActionListener());
        this.listModel = new DefaultListModel();
        this.importedSchemasList.setModel(this.listModel);
        this.importedSchemasList.setCellRenderer(new ImportedSchemasPanelListCellRenderer());
        this.importedSchemasList.addListSelectionListener(new SchemaListSelectionListener());
        this.populateSchemas();
        this.removeBtn.setEnabled(false);
    }

    private void populateSchemas() {
        for (int i = 0; i < this.importedSchemas.length; ++i) {
            this.listModel.addElement(this.importedSchemas[i]);
        }
    }

    public DefaultListModel getListModel() {
        return this.listModel;
    }

    private int getSelectedRow() {
        ListSelectionModel listSelectionModel = this.importedSchemasList.getSelectionModel();
        if (listSelectionModel.isSelectionEmpty()) {
            return -1;
        }
        return listSelectionModel.getMinSelectionIndex();
    }

    public Set<Schema> getSchemas() {
        HashSet<Schema> hashSet = new HashSet<Schema>();
        for (int i = 0; i < this.listModel.getSize(); ++i) {
            Schema schema = (Schema)this.listModel.getElementAt(i);
            hashSet.add(schema);
        }
        return hashSet;
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.importedSchemasList = new JList();
        this.addBtn = new JButton();
        this.removeBtn = new JButton();
        this.schemasLabel = new JLabel();
        this.importedSchemasList.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.importedSchemasList.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            public int getSize() {
                return this.strings.length;
            }

            public Object getElementAt(int n) {
                return this.strings[n];
            }
        });
        this.jScrollPane1.setViewportView(this.importedSchemasList);
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org/netbeans/modules/websvc/design/view/panels/Bundle");
        Mnemonics.setLocalizedText((AbstractButton)this.addBtn, (String)resourceBundle.getString("Add_DotDotDot_label"));
        Mnemonics.setLocalizedText((AbstractButton)this.removeBtn, (String)resourceBundle.getString("Remove_label"));
        this.schemasLabel.setLabelFor(this.importedSchemasList);
        Mnemonics.setLocalizedText((JLabel)this.schemasLabel, (String)resourceBundle.getString("LBL_IMPORTED_SCHEMAS"));
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.schemasLabel).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.jScrollPane1, -1, 319, Short.MAX_VALUE).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.addBtn, -1, 114, Short.MAX_VALUE).add((Component)this.removeBtn, -1, 114, Short.MAX_VALUE)))).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.schemasLabel).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.addBtn).addPreferredGap(0).add((Component)this.removeBtn)).add((Component)this.jScrollPane1, -1, 276, Short.MAX_VALUE)).addContainerGap()));
    }

    class ImportedSchemasPanelListCellRenderer
    extends JLabel
    implements ListCellRenderer {
        public ImportedSchemasPanelListCellRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (object instanceof Schema) {
                Schema schema = (Schema)object;
                this.setText(schema.getTargetNamespace());
            } else {
                this.setText(object.toString());
            }
            this.setBackground(bl ? Color.black : Color.white);
            this.setForeground(bl ? Color.white : Color.black);
            return this;
        }
    }

    class SchemaListSelectionListener
    implements ListSelectionListener {
        SchemaListSelectionListener() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (ImportedSchemasPanel.this.importedSchemasList.getSelectedIndex() >= 0) {
                ImportedSchemasPanel.this.removeBtn.setEnabled(true);
            } else {
                ImportedSchemasPanel.this.removeBtn.setEnabled(false);
            }
        }
    }

    class AddButtonActionListener
    implements ActionListener {
        DialogDescriptor dlgDesc = null;

        AddButtonActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ImportSchemaDialog importSchemaDialog = new ImportSchemaDialog(ImportedSchemasPanel.this.project);
            importSchemaDialog.show();
            if (importSchemaDialog.okButtonPressed()) {
                Set<Schema> set = importSchemaDialog.getSelectedSchemas();
                for (Schema schema : set) {
                    ImportedSchemasPanel.this.listModel.addElement(schema);
                }
            }
        }
    }

    class RemoveButtonActionListener
    implements ActionListener {
        RemoveButtonActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = ImportedSchemasPanel.this.getSelectedRow();
            if (n == -1) {
                return;
            }
            Schema schema = (Schema)ImportedSchemasPanel.this.listModel.getElementAt(n);
            if (this.confirmDeletion(schema.getTargetNamespace())) {
                ImportedSchemasPanel.this.listModel.removeElementAt(n);
            }
        }

        private boolean confirmDeletion(String string) {
            NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(ImportedSchemasPanel.class, (String)"MSG_CONFIRM_DELETE", (Object)string), NbBundle.getMessage(ImportedSchemasPanel.class, (String)"TTL_CONFIRM_DELETE"), 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation);
            return confirmation.getValue() == NotifyDescriptor.YES_OPTION;
        }
    }
}

