/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.design.view.actions;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.Set;
import javax.swing.AbstractAction;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.websvc.api.jaxws.project.config.Service;
import org.netbeans.modules.websvc.core.MethodGenerator;
import org.netbeans.modules.websvc.design.javamodel.MethodModel;
import org.netbeans.modules.websvc.design.schema2java.OperationGeneratorHelper;
import org.netbeans.modules.websvc.design.util.WSDLUtils;
import org.netbeans.modules.websvc.design.view.actions.AddOperationAction;
import org.netbeans.modules.websvc.jaxws.api.JAXWSSupport;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoveOperationAction
extends AbstractAction {
    private Set<MethodModel> methods;
    private Service service;

    public RemoveOperationAction(Service service) {
        super(RemoveOperationAction.getName());
        this.putValue("ShortDescription", NbBundle.getMessage(RemoveOperationAction.class, (String)"Hint_RemoveOperation"));
        this.putValue("MnemonicKey", Integer.valueOf(NbBundle.getMessage(AddOperationAction.class, (String)"LBL_RemoveOperation_mnem_pos")));
        this.service = service;
        this.setEnabled(false);
    }

    public void setWorkingSet(Set<MethodModel> set) {
        this.methods = set;
        this.setEnabled(set != null && !set.isEmpty());
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.methods.size() < 1) {
            return;
        }
        boolean bl = this.methods.size() == 1;
        String string = bl ? this.methods.iterator().next().getOperationName() : "" + this.methods.size();
        NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(RemoveOperationAction.class, (String)(bl ? "MSG_OPERATION_DELETE" : "MSG_OPERATIONS_DELETE"), (Object)string));
        Object object = DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation);
        if (object == NotifyDescriptor.YES_OPTION) {
            final ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(RemoveOperationAction.class, (String)(bl ? "MSG_RemoveOperation" : "MSG_RemoveOperations"), (Object)string));
            Task task = new Task(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    progressHandle.start();
                    try {
                        RemoveOperationAction.this.removeOperation(RemoveOperationAction.this.methods);
                    }
                    catch (IOException iOException) {
                        progressHandle.finish();
                        ErrorManager.getDefault().notify((Throwable)iOException);
                    }
                    finally {
                        progressHandle.finish();
                    }
                }
            });
            RequestProcessor.getDefault().post((Runnable)task);
        }
    }

    private String convertOperationName(String string) {
        String string2 = string;
        String string3 = string2.substring(0, 1);
        string3 = string3.toLowerCase();
        string2 = string3.concat(string2.substring(1));
        return string2;
    }

    private void removeOperation(Set<MethodModel> set) throws IOException {
        for (MethodModel methodModel : set) {
            WSDLModel wSDLModel;
            OperationGeneratorHelper operationGeneratorHelper;
            String string = methodModel.getOperationName();
            FileObject fileObject = this.getImplementationClass(methodModel);
            File file = this.getWSDLFile(fileObject);
            if (file != null) {
                operationGeneratorHelper = new OperationGeneratorHelper(file);
                wSDLModel = WSDLUtils.getWSDLModel(FileUtil.toFileObject((File)file), true);
                operationGeneratorHelper.removeWSOperation(wSDLModel, OperationGeneratorHelper.getPortTypeNameFromImpl(fileObject), string);
                operationGeneratorHelper.generateJavaArtifacts(this.service.getName(), fileObject, this.convertOperationName(string), true);
            } else {
                MethodGenerator.deleteMethod((FileObject)fileObject, (String)string);
            }
            if (!(operationGeneratorHelper = DataObject.find((FileObject)fileObject)).isModified() || (wSDLModel = (SaveCookie)operationGeneratorHelper.getCookie(SaveCookie.class)) == null) continue;
            wSDLModel.save();
        }
    }

    private File getWSDLFile(FileObject fileObject) {
        FileObject fileObject2;
        JAXWSSupport jAXWSSupport;
        String string = this.service.getLocalWsdlFile();
        if (string != null && (jAXWSSupport = JAXWSSupport.getJAXWSSupport((FileObject)fileObject)) != null && (fileObject2 = jAXWSSupport.getLocalWsdlFolderForService(this.service.getName(), false)) != null) {
            File file = FileUtil.toFile((FileObject)fileObject2);
            return new File(file.getAbsolutePath() + File.separator + string);
        }
        return null;
    }

    private static String getName() {
        return NbBundle.getMessage(RemoveOperationAction.class, (String)"LBL_RemoveOperation");
    }

    private FileObject getImplementationClass(MethodModel methodModel) {
        FileObject fileObject = null;
        FileObject fileObject2 = methodModel.getImplementationClass();
        String string = this.service.getImplementationClass();
        if (this.service.getLocalWsdlFile() != null) {
            Project project = FileOwnerQuery.getOwner((FileObject)fileObject2);
            SourceGroup[] sourceGroupArray = ProjectUtils.getSources((Project)project).getSourceGroups("java");
            if (sourceGroupArray.length > 0) {
                ClassPath classPath = null;
                for (int i = 0; i < sourceGroupArray.length && ((classPath = ClassPath.getClassPath((FileObject)sourceGroupArray[i].getRootFolder(), (String)"classpath/source")) == null || (fileObject = classPath.findResource(string.replace('.', '/') + ".java")) == null); ++i) {
                }
            }
        } else {
            fileObject = fileObject2;
        }
        return fileObject;
    }
}

