/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.design.view.actions;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.websvc.design.view.actions.ParamModel;
import org.netbeans.modules.websvc.design.view.actions.Utils;
import org.netbeans.modules.xml.schema.model.GlobalElement;
import org.netbeans.modules.xml.schema.model.GlobalType;
import org.netbeans.modules.xml.schema.model.Import;
import org.netbeans.modules.xml.schema.model.ReferenceableSchemaComponent;
import org.netbeans.modules.xml.schema.model.Schema;
import org.netbeans.modules.xml.schema.model.SchemaModel;
import org.netbeans.modules.xml.wsdl.model.Definitions;
import org.netbeans.modules.xml.wsdl.model.Types;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.xam.locator.CatalogModelException;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ParametersPanel
extends JPanel {
    private static final int COL_NAME_INDEX = 0;
    private static final int COL_TYPE_INDEX = 1;
    private static final String[] columnNames = new String[]{NbBundle.getMessage(ParametersPanel.class, (String)"ParametersPanel.LBL_Name"), NbBundle.getMessage(ParametersPanel.class, (String)"ParametersPanel.LBL_Type")};
    private final ParamsTableModel tableModel;
    private List<ReferenceableSchemaComponent> schemaTypes;
    private WSDLModel wsdlModel;
    private JButton addButton;
    private JButton downButton;
    private JScrollPane jScrollPane1;
    private JButton removeButton;
    private JTable table;
    private JButton upButton;

    public ParametersPanel() {
        this.initComponents();
        this.tableModel = new ParamsTableModel();
    }

    public ParametersPanel(WSDLModel wSDLModel) {
        this.wsdlModel = wSDLModel;
        this.initComponents();
        this.tableModel = new ParamsTableModel();
        this.table.setModel(this.tableModel);
        this.table.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                ParametersPanel.this.updateButtons();
            }
        });
        this.table.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                ParametersPanel.this.updateButtons();
            }
        });
        this.tableModel.addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent tableModelEvent) {
                ParametersPanel.this.updateButtons();
            }
        });
        try {
            this.schemaTypes = this.getSchemaTypes();
            if (this.schemaTypes == null) {
                return;
            }
            String[] stringArray = new String[this.schemaTypes.size()];
            int n = 0;
            for (ReferenceableSchemaComponent referenceableSchemaComponent : this.schemaTypes) {
                stringArray[n++] = Utils.getDisplayName(referenceableSchemaComponent);
            }
            TableColumn tableColumn = this.table.getColumnModel().getColumn(1);
            tableColumn.setPreferredWidth(300);
            tableColumn.setCellEditor(new MyComboBoxEditor(stringArray));
            tableColumn.setCellRenderer(new MyComboBoxRenderer(stringArray));
        }
        catch (CatalogModelException catalogModelException) {
            catalogModelException.printStackTrace();
        }
    }

    public void refreshSchemaTypes() {
        try {
            this.schemaTypes = this.getSchemaTypes();
            String[] stringArray = new String[this.schemaTypes.size()];
            int n = 0;
            for (ReferenceableSchemaComponent referenceableSchemaComponent : this.schemaTypes) {
                stringArray[n++] = Utils.getDisplayName(referenceableSchemaComponent);
            }
            TableColumn tableColumn = this.table.getColumnModel().getColumn(1);
            tableColumn.setPreferredWidth(300);
            tableColumn.setCellEditor(new MyComboBoxEditor(stringArray));
            tableColumn.setCellRenderer(new MyComboBoxRenderer(stringArray));
        }
        catch (CatalogModelException catalogModelException) {
            catalogModelException.printStackTrace();
        }
    }

    private List<ReferenceableSchemaComponent> getSchemaTypes() throws CatalogModelException {
        Definitions definitions = this.wsdlModel.getDefinitions();
        Types types = definitions.getTypes();
        if (types == null) {
            return null;
        }
        Collection collection = types.getSchemas();
        ArrayList<ReferenceableSchemaComponent> arrayList = new ArrayList<ReferenceableSchemaComponent>();
        arrayList.addAll(Utils.getPrimitiveTypes());
        for (Schema schema : collection) {
            String string = schema.getTargetNamespace();
            if (string != null) {
                this.populateWithElements(this.wsdlModel, schema.getModel(), arrayList);
            }
            Collection collection2 = schema.getImports();
            for (Import import_ : collection2) {
                SchemaModel schemaModel = import_.resolveReferencedModel();
                this.populateWithElements(this.wsdlModel, schemaModel, arrayList);
            }
        }
        return arrayList;
    }

    private void populateWithElements(WSDLModel wSDLModel, SchemaModel schemaModel, List<ReferenceableSchemaComponent> list) {
        Object object;
        Object object22;
        Collection collection = schemaModel.getSchema().getElements();
        for (Object object22 : collection) {
            if (Utils.isUsedInOperation(wSDLModel, (GlobalElement)object22)) continue;
            list.add((ReferenceableSchemaComponent)object22);
        }
        Collection collection2 = schemaModel.getSchema().getComplexTypes();
        object22 = collection2.iterator();
        while (object22.hasNext()) {
            object = (GlobalType)object22.next();
            list.add((ReferenceableSchemaComponent)object);
        }
        object22 = schemaModel.getSchema().getSimpleTypes();
        object = object22.iterator();
        while (object.hasNext()) {
            GlobalType globalType = (GlobalType)object.next();
            list.add((ReferenceableSchemaComponent)globalType);
        }
    }

    public List<ParamModel> getParameters() {
        return this.tableModel.getParameters();
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.table = new JTable();
        this.addButton = new JButton();
        this.removeButton = new JButton();
        this.upButton = new JButton();
        this.downButton = new JButton();
        this.table.setModel(new DefaultTableModel(new Object[0][], new String[0]));
        this.jScrollPane1.setViewportView(this.table);
        Mnemonics.setLocalizedText((AbstractButton)this.addButton, (String)NbBundle.getMessage(ParametersPanel.class, (String)"LBL_ADD"));
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ParametersPanel.this.addButtonActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.removeButton, (String)NbBundle.getMessage(ParametersPanel.class, (String)"LBL_REMOVE"));
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ParametersPanel.this.removeButtonActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.upButton, (String)NbBundle.getMessage(ParametersPanel.class, (String)"LBL_UP"));
        this.upButton.setEnabled(false);
        Mnemonics.setLocalizedText((AbstractButton)this.downButton, (String)NbBundle.getMessage(ParametersPanel.class, (String)"LBL_DOWN"));
        this.downButton.setEnabled(false);
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.jScrollPane1, -1, 367, Short.MAX_VALUE).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.addButton).add((Component)this.removeButton).add((Component)this.upButton).add((Component)this.downButton)).addContainerGap()));
        groupLayout.linkSize(new Component[]{this.addButton, this.downButton, this.removeButton, this.upButton}, 1);
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.addButton).addPreferredGap(0).add((Component)this.removeButton).add(22, 22, 22).add((Component)this.upButton).addPreferredGap(0).add((Component)this.downButton)).add((Component)this.jScrollPane1, -1, 287, Short.MAX_VALUE)).addContainerGap()));
    }

    private void removeButtonActionPerformed(ActionEvent actionEvent) {
        int n = this.table.getSelectedRow();
        if (n > -1) {
            this.tableModel.removeParameter(n);
        }
        if (n == this.table.getRowCount()) {
            --n;
        }
        this.table.getSelectionModel().setSelectionInterval(n, n);
        this.updateButtons();
    }

    private void addButtonActionPerformed(ActionEvent actionEvent) {
        int n = this.tableModel.addParameter();
        this.table.getSelectionModel().setSelectionInterval(n, n);
        this.updateButtons();
    }

    private void updateButtons() {
        int n = this.table.getSelectedRowCount();
        this.removeButton.setEnabled(n != 0);
        this.upButton.setEnabled(n == 1);
        this.downButton.setEnabled(n == 1);
    }

    private class MyComboBoxEditor
    extends DefaultCellEditor {
        public MyComboBoxEditor(String[] stringArray) {
            super(new JComboBox<String>(stringArray));
        }
    }

    private class MyComboBoxRenderer
    extends JComboBox
    implements TableCellRenderer {
        public MyComboBoxRenderer(String[] stringArray) {
            super(stringArray);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (bl) {
                this.setForeground(jTable.getSelectionForeground());
                super.setBackground(jTable.getSelectionBackground());
            } else {
                this.setForeground(jTable.getForeground());
                this.setBackground(jTable.getBackground());
            }
            this.setSelectedItem(object);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ParamsTableModel
    extends AbstractTableModel {
        private final List<ParamModel> parameters = new ArrayList<ParamModel>();

        public List<ParamModel> getParameters() {
            return this.parameters;
        }

        public int addParameter() {
            String string = this.generateUniqueName("arg");
            ParamModel paramModel = new ParamModel(string);
            int n = this.parameters.size();
            this.parameters.add(paramModel);
            if (ParametersPanel.this.schemaTypes.size() > 0) {
                ReferenceableSchemaComponent referenceableSchemaComponent = (ReferenceableSchemaComponent)ParametersPanel.this.schemaTypes.get(0);
                String string2 = referenceableSchemaComponent.getName();
                if (referenceableSchemaComponent instanceof GlobalType) {
                    string2 = Utils.getDisplayName(referenceableSchemaComponent);
                }
                this.setValueAt(string2, n, 1);
            }
            this.fireTableRowsInserted(n, n);
            return n;
        }

        public void removeParameter(int n) {
            this.parameters.remove(n);
            this.fireTableRowsDeleted(n, n);
        }

        @Override
        public int getRowCount() {
            return this.parameters.size();
        }

        @Override
        public int getColumnCount() {
            return columnNames.length;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            String string = null;
            ParamModel paramModel = this.parameters.get(n);
            if (paramModel != null) {
                switch (n2) {
                    case 0: {
                        string = paramModel.getParamName();
                        break;
                    }
                    case 1: {
                        string = paramModel.getDisplayName();
                    }
                }
            }
            return string;
        }

        @Override
        public String getColumnName(int n) {
            return columnNames[n];
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return true;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            ParamModel paramModel = this.parameters.get(n);
            ParamModel paramModel2 = new ParamModel();
            if (n2 == 0) {
                paramModel2.setParamName((String)object);
                paramModel2.setParamType(paramModel.getParamType());
            } else if (n2 == 1) {
                for (ReferenceableSchemaComponent referenceableSchemaComponent : ParametersPanel.this.schemaTypes) {
                    if (object == null || !Utils.getDisplayName(referenceableSchemaComponent).equals(object)) continue;
                    paramModel2.setParamType(referenceableSchemaComponent);
                    break;
                }
                paramModel2.setParamName(paramModel.getParamName());
            }
            this.parameters.set(n, paramModel2);
            this.fireTableCellUpdated(n, n2);
        }

        private String generateUniqueName(String string) {
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            for (ParamModel paramModel : this.parameters) {
                String string2;
                if (string.equals(paramModel.getParamName()) || !paramModel.getParamName().startsWith(string) || !this.isNumber(string2 = paramModel.getParamName().substring(string.length()))) continue;
                arrayList.add(Integer.parseInt(string2));
            }
            Collections.sort(arrayList);
            Object object = string;
            if (arrayList.size() > 0) {
                int n = (Integer)arrayList.get(arrayList.size() - 1) + 1;
                object = string + n;
            } else if (this.parameters.size() > 0) {
                object = string + 1;
            }
            return object;
        }

        private boolean isNumber(String string) {
            for (char c : string.toCharArray()) {
                if (Character.isDigit(c)) continue;
                return false;
            }
            return true;
        }
    }
}

