/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.refactoring.ui;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.SingleCopyRefactoring;
import org.netbeans.modules.refactoring.spi.ui.CustomRefactoringPanel;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUI;
import org.netbeans.modules.xml.refactoring.XMLRefactoringTransaction;
import org.netbeans.modules.xml.refactoring.spi.SharedUtils;
import org.netbeans.modules.xml.refactoring.ui.CopyPanel;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.Referenceable;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

public class CopyRefactoringUI
implements RefactoringUI {
    private SingleCopyRefactoring refactoring;
    private CopyPanel panel;
    private Model target;
    private boolean disable;
    private String oldFileName;
    private FileObject targetFile;

    public CopyRefactoringUI(Model model) {
        this.target = model;
        this.refactoring = new SingleCopyRefactoring(Lookups.singleton((Object)model));
        XMLRefactoringTransaction xMLRefactoringTransaction = new XMLRefactoringTransaction((Referenceable)model, (AbstractRefactoring)this.refactoring);
        this.refactoring.getContext().add((Object)xMLRefactoringTransaction);
        this.disable = false;
        this.targetFile = (FileObject)model.getModelSource().getLookup().lookup(FileObject.class);
        this.oldFileName = this.targetFile.getName();
    }

    public boolean isQuery() {
        return false;
    }

    public CustomRefactoringPanel getPanel(ChangeListener changeListener) {
        if (this.panel == null) {
            String string = this.targetFile.getParent().getName();
            this.panel = new CopyPanel(changeListener, this.getName() + " - " + this.oldFileName, string, this.targetFile, this.oldFileName);
            this.panel.setCombosEnabled(!this.disable);
        }
        return this.panel;
    }

    public Problem setParameters() {
        this.setupRefactoring();
        return this.refactoring.checkParameters();
    }

    public Problem checkParameters() {
        if (this.panel == null) {
            return null;
        }
        this.setupRefactoring();
        return this.refactoring.fastCheckParameters();
    }

    private void setupRefactoring() {
        this.refactoring.setNewName(this.panel.getNewName());
        URL uRL = URLMapper.findURL((FileObject)this.panel.getRootFolder(), (int)1);
        try {
            this.refactoring.setTarget(Lookups.singleton((Object)new URL(uRL.toExternalForm() + "/" + this.panel.getPackageName().replace('.', '/'))));
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
        }
    }

    public AbstractRefactoring getRefactoring() {
        return this.refactoring;
    }

    public String getDescription() {
        return NbBundle.getMessage(CopyRefactoringUI.class, (String)"DSC_CopyClass", (Object)this.refactoring.getNewName());
    }

    public String getName() {
        return NbBundle.getMessage(CopyRefactoringUI.class, (String)"LBL_CopyClass");
    }

    public boolean hasParameters() {
        return true;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(CopyRefactoringUI.class);
    }

    public boolean isRefactoringBypassRequired() {
        return !this.panel.isUpdateReferences();
    }

    public void doRefactoringBypass() throws IOException {
        Model model = (Model)this.refactoring.getRefactoringSource().lookup(Model.class);
        FileObject fileObject = (FileObject)model.getModelSource().getLookup().lookup(FileObject.class);
        FileObject fileObject2 = SharedUtils.getOrCreateFolder((URL)this.refactoring.getTarget().lookup(URL.class));
        if (fileObject != null) {
            DataObject dataObject = DataObject.find((FileObject)fileObject);
            DataFolder dataFolder = DataFolder.findFolder((FileObject)fileObject2);
            dataObject.copy(dataFolder).rename(this.panel.getNewName());
        }
    }
}

